/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.Blocks.Terrain;

import com.bioxx.tfc.Blocks.Terrain.BlockCollapsible;
import com.bioxx.tfc.Blocks.Terrain.BlockStone;
import com.bioxx.tfc.Core.TFC_Climate;
import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.TerraFirmaCraft;
import com.bioxx.tfc.TileEntities.TEOre;
import com.bioxx.tfc.WorldGen.DataLayer;
import com.bioxx.tfc.api.Constant.Global;
import com.bioxx.tfc.api.TFCBlocks;
import com.bioxx.tfc.api.TFCItems;
import com.bioxx.tfc.api.TFCOptions;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class BlockOre
extends BlockCollapsible {
    public String[] blockNames = Global.ORE_METAL;
    protected IIcon[] icons = new IIcon[this.blockNames.length];

    public BlockOre(Material mat) {
        super(mat);
        this.func_149675_a(true);
        this.func_149647_a(null);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        if (TFCOptions.enableDebugMode && world.field_72995_K) {
            int metadata = world.func_72805_g(x, y, z);
            TerraFirmaCraft.LOG.info("Meta = " + (this.func_149739_a() + ":" + metadata));
            TEOre te = (TEOre)world.func_147438_o(x, y, z);
            if (te != null) {
                TerraFirmaCraft.LOG.info("Ore  BaseID = " + te.baseBlockID + "| BaseMeta =" + te.baseBlockMeta);
            }
        }
        return false;
    }

    @Override
    public int[] getDropBlock(World world, int x, int y, int z) {
        int[] data = new int[]{-1, -1};
        DataLayer dl = TFC_Climate.getCacheManager(world).getRockLayerAt(x, z, TFC_Core.getRockLayerFromHeight(world, x, y, z));
        if (dl != null) {
            BlockStone stone = null;
            if (dl.block instanceof BlockStone) {
                stone = (BlockStone)dl.block;
            }
            if (stone != null) {
                data[0] = Block.func_149682_b((Block)stone.dropBlock);
                data[1] = dl.data2;
            }
        }
        return data;
    }

    public int func_149692_a(int dmg) {
        if (dmg == 14 || dmg == 15) {
            return 0;
        }
        return dmg;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        if (meta == 14 || meta == 15) {
            return 1 + random.nextInt(2);
        }
        return 1;
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta >= this.icons.length) {
            return this.icons[0];
        }
        return this.icons[meta];
    }

    public void func_149651_a(IIconRegister iconRegisterer) {
        for (int i = 0; i < this.blockNames.length; ++i) {
            this.icons[i] = iconRegisterer.func_94245_a("terrafirmacraft:ores/" + this.blockNames[i] + " Ore");
        }
    }

    public int func_149645_b() {
        return TFCBlocks.oreRenderId;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (!world.field_72995_K) {
            boolean dropOres = false;
            boolean hasHammer = false;
            int meta = world.func_72805_g(x, y, z);
            boolean isCoal = meta == 14 || meta == 15;
            ItemStack itemstack = null;
            if (player != null) {
                TFC_Core.addPlayerExhaustion(player, 0.001f);
                player.func_71064_a(StatList.field_75934_C[BlockOre.func_149682_b((Block)this)], 1);
                dropOres = player.func_146099_a((Block)this);
                ItemStack heldItem = player.func_71045_bC();
                if (heldItem != null) {
                    int[] itemIDs;
                    for (int id : itemIDs = OreDictionary.getOreIDs((ItemStack)heldItem)) {
                        String name = OreDictionary.getOreName((int)id);
                        if (!name.startsWith("itemHammer")) continue;
                        hasHammer = true;
                        break;
                    }
                }
            }
            if (player == null || dropOres) {
                if (isCoal) {
                    itemstack = new ItemStack(TFCItems.coal, 1 + world.field_73012_v.nextInt(2));
                } else {
                    TEOre te = (TEOre)world.func_147438_o(x, y, z);
                    int ore = this.getOreGrade(te, meta);
                    itemstack = new ItemStack(TFCItems.oreChunk, 1, this.func_149692_a(ore));
                }
            } else if (hasHammer && !isCoal) {
                itemstack = new ItemStack(TFCItems.smallOreChunk, 1, meta);
            }
            if (itemstack != null) {
                this.func_149642_a(world, x, y, z, itemstack);
            }
        }
        return world.func_147468_f(x, y, z);
    }

    @Override
    public void func_149636_a(World world, EntityPlayer entityplayer, int x, int y, int z, int meta) {
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TEOre te = (TEOre)world.func_147438_o(x, y, z);
        int ore = this.getOreGrade(te, metadata);
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        for (int i = 0; i < count; ++i) {
            ItemStack itemstack = metadata == 14 || metadata == 15 ? new ItemStack(TFCItems.coal) : new ItemStack(TFCItems.oreChunk, 1, this.func_149692_a(ore));
            ret.add(itemstack);
        }
        return ret;
    }

    public static Item getDroppedItem(int meta) {
        if (meta == 14 || meta == 15) {
            return TFCItems.coal;
        }
        return TFCItems.smallOreChunk;
    }

    public boolean func_149659_a(Explosion exp) {
        return false;
    }

    @Override
    public void func_149723_a(World world, int x, int y, int z, Explosion exp) {
        world.func_147468_f(x, y, z);
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion exp) {
        if (!world.field_72995_K) {
            TEOre te = (TEOre)world.func_147438_o(x, y, z);
            Random random = new Random();
            int meta = world.func_72805_g(x, y, z);
            int ore = this.getOreGrade(te, meta);
            ItemStack itemstack = meta == 14 || meta == 15 ? new ItemStack(TFCItems.coal, 1 + random.nextInt(2)) : new ItemStack(TFCItems.oreChunk, 1, ore);
            this.func_149642_a(world, x, y, z, itemstack);
            this.func_149723_a(world, x, y, z, exp);
        }
    }

    public int getOreGrade(TEOre te, int ore) {
        if (te != null) {
            int grade = te.extraData & 7;
            if (grade == 1) {
                ore += 35;
            } else if (grade == 2) {
                ore += 49;
            }
        }
        return ore;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return null;
    }

    public TileEntity createTileEntity(World w, int meta) {
        return new TEOre();
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!world.field_72995_K) {
            this.scanVisible(world, x, y, z);
        }
    }

    public void scanVisible(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            TEOre te = (TEOre)world.func_147438_o(x, y, z);
            if ((te.extraData & 8) == 0 && y < 255 && y > 0 && world.func_72899_e(x, y - 1, z) && world.func_72899_e(x, y + 1, z) && world.func_72899_e(x - 1, y, z) && world.func_72899_e(x + 1, y, z) && world.func_72899_e(x, y, z - 1) && world.func_72899_e(x, y, z + 1) && (!world.func_147439_a(x, y - 1, z).func_149662_c() || !world.func_147439_a(x, y + 1, z).func_149662_c() || !world.func_147439_a(x - 1, y, z).func_149662_c() || !world.func_147439_a(x + 1, y, z).func_149662_c() || !world.func_147439_a(x, y, z - 1).func_149662_c() || !world.func_147439_a(x, y, z + 1).func_149662_c())) {
                te.setVisible();
            }
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        if (!world.field_72995_K) {
            this.scanVisible(world, x, y, z);
        }
    }
}

