/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.Chunkdata;

import com.bioxx.tfc.Chunkdata.ChunkData;
import com.bioxx.tfc.Core.TFC_Time;
import com.bioxx.tfc.api.TFCOptions;
import net.minecraft.util.LongHashMap;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ChunkDataManager {
    private LongHashMap chunkmap = new LongHashMap();

    public ChunkDataManager(World world) {
    }

    public void removeData(int x, int z) {
        long key = ChunkCoordIntPair.func_77272_a((int)x, (int)z);
        if (this.chunkmap.func_76161_b(key)) {
            this.chunkmap.func_76159_d(key);
        }
    }

    public void addData(long key, ChunkData cd) {
        this.chunkmap.func_76163_a(key, (Object)cd);
    }

    public void addData(Chunk chunk, ChunkData cd) {
        this.chunkmap.func_76163_a(ChunkCoordIntPair.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h), (Object)cd);
    }

    public void addData(int x, int z, ChunkData cd) {
        this.chunkmap.func_76163_a(ChunkCoordIntPair.func_77272_a((int)x, (int)z), (Object)cd);
    }

    public ChunkData getData(int x, int z) {
        long key = ChunkCoordIntPair.func_77272_a((int)x, (int)z);
        if (this.chunkmap.func_76161_b(key)) {
            return (ChunkData)this.chunkmap.func_76164_a(key);
        }
        return null;
    }

    public ChunkData getData(long key) {
        if (this.chunkmap.func_76161_b(key)) {
            return (ChunkData)this.chunkmap.func_76164_a(key);
        }
        return null;
    }

    public boolean hasData(long key) {
        return this.chunkmap.func_76161_b(key);
    }

    public boolean addProtection(int x, int z, int amount) {
        ChunkData d = this.getData(x, z);
        if (d != null) {
            if (d.spawnProtection < 24 * TFC_Time.daysInMonth * TFCOptions.maxProtectionMonths) {
                d.setSpawnProtectionWithUpdate(amount);
            }
            return true;
        }
        return false;
    }

    public void setFishPop(int x, int z, float fishPop) {
        ChunkData d = this.getData(x, z);
        if (d != null && fishPop >= 0.0f) {
            d.fishPop = fishPop;
        }
    }

    public int getFishPop(int x, int z) {
        ChunkData d = this.getData(x, z);
        if (d != null) {
            return (int)d.fishPop;
        }
        return -1;
    }

    public boolean catchFish(int x, int z) {
        ChunkData d = this.getData(x, z);
        if (d != null && d.fishPop > 0.0f) {
            d.fishPop -= 1.0f;
            return true;
        }
        return false;
    }

    public boolean setLastVisted(int x, int z) {
        ChunkData d = this.getData(x, z);
        if (d != null) {
            d.lastVisited = TFC_Time.getTotalTicks();
            return true;
        }
        return false;
    }
}

