/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.Containers;

import com.bioxx.tfc.Containers.ContainerTFC;
import com.bioxx.tfc.Containers.Slots.SlotForShowOnly;
import com.bioxx.tfc.Containers.Slots.SlotSizeSmallVessel;
import com.bioxx.tfc.TileEntities.TEIngotPile;
import com.bioxx.tfc.api.Food;
import com.bioxx.tfc.api.Interfaces.IFood;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class ContainerVessel
extends ContainerTFC {
    private World world;
    public InventoryCrafting containerInv = new InventoryCrafting((Container)this, 2, 2);
    private List<Item> exceptions;

    public ContainerVessel(InventoryPlayer playerinv, World world, int x, int y, int z) {
        this.player = playerinv.field_70458_d;
        this.world = world;
        this.bagsSlotNum = this.player.field_71071_by.field_70461_c;
        this.exceptions = new ArrayList<Item>();
        for (Item ingot : TEIngotPile.getIngots()) {
            this.exceptions.add(ingot);
        }
        this.layoutContainer((IInventory)playerinv, 0, 0);
        if (!world.field_72995_K) {
            this.loadBagInventory();
        }
        this.doItemSaving = true;
    }

    @Override
    public void reloadContainer() {
        if (!this.world.field_72995_K) {
            this.loadBagInventory();
        }
    }

    public void loadBagInventory() {
        if (this.player.field_71071_by.func_70301_a(this.bagsSlotNum) != null && this.player.field_71071_by.func_70301_a(this.bagsSlotNum).func_77942_o()) {
            NBTTagList nbttaglist = this.player.field_71071_by.func_70301_a(this.bagsSlotNum).func_77978_p().func_150295_c("Items", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                this.isLoading = true;
                NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                byte byte0 = nbttagcompound1.func_74771_c("Slot");
                if (byte0 < 0 || byte0 >= 4) continue;
                ItemStack is = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
                if (is.field_77994_a >= 1) {
                    this.containerInv.func_70299_a((int)byte0, is);
                    continue;
                }
                this.containerInv.func_70299_a((int)byte0, null);
            }
        }
    }

    @Override
    public void saveContents(ItemStack is) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.containerInv.func_70302_i_(); ++i) {
            ItemStack contentStack = this.containerInv.func_70301_a(i);
            if (contentStack != null && contentStack.func_77973_b() instanceof IFood && Food.getDecay(contentStack) / 160.0f > 0.9f) {
                this.containerInv.func_70299_a(i, null);
            }
            if (contentStack == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            contentStack.func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        if (is != null) {
            if (!is.func_77942_o()) {
                is.func_77982_d(new NBTTagCompound());
            }
            is.func_77978_p().func_74782_a("Items", (NBTBase)nbttaglist);
        }
    }

    @Override
    public ItemStack loadContents(int slot) {
        NBTTagList nbttaglist;
        if (this.player.field_71071_by.func_70301_a(this.bagsSlotNum) != null && this.player.field_71071_by.func_70301_a(this.bagsSlotNum).func_77942_o() && (nbttaglist = this.player.field_71071_by.func_70301_a(this.bagsSlotNum).func_77978_p().func_150295_c("Items", 10)) != null) {
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                byte byte0 = nbttagcompound1.func_74771_c("Slot");
                if (byte0 != slot) continue;
                return ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
            }
        }
        return null;
    }

    @Override
    public boolean func_75145_c(EntityPlayer var1) {
        return true;
    }

    protected void layoutContainer(IInventory playerInventory, int xSize, int ySize) {
        int row;
        this.func_75146_a(new SlotSizeSmallVessel((IInventory)this.containerInv, 0, 71, 25).addItemException(this.exceptions));
        this.func_75146_a(new SlotSizeSmallVessel((IInventory)this.containerInv, 1, 89, 25).addItemException(this.exceptions));
        this.func_75146_a(new SlotSizeSmallVessel((IInventory)this.containerInv, 2, 71, 43).addItemException(this.exceptions));
        this.func_75146_a(new SlotSizeSmallVessel((IInventory)this.containerInv, 3, 89, 43).addItemException(this.exceptions));
        for (row = 0; row < 9; ++row) {
            if (row == this.bagsSlotNum) {
                this.func_75146_a(new SlotForShowOnly(playerInventory, row, 8 + row * 18, 148));
                continue;
            }
            this.func_75146_a(new Slot(playerInventory, row, 8 + row * 18, 148));
        }
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot(playerInventory, col + row * 9 + 9, 8 + col * 18, 90 + row * 18));
            }
        }
    }

    @Override
    public ItemStack transferStackInSlotTFC(EntityPlayer player, int slotNum) {
        ItemStack origStack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotNum);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            origStack = slotStack.func_77946_l();
            if (slotNum < 4 ? !this.func_75135_a(slotStack, 4, this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, 0, 4, false)) {
                return null;
            }
            if (slotStack.field_77994_a <= 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.field_77994_a == origStack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, slotStack);
        }
        return origStack;
    }
}

