/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.Core.Player;

import com.bioxx.tfc.Core.Player.BodyTempStats;
import com.bioxx.tfc.Core.TFC_Climate;
import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.Core.TFC_Time;
import com.bioxx.tfc.Render.EntityRendererTFC;
import com.bioxx.tfc.api.Enums.EnumFoodGroup;
import com.bioxx.tfc.api.Food;
import com.bioxx.tfc.api.FoodRegistry;
import com.bioxx.tfc.api.Interfaces.IFood;
import com.bioxx.tfc.api.TFCOptions;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;

public class FoodStatsTFC {
    private boolean updateStats = !TFCOptions.enableDebugMode;
    public float stomachLevel = 24.0f;
    private float stomachMax = 24.0f;
    private float prevFoodLevel = 24.0f;
    private ResourceLocation drunkBlur = new ResourceLocation("shaders/post/blur.json");
    private ResourceLocation wastedBlur = new ResourceLocation("shaders/post/blur.json");
    public float nutrFruit = 1.0f;
    public float nutrVeg = 1.0f;
    public float nutrGrain = 1.0f;
    public float nutrDairy = 1.0f;
    public float nutrProtein = 1.0f;
    private boolean sendUpdate = true;
    public long soberTime;
    private float satisfaction;
    private float foodExhaustionLevel;
    public long foodTimer;
    public long foodHealTimer;
    public float waterLevel = 48000.0f;
    public long waterTimer;
    public EntityPlayer player;
    private long nameSeed = Long.MIN_VALUE;
    private boolean satFruit;
    private boolean satVeg;
    private boolean satGrain;
    private boolean satProtein;
    private boolean satDairy;

    public FoodStatsTFC(EntityPlayer player) {
        this.player = player;
        this.waterTimer = Math.max(TFC_Time.getTotalTicks(), TFC_Time.startTime);
        this.foodTimer = Math.max(TFC_Time.getTotalTicks(), TFC_Time.startTime);
        this.foodHealTimer = Math.max(TFC_Time.getTotalTicks(), TFC_Time.startTime);
    }

    public void onUpdate(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            BodyTempStats bodyTemp = TFC_Core.getBodyTempStats(player);
            float temp = TFC_Climate.getHeightAdjustedTemp(player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            float tempWaterMod = temp;
            tempWaterMod = tempWaterMod >= 25.0f ? (tempWaterMod - 25.0f) * 0.2f : 0.0f;
            if (this.foodTimer < TFC_Time.startTime) {
                this.foodTimer = TFC_Time.startTime;
                this.foodHealTimer = TFC_Time.startTime;
                this.waterTimer = TFC_Time.startTime;
            }
            if (TFC_Time.getTotalTicks() - this.foodTimer >= 1000L && !player.field_71075_bZ.field_75098_d && this.updateStats) {
                float hunger;
                this.foodTimer += 1000L;
                float drainMult = 1.0f;
                if (player.func_70608_bn()) {
                    drainMult = 0.5f;
                }
                if (player.func_70051_ag()) {
                    this.waterLevel -= 5.0f + tempWaterMod;
                }
                if (!player.field_71075_bZ.field_75098_d && this.updateStats) {
                    this.waterLevel -= (float)bodyTemp.getExtraWater() * drainMult;
                }
                if (this.satisfaction >= (hunger = (1.0f + this.foodExhaustionLevel + (float)bodyTemp.getExtraFood()) * drainMult)) {
                    this.satisfaction -= hunger;
                    hunger = 0.0f;
                    this.foodExhaustionLevel = 0.0f;
                } else {
                    hunger -= this.satisfaction;
                    this.satisfaction = 0.0f;
                    this.foodExhaustionLevel = 0.0f;
                }
                this.stomachLevel = Math.max(this.stomachLevel - hunger, 0.0f);
                if (this.satisfaction == 0.0f) {
                    this.satProtein = false;
                    this.satFruit = false;
                    this.satVeg = false;
                    this.satDairy = false;
                    this.satGrain = false;
                }
                if (this.stomachLevel <= 0.0f) {
                    this.reduceNutrition(0.0024f);
                } else if (this.satisfaction <= 0.0f) {
                    this.reduceNutrition(8.0E-4f);
                } else {
                    if (this.satProtein) {
                        this.addNutrition(EnumFoodGroup.Protein, this.satisfaction * ((1.0f - this.nutrProtein) / 100.0f), false);
                    }
                    if (this.satGrain) {
                        this.addNutrition(EnumFoodGroup.Grain, this.satisfaction * ((1.0f - this.nutrGrain) / 100.0f), false);
                    }
                    if (this.satVeg) {
                        this.addNutrition(EnumFoodGroup.Vegetable, this.satisfaction * ((1.0f - this.nutrVeg) / 100.0f), false);
                    }
                    if (this.satFruit) {
                        this.addNutrition(EnumFoodGroup.Fruit, this.satisfaction * ((1.0f - this.nutrFruit) / 100.0f), false);
                    }
                    if (this.satDairy) {
                        this.addNutrition(EnumFoodGroup.Dairy, this.satisfaction * ((1.0f - this.nutrDairy) / 100.0f), false);
                    }
                }
                this.sendUpdate = true;
            }
            if (TFC_Time.getTotalTicks() - this.foodHealTimer >= 500L) {
                this.foodHealTimer += 500L;
                if (this.stomachLevel >= this.getMaxStomach(player) / 4.0f && player.func_70996_bM()) {
                    player.func_70691_i((float)((int)(player.func_110138_aP() * 0.01f)));
                }
            }
            if (!player.field_71075_bZ.field_75098_d && this.updateStats) {
                while (this.waterTimer < TFC_Time.getTotalTicks()) {
                    this.waterLevel -= 1.0f + tempWaterMod / 2.0f;
                    if (this.waterLevel < 0.0f) {
                        this.waterLevel = 0.0f;
                    }
                    if (!TFC_Core.isPlayerInDebugMode(player) && this.waterLevel == 0.0f && temp > 35.0f) {
                        player.func_70097_a(new DamageSource("heatStroke").func_76348_h().func_151518_m(), 2.0f);
                    }
                    ++this.waterTimer;
                }
            }
        }
    }

    public void clientUpdate() {
        if (Minecraft.func_71410_x().field_71460_t instanceof EntityRendererTFC) {
            EntityRendererTFC erTFC = (EntityRendererTFC)Minecraft.func_71410_x().field_71460_t;
            if (!(erTFC.getCurrentShaderLocation() != null && erTFC.getCurrentShaderLocation().equals((Object)this.wastedBlur) || this.soberTime <= TFC_Time.getTotalTicks() + 8000L)) {
                erTFC.setManualShader(this.wastedBlur);
            } else if (!(erTFC.getCurrentShaderLocation() != null && erTFC.getCurrentShaderLocation().equals((Object)this.drunkBlur) || this.soberTime <= TFC_Time.getTotalTicks() + 4000L || this.soberTime > TFC_Time.getTotalTicks() + 8000L)) {
                erTFC.setManualShader(this.drunkBlur);
            } else if (erTFC.getManualShaderBeingUsed() && this.soberTime <= TFC_Time.getTotalTicks() + 4000L) {
                erTFC.deactivateManualShader();
            }
        }
    }

    protected void reduceNutrition(float amount) {
        this.nutrFruit = Math.max(this.nutrFruit - (amount + this.foodExhaustionLevel), 0.0f);
        this.nutrVeg = Math.max(this.nutrVeg - (amount + this.foodExhaustionLevel), 0.0f);
        this.nutrGrain = Math.max(this.nutrGrain - (amount + this.foodExhaustionLevel), 0.0f);
        this.nutrProtein = Math.max(this.nutrProtein - (amount + this.foodExhaustionLevel), 0.0f);
        this.nutrDairy = Math.max(this.nutrDairy - (amount + this.foodExhaustionLevel), 0.0f);
        this.sendUpdate = true;
    }

    public int getMaxWater(EntityPlayer player) {
        return 48000 + 200 * player.field_71068_ca;
    }

    public float getMaxStomach(EntityPlayer player) {
        return this.stomachMax;
    }

    public float getFoodLevel() {
        return this.stomachLevel;
    }

    @SideOnly(value=Side.CLIENT)
    public float getPrevFoodLevel() {
        return this.prevFoodLevel;
    }

    public boolean needFood() {
        return this.stomachLevel < this.getMaxStomach(this.player) && (double)(this.getMaxStomach(this.player) - this.stomachLevel) > 0.1;
    }

    public boolean needDrink() {
        return this.waterLevel < (float)(this.getMaxWater(this.player) - 500);
    }

    public void readNBT(NBTTagCompound par1NBTTagCompound) {
        if (par1NBTTagCompound.func_74764_b("foodCompound")) {
            NBTTagCompound foodCompound = par1NBTTagCompound.func_74775_l("foodCompound");
            this.waterLevel = foodCompound.func_74760_g("waterLevel");
            this.stomachLevel = foodCompound.func_74760_g("foodLevel");
            this.foodTimer = foodCompound.func_74763_f("foodTickTimer");
            this.foodHealTimer = foodCompound.func_74763_f("foodHealTimer");
            this.waterTimer = foodCompound.func_74763_f("waterTimer");
            this.soberTime = foodCompound.func_74763_f("soberTime");
            this.satisfaction = foodCompound.func_74760_g("foodSaturationLevel");
            this.foodExhaustionLevel = foodCompound.func_74760_g("foodExhaustionLevel");
            this.nutrFruit = foodCompound.func_74760_g("nutrFruit");
            this.nutrVeg = foodCompound.func_74760_g("nutrVeg");
            this.nutrGrain = foodCompound.func_74760_g("nutrGrain");
            this.nutrProtein = foodCompound.func_74760_g("nutrProtein");
            this.nutrDairy = foodCompound.func_74760_g("nutrDairy");
            this.sendUpdate = foodCompound.func_74767_n("shouldSendUpdate");
            this.satFruit = foodCompound.func_74767_n("satFruit");
            this.satVeg = foodCompound.func_74767_n("satVeg");
            this.satGrain = foodCompound.func_74767_n("satGrain");
            this.satProtein = foodCompound.func_74767_n("satProtein");
            this.satDairy = foodCompound.func_74767_n("satDairy");
        }
    }

    public void writeNBT(NBTTagCompound nbt) {
        NBTTagCompound foodNBT = new NBTTagCompound();
        foodNBT.func_74776_a("waterLevel", this.waterLevel);
        foodNBT.func_74776_a("foodLevel", this.stomachLevel);
        foodNBT.func_74772_a("foodTickTimer", this.foodTimer);
        foodNBT.func_74772_a("foodHealTimer", this.foodHealTimer);
        foodNBT.func_74772_a("waterTimer", this.waterTimer);
        foodNBT.func_74772_a("soberTime", this.soberTime);
        foodNBT.func_74776_a("foodSaturationLevel", this.satisfaction);
        foodNBT.func_74776_a("foodExhaustionLevel", this.foodExhaustionLevel);
        foodNBT.func_74776_a("nutrFruit", this.nutrFruit);
        foodNBT.func_74776_a("nutrVeg", this.nutrVeg);
        foodNBT.func_74776_a("nutrGrain", this.nutrGrain);
        foodNBT.func_74776_a("nutrProtein", this.nutrProtein);
        foodNBT.func_74776_a("nutrDairy", this.nutrDairy);
        foodNBT.func_74757_a("shouldSendUpdate", this.sendUpdate);
        foodNBT.func_74757_a("satFruit", this.satFruit);
        foodNBT.func_74757_a("satVeg", this.satVeg);
        foodNBT.func_74757_a("satGrain", this.satGrain);
        foodNBT.func_74757_a("satProtein", this.satProtein);
        foodNBT.func_74757_a("satDairy", this.satDairy);
        nbt.func_74782_a("foodCompound", (NBTBase)foodNBT);
    }

    public void addFoodExhaustion(float par1) {
        this.foodExhaustionLevel = par1;
    }

    public float getSatisfaction() {
        return this.satisfaction;
    }

    public void setFoodLevel(float par1) {
        if (par1 != this.stomachLevel) {
            this.sendUpdate = true;
        }
        this.stomachLevel = par1;
    }

    public void setSatisfaction(float par1, int[] fg) {
        this.satisfaction = Math.min(par1, 10.0f);
        block7: for (int i = 0; i < fg.length; ++i) {
            if (fg[i] == -1) continue;
            EnumFoodGroup efg = FoodRegistry.getInstance().getFoodGroup(fg[i]);
            switch (efg) {
                case Protein: {
                    this.satProtein = true;
                    continue block7;
                }
                case Grain: {
                    this.satGrain = true;
                    continue block7;
                }
                case Fruit: {
                    this.satFruit = true;
                    continue block7;
                }
                case Vegetable: {
                    this.satVeg = true;
                    continue block7;
                }
                case Dairy: {
                    this.satDairy = true;
                    continue block7;
                }
            }
        }
    }

    public long getPlayerFoodSeed() {
        if (this.nameSeed == Long.MIN_VALUE) {
            byte[] nameBytes;
            long seed = 0L;
            for (byte b : nameBytes = this.player.func_70005_c_().getBytes()) {
                seed += (long)b;
            }
            this.nameSeed = seed + this.player.field_70170_p.func_72905_C();
        }
        return this.nameSeed;
    }

    public int[] getPrefTaste() {
        Random r = new Random(this.getPlayerFoodSeed());
        return new int[]{20 + r.nextInt(70), 20 + r.nextInt(70), 20 + r.nextInt(70), 20 + r.nextInt(70), 20 + r.nextInt(70)};
    }

    public float getTasteFactor(ItemStack food) {
        float tasteFactor = 0.85f;
        int[] tastePref = this.getPrefTaste();
        tasteFactor += this.getTasteDistanceFactor(tastePref[0], ((IFood)food.func_77973_b()).getTasteSweet(food));
        tasteFactor += this.getTasteDistanceFactor(tastePref[1], ((IFood)food.func_77973_b()).getTasteSour(food));
        tasteFactor += this.getTasteDistanceFactor(tastePref[2], ((IFood)food.func_77973_b()).getTasteSalty(food));
        tasteFactor += this.getTasteDistanceFactor(tastePref[3], ((IFood)food.func_77973_b()).getTasteBitter(food));
        return tasteFactor += this.getTasteDistanceFactor(tastePref[4], ((IFood)food.func_77973_b()).getTasteSavory(food));
    }

    public float getTasteDistanceFactor(int pref, int val) {
        int abs = Math.abs(pref - val);
        if (abs < 11) {
            return (float)(10 - abs) * 0.01f;
        }
        return 0.0f;
    }

    public float getNutritionHealthModifier() {
        float nMod = 0.0f;
        nMod += 0.2f * this.nutrFruit;
        nMod += 0.2f * this.nutrVeg;
        nMod += 0.2f * this.nutrGrain;
        nMod += 0.2f * this.nutrProtein;
        return Math.max(nMod += 0.2f * this.nutrDairy, 0.05f);
    }

    public static int getMaxHealth(EntityPlayer player) {
        return (int)((float)Math.min(1000 + player.field_71068_ca * TFCOptions.healthGainRate, TFCOptions.healthGainCap) * TFC_Core.getPlayerFoodStats(player).getNutritionHealthModifier());
    }

    public static boolean reduceFood(ItemStack is, float amount) {
        if (is.func_77942_o()) {
            float weight = Food.getWeight(is);
            float decay = Food.getDecay(is);
            if (decay >= 0.0f && weight - decay - amount <= 0.0f) {
                return true;
            }
            if (decay <= 0.0f && weight - amount <= 0.0f) {
                return true;
            }
            Food.setWeight(is, weight - amount);
        }
        return false;
    }

    public void addNutrition(EnumFoodGroup fg, float foodAmt) {
        this.addNutrition(fg, foodAmt, true);
    }

    public void addNutrition(EnumFoodGroup fg, float foodAmt, boolean shouldDoMath) {
        float amount = foodAmt;
        if (shouldDoMath) {
            amount = foodAmt / 5.0f / 50.0f;
        }
        switch (fg) {
            case Dairy: {
                this.nutrDairy = Math.min(this.nutrDairy + amount, 1.0f);
                break;
            }
            case Fruit: {
                this.nutrFruit = Math.min(this.nutrFruit + amount, 1.0f);
                break;
            }
            case Grain: {
                this.nutrGrain = Math.min(this.nutrGrain + amount, 1.0f);
                break;
            }
            case Protein: {
                this.nutrProtein = Math.min(this.nutrProtein + amount, 1.0f);
                break;
            }
            case Vegetable: {
                this.nutrVeg = Math.min(this.nutrVeg + amount, 1.0f);
                break;
            }
        }
    }

    public boolean shouldSendUpdate() {
        return this.sendUpdate;
    }

    public void restoreWater(EntityPlayer player, int w) {
        this.waterLevel = Math.min(this.waterLevel + (float)w, (float)this.getMaxWater(player));
        this.sendUpdate = true;
        this.writeNBT(player.getEntityData());
    }

    public void resetTimers() {
        this.waterTimer = TFC_Time.getTotalTicks();
        this.foodTimer = TFC_Time.getTotalTicks();
        this.foodHealTimer = TFC_Time.getTotalTicks();
    }

    public void consumeAlcohol() {
        this.soberTime = this.soberTime <= TFC_Time.getTotalTicks() ? TFC_Time.getTotalTicks() + (long)this.player.field_70170_p.field_73012_v.nextInt(1000) + 400L : (this.soberTime += (long)(this.player.field_70170_p.field_73012_v.nextInt(1000) + 400));
        this.sendUpdate = true;
    }
}

