/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.Core.Player;

import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.Handlers.Network.PlayerUpdatePacket;
import com.bioxx.tfc.TerraFirmaCraft;
import com.bioxx.tfc.api.Events.GetSkillMultiplierEvent;
import com.bioxx.tfc.api.Events.PlayerSkillEvent;
import com.bioxx.tfc.api.SkillsManager;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;

public class SkillStats {
    private Map<SkillsManager.Skill, Integer> skillsMap;
    private EntityPlayer player;

    public SkillStats(EntityPlayer p) {
        this.player = p;
        this.skillsMap = new HashMap<SkillsManager.Skill, Integer>();
        for (SkillsManager.Skill s : SkillsManager.instance.getSkillsArray()) {
            this.setSkill(s.skillName, 0);
        }
    }

    public Object[] getSkillsKeysArray() {
        return this.skillsMap.keySet().toArray();
    }

    public void setSkill(String skillName, int amount) {
        SkillsManager.Skill sk = SkillsManager.instance.getSkill(skillName);
        if (sk != null) {
            this.skillsMap.put(sk, amount);
        }
    }

    public void setSkillSave(String skillName, int amount) {
        SkillsManager.Skill sk = SkillsManager.instance.getSkill(skillName);
        if (sk != null) {
            this.skillsMap.put(sk, amount);
        }
        this.writeNBT(this.player.getEntityData());
    }

    public void increaseSkill(String skillName, int amount) {
        int i;
        SkillsManager.Skill sk = SkillsManager.instance.getSkill(skillName);
        PlayerSkillEvent.Increase event = new PlayerSkillEvent.Increase(this.player, skillName, amount);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            if (this.skillsMap.containsKey(sk)) {
                i = this.skillsMap.get(sk);
                this.skillsMap.put(sk, i + amount);
            } else {
                this.skillsMap.put(sk, amount);
            }
        }
        i = this.skillsMap.get(sk);
        if (this.player instanceof EntityPlayerMP) {
            PlayerUpdatePacket pkt = new PlayerUpdatePacket(1, skillName, i);
            TerraFirmaCraft.PACKET_PIPELINE.sendTo(pkt, (EntityPlayerMP)this.player);
        }
        this.writeNBT(this.player.getEntityData());
    }

    public int getSkillRaw(String skillName) {
        SkillsManager.Skill sk = SkillsManager.instance.getSkill(skillName);
        if (this.skillsMap.containsKey(sk)) {
            return this.skillsMap.get(sk);
        }
        return 0;
    }

    public SkillRank getSkillRank(String skillName) {
        float raw = this.getSkillMultiplier(skillName);
        if ((double)raw < 0.25) {
            return SkillRank.Novice;
        }
        if ((double)raw < 0.5) {
            return SkillRank.Adept;
        }
        if ((double)raw < 0.75) {
            return SkillRank.Expert;
        }
        return SkillRank.Master;
    }

    public float getPercToNextRank(String skillName) {
        float raw = this.getSkillMultiplier(skillName);
        if ((double)raw < 0.25) {
            return raw / 0.25f;
        }
        if ((double)raw < 0.5) {
            return (raw - 0.25f) / 0.25f;
        }
        if ((double)raw < 0.75) {
            return (raw - 0.5f) / 0.25f;
        }
        return (raw - 0.75f) / 0.25f;
    }

    public float getSkillMultiplier(String skillName) {
        int skill = this.getSkillRaw(skillName);
        SkillsManager.Skill sk = SkillsManager.instance.getSkill(skillName);
        float mult = this.getSkillMult(skill, sk.skillRate);
        GetSkillMultiplierEvent event = new GetSkillMultiplierEvent(this.player, skillName, mult);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.skillResult;
    }

    private float getSkillMult(int skill, float rate) {
        return 1.0f - rate / (rate + (float)skill);
    }

    public void readNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("skillCompound")) {
            NBTTagCompound skillCompound = nbt.func_74775_l("skillCompound");
            for (Object n : skillCompound.func_150296_c()) {
                String skill = (String)n;
                this.setSkill(skill, skillCompound.func_74762_e(skill));
            }
        }
    }

    public void writeNBT(NBTTagCompound nbt) {
        Object[] keys;
        NBTTagCompound skillCompound = new NBTTagCompound();
        for (Object o : keys = this.skillsMap.keySet().toArray()) {
            SkillsManager.Skill k = (SkillsManager.Skill)o;
            int f = this.skillsMap.get(k);
            skillCompound.func_74768_a(k.skillName, f);
        }
        nbt.func_74782_a("skillCompound", (NBTBase)skillCompound);
    }

    public void toOutBuffer(ByteBuf buffer) {
        Object[] keys = this.skillsMap.keySet().toArray();
        buffer.writeInt(keys.length);
        for (Object o : keys) {
            SkillsManager.Skill k = (SkillsManager.Skill)o;
            int f = this.skillsMap.get(k);
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)k.skillName);
            buffer.writeInt(f);
        }
    }

    public static enum SkillRank {
        Novice("gui.skill.novice"),
        Adept("gui.skill.adept"),
        Expert("gui.skill.expert"),
        Master("gui.skill.master");

        String name;

        private SkillRank(String local) {
            this.name = local;
        }

        public String getUnlocalizedName() {
            return this.name;
        }

        public String getLocalizedName() {
            return TFC_Core.translate(this.name);
        }
    }
}

