/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.Core;

import com.bioxx.tfc.Chunkdata.ChunkData;
import com.bioxx.tfc.Core.ColorizerFoliageTFC;
import com.bioxx.tfc.Core.ColorizerGrassTFC;
import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.Core.TFC_Time;
import com.bioxx.tfc.Core.WeatherManager;
import com.bioxx.tfc.WorldGen.DataLayer;
import com.bioxx.tfc.WorldGen.WorldCacheManager;
import com.bioxx.tfc.api.Util.Helper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.World;

public class TFC_Climate {
    public static Map<World, WorldCacheManager> worldPair = new HashMap<World, WorldCacheManager>();
    private static final float[] Y_FACTOR_CACHE = new float[441];
    private static final float[] Z_FACTOR_CACHE = new float[30001];
    private static final float[][] MONTH_TEMP_CACHE = new float[12][30001];

    public static void initCache() {
        float factor;
        for (int y = 0; y < Y_FACTOR_CACHE.length; ++y) {
            factor = y < 110 ? (float)(y * y) / 677.966f : 0.16225f * (float)y;
            TFC_Climate.Y_FACTOR_CACHE[y] = factor;
        }
        for (int zCoord = 0; zCoord < TFC_Climate.getMaxZPos() + 1; ++zCoord) {
            factor = 0.0f;
            float z = zCoord;
            TFC_Climate.Z_FACTOR_CACHE[zCoord] = factor = ((float)TFC_Climate.getMaxZPos() - z) / (float)TFC_Climate.getMaxZPos();
            block11: for (int month = 0; month < 12; ++month) {
                float MAXTEMP = 35.0f;
                double angle = (double)factor * 1.5707963267948966;
                double latitudeFactor = Math.cos(angle);
                switch (month) {
                    case 10: {
                        TFC_Climate.MONTH_TEMP_CACHE[month][zCoord] = (float)(35.0 - 13.5 * latitudeFactor - latitudeFactor * 55.0);
                        continue block11;
                    }
                    case 9: 
                    case 11: {
                        TFC_Climate.MONTH_TEMP_CACHE[month][zCoord] = (float)(35.0 - 12.5 * latitudeFactor - latitudeFactor * 53.0);
                        continue block11;
                    }
                    case 0: 
                    case 8: {
                        TFC_Climate.MONTH_TEMP_CACHE[month][zCoord] = (float)(35.0 - 10.0 * latitudeFactor - latitudeFactor * 46.0);
                        continue block11;
                    }
                    case 1: 
                    case 7: {
                        TFC_Climate.MONTH_TEMP_CACHE[month][zCoord] = (float)(35.0 - 7.5 * latitudeFactor - latitudeFactor * 40.0);
                        continue block11;
                    }
                    case 2: 
                    case 6: {
                        TFC_Climate.MONTH_TEMP_CACHE[month][zCoord] = (float)(35.0 - 5.0 * latitudeFactor - latitudeFactor * 33.0);
                        continue block11;
                    }
                    case 3: 
                    case 5: {
                        TFC_Climate.MONTH_TEMP_CACHE[month][zCoord] = (float)(35.0 - 2.5 * latitudeFactor - latitudeFactor * 27.0);
                        continue block11;
                    }
                    case 4: {
                        TFC_Climate.MONTH_TEMP_CACHE[month][zCoord] = (float)(35.0 - 1.5 * latitudeFactor - latitudeFactor * 27.0);
                    }
                }
            }
        }
    }

    protected static float getZFactor(int zCoord) {
        if (zCoord < 0) {
            zCoord = -zCoord;
        }
        if (zCoord > TFC_Climate.getMaxZPos()) {
            zCoord = TFC_Climate.getMaxZPos();
        }
        return Z_FACTOR_CACHE[zCoord];
    }

    protected static float getTemp(World world, int x, int z) {
        return TFC_Climate.getTemp0(world, TFC_Time.currentDay, TFC_Time.getHour(), x, z, false);
    }

    protected static float getTemp(World world, int day, int hour, int x, int z) {
        return TFC_Climate.getTemp0(world, day, hour, x, z, false);
    }

    protected static float getBioTemp(World world, int day, int x, int z) {
        return TFC_Climate.getTemp0(world, day, 0, x, z, true);
    }

    private static float getTemp0(World world, int day, int hour, int x, int z, boolean bio) {
        if (TFC_Climate.getCacheManager(world) != null) {
            float dailyTemp;
            float hourMod;
            float zMod = TFC_Climate.getZFactor(z);
            float zTemp = zMod * TFC_Climate.getMaxTemperature() - 20.0f + (zMod - 0.5f) * 10.0f;
            float rain = TFC_Climate.getRainfall(world, x, 144, z);
            float rainMod = (1.0f - rain / 4000.0f) * zMod;
            int month = TFC_Time.getSeasonFromDayOfYear(day, z);
            int lastMonth = TFC_Time.getSeasonFromDayOfYear(day - TFC_Time.daysInMonth, z);
            float monthTemp = TFC_Climate.getMonthTemp(month, z);
            float lastMonthTemp = TFC_Climate.getMonthTemp(lastMonth, z);
            int dayOfMonth = TFC_Time.getDayOfMonthFromDayOfYear(day);
            if (bio) {
                hourMod = 0.2f;
                dailyTemp = 0.0f;
            } else {
                int h = (hour - 6) % 24;
                if (h < 0) {
                    h += 24;
                }
                hourMod = h < 12 ? (float)h / 11.0f * 0.3f : 0.3f - ((float)h - 12.0f) / 11.0f * 0.3f;
                dailyTemp = WeatherManager.getInstance().getDailyTemp(day);
            }
            float monthDelta = (monthTemp - lastMonthTemp) * (float)dayOfMonth / (float)TFC_Time.daysInMonth;
            float temp = lastMonthTemp + monthDelta;
            temp += dailyTemp + hourMod * (zTemp + dailyTemp);
            temp = temp >= 12.0f ? (temp += 8.0f * rainMod * zMod) : (temp -= 8.0f * rainMod * zMod);
            return temp;
        }
        return -10.0f;
    }

    protected static float getMonthTemp(int season, int z) {
        if (z < 0) {
            z = -z;
        }
        if (z > TFC_Climate.getMaxZPos()) {
            z = TFC_Climate.getMaxZPos();
        }
        return MONTH_TEMP_CACHE[season][z];
    }

    protected static float getTempSpecificDay(World world, int day, int x, int z) {
        return TFC_Climate.getTemp(world, day, 12, x, z);
    }

    public static float getHeightAdjustedTemp(World world, int x, int y, int z) {
        float temp = TFC_Climate.getTemp(world, x, z);
        temp += TFC_Climate.getTemp(world, x + 1, z);
        temp += TFC_Climate.getTemp(world, x - 1, z);
        temp += TFC_Climate.getTemp(world, x, z + 1);
        temp += TFC_Climate.getTemp(world, x, z - 1);
        temp /= 5.0f;
        temp = TFC_Climate.adjustHeightToTemp(y, temp);
        float light = 1.0f;
        if (world.func_72863_F() != null) {
            if (world.func_72937_j(x, y, z)) {
                light = 0.0f;
            } else {
                float bl = world.func_72957_l(x, y, z);
                light = 0.25f * (1.0f - bl / 15.0f);
            }
        }
        if (temp > 0.0f) {
            return temp - temp * light;
        }
        return temp;
    }

    public static float adjustHeightToTemp(int y, float temp) {
        if (y > 144) {
            int i = y - 144;
            if (i >= Y_FACTOR_CACHE.length) {
                i = Y_FACTOR_CACHE.length - 1;
            }
            temp -= Y_FACTOR_CACHE[i];
        }
        return temp;
    }

    public static float getHeightAdjustedTempSpecificDay(World world, int day, int x, int y, int z) {
        float temp = TFC_Climate.getTempSpecificDay(world, day, x, z);
        temp = TFC_Climate.adjustHeightToTemp(y, temp);
        return temp;
    }

    public static float getHeightAdjustedTempSpecificDay(World world, int day, int hour, int x, int y, int z) {
        float temp = TFC_Climate.getTemp(world, day, hour, x, z);
        temp = TFC_Climate.adjustHeightToTemp(y, temp);
        return temp;
    }

    public static float getHeightAdjustedBioTemp(World world, int day, int x, int y, int z) {
        float temp = TFC_Climate.getBioTemp(world, day, x, z);
        temp = TFC_Climate.adjustHeightToTemp(y, temp);
        return temp;
    }

    public static float getMaxTemperature() {
        return 52.0f;
    }

    public static float getBioTemperatureHeight(World world, int x, int y, int z) {
        float temp = 0.0f;
        for (int i = 0; i < 12; ++i) {
            float t = TFC_Climate.getHeightAdjustedBioTemp(world, i * TFC_Time.daysInMonth, x, y, z);
            temp += t;
        }
        return temp / 12.0f;
    }

    public static float getBioTemperature(World world, int x, int z) {
        float temp = 0.0f;
        for (int i = 0; i < 24; ++i) {
            float t = TFC_Climate.getBioTemp(world, i * TFC_Time.daysInMonth / 2, x, z);
            temp += t;
        }
        return temp / 24.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public static int getGrassColor(World world, int x, int y, int z) {
        float temp = (TFC_Climate.getTemp(world, x, z) + TFC_Climate.getMaxTemperature()) / (TFC_Climate.getMaxTemperature() * 2.0f);
        float rain = TFC_Climate.getRainfall(world, x, y, z) / 8000.0f;
        double var1 = Helper.clampFloat(temp, 0.0f, 1.0f);
        double var3 = Helper.clampFloat(rain, 0.0f, 1.0f);
        return ColorizerGrassTFC.getGrassColor(var1, var3);
    }

    @SideOnly(value=Side.CLIENT)
    public static int getFoliageColor(World world, int x, int y, int z) {
        float temperature = TFC_Climate.getHeightAdjustedTempSpecificDay(world, TFC_Time.getDayOfYear(), x, y, z);
        float rainfall = TFC_Climate.getRainfall(world, x, y, z);
        if (temperature > 5.0f && rainfall > 100.0f) {
            float temp = (temperature + 35.0f) / (TFC_Climate.getMaxTemperature() + 35.0f);
            float rain = rainfall / 8000.0f;
            double var1 = Helper.clampFloat(temp, 0.0f, 1.0f);
            double var3 = Helper.clampFloat(rain, 0.0f, 1.0f);
            return ColorizerFoliageTFC.getFoliageColor(var1, var3);
        }
        return ColorizerFoliageTFC.getFoliageDead();
    }

    @SideOnly(value=Side.CLIENT)
    public static int getFoliageColorEvergreen(World world, int x, int y, int z) {
        float rainfall = TFC_Climate.getRainfall(world, x, y, z);
        if (rainfall > 100.0f) {
            float temp = (TFC_Climate.getTemp(world, x, z) + 35.0f) / (TFC_Climate.getMaxTemperature() + 35.0f);
            float rain = rainfall / 8000.0f;
            double var1 = Helper.clampFloat(temp, 0.0f, 1.0f);
            double var3 = Helper.clampFloat(rain, 0.0f, 1.0f);
            return ColorizerFoliageTFC.getFoliageColor(var1, var3);
        }
        return ColorizerFoliageTFC.getFoliageDead();
    }

    public static float getRainfall(World world, int x, int y, int z) {
        ChunkData cd;
        if (world.field_72995_K && TFC_Core.getCDM(world) != null && (cd = TFC_Core.getCDM(world).getData(x >> 4, z >> 4)) != null) {
            return cd.getRainfall(x & 0xF, z & 0xF);
        }
        if (TFC_Climate.getCacheManager(world) != null) {
            DataLayer dl = TFC_Climate.getCacheManager(world).getRainfallLayerAt(x, z);
            return dl != null ? dl.floatdata1 : DataLayer.RAIN_500.floatdata1;
        }
        return DataLayer.RAIN_500.floatdata1;
    }

    public static int getTreeLayer(World world, int x, int y, int z, int index) {
        return TFC_Climate.getCacheManager((World)world).getTreeLayerAt((int)x, (int)z, (int)index).data1;
    }

    public static DataLayer getRockLayer(World world, int x, int y, int z, int index) {
        return TFC_Climate.getCacheManager(world).getRockLayerAt(x, z, index);
    }

    public static int getMaxZPos() {
        return 30000;
    }

    public static boolean isSwamp(World world, int x, int y, int z) {
        float rain = TFC_Climate.getRainfall(world, x, y, z);
        float evt = TFC_Climate.getCacheManager((World)world).getEVTLayerAt((int)x, (int)z).floatdata1;
        return rain >= 1000.0f && (double)evt <= 0.25 && (double)world.func_72807_a((int)x, (int)z).field_76749_E < 0.15;
    }

    public static int getStability(World world, int x, int z) {
        if (TFC_Climate.getCacheManager(world) != null) {
            return TFC_Climate.getCacheManager((World)world).getStabilityLayerAt((int)x, (int)z).data1;
        }
        return 0;
    }

    public static WorldCacheManager getCacheManager(World world) {
        return worldPair.get(world);
    }

    public static void removeCacheManager(World world) {
        if (worldPair.containsKey(world)) {
            worldPair.remove(world);
        }
    }
}

