/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.Core.Util;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class CaseInsensitiveHashMap<V>
extends HashMap<String, V> {
    public CaseInsensitiveHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public CaseInsensitiveHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public CaseInsensitiveHashMap() {
    }

    public CaseInsensitiveHashMap(Map<? extends String, ? extends V> m) {
        super(CaseInsensitiveHashMap.toLowercase(m));
    }

    private static Map<String, Object> toLowercase(Map<? extends String, ?> m) {
        ImmutableMap.Builder temp = ImmutableMap.builder();
        for (Map.Entry<String, ?> entry : m.entrySet()) {
            temp.put((Object)CaseInsensitiveHashMap.toLowercase(entry.getKey()), entry.getValue());
        }
        return temp.build();
    }

    private static String toString(Object o) {
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    private static String toLowercase(String key) {
        if (Strings.isNullOrEmpty((String)key)) {
            return key;
        }
        return key.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public V get(Object key) {
        return this.get(CaseInsensitiveHashMap.toString(key));
    }

    @Override
    public V put(String key, V value) {
        return super.put(CaseInsensitiveHashMap.toLowercase(key), value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        super.putAll(CaseInsensitiveHashMap.toLowercase(m));
    }

    @Override
    public V remove(Object key) {
        return this.remove(CaseInsensitiveHashMap.toString(key));
    }

    public V get(String key) {
        return super.get(CaseInsensitiveHashMap.toLowercase(key));
    }

    public V remove(String key) {
        return super.remove(CaseInsensitiveHashMap.toLowercase(key));
    }
}

