/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.Core;

import com.bioxx.tfc.Core.TFC_Climate;
import com.bioxx.tfc.Core.TFC_Time;
import java.util.Random;
import net.minecraft.world.World;

public class WeatherManager {
    protected static final WeatherManager INSTANCE = new WeatherManager();
    private Random rand = new Random();
    private Random clientRand = new Random();
    public long seed;

    public static final WeatherManager getInstance() {
        return INSTANCE;
    }

    public float getDailyTemp() {
        this.rand.setSeed(this.seed + (long)TFC_Time.getTotalDays());
        return (this.rand.nextInt(200) - 100) / 10;
    }

    public float getDailyTemp(int day) {
        this.rand.setSeed(this.seed + (long)day);
        return (this.rand.nextInt(200) - 100) / 20;
    }

    public float getWeeklyTemp(int week) {
        this.rand.setSeed(this.seed + (long)week);
        return (this.rand.nextInt(200) - 100) / 10;
    }

    public static int getDayOfWeek(long day) {
        long days = day / 6L;
        return (int)(day - days * 6L);
    }

    public static boolean canSnow(World world, int x, int y, int z) {
        return TFC_Climate.getHeightAdjustedTemp(world, x, y, z) <= 0.0f;
    }

    public float getLocalFog(World world, int x, int y, int z) {
        int hour;
        if (world.field_72995_K && (hour = TFC_Time.getHour()) >= 4 && hour < 9) {
            this.clientRand.setSeed(TFC_Time.getTotalDays());
            float rain = TFC_Climate.getRainfall(world, x, y, z);
            float strength = this.clientRand.nextFloat();
            if (rain >= 500.0f && this.clientRand.nextInt(3) == 0) {
                float mult = 1.0f;
                if (9 - hour < 2) {
                    mult = 0.5f;
                }
                return strength * mult;
            }
        }
        return 0.0f;
    }

    public float getSnowStrength() {
        int hour = TFC_Time.getHour();
        this.clientRand.setSeed(TFC_Time.getTotalDays() + hour);
        return this.clientRand.nextFloat();
    }
}

