/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.Entities;

import com.bioxx.tfc.Blocks.Terrain.BlockCobble;
import com.bioxx.tfc.Blocks.Terrain.BlockOre;
import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.api.TFCBlocks;
import com.bioxx.tfc.api.TFCOptions;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityFallingBlockTFC
extends Entity
implements IEntityAdditionalSpawnData {
    private Block block;
    public int blockMeta;
    public int aliveTimer;
    public boolean shouldDropItem = true;
    private boolean hurtEntities;
    public int maxDamage = 2000;
    public float damage = 100.0f;
    public NBTTagCompound tileEntityData;

    public EntityFallingBlockTFC(World world) {
        super(world);
    }

    public EntityFallingBlockTFC(World world, double x, double y, double z, Block b) {
        this(world, x, y, z, b, 0);
    }

    public EntityFallingBlockTFC(World world, double x, double y, double z, Block b, int meta) {
        this(world);
        this.shouldDropItem = false;
        this.block = b;
        this.blockMeta = meta;
        this.field_70156_m = true;
        this.func_70105_a(0.98f, 0.98f);
        this.field_70129_M = this.field_70131_O / 2.0f;
        this.func_70107_b(x, y, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.hurtEntities = b instanceof BlockCobble;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70071_h_() {
        if (this.block == null) {
            return;
        }
        if (this.block.func_149688_o() == Material.field_151579_a) {
            this.func_70106_y();
        } else {
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            ++this.aliveTimer;
            this.field_70181_x -= (double)0.04f;
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.98f;
            this.field_70181_x *= (double)0.98f;
            this.field_70179_y *= (double)0.98f;
            if (!this.field_70170_p.field_72995_K) {
                int i = MathHelper.func_76128_c((double)this.field_70165_t);
                int j = MathHelper.func_76128_c((double)this.field_70163_u);
                int k = MathHelper.func_76128_c((double)this.field_70161_v);
                if (this.aliveTimer == 1) {
                    this.field_70170_p.func_147468_f(i, j, k);
                }
                if (this.field_70122_E) {
                    if (this.canReplace(this.field_70170_p, i, j, k)) {
                        this.field_70170_p.func_147468_f(i, j, k);
                    } else if (this.field_70170_p.func_147439_a(i, j, k).func_149669_A() < 1.0) {
                        ++j;
                    }
                    if (this.canReplace(this.field_70170_p, i, j - 1, k)) {
                        this.field_70170_p.func_147468_f(i, j - 1, k);
                        this.field_70122_E = false;
                    }
                }
                if (this.field_70122_E) {
                    this.field_70159_w *= (double)0.7f;
                    this.field_70179_y *= (double)0.7f;
                    this.field_70181_x *= -0.5;
                    if (this.field_70170_p.func_147439_a(i, j, k) != Blocks.field_150326_M) {
                        this.func_70106_y();
                        if (this.canPlaceEntityOnSide(this.field_70170_p, this.block, i, j, k, true, 1, null, null) && !BlockFalling.func_149831_e((World)this.field_70170_p, (int)i, (int)(j - 1), (int)k)) {
                            TileEntity tileentity;
                            if (this.tileEntityData != null && this.block instanceof ITileEntityProvider && (tileentity = this.field_70170_p.func_147438_o(i, j, k)) != null) {
                                NBTTagCompound nbttagcompound = new NBTTagCompound();
                                tileentity.func_145841_b(nbttagcompound);
                                for (String s : this.tileEntityData.func_150296_c()) {
                                    NBTBase nbtbase = this.tileEntityData.func_74781_a(s);
                                    if ("x".equals(s) || "y".equals(s) || "z".equals(s)) continue;
                                    nbttagcompound.func_74782_a(s, nbtbase.func_74737_b());
                                }
                                tileentity.func_145839_a(nbttagcompound);
                                tileentity.func_70296_d();
                            }
                        } else if (this.shouldDropItem) {
                            this.func_70099_a(new ItemStack(this.block, 1, this.block.func_149692_a(this.blockMeta)), 0.0f);
                        }
                    }
                } else if (this.aliveTimer > 100 && !this.field_70170_p.field_72995_K && (j < 1 || j > 256) || this.aliveTimer > 600) {
                    if (this.shouldDropItem) {
                        this.func_70099_a(new ItemStack(this.block, 1, this.block.func_149692_a(this.blockMeta)), 0.0f);
                    }
                    this.func_70106_y();
                }
            }
        }
    }

    public boolean canPlaceEntityOnSide(World world, Block fallingBlock, int x, int y, int z, boolean skipEntityCheck, int side, Entity thisEntity, ItemStack is) {
        AxisAlignedBB axisalignedbb = null;
        if (!skipEntityCheck && !world.func_72917_a(axisalignedbb = fallingBlock.func_149668_a(world, x, y, z), thisEntity)) {
            return false;
        }
        Block block1 = world.func_147439_a(x, y, z);
        return block1.func_149688_o() == Material.field_151594_q ? true : this.canReplace(world, x, y, z);
    }

    public boolean canReplace(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (this.canDestroy(b) && (b.isAir((IBlockAccess)world, x, y, z) || !b.func_149662_c() && !b.func_149686_d() && !this.field_70170_p.isSideSolid(x, y, z, ForgeDirection.UP))) {
            return TFC_Core.setBlockWithDrops(this.field_70170_p, x, y, z, this.getBlock(), this.blockMeta);
        }
        if (b instanceof BlockOre && TFCOptions.enableCaveInsDestroyOre) {
            return world.func_147468_f(x, y, z);
        }
        return false;
    }

    private boolean canDestroy(Block b) {
        return b != TFCBlocks.charcoal && b != TFCBlocks.molten;
    }

    protected void func_70069_a(float fallDistance) {
        int height;
        if (this.hurtEntities && (height = MathHelper.func_76123_f((float)(fallDistance - 1.0f))) > 0) {
            ArrayList arraylist = new ArrayList(this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D));
            DamageSource damagesource = new DamageSource("caveIn").func_76348_h().func_151518_m();
            for (Entity entity : arraylist) {
                entity.func_70097_a(damagesource, (float)Math.min(MathHelper.func_76141_d((float)((float)height * this.damage)), this.maxDamage));
            }
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74774_a("Tile", (byte)Block.func_149682_b((Block)this.block));
        nbt.func_74768_a("TileID", Block.func_149682_b((Block)this.block));
        nbt.func_74774_a("Data", (byte)this.blockMeta);
        nbt.func_74774_a("Time", (byte)this.aliveTimer);
        nbt.func_74757_a("DropItem", this.shouldDropItem);
        nbt.func_74757_a("HurtEntities", this.hurtEntities);
        nbt.func_74776_a("FallHurtAmount", this.damage);
        nbt.func_74768_a("FallHurtMax", this.maxDamage);
        if (this.tileEntityData != null) {
            nbt.func_74782_a("TileEntityData", (NBTBase)this.tileEntityData);
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.block = nbt.func_150297_b("TileID", 99) ? Block.func_149729_e((int)nbt.func_74762_e("TileID")) : Block.func_149729_e((int)(nbt.func_74771_c("Tile") & 0xFF));
        this.blockMeta = nbt.func_74771_c("Data") & 0xFF;
        this.aliveTimer = nbt.func_74771_c("Time") & 0xFF;
        if (nbt.func_150297_b("HurtEntities", 99)) {
            this.hurtEntities = nbt.func_74767_n("HurtEntities");
            this.damage = nbt.func_74760_g("FallHurtAmount");
            this.maxDamage = nbt.func_74762_e("FallHurtMax");
        } else if (this.block instanceof BlockCobble) {
            this.hurtEntities = true;
        }
        if (nbt.func_150297_b("DropItem", 99)) {
            this.shouldDropItem = nbt.func_74767_n("DropItem");
        }
        if (nbt.func_150297_b("TileEntityData", 10)) {
            this.tileEntityData = nbt.func_74775_l("TileEntityData");
        }
        if (this.block.func_149688_o() == Material.field_151579_a) {
            this.block = Blocks.field_150354_m;
        }
    }

    public void setHurt(boolean hurt) {
        this.hurtEntities = hurt;
    }

    public void func_85029_a(CrashReportCategory category) {
        super.func_85029_a(category);
        category.func_71507_a("Immitating block ID", (Object)Block.func_149682_b((Block)this.block));
        category.func_71507_a("Immitating block data", (Object)this.blockMeta);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public World getWorld() {
        return this.field_70170_p;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    public Block getBlock() {
        return this.block;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(Block.func_149682_b((Block)this.block));
        buffer.writeByte(this.blockMeta & 0xF);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.block = Block.func_149729_e((int)additionalData.readInt());
        this.blockMeta = additionalData.readByte();
    }
}

