/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.Entities.Mobs;

import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.Core.TFC_Time;
import com.bioxx.tfc.Entities.AI.EntityAIAvoidEntityTFC;
import com.bioxx.tfc.Entities.AI.EntityAIFindNest;
import com.bioxx.tfc.Entities.Mobs.EntityWolfTFC;
import com.bioxx.tfc.Food.ItemFoodTFC;
import com.bioxx.tfc.Items.ItemCustomNameTag;
import com.bioxx.tfc.api.Entities.IAnimal;
import com.bioxx.tfc.api.TFCItems;
import com.bioxx.tfc.api.TFCOptions;
import com.bioxx.tfc.api.Util.Helper;
import java.nio.ByteBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIEatGrass;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityChickenTFC
extends EntityChicken
implements IAnimal {
    private static final float DIMORPHISM = 0.0606f;
    private static final int DEGREE_OF_DIVERSION = 2;
    protected static final int FAMILIARITY_CAP = 45;
    private static final int EGG_TIME = 24000;
    private final EntityAIEatGrass aiEatGrass = new EntityAIEatGrass((EntityLiving)this);
    private int sex;
    private int hunger;
    private float sizeMod;
    private float strengthMod;
    private float aggressionMod = 1.0f;
    private float obedienceMod = 1.0f;
    private boolean inLove;
    private long nextEgg;
    private int familiarity;
    private long lastFamiliarityUpdate;
    private boolean familiarizedToday;

    public EntityChickenTFC(World par1World) {
        super(par1World);
        this.func_70105_a(0.3f, 0.7f);
        this.field_70887_j = 9999;
        this.nextEgg = TFC_Time.getTotalTicks() + 24000L;
        this.hunger = 168000;
        this.sex = this.field_70146_Z.nextInt(2);
        this.field_70714_bg.field_75782_a.clear();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.4));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityChickenTFC.class, 6.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntityTFC((EntityCreature)this, EntityWolfTFC.class, 8.0f, 0.5, 0.7f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiEatGrass);
        this.addAI();
        this.sizeMod = (float)Math.sqrt(((float)(this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(30) + 1) * (this.field_70146_Z.nextBoolean() ? 1 : -1)) * 0.01f + 1.0f) * (1.0f - 0.0606f * (float)this.sex));
        this.strengthMod = (float)Math.sqrt((float)(this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(20) + 1) * (this.field_70146_Z.nextBoolean() ? 1 : -1)) * 0.01f + this.sizeMod);
        this.aggressionMod = (float)Math.sqrt((float)(this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(20) + 1) * (this.field_70146_Z.nextBoolean() ? 1 : -1)) * 0.01f + 1.0f);
        this.obedienceMod = (float)Math.sqrt((float)(this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(20) + 1) * (this.field_70146_Z.nextBoolean() ? 1 : -1)) * 0.01f + 1.0f / this.aggressionMod);
        this.setAge(TFC_Time.getTotalDays() - this.getNumberOfDaysToAdult());
    }

    public EntityChickenTFC(World world, double posX, double posY, double posZ, NBTTagCompound genes) {
        this(world);
        this.field_70165_t = posX;
        this.field_70163_u = posY;
        this.field_70161_v = posZ;
        float motherSize = genes.func_74760_g("m_size");
        float fatherSize = genes.func_74760_g("f_size");
        this.sizeMod = ((float)(this.field_70146_Z.nextInt(3) * (this.field_70146_Z.nextBoolean() ? 1 : -1)) / 10.0f + 1.0f) * (1.0f - 0.1f * (float)this.sex) * (float)Math.sqrt((motherSize + fatherSize) / 1.9f);
        this.setAge(TFC_Time.getTotalDays());
    }

    public void addAI() {
        if (this.sex == 0) {
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        }
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, (double)1.2f, TFCItems.wheatGrain, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, (double)1.2f, TFCItems.ryeGrain, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, (double)1.2f, TFCItems.riceGrain, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, (double)1.2f, TFCItems.barleyGrain, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, (double)1.2f, TFCItems.oatGrain, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, (double)1.2f, TFCItems.maizeEar, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFindNest((EntityAnimal)this, 1.2f));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
    }

    @Override
    public boolean canFamiliarize() {
        return !this.isAdult() || this.isAdult() && this.familiarity <= 45;
    }

    @Override
    public boolean canMateWith(IAnimal animal) {
        return animal.getGender() != this.getGender() && this.isAdult() && animal.isAdult() && animal.getAnimalTypeID() == this.getAnimalTypeID();
    }

    @Override
    public boolean checkFamiliarity(IAnimal.InteractionEnum interaction, EntityPlayer player) {
        boolean flag = false;
        switch (interaction) {
            case NAME: {
                flag = this.familiarity > 50;
                break;
            }
        }
        if (!flag && player != null && !player.field_70170_p.field_72995_K) {
            TFC_Core.sendInfoMessage(player, (IChatComponent)new ChatComponentTranslation("entity.notFamiliar", new Object[0]));
        }
        return flag;
    }

    public EntityChicken func_90011_a(EntityAgeable entityAgeable) {
        return (EntityChicken)this.createChildTFC(entityAgeable);
    }

    @Override
    public EntityAgeable createChildTFC(EntityAgeable entityageable) {
        if (entityageable instanceof IAnimal) {
            IAnimal animal = (IAnimal)entityageable;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74776_a("m_size", animal.getSizeMod());
            nbt.func_74776_a("f_size", animal.getSizeMod());
            return new EntityChickenTFC(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, nbt);
        }
        return null;
    }

    protected void func_70628_a(boolean par1, int par2) {
        float ageMod = TFC_Core.getPercentGrown(this);
        this.func_145779_a(Items.field_151008_G, (int)(ageMod * this.sizeMod * (float)(5 + this.field_70146_Z.nextInt(10))));
        if (this.isAdult()) {
            float foodWeight = ageMod * (this.sizeMod * 40.0f);
            TFC_Core.animalDropMeat((Entity)this, TFCItems.chickenRaw, foodWeight);
            this.func_145779_a(Items.field_151103_aS, this.field_70146_Z.nextInt(2) + 1);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(13, (Object)0);
        this.field_70180_af.func_75682_a(15, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
    }

    @Override
    public void familiarize(EntityPlayer ep) {
        ItemStack stack = ep.func_70694_bm();
        if (stack != null && this.isFood(stack) && !this.familiarizedToday && this.canFamiliarize()) {
            if (!ep.field_71075_bZ.field_75098_d) {
                ep.field_71071_by.func_70299_a(ep.field_71071_by.field_70461_c, ((ItemFoodTFC)stack.func_77973_b()).onConsumedByEntity(ep.func_70694_bm(), this.field_70170_p, (EntityLivingBase)this));
            } else {
                this.field_70170_p.func_72956_a((Entity)this, "random.burp", 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            this.hunger += 24000;
            this.familiarizedToday = true;
            this.func_70671_ap().func_75651_a((Entity)ep, 0.0f, 0.0f);
            this.func_70642_aH();
        }
    }

    @Override
    public float getAggressionMod() {
        return this.aggressionMod;
    }

    @Override
    public int getAnimalTypeID() {
        return Helper.stringToInt("chicken");
    }

    @Override
    public Vec3 getAttackedVec() {
        return null;
    }

    @Override
    public int getBirthDay() {
        return this.field_70180_af.func_75679_c(15);
    }

    protected Item func_146068_u() {
        return Items.field_151008_G;
    }

    @Override
    public int getDueDay() {
        return 0;
    }

    public ItemStack getEggs() {
        if (TFC_Time.getTotalTicks() >= this.nextEgg) {
            this.nextEgg = TFC_Time.getTotalTicks() + 24000L;
            return new ItemStack(TFCItems.egg, 1);
        }
        return null;
    }

    @Override
    public EntityLiving getEntity() {
        return this;
    }

    @Override
    public int getFamiliarity() {
        return this.familiarity;
    }

    @Override
    public boolean getFamiliarizedToday() {
        return this.familiarizedToday;
    }

    @Override
    public Entity getFearSource() {
        return null;
    }

    @Override
    public IAnimal.GenderEnum getGender() {
        return IAnimal.GenderEnum.GENDERS[this.field_70180_af.func_75679_c(13)];
    }

    @Override
    public int getHunger() {
        return this.hunger;
    }

    @Override
    public boolean getInLove() {
        return this.inLove;
    }

    public long getLastFamiliarityUpdate() {
        return this.lastFamiliarityUpdate;
    }

    public long getNextEgg() {
        return this.nextEgg;
    }

    @Override
    public int getNumberOfDaysToAdult() {
        return (int)((double)(TFCOptions.animalTimeMultiplier * (float)TFC_Time.daysInMonth) * 4.14);
    }

    @Override
    public float getObedienceMod() {
        return this.obedienceMod;
    }

    public int getSex() {
        return this.sex;
    }

    @Override
    public float getSizeMod() {
        return this.sizeMod;
    }

    @Override
    public float getStrengthMod() {
        return this.strengthMod;
    }

    @Override
    public void handleFamiliarityUpdate() {
        int totalDays = TFC_Time.getTotalDays();
        if (this.lastFamiliarityUpdate < (long)totalDays) {
            if (this.familiarizedToday && this.familiarity < 100) {
                this.lastFamiliarityUpdate = totalDays;
                this.familiarizedToday = false;
                float familiarityChange = 6.0f * this.obedienceMod / this.aggressionMod;
                if (this.isAdult() && this.familiarity <= 45) {
                    this.familiarity = (int)((float)this.familiarity + familiarityChange);
                } else if (!this.isAdult()) {
                    float ageMod = 2.0f / (1.0f + TFC_Core.getPercentGrown(this));
                    this.familiarity = (int)((float)this.familiarity + ageMod * familiarityChange);
                    if (this.familiarity > 70) {
                        this.obedienceMod *= 1.01f;
                    }
                }
            } else if (this.familiarity < 30) {
                this.familiarity = (int)((long)this.familiarity - 2L * ((long)TFC_Time.getTotalDays() - this.lastFamiliarityUpdate));
                this.lastFamiliarityUpdate = totalDays;
            }
        }
        if (this.familiarity > 100) {
            this.familiarity = 100;
        }
        if (this.familiarity < 0) {
            this.familiarity = 0;
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack itemstack = player.func_70694_bm();
        if (!this.field_70170_p.field_72995_K) {
            if (this.isAdult() && player.func_70093_af() && !this.isFood(itemstack) && this.func_70097_a(DamageSource.field_76377_j, 5.0f)) {
                player.field_71071_by.func_70441_a(new ItemStack(Items.field_151008_G, 1));
                this.familiarity -= 4;
                return true;
            }
            if (player.func_70093_af() && !this.familiarizedToday && this.canFamiliarize()) {
                this.familiarize(player);
                return true;
            }
        }
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemCustomNameTag && itemstack.func_77942_o() && itemstack.field_77990_d.func_74764_b("ItemName")) {
            if (this.trySetName(itemstack.field_77990_d.func_74779_i("ItemName"), player)) {
                --itemstack.field_77994_a;
            }
            return true;
        }
        return super.func_70085_c(player);
    }

    @Override
    public boolean isAdult() {
        return this.getBirthDay() + this.getNumberOfDaysToAdult() <= TFC_Time.getTotalDays();
    }

    public boolean func_70650_aV() {
        return true;
    }

    public boolean func_70877_b(ItemStack par1ItemStack) {
        return false;
    }

    public boolean func_70631_g_() {
        return !this.isAdult();
    }

    @Override
    public boolean isFood(ItemStack item) {
        return item != null && (item.func_77973_b() == TFCItems.wheatGrain || item.func_77973_b() == TFCItems.oatGrain || item.func_77973_b() == TFCItems.riceGrain || item.func_77973_b() == TFCItems.barleyGrain || item.func_77973_b() == TFCItems.ryeGrain || item.func_77973_b() == TFCItems.maizeEar);
    }

    @Override
    public boolean isPregnant() {
        return false;
    }

    @Override
    public void mate(IAnimal otherAnimal) {
    }

    public void func_70636_d() {
        if (this.hunger > 168000) {
            this.hunger = 168000;
        }
        if (this.hunger > 0) {
            --this.hunger;
        }
        this.syncData();
        if (this.isAdult()) {
            this.func_70873_a(0);
        } else {
            this.func_70873_a(-1);
        }
        this.roosterCrow();
        this.handleFamiliarityUpdate();
        this.field_70887_j = 9999;
        TFC_Core.preventEntityDataUpdate = true;
        if (this.getGender() == IAnimal.GenderEnum.MALE) {
            this.nextEgg = 10000L;
        }
        super.func_70636_d();
        TFC_Core.preventEntityDataUpdate = false;
        if (this.hunger > 144000 && this.field_70146_Z.nextInt(100) == 0 && this.func_110143_aJ() < TFC_Core.getEntityMaxHealth((EntityLivingBase)this) && !this.field_70128_L) {
            this.func_70691_i(1.0f);
        } else if (this.hunger < 144000 && super.func_70880_s()) {
            this.setInLove(false);
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.sex = nbt.func_74762_e("Sex");
        this.sizeMod = nbt.func_74760_g("Size Modifier");
        this.familiarity = nbt.func_74762_e("Familiarity");
        this.lastFamiliarityUpdate = nbt.func_74763_f("lastFamUpdate");
        this.familiarizedToday = nbt.func_74767_n("Familiarized Today");
        this.strengthMod = nbt.func_74760_g("Strength Modifier");
        this.aggressionMod = nbt.func_74760_g("Aggression Modifier");
        this.obedienceMod = nbt.func_74760_g("Obedience Modifier");
        this.hunger = nbt.func_74762_e("Hunger");
        this.field_70180_af.func_75692_b(15, (Object)nbt.func_74762_e("Age"));
        this.nextEgg = nbt.func_74763_f("nextEgg");
    }

    public void roosterCrow() {
        if ((TFC_Time.getTotalTicks() - 15L) % 24000L == 0L && this.getGender() == IAnimal.GenderEnum.MALE && this.isAdult() && this.field_70170_p.func_72937_j((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v)) {
            this.func_85030_a("terrafirmacraft:mob.rooster.cry", 6.0f, this.field_70146_Z.nextFloat() / 2.0f + 0.75f);
        }
    }

    @Override
    public void setAge(int par1) {
        this.field_70180_af.func_75692_b(15, (Object)par1);
    }

    @Override
    public void setAggressionMod(float aggressionMod) {
        this.aggressionMod = aggressionMod;
    }

    @Override
    public void setAttackedVec(Vec3 attackedVec) {
    }

    @Override
    public void setBirthDay(int day) {
        this.field_70180_af.func_75692_b(15, (Object)day);
    }

    @Override
    public void setFamiliarity(int familiarity) {
        this.familiarity = familiarity;
    }

    public void setFamiliarizedToday(boolean familiarizedToday) {
        this.familiarizedToday = familiarizedToday;
    }

    @Override
    public void setFearSource(Entity fearSource) {
    }

    public void func_70873_a(int par1) {
        if (!TFC_Core.preventEntityDataUpdate) {
            this.field_70180_af.func_75692_b(12, (Object)par1);
        }
    }

    @Override
    public void setHunger(int h) {
        this.hunger = h;
    }

    @Override
    public void setInLove(boolean b) {
        this.inLove = b;
    }

    public void setLastFamiliarityUpdate(long lastFamiliarityUpdate) {
        this.lastFamiliarityUpdate = lastFamiliarityUpdate;
    }

    public void setNextEgg(long nextEgg) {
        this.nextEgg = nextEgg;
    }

    @Override
    public void setObedienceMod(float obedienceMod) {
        this.obedienceMod = obedienceMod;
    }

    public void setSex(int sex) {
        this.sex = sex;
    }

    @Override
    public void setSizeMod(float sizeMod) {
        this.sizeMod = sizeMod;
    }

    @Override
    public void setStrengthMod(float strengthMod) {
        this.strengthMod = strengthMod;
    }

    public void syncData() {
        if (this.field_70180_af != null) {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_75692_b(13, (Object)this.sex);
                byte[] values = new byte[]{TFC_Core.getByteFromSmallFloat(this.sizeMod), TFC_Core.getByteFromSmallFloat(this.strengthMod), TFC_Core.getByteFromSmallFloat(this.aggressionMod), TFC_Core.getByteFromSmallFloat(this.obedienceMod), (byte)this.familiarity, (byte)(this.familiarizedToday ? 1 : 0), 0, 0};
                ByteBuffer buf = ByteBuffer.wrap(values);
                this.field_70180_af.func_75692_b(22, (Object)buf.getInt());
                this.field_70180_af.func_75692_b(23, (Object)buf.getInt());
            } else {
                this.sex = this.field_70180_af.func_75679_c(13);
                ByteBuffer buf = ByteBuffer.allocate(8);
                buf.putInt(this.field_70180_af.func_75679_c(22));
                buf.putInt(this.field_70180_af.func_75679_c(23));
                byte[] values = buf.array();
                this.sizeMod = TFC_Core.getSmallFloatFromByte(values[0]);
                this.strengthMod = TFC_Core.getSmallFloatFromByte(values[1]);
                this.aggressionMod = TFC_Core.getSmallFloatFromByte(values[2]);
                this.obedienceMod = TFC_Core.getSmallFloatFromByte(values[3]);
                this.familiarity = values[4];
                this.familiarizedToday = values[5] == 1;
            }
        }
    }

    @Override
    public boolean trySetName(String name, EntityPlayer player) {
        if (this.checkFamiliarity(IAnimal.InteractionEnum.NAME, player)) {
            this.func_94058_c(name);
            return true;
        }
        this.func_85030_a(this.func_70621_aR(), 6.0f, this.field_70146_Z.nextFloat() / 2.0f + (this.func_70631_g_() ? 1.25f : 0.75f));
        return false;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("Sex", this.sex);
        nbt.func_74776_a("Size Modifier", this.sizeMod);
        nbt.func_74768_a("Familiarity", this.familiarity);
        nbt.func_74772_a("lastFamUpdate", this.lastFamiliarityUpdate);
        nbt.func_74757_a("Familiarized Today", this.familiarizedToday);
        nbt.func_74776_a("Strength Modifier", this.strengthMod);
        nbt.func_74776_a("Aggression Modifier", this.aggressionMod);
        nbt.func_74776_a("Obedience Modifier", this.obedienceMod);
        nbt.func_74768_a("Hunger", this.hunger);
        nbt.func_74768_a("Age", this.getBirthDay());
        nbt.func_74772_a("nextEgg", this.nextEgg);
    }
}

