/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.Entities.Mobs;

import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.Core.TFC_Time;
import com.bioxx.tfc.Entities.AI.AIEatGrass;
import com.bioxx.tfc.Entities.AI.EntityAIAvoidEntityTFC;
import com.bioxx.tfc.Entities.AI.EntityAIMateTFC;
import com.bioxx.tfc.Entities.AI.EntityAIPanicTFC;
import com.bioxx.tfc.Entities.Mobs.EntityBear;
import com.bioxx.tfc.Entities.Mobs.EntityHorseBredSelector;
import com.bioxx.tfc.Entities.Mobs.EntityWolfTFC;
import com.bioxx.tfc.Food.ItemFoodTFC;
import com.bioxx.tfc.Items.ItemCustomNameTag;
import com.bioxx.tfc.TerraFirmaCraft;
import com.bioxx.tfc.api.Entities.IAnimal;
import com.bioxx.tfc.api.TFCBlocks;
import com.bioxx.tfc.api.TFCItems;
import com.bioxx.tfc.api.TFCOptions;
import com.bioxx.tfc.api.Util.Helper;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIRunAroundLikeCrazy;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.AnimalChest;
import net.minecraft.inventory.IInvBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S1BPacketEntityAttach;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityHorseTFC
extends EntityHorse
implements IInvBasic,
IAnimal {
    private static final IEntitySelector HORSE_BREEDING_SELECTOR = new EntityHorseBredSelector();
    private static final IAttribute HORSE_JUMP_STRENGTH = new RangedAttribute("horse.jumpStrengthTFC", 0.7, 0.0, 2.0).func_111117_a("Jump StrengthTFC").func_111112_a(true);
    private static final float GESTATION_PERIOD = 11.17f;
    private static final float DIMORPHISM = 0.0813f;
    private static final int DEGREE_OF_DIVERSION = 2;
    private static final int FAMILIARITY_CAP = 35;
    protected final AIEatGrass aiEatGrass = new AIEatGrass(this);
    private long animalID;
    private int sex;
    private int hunger = 168000;
    private boolean pregnant = false;
    private int pregnancyRequiredTime;
    private long timeOfConception = 0L;
    private float sizeMod;
    private float strengthMod;
    private float aggressionMod = 1.0f;
    private float obedienceMod = 1.0f;
    private float mateSizeMod;
    private float mateStrengthMod;
    private float mateAggroMod;
    private float mateObedMod;
    private int mateType;
    private int mateVariant;
    private double mateMaxHealth = this.calcMaxHealth();
    private double mateJumpStrength = this.calcJumpStrength();
    private double mateMoveSpeed = this.calcMoveSpeed();
    private boolean inLove;
    private Vec3 attackedVec;
    private Entity fearSource;
    private int familiarity;
    private long lastFamiliarityUpdate;
    private boolean familiarizedToday;

    public EntityHorseTFC(World par1World) {
        super(par1World);
        this.animalID = TFC_Time.getTotalTicks() + (long)this.func_145782_y();
        this.pregnancyRequiredTime = (int)(TFCOptions.animalTimeMultiplier * 11.17f * (float)TFC_Time.ticksInMonth);
        this.sex = this.field_70146_Z.nextInt(2);
        this.sizeMod = (float)Math.sqrt(((float)(this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(30) + 1) * (this.field_70146_Z.nextBoolean() ? 1 : -1)) * 0.01f + 1.0f) * (1.0f - 0.0813f * (float)this.sex));
        this.strengthMod = (float)Math.sqrt((float)(this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(20) + 1) * (this.field_70146_Z.nextBoolean() ? 1 : -1)) * 0.01f + this.sizeMod);
        this.aggressionMod = (float)Math.sqrt((float)(this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(20) + 1) * (this.field_70146_Z.nextBoolean() ? 1 : -1)) * 0.01f + 1.0f);
        this.obedienceMod = (float)Math.sqrt((float)(this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(20) + 1) * (this.field_70146_Z.nextBoolean() ? 1 : -1)) * 0.01f + 1.0f / this.aggressionMod);
        this.func_70105_a(1.4f, 1.6f);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.field_75782_a.clear();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIRunAroundLikeCrazy((EntityHorse)this, 1.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.7));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMateTFC(this, this.field_70170_p, 1.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntityTFC((EntityCreature)this, EntityWolfTFC.class, 8.0f, 0.5, 0.7f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntityTFC((EntityCreature)this, EntityBear.class, 16.0f, 0.25, 0.3f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, (double)1.2f, TFCItems.wheatGrain, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, (double)1.2f, TFCItems.ryeGrain, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, (double)1.2f, TFCItems.riceGrain, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, (double)1.2f, TFCItems.barleyGrain, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, (double)1.2f, TFCItems.oatGrain, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, (double)1.2f, TFCItems.maizeEar, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiEatGrass);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanicTFC((EntityCreature)this, 1.2, true));
        this.updateChestSaddle();
        this.setAge(TFC_Time.getTotalDays() - this.getNumberOfDaysToAdult());
    }

    public EntityHorseTFC(World par1World, IAnimal mother, List<Float> data, int type, int variant) {
        this(par1World);
        float fatherSize = 1.0f;
        float fatherStr = 1.0f;
        float fatherAggro = 1.0f;
        float fatherObed = 1.0f;
        block6: for (int i = 0; i < data.size(); ++i) {
            switch (i) {
                case 0: {
                    fatherSize = data.get(i).floatValue();
                    continue block6;
                }
                case 1: {
                    fatherStr = data.get(i).floatValue();
                    continue block6;
                }
                case 2: {
                    fatherAggro = data.get(i).floatValue();
                    continue block6;
                }
                case 3: {
                    fatherObed = data.get(i).floatValue();
                    continue block6;
                }
            }
        }
        this.field_70165_t = ((EntityLivingBase)mother).field_70165_t;
        this.field_70163_u = ((EntityLivingBase)mother).field_70163_u;
        this.field_70161_v = ((EntityLivingBase)mother).field_70161_v;
        float invSizeRatio = 0.52118623f;
        this.sizeMod = (float)Math.sqrt(this.sizeMod * this.sizeMod * (float)Math.sqrt((mother.getSizeMod() + fatherSize) * invSizeRatio));
        this.strengthMod = (float)Math.sqrt(this.strengthMod * this.strengthMod * (float)Math.sqrt((mother.getStrengthMod() + fatherStr) * 0.5f));
        this.aggressionMod = (float)Math.sqrt(this.aggressionMod * this.aggressionMod * (float)Math.sqrt((mother.getAggressionMod() + fatherAggro) * 0.5f));
        this.obedienceMod = (float)Math.sqrt(this.obedienceMod * this.obedienceMod * (float)Math.sqrt((mother.getObedienceMod() + fatherObed) * 0.5f));
        this.familiarity = (int)(mother.getFamiliarity() < 90 ? (float)(mother.getFamiliarity() / 2) : (float)mother.getFamiliarity() * 0.9f);
        this.setAge(TFC_Time.getTotalDays());
        this.func_110214_p(type);
        this.func_110235_q(variant);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(HORSE_JUMP_STRENGTH);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(1250.0f * this.sizeMod * this.strengthMod));
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.225f * (double)this.strengthMod * (double)this.obedienceMod / (double)(this.sizeMod * this.sizeMod));
        this.func_70606_j(this.func_110138_aP());
    }

    private double calcJumpStrength() {
        return (double)0.4f + this.field_70146_Z.nextDouble() * 0.2 + this.field_70146_Z.nextDouble() * 0.2 + this.field_70146_Z.nextDouble() * 0.2;
    }

    private float calcMaxHealth() {
        return 1000.0f + (float)this.field_70146_Z.nextInt(101) + (float)this.field_70146_Z.nextInt(151);
    }

    private double calcMoveSpeed() {
        return ((double)0.45f + this.field_70146_Z.nextDouble() * 0.3 + this.field_70146_Z.nextDouble() * 0.3 + this.field_70146_Z.nextDouble() * 0.3) * 0.25;
    }

    @Override
    public boolean canFamiliarize() {
        return !this.isAdult() || this.isAdult() && this.familiarity <= 35;
    }

    public boolean func_70878_b(EntityAnimal animal) {
        if (animal == this) {
            return false;
        }
        if (animal.getClass() != this.getClass()) {
            return false;
        }
        EntityHorseTFC entityhorse = (EntityHorseTFC)animal;
        if (this.getBreedable() && entityhorse.getBreedable()) {
            int j;
            int i = this.func_110265_bP();
            return i == (j = entityhorse.func_110265_bP()) || i == 0 && j == 1 || i == 1 && j == 0;
        }
        return false;
    }

    @Override
    public boolean canMateWith(IAnimal animal) {
        return animal.getGender() != this.getGender() && this.isAdult() && animal.isAdult() && animal instanceof EntityHorseTFC;
    }

    @Override
    public boolean checkFamiliarity(IAnimal.InteractionEnum interaction, EntityPlayer player) {
        boolean flag = false;
        switch (interaction) {
            case MOUNT: {
                flag = this.familiarity > 15;
                break;
            }
            case BREED: {
                flag = this.familiarity > 20;
                break;
            }
            case NAME: {
                flag = this.familiarity > 40;
                break;
            }
        }
        if (!flag && player != null && !player.field_70170_p.field_72995_K) {
            TFC_Core.sendInfoMessage(player, (IChatComponent)new ChatComponentTranslation("entity.notFamiliar", new Object[0]));
        }
        return flag;
    }

    public void func_110160_i(boolean par1, boolean par2) {
        Entity entity = this.func_110166_bE();
        if (entity instanceof EntityPlayer) {
            if (entity.func_70093_af()) {
                super.func_110160_i(par1, true);
            }
        } else {
            super.func_110160_i(par1, true);
        }
    }

    public EntityAgeable func_90011_a(EntityAgeable eAgeable) {
        return this.createChildTFC(eAgeable);
    }

    @Override
    public EntityAgeable createChildTFC(EntityAgeable eAgeable) {
        ArrayList<Float> data = new ArrayList<Float>();
        data.add(Float.valueOf(this.mateSizeMod));
        data.add(Float.valueOf(this.mateStrengthMod));
        data.add(Float.valueOf(this.mateAggroMod));
        data.add(Float.valueOf(this.mateObedMod));
        int momType = this.func_110265_bP();
        int dadType = this.mateType;
        int babyType = 0;
        int babyVariant = 0;
        if (momType == dadType) {
            babyType = momType;
        } else if (momType == 0 && dadType == 1 || momType == 1 && dadType == 0) {
            babyType = 2;
        }
        if (babyType == 0) {
            int l = this.field_70146_Z.nextInt(9);
            babyVariant = l < 4 ? this.func_110202_bQ() & 0xFF : (l < 8 ? this.mateVariant & 0xFF : this.field_70146_Z.nextInt(7));
            int j1 = this.field_70146_Z.nextInt(5);
            babyVariant = j1 < 4 ? (babyVariant |= this.func_110202_bQ() & 0xFF00) : (j1 < 8 ? (babyVariant |= this.mateVariant & 0xFF00) : (babyVariant |= this.field_70146_Z.nextInt(5) << 8 & 0xFF00));
        }
        EntityHorseTFC baby = new EntityHorseTFC(this.field_70170_p, this, data, babyType, babyVariant);
        double healthSum = this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() + this.mateMaxHealth + (double)this.calcMaxHealth();
        baby.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(healthSum / 3.0);
        double jumpSum = this.func_110148_a(HORSE_JUMP_STRENGTH).func_111125_b() + this.mateJumpStrength + this.calcJumpStrength();
        baby.func_110148_a(HORSE_JUMP_STRENGTH).func_111128_a(jumpSum / 3.0);
        double speedSum = this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() + this.mateMoveSpeed + this.calcMoveSpeed();
        baby.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(speedSum / 3.0);
        baby.func_70606_j((float)baby.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b());
        return baby;
    }

    public void func_110224_ci() {
        if (!this.field_70170_p.field_72995_K && this.func_110261_ca()) {
            this.func_110207_m(false);
        }
    }

    protected void func_70628_a(boolean par1, int par2) {
        float ageMod = TFC_Core.getPercentGrown(this);
        this.func_70099_a(new ItemStack(TFCItems.hide, 1, Math.max(0, Math.min(2, (int)(ageMod * 3.0f - 1.0f)))), 0.0f);
        this.func_145779_a(Items.field_151103_aS, (int)((float)(this.field_70146_Z.nextInt(8) + 3) * ageMod));
        if (this.func_110167_bD()) {
            this.func_70099_a(new ItemStack(TFCItems.rope), 0.0f);
        }
        float foodWeight = ageMod * (this.sizeMod * 4000.0f);
        TFC_Core.animalDropMeat((Entity)this, TFCItems.horseMeatRaw, foodWeight);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(13, (Object)0);
        this.field_70180_af.func_75682_a(15, (Object)0);
        this.field_70180_af.func_75682_a(26, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)0);
        this.field_70180_af.func_75682_a(25, (Object)String.valueOf("0"));
    }

    @Override
    public void familiarize(EntityPlayer ep) {
        ItemStack stack = ep.func_70694_bm();
        if ((this.field_70153_n == null || !this.field_70153_n.equals((Object)ep)) && !this.familiarizedToday && stack != null && this.isFood(stack) && this.canFamiliarize()) {
            if (!ep.field_71075_bZ.field_75098_d) {
                ep.field_71071_by.func_70299_a(ep.field_71071_by.field_70461_c, ((ItemFoodTFC)stack.func_77973_b()).onConsumedByEntity(ep.func_70694_bm(), this.field_70170_p, (EntityLivingBase)this));
            } else {
                this.field_70170_p.func_72956_a((Entity)this, "random.burp", 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            this.hunger += 24000;
            this.familiarizedToday = true;
            this.func_70671_ap().func_75651_a((Entity)ep, 0.0f, 0.0f);
            this.func_70642_aH();
        }
        if (this.field_70153_n != null && this.field_70153_n.equals((Object)ep) && this.isAdult()) {
            this.familiarizedToday = true;
            this.func_70671_ap().func_75651_a((Entity)ep, 0.0f, 0.0f);
            this.func_70642_aH();
        }
    }

    @Override
    public float getAggressionMod() {
        return this.aggressionMod;
    }

    @Override
    public int getAnimalTypeID() {
        return Helper.stringToInt("horse");
    }

    @Override
    public Vec3 getAttackedVec() {
        return this.attackedVec;
    }

    @Override
    public int getBirthDay() {
        return this.field_70180_af.func_75679_c(15);
    }

    private boolean getBreedable() {
        return this.field_70153_n == null && this.field_70154_o == null && this.func_110248_bS() && this.func_110228_bR() && !this.func_110222_cv() && this.func_110143_aJ() >= this.func_110138_aP();
    }

    protected EntityHorseTFC getClosestHorse(Entity entity, double range) {
        double maxDistance = Double.MAX_VALUE;
        EntityHorseTFC closestHorse = null;
        List list = this.field_70170_p.func_94576_a(entity, entity.field_70121_D.func_72321_a(range, range, range), HORSE_BREEDING_SELECTOR);
        for (EntityHorseTFC nearbyHorse : list) {
            double distance = nearbyHorse.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (!(distance < maxDistance)) continue;
            closestHorse = nearbyHorse;
            maxDistance = distance;
        }
        return closestHorse;
    }

    @Override
    public int getDueDay() {
        return TFC_Time.getDayFromTotalHours((this.timeOfConception + (long)this.pregnancyRequiredTime) / 1000L);
    }

    @Override
    public EntityLiving getEntity() {
        return this;
    }

    @Override
    public int getFamiliarity() {
        return this.familiarity;
    }

    @Override
    public boolean getFamiliarizedToday() {
        return this.familiarizedToday;
    }

    @Override
    public Entity getFearSource() {
        return this.fearSource;
    }

    @Override
    public IAnimal.GenderEnum getGender() {
        return IAnimal.GenderEnum.GENDERS[this.field_70180_af.func_75679_c(13)];
    }

    public AnimalChest getHorseChest() {
        return this.field_110296_bG;
    }

    @Override
    public int getHunger() {
        return this.hunger;
    }

    @Override
    public boolean getInLove() {
        return this.inLove;
    }

    public long getLastFamiliarityUpdate() {
        return this.lastFamiliarityUpdate;
    }

    public boolean func_110167_bD() {
        if (super.func_110167_bD() && this.func_110166_bE() instanceof EntityPlayer && ((EntityPlayer)this.func_110166_bE()).field_71071_by.func_70448_g() == null && this.func_110174_bM() != -1.0f) {
            return false;
        }
        return super.func_110167_bD();
    }

    public int func_110218_cm() {
        return (int)(500.0f * this.aggressionMod);
    }

    public double func_70042_X() {
        float offset = this.sizeMod * this.field_70131_O * 0.75f;
        int type = this.func_110265_bP();
        if (type == 1) {
            offset *= 0.87f;
        } else if (type == 2) {
            offset *= 0.92f;
        }
        return offset;
    }

    @Override
    public int getNumberOfDaysToAdult() {
        return (int)(TFCOptions.animalTimeMultiplier * (float)TFC_Time.daysInMonth * 30.0f);
    }

    private int getNumChestSlots() {
        int i = this.func_110265_bP();
        return this.func_110261_ca() && (i == 1 || i == 2) ? 17 : 2;
    }

    @Override
    public float getObedienceMod() {
        return this.obedienceMod;
    }

    public int getPregnancyRequiredTime() {
        return this.pregnancyRequiredTime;
    }

    public int getSex() {
        return this.sex;
    }

    @Override
    public float getSizeMod() {
        return this.sizeMod;
    }

    @Override
    public float getStrengthMod() {
        return this.strengthMod;
    }

    public long getTimeOfConception() {
        return this.timeOfConception;
    }

    @Override
    public void handleFamiliarityUpdate() {
        int totalDays = TFC_Time.getTotalDays();
        if (this.lastFamiliarityUpdate < (long)totalDays) {
            if (this.familiarizedToday && this.familiarity < 100) {
                this.lastFamiliarityUpdate = totalDays;
                this.familiarizedToday = false;
                float familiarityChange = 6.0f * this.obedienceMod / this.aggressionMod;
                if (this.isAdult() && this.familiarity <= 35) {
                    this.familiarity = (int)((float)this.familiarity + familiarityChange);
                } else if (!this.isAdult()) {
                    float ageMod = 2.0f / (1.0f + TFC_Core.getPercentGrown(this));
                    this.familiarity = (int)((float)this.familiarity + ageMod * familiarityChange);
                    if (this.familiarity > 70) {
                        this.obedienceMod *= 1.01f;
                    }
                }
            } else if (this.familiarity < 30) {
                this.familiarity = (int)((long)this.familiarity - 2L * ((long)TFC_Time.getTotalDays() - this.lastFamiliarityUpdate));
                this.lastFamiliarityUpdate = totalDays;
            }
        }
        if (this.familiarity > 100) {
            this.familiarity = 100;
        }
        if (this.familiarity < 0) {
            this.familiarity = 0;
        }
    }

    public int func_110198_t(int temper) {
        int j = MathHelper.func_76125_a((int)(this.func_110252_cg() + (int)((float)(temper *= 5) * this.obedienceMod * (1.0f / this.aggressionMod))), (int)0, (int)this.func_110218_cm());
        this.func_110238_s(j);
        return j;
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (!this.field_70170_p.field_72995_K) {
            if (player.func_70093_af() && !this.familiarizedToday && itemstack != null && this.canFamiliarize()) {
                this.familiarize(player);
                return true;
            }
            TFC_Core.sendInfoMessage(player, (IChatComponent)new ChatComponentTranslation(this.getGender() == IAnimal.GenderEnum.FEMALE ? "entity.female" : "entity.male", new Object[0]));
            if (this.getGender() == IAnimal.GenderEnum.FEMALE && this.pregnant) {
                TFC_Core.sendInfoMessage(player, (IChatComponent)new ChatComponentTranslation("entity.pregnant", new Object[0]));
            }
        }
        if (itemstack != null && this.isBreedingItemTFC(itemstack) && this.checkFamiliarity(IAnimal.InteractionEnum.BREED, player) && this.func_70874_b() == 0 && !super.func_70880_s() && (this.familiarizedToday || !this.canFamiliarize())) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ((ItemFoodTFC)itemstack.func_77973_b()).onConsumedByEntity(player.func_70694_bm(), this.field_70170_p, (EntityLivingBase)this));
            }
            this.hunger += 24000;
            this.setInLove(true);
            return true;
        }
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemCustomNameTag && itemstack.func_77942_o() && itemstack.field_77990_d.func_74764_b("ItemName")) {
            if (this.trySetName(itemstack.field_77990_d.func_74779_i("ItemName"), player)) {
                --itemstack.field_77994_a;
            }
            return true;
        }
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151063_bx) {
            return super.func_70085_c(player);
        }
        if (this.func_110248_bS() && this.func_110228_bR() && player.func_70093_af() && !this.func_110167_bD()) {
            this.func_110199_f(player);
            return true;
        }
        if (this.func_110248_bS() && this.func_110228_bR() && player.func_70093_af() && this.func_110167_bD()) {
            this.func_110160_i(true, true);
            return true;
        }
        if (this.func_110228_bR() && this.field_70153_n != null) {
            return super.func_70085_c(player);
        }
        if (itemstack != null) {
            if (!this.func_110248_bS()) {
                if (itemstack.func_111282_a(player, (EntityLivingBase)this)) {
                    return true;
                }
                this.func_110231_cz();
            }
            boolean flag = false;
            if (this.func_110229_cs() && !this.func_110261_ca() && itemstack.func_77973_b() == Item.func_150898_a((Block)TFCBlocks.chest)) {
                this.func_110207_m(true);
                this.func_85030_a("mob.chickenplop", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                flag = true;
                this.updateChestSaddle();
            }
            if (flag) {
                if (!player.field_71075_bZ.field_75098_d && --itemstack.field_77994_a == 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                }
                return true;
            }
        }
        if (this.func_110228_bR() && this.field_70153_n == null) {
            if (itemstack != null && itemstack.func_111282_a(player, (EntityLivingBase)this)) {
                return true;
            }
            if (this.func_110166_bE() instanceof EntityPlayer && this.func_110166_bE() == player) {
                this.mountHorse(player);
            }
            return true;
        }
        return super.func_70085_c(player);
    }

    @Override
    public boolean isAdult() {
        return this.getBirthDay() + this.getNumberOfDaysToAdult() <= TFC_Time.getTotalDays();
    }

    public boolean func_70877_b(ItemStack par1ItemStack) {
        return false;
    }

    public boolean isBreedingItemTFC(ItemStack item) {
        return !this.pregnant && this.isFood(item);
    }

    public boolean func_70631_g_() {
        return !this.isAdult();
    }

    @Override
    public boolean isFood(ItemStack item) {
        return item != null && (item.func_77973_b() == TFCItems.wheatGrain || item.func_77973_b() == TFCItems.oatGrain || item.func_77973_b() == TFCItems.riceGrain || item.func_77973_b() == TFCItems.barleyGrain || item.func_77973_b() == TFCItems.ryeGrain || item.func_77973_b() == TFCItems.maizeEar);
    }

    @Override
    public boolean isPregnant() {
        return this.pregnant;
    }

    @Override
    public void mate(IAnimal otherAnimal) {
        if (this.getGender() == IAnimal.GenderEnum.MALE) {
            otherAnimal.mate(this);
            this.setInLove(false);
            this.func_70875_t();
            return;
        }
        this.timeOfConception = TFC_Time.getTotalTicks();
        this.pregnant = true;
        this.func_70875_t();
        this.setInLove(false);
        otherAnimal.setInLove(false);
        this.mateSizeMod = otherAnimal.getSizeMod();
        this.mateStrengthMod = otherAnimal.getStrengthMod();
        this.mateAggroMod = otherAnimal.getAggressionMod();
        this.mateObedMod = otherAnimal.getObedienceMod();
        this.mateType = ((EntityHorse)otherAnimal).func_110265_bP();
        this.mateVariant = ((EntityHorse)otherAnimal).func_110202_bQ();
        this.mateMaxHealth = ((EntityLivingBase)otherAnimal).func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
        this.mateJumpStrength = ((EntityLivingBase)otherAnimal).func_110148_a(HORSE_JUMP_STRENGTH).func_111125_b();
        this.mateMoveSpeed = ((EntityLivingBase)otherAnimal).func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b();
    }

    private void mountHorse(EntityPlayer player) {
        player.field_70177_z = this.field_70177_z;
        player.field_70125_A = this.field_70125_A;
        this.func_110227_p(false);
        this.func_110219_q(false);
        if (!this.field_70170_p.field_72995_K && this.checkFamiliarity(IAnimal.InteractionEnum.MOUNT, player)) {
            player.func_70078_a((Entity)this);
        }
    }

    public void func_70636_d() {
        if (this.hunger > 168000) {
            this.hunger = 168000;
        }
        if (this.hunger > 0) {
            --this.hunger;
        }
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer && this.field_70146_Z.nextInt(600) == 0 && !this.familiarizedToday && this.canFamiliarize()) {
            this.familiarize((EntityPlayer)this.field_70153_n);
        }
        this.syncData();
        if (this.isAdult()) {
            this.func_70873_a(0);
        } else {
            this.func_70873_a(-1);
        }
        this.handleFamiliarityUpdate();
        if (!this.field_70170_p.field_72995_K && this.isPregnant() && TFC_Time.getTotalTicks() >= this.timeOfConception + (long)this.pregnancyRequiredTime) {
            EntityHorseTFC baby = (EntityHorseTFC)this.createChildTFC((EntityAgeable)this);
            baby.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
            baby.field_70759_as = baby.field_70177_z;
            baby.field_70761_aq = baby.field_70177_z;
            this.field_70170_p.func_72838_d((Entity)baby);
            baby.setAge(TFC_Time.getTotalDays());
            this.pregnant = false;
        }
        TFC_Core.preventEntityDataUpdate = true;
        super.func_70636_d();
        TFC_Core.preventEntityDataUpdate = false;
        if (this.hunger > 144000 && this.field_70146_Z.nextInt(100) == 0 && this.func_110143_aJ() < TFC_Core.getEntityMaxHealth((EntityLivingBase)this) && !this.field_70128_L) {
            this.func_70691_i(1.0f);
        } else if (this.hunger < 144000 && super.func_70880_s()) {
            this.setInLove(false);
        }
    }

    public IEntityLivingData func_110161_a(IEntityLivingData livingData) {
        IEntityLivingData data = super.func_110161_a(livingData);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1250.0);
        this.func_70691_i(1250.0f);
        return data;
    }

    public void func_110199_f(EntityPlayer player) {
        Entity temp = player.field_70154_o;
        if (temp == null) {
            player.field_70154_o = this;
            if (player instanceof EntityPlayerMP) {
                EntityPlayerMP playerMP = (EntityPlayerMP)player;
                playerMP.field_71135_a.func_147359_a((Packet)new S1BPacketEntityAttach(0, (Entity)playerMP, (Entity)this));
                this.openHorseContainer(player);
                playerMP.field_71135_a.func_147359_a((Packet)new S1BPacketEntityAttach(0, (Entity)playerMP, temp));
            } else {
                this.openHorseContainer(player);
            }
            player.field_70154_o = null;
        }
        if (temp != null && temp == this) {
            this.openHorseContainer(player);
        }
    }

    private void openHorseContainer(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && (this.field_70153_n == null || this.field_70153_n == player) && this.func_110248_bS()) {
            player.openGui((Object)TerraFirmaCraft.instance, 42, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
    }

    public void func_70037_a(NBTTagCompound nbttc) {
        ItemStack itemstack;
        super.func_70037_a(nbttc);
        NBTTagCompound nbt = nbttc;
        this.animalID = nbt.func_74763_f("Animal ID");
        this.sex = nbt.func_74762_e("Sex");
        this.sizeMod = nbt.func_74760_g("Size Modifier");
        this.familiarity = nbt.func_74762_e("Familiarity");
        this.lastFamiliarityUpdate = nbt.func_74763_f("lastFamUpdate");
        this.familiarizedToday = nbt.func_74767_n("Familiarized Today");
        this.strengthMod = nbt.func_74760_g("Strength Modifier");
        this.aggressionMod = nbt.func_74760_g("Aggression Modifier");
        this.obedienceMod = nbt.func_74760_g("Obedience Modifier");
        this.hunger = nbt.func_74762_e("Hunger");
        this.pregnant = nbt.func_74767_n("Pregnant");
        this.mateSizeMod = nbt.func_74760_g("MateSize");
        this.mateStrengthMod = nbt.func_74760_g("MateStrength");
        this.mateAggroMod = nbt.func_74760_g("MateAggro");
        this.mateObedMod = nbt.func_74760_g("MateObed");
        this.mateType = nbt.func_74762_e("MateType");
        this.mateVariant = nbt.func_74762_e("MateVariant");
        this.mateMaxHealth = nbt.func_74769_h("MateHealth");
        this.mateJumpStrength = nbt.func_74769_h("MateJump");
        this.mateMoveSpeed = nbt.func_74769_h("MateSpeed");
        this.timeOfConception = nbt.func_74763_f("ConceptionTime");
        this.setAge(nbt.func_74762_e("Age"));
        if (this.func_110261_ca()) {
            NBTTagList nbttaglist = nbttc.func_150295_c("Items", 10);
            this.updateChestSaddle();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbt1 = nbttaglist.func_150305_b(i);
                int j = nbt1.func_74771_c("Slot") & 0xFF;
                if (j < 2 || j >= this.field_110296_bG.func_70302_i_()) continue;
                this.field_110296_bG.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbt1));
            }
        }
        if (nbttc.func_150297_b("ArmorItem", 10) && (itemstack = ItemStack.func_77949_a((NBTTagCompound)nbttc.func_74775_l("ArmorItem"))) != null && EntityHorse.func_146085_a((Item)itemstack.func_77973_b())) {
            this.field_110296_bG.func_70299_a(1, itemstack);
        }
        if (nbttc.func_150297_b("SaddleItem", 10)) {
            itemstack = ItemStack.func_77949_a((NBTTagCompound)nbttc.func_74775_l("SaddleItem"));
            if (itemstack != null && itemstack.func_77973_b() == Items.field_151141_av) {
                this.field_110296_bG.func_70299_a(0, itemstack);
            }
        } else if (nbttc.func_74767_n("Saddle")) {
            this.field_110296_bG.func_70299_a(0, new ItemStack(Items.field_151141_av));
        }
        this.updateSaddle();
    }

    @Override
    public void setAge(int par1) {
        this.field_70180_af.func_75692_b(15, (Object)par1);
    }

    @Override
    public void setAggressionMod(float aggressionMod) {
        this.aggressionMod = aggressionMod;
    }

    @Override
    public void setAttackedVec(Vec3 attackedVec) {
        this.attackedVec = attackedVec;
    }

    @Override
    public void setBirthDay(int day) {
        this.field_70180_af.func_75692_b(15, (Object)day);
    }

    @Override
    public void setFamiliarity(int familiarity) {
        this.familiarity = familiarity;
    }

    public void setFamiliarizedToday(boolean familiarizedToday) {
        this.familiarizedToday = familiarizedToday;
    }

    @Override
    public void setFearSource(Entity fearSource) {
        this.fearSource = fearSource;
    }

    public void func_70873_a(int par1) {
        if (!TFC_Core.preventEntityDataUpdate) {
            this.field_70180_af.func_75692_b(12, (Object)par1);
        }
    }

    @Override
    public void setHunger(int h) {
        this.hunger = h;
    }

    @Override
    public void setInLove(boolean b) {
        this.inLove = b;
        if (b) {
            this.field_70789_a = null;
            this.field_70170_p.func_72960_a((Entity)this, (byte)18);
        }
    }

    public void setLastFamiliarityUpdate(long lastFamiliarityUpdate) {
        this.lastFamiliarityUpdate = lastFamiliarityUpdate;
    }

    @Override
    public void setObedienceMod(float obedienceMod) {
        this.obedienceMod = obedienceMod;
    }

    public void setPregnancyRequiredTime(int pregnancyRequiredTime) {
        this.pregnancyRequiredTime = pregnancyRequiredTime;
    }

    public void setPregnant(boolean pregnant) {
        this.pregnant = pregnant;
    }

    public void setSex(int sex) {
        this.sex = sex;
    }

    @Override
    public void setSizeMod(float sizeMod) {
        this.sizeMod = sizeMod;
    }

    @Override
    public void setStrengthMod(float strengthMod) {
        this.strengthMod = strengthMod;
    }

    public void setTimeOfConception(long timeOfConception) {
        this.timeOfConception = timeOfConception;
    }

    public void syncData() {
        if (this.field_70180_af != null) {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_75692_b(13, (Object)this.sex);
                byte[] values = new byte[]{TFC_Core.getByteFromSmallFloat(this.sizeMod), TFC_Core.getByteFromSmallFloat(this.strengthMod), TFC_Core.getByteFromSmallFloat(this.aggressionMod), TFC_Core.getByteFromSmallFloat(this.obedienceMod), (byte)this.familiarity, (byte)(this.familiarizedToday ? 1 : 0), (byte)(this.pregnant ? 1 : 0), 0};
                ByteBuffer buf = ByteBuffer.wrap(values);
                this.field_70180_af.func_75692_b(26, (Object)buf.getInt());
                this.field_70180_af.func_75692_b(24, (Object)buf.getInt());
                this.field_70180_af.func_75692_b(25, (Object)String.valueOf(this.timeOfConception));
            } else {
                this.sex = this.field_70180_af.func_75679_c(13);
                ByteBuffer buf = ByteBuffer.allocate(8);
                buf.putInt(this.field_70180_af.func_75679_c(26));
                buf.putInt(this.field_70180_af.func_75679_c(24));
                byte[] values = buf.array();
                this.sizeMod = TFC_Core.getSmallFloatFromByte(values[0]);
                this.strengthMod = TFC_Core.getSmallFloatFromByte(values[1]);
                this.aggressionMod = TFC_Core.getSmallFloatFromByte(values[2]);
                this.obedienceMod = TFC_Core.getSmallFloatFromByte(values[3]);
                this.familiarity = values[4];
                this.familiarizedToday = values[5] == 1;
                this.pregnant = values[6] == 1;
                try {
                    this.timeOfConception = Long.parseLong(this.field_70180_af.func_75681_e(25));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean trySetName(String name, EntityPlayer player) {
        if (this.checkFamiliarity(IAnimal.InteractionEnum.NAME, player)) {
            this.func_94058_c(name);
            return true;
        }
        this.func_85030_a(this.func_70621_aR(), 6.0f, this.field_70146_Z.nextFloat() / 2.0f + (this.func_70631_g_() ? 1.25f : 0.75f));
        return false;
    }

    public void updateChestSaddle() {
        AnimalChest animalchest = this.field_110296_bG;
        this.field_110296_bG = new AnimalChest("HorseChest", this.getNumChestSlots());
        if (animalchest != null) {
            animalchest.func_110132_b((IInvBasic)this);
            int i = Math.min(animalchest.func_70302_i_(), this.field_110296_bG.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = animalchest.func_70301_a(j);
                if (itemstack == null) continue;
                this.field_110296_bG.func_70299_a(j, itemstack.func_77946_l());
            }
            animalchest = null;
        }
        this.field_110296_bG.func_110134_a((IInvBasic)this);
        this.updateSaddle();
    }

    private void updateSaddle() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_110251_o(this.field_110296_bG.func_70301_a(0) != null);
            if (this.func_110265_bP() == 0) {
                this.func_146086_d(this.field_110296_bG.func_70301_a(1));
            }
        }
    }

    public void func_70014_b(NBTTagCompound nbttc) {
        super.func_70014_b(nbttc);
        nbttc.func_74768_a("Sex", this.sex);
        nbttc.func_74772_a("Animal ID", this.animalID);
        nbttc.func_74776_a("Size Modifier", this.sizeMod);
        nbttc.func_74768_a("Familiarity", this.familiarity);
        nbttc.func_74772_a("lastFamUpdate", this.lastFamiliarityUpdate);
        nbttc.func_74757_a("Familiarized Today", this.familiarizedToday);
        NBTTagCompound nbt = nbttc;
        nbt.func_74776_a("Strength Modifier", this.strengthMod);
        nbt.func_74776_a("Aggression Modifier", this.aggressionMod);
        nbt.func_74776_a("Obedience Modifier", this.obedienceMod);
        nbttc.func_74768_a("Hunger", this.hunger);
        nbttc.func_74757_a("Pregnant", this.pregnant);
        nbttc.func_74776_a("MateSize", this.mateSizeMod);
        nbttc.func_74776_a("MateStrength", this.mateStrengthMod);
        nbttc.func_74776_a("MateAggro", this.mateAggroMod);
        nbttc.func_74776_a("MateObed", this.mateObedMod);
        nbttc.func_74768_a("MateType", this.mateType);
        nbttc.func_74768_a("MateVariant", this.mateVariant);
        nbttc.func_74780_a("MateHealth", this.mateMaxHealth);
        nbttc.func_74780_a("MateJump", this.mateJumpStrength);
        nbttc.func_74780_a("MateSpeed", this.mateMoveSpeed);
        nbttc.func_74772_a("ConceptionTime", this.timeOfConception);
        nbttc.func_74768_a("Age", this.getBirthDay());
        if (this.func_110261_ca()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 2; i < this.field_110296_bG.func_70302_i_(); ++i) {
                ItemStack itemstack = this.field_110296_bG.func_70301_a(i);
                if (itemstack == null) continue;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74774_a("Slot", (byte)i);
                itemstack.func_77955_b(nbttagcompound1);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttc.func_74782_a("Items", (NBTBase)nbttaglist);
        }
        if (this.field_110296_bG.func_70301_a(1) != null) {
            nbttc.func_74782_a("ArmorItem", (NBTBase)this.field_110296_bG.func_70301_a(1).func_77955_b(new NBTTagCompound()));
        }
        if (this.field_110296_bG.func_70301_a(0) != null) {
            nbttc.func_74782_a("SaddleItem", (NBTBase)this.field_110296_bG.func_70301_a(0).func_77955_b(new NBTTagCompound()));
        }
    }
}

