/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.Entities.Mobs;

import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.Core.TFC_Time;
import com.bioxx.tfc.Entities.AI.AIEatGrass;
import com.bioxx.tfc.Entities.AI.EntityAIAvoidEntityTFC;
import com.bioxx.tfc.Entities.AI.EntityAIMateTFC;
import com.bioxx.tfc.Entities.Mobs.EntityBear;
import com.bioxx.tfc.Entities.Mobs.EntityWolfTFC;
import com.bioxx.tfc.Food.ItemFoodTFC;
import com.bioxx.tfc.Items.ItemCustomNameTag;
import com.bioxx.tfc.Items.Tools.ItemKnife;
import com.bioxx.tfc.api.Entities.IAnimal;
import com.bioxx.tfc.api.TFCItems;
import com.bioxx.tfc.api.TFCOptions;
import com.bioxx.tfc.api.Util.Helper;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class EntitySheepTFC
extends EntitySheep
implements IShearable,
IAnimal {
    public static final float[][] FLEECE_COLOR_TABLE = new float[][]{{1.0f, 1.0f, 1.0f}, {0.95f, 0.7f, 0.2f}, {0.9f, 0.5f, 0.85f}, {0.6f, 0.7f, 0.95f}, {0.9f, 0.9f, 0.2f}, {0.5f, 0.8f, 0.1f}, {0.95f, 0.7f, 0.8f}, {0.3f, 0.3f, 0.3f}, {0.6f, 0.6f, 0.6f}, {0.3f, 0.6f, 0.7f}, {0.7f, 0.4f, 0.9f}, {0.2f, 0.4f, 0.8f}, {0.5f, 0.4f, 0.3f}, {0.4f, 0.5f, 0.2f}, {0.8f, 0.3f, 0.3f}, {0.1f, 0.1f, 0.1f}};
    private static final float GESTATION_PERIOD = 5.0f;
    private static final float DIMORPHISM = 0.1633f;
    private static final int DEGREE_OF_DIVERSION = 2;
    private static final int FAMILIARITY_CAP = 35;
    private final InventoryCrafting colorCrafting = new InventoryCrafting(new Container(){

        public boolean func_75145_c(EntityPlayer p_75145_1_) {
            return false;
        }
    }, 2, 1);
    private int sheepTimer;
    protected final AIEatGrass aiEatGrass = new AIEatGrass(this);
    private long animalID;
    private int sex;
    private int hunger;
    private boolean pregnant;
    private int pregnancyRequiredTime;
    private long timeOfConception;
    private float mateSizeMod;
    private float mateStrengthMod;
    private float mateAggroMod;
    private float mateObedMod;
    private int mateColor;
    private float sizeMod;
    private float strengthMod;
    private float aggressionMod = 1.0f;
    private float obedienceMod = 1.0f;
    private boolean inLove;
    private EntityPlayer shearer;
    private int familiarity;
    private long lastFamiliarityUpdate;
    private boolean familiarizedToday;

    public EntitySheepTFC(World par1World) {
        super(par1World);
        this.func_70105_a(0.9f, 1.3f);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMateTFC(this, this.field_70170_p, 1.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, (double)1.2f, TFCItems.wheatGrain, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, (double)1.2f, TFCItems.ryeGrain, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, (double)1.2f, TFCItems.riceGrain, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, (double)1.2f, TFCItems.barleyGrain, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, (double)1.2f, TFCItems.oatGrain, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, (double)1.2f, TFCItems.maizeEar, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntityTFC((EntityCreature)this, EntityWolfTFC.class, 8.0f, 0.5, 0.7f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntityTFC((EntityCreature)this, EntityBear.class, 16.0f, 0.25, 0.3f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiEatGrass);
        this.colorCrafting.func_70299_a(0, new ItemStack(Items.field_151100_aR, 1, 0));
        this.colorCrafting.func_70299_a(1, new ItemStack(Items.field_151100_aR, 1, 0));
        this.hunger = 168000;
        this.animalID = TFC_Time.getTotalTicks() + (long)this.func_145782_y();
        this.pregnant = false;
        this.pregnancyRequiredTime = (int)(TFCOptions.animalTimeMultiplier * 5.0f * (float)TFC_Time.ticksInMonth);
        this.timeOfConception = 0L;
        this.mateSizeMod = 0.0f;
        this.sex = this.field_70146_Z.nextInt(2);
        this.sizeMod = (float)Math.sqrt(((float)(this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(30) + 1) * (this.field_70146_Z.nextBoolean() ? 1 : -1)) * 0.01f + 1.0f) * (1.0f - 0.1633f * (float)this.sex));
        this.strengthMod = (float)Math.sqrt((float)(this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(20) + 1) * (this.field_70146_Z.nextBoolean() ? 1 : -1)) * 0.01f + this.sizeMod);
        this.aggressionMod = (float)Math.sqrt((float)(this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(20) + 1) * (this.field_70146_Z.nextBoolean() ? 1 : -1)) * 0.01f + 1.0f);
        this.obedienceMod = (float)Math.sqrt((float)(this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(20) + 1) * (this.field_70146_Z.nextBoolean() ? 1 : -1)) * 0.01f + 1.0f / this.aggressionMod);
        this.setAge(TFC_Time.getTotalDays() - this.getNumberOfDaysToAdult());
    }

    public EntitySheepTFC(World par1World, IAnimal mother, List<Float> data) {
        this(par1World);
        float fatherSize = 1.0f;
        float fatherStr = 1.0f;
        float fatherAggro = 1.0f;
        float fatherObed = 1.0f;
        block6: for (int i = 0; i < data.size(); ++i) {
            switch (i) {
                case 0: {
                    fatherSize = data.get(i).floatValue();
                    continue block6;
                }
                case 1: {
                    fatherStr = data.get(i).floatValue();
                    continue block6;
                }
                case 2: {
                    fatherAggro = data.get(i).floatValue();
                    continue block6;
                }
                case 3: {
                    fatherObed = data.get(i).floatValue();
                    continue block6;
                }
            }
        }
        this.field_70165_t = ((EntityLivingBase)mother).field_70165_t;
        this.field_70163_u = ((EntityLivingBase)mother).field_70163_u;
        this.field_70161_v = ((EntityLivingBase)mother).field_70161_v;
        float invSizeRatio = 0.54445475f;
        this.sizeMod = (float)Math.sqrt(this.sizeMod * this.sizeMod * (float)Math.sqrt((mother.getSizeMod() + fatherSize) * invSizeRatio));
        this.strengthMod = (float)Math.sqrt(this.strengthMod * this.strengthMod * (float)Math.sqrt((mother.getStrengthMod() + fatherStr) * 0.5f));
        this.aggressionMod = (float)Math.sqrt(this.aggressionMod * this.aggressionMod * (float)Math.sqrt((mother.getAggressionMod() + fatherAggro) * 0.5f));
        this.obedienceMod = (float)Math.sqrt(this.obedienceMod * this.obedienceMod * (float)Math.sqrt((mother.getObedienceMod() + fatherObed) * 0.5f));
        this.familiarity = (int)(mother.getFamiliarity() < 90 ? (float)(mother.getFamiliarity() / 2) : (float)mother.getFamiliarity() * 0.9f);
        this.setAge(TFC_Time.getTotalDays());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(400.0);
    }

    @Override
    public boolean canFamiliarize() {
        return !this.isAdult() || this.isAdult() && this.familiarity <= 35;
    }

    @Override
    public boolean canMateWith(IAnimal animal) {
        return animal.getGender() != this.getGender() && this.isAdult() && animal.isAdult() && animal instanceof EntitySheepTFC;
    }

    @Override
    public boolean checkFamiliarity(IAnimal.InteractionEnum interaction, EntityPlayer player) {
        boolean flag = false;
        switch (interaction) {
            case BREED: {
                flag = this.familiarity > 20;
                break;
            }
            case SHEAR: {
                flag = this.familiarity > 10;
                break;
            }
            case NAME: {
                flag = this.familiarity > 40;
                break;
            }
        }
        if (!flag && player != null && !player.field_70170_p.field_72995_K) {
            TFC_Core.sendInfoMessage(player, (IChatComponent)new ChatComponentTranslation("entity.notFamiliar", new Object[0]));
        }
        return flag;
    }

    public int combineColors(EntityAnimal parent, int mateColor) {
        int parent1Color = 15 - ((EntitySheep)parent).func_70896_n();
        int parent2Color = 15 - mateColor;
        this.colorCrafting.func_70301_a(0).func_77964_b(parent1Color);
        this.colorCrafting.func_70301_a(1).func_77964_b(parent2Color);
        ItemStack itemstack = CraftingManager.func_77594_a().func_82787_a(this.colorCrafting, ((EntitySheep)parent).field_70170_p);
        int babyColor = itemstack != null && itemstack.func_77973_b() == Items.field_151100_aR ? itemstack.func_77960_j() : (this.field_70170_p.field_73012_v.nextBoolean() ? parent1Color : parent2Color);
        return babyColor;
    }

    public EntitySheep func_90011_a(EntityAgeable entityageable) {
        return (EntitySheep)this.createChildTFC(entityageable);
    }

    @Override
    public EntityAgeable createChildTFC(EntityAgeable eAgeable) {
        ArrayList<Float> data = new ArrayList<Float>();
        data.add(Float.valueOf(eAgeable.getEntityData().func_74760_g("MateSize")));
        data.add(Float.valueOf(eAgeable.getEntityData().func_74760_g("MateStrength")));
        data.add(Float.valueOf(eAgeable.getEntityData().func_74760_g("MateAggro")));
        data.add(Float.valueOf(eAgeable.getEntityData().func_74760_g("MateObed")));
        EntitySheepTFC baby = new EntitySheepTFC(this.field_70170_p, this, data);
        int colorMeta = this.combineColors((EntityAnimal)this, ((EntitySheepTFC)eAgeable).mateColor);
        baby.func_70891_b(15 - colorMeta);
        return baby;
    }

    protected void func_70628_a(boolean par1, int par2) {
        float ageMod = TFC_Core.getPercentGrown(this);
        if (!this.func_70892_o()) {
            this.func_70099_a(new ItemStack(TFCItems.sheepSkin, 1, Math.max(0, Math.min(2, (int)(ageMod * this.sizeMod)))), 0.0f);
        } else {
            this.func_70099_a(new ItemStack(TFCItems.hide, 1, Math.max(0, Math.min(2, (int)(ageMod * this.sizeMod)))), 0.0f);
        }
        this.func_145779_a(Items.field_151103_aS, (int)((float)(this.field_70146_Z.nextInt(5) + 2) * ageMod));
        float foodWeight = ageMod * (this.sizeMod * 640.0f);
        TFC_Core.animalDropMeat((Entity)this, TFCItems.muttonRaw, foodWeight);
    }

    public void func_70615_aA() {
        this.func_70893_e(false);
        this.hunger += 24000;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(13, (Object)0);
        this.field_70180_af.func_75682_a(15, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)String.valueOf("0"));
    }

    @Override
    public void familiarize(EntityPlayer ep) {
        ItemStack stack = ep.func_70694_bm();
        if (stack != null && !this.familiarizedToday && this.isFood(stack) && this.canFamiliarize()) {
            if (!ep.field_71075_bZ.field_75098_d) {
                ep.field_71071_by.func_70299_a(ep.field_71071_by.field_70461_c, ((ItemFoodTFC)stack.func_77973_b()).onConsumedByEntity(ep.func_70694_bm(), this.field_70170_p, (EntityLivingBase)this));
            } else {
                this.field_70170_p.func_72956_a((Entity)this, "random.burp", 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            this.hunger += 24000;
            this.familiarizedToday = true;
            this.func_70671_ap().func_75651_a((Entity)ep, 0.0f, 0.0f);
            this.func_70642_aH();
        }
    }

    @Override
    public float getAggressionMod() {
        return this.aggressionMod;
    }

    public long getAnimalID() {
        return this.animalID;
    }

    @Override
    public int getAnimalTypeID() {
        return Helper.stringToInt("sheep");
    }

    @Override
    public Vec3 getAttackedVec() {
        return null;
    }

    @Override
    public int getBirthDay() {
        return this.field_70180_af.func_75679_c(15);
    }

    protected Item func_146068_u() {
        return TFCItems.wool;
    }

    @Override
    public int getDueDay() {
        return TFC_Time.getDayFromTotalHours((this.timeOfConception + (long)this.pregnancyRequiredTime) / 1000L);
    }

    @Override
    public EntityLiving getEntity() {
        return this;
    }

    @Override
    public int getFamiliarity() {
        return this.familiarity;
    }

    @Override
    public boolean getFamiliarizedToday() {
        return this.familiarizedToday;
    }

    @Override
    public Entity getFearSource() {
        return null;
    }

    @Override
    public IAnimal.GenderEnum getGender() {
        return IAnimal.GenderEnum.GENDERS[this.field_70180_af.func_75679_c(13)];
    }

    @Override
    public int getHunger() {
        return this.hunger;
    }

    @Override
    public boolean getInLove() {
        return this.inLove;
    }

    public long getLastFamiliarityUpdate() {
        return this.lastFamiliarityUpdate;
    }

    @Override
    public int getNumberOfDaysToAdult() {
        return (int)(TFCOptions.animalTimeMultiplier * (float)TFC_Time.daysInMonth * 12.0f);
    }

    @Override
    public float getObedienceMod() {
        return this.obedienceMod;
    }

    public int getPregnancyRequiredTime() {
        return this.pregnancyRequiredTime;
    }

    public int getSex() {
        return this.sex;
    }

    public EntityPlayer getShearer() {
        return this.shearer;
    }

    public int getSheepTimer() {
        return this.sheepTimer;
    }

    @Override
    public float getSizeMod() {
        return this.sizeMod;
    }

    @Override
    public float getStrengthMod() {
        return this.strengthMod;
    }

    public long getTimeOfConception() {
        return this.timeOfConception;
    }

    @Override
    public void handleFamiliarityUpdate() {
        int totalDays = TFC_Time.getTotalDays();
        if (this.lastFamiliarityUpdate < (long)totalDays) {
            if (this.familiarizedToday && this.familiarity < 100) {
                this.lastFamiliarityUpdate = totalDays;
                this.familiarizedToday = false;
                float familiarityChange = 6.0f * this.obedienceMod / this.aggressionMod;
                if (this.isAdult() && this.familiarity <= 35) {
                    this.familiarity = (int)((float)this.familiarity + familiarityChange);
                } else if (!this.isAdult()) {
                    float ageMod = 2.0f / (1.0f + TFC_Core.getPercentGrown(this));
                    this.familiarity = (int)((float)this.familiarity + ageMod * familiarityChange);
                    if (this.familiarity > 70) {
                        this.obedienceMod *= 1.01f;
                    }
                }
            } else if (this.familiarity < 30) {
                this.familiarity = (int)((long)this.familiarity - 2L * ((long)TFC_Time.getTotalDays() - this.lastFamiliarityUpdate));
                this.lastFamiliarityUpdate = totalDays;
            }
        }
        if (this.familiarity > 100) {
            this.familiarity = 100;
        }
        if (this.familiarity < 0) {
            this.familiarity = 0;
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack itemstack;
        if (!this.field_70170_p.field_72995_K) {
            if (player.func_70093_af() && !this.familiarizedToday && this.canFamiliarize()) {
                this.familiarize(player);
                return true;
            }
            if (this.getGender() == IAnimal.GenderEnum.FEMALE && this.pregnant) {
                TFC_Core.sendInfoMessage(player, (IChatComponent)new ChatComponentTranslation("entity.pregnant", new Object[0]));
            }
            this.shearer = player;
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemKnife && !this.func_70892_o() && this.checkFamiliarity(IAnimal.InteractionEnum.SHEAR, player) && this.isAdult()) {
                if (!this.familiarizedToday && this.familiarity <= 35) {
                    this.familiarizedToday = true;
                    this.func_70671_ap().func_75651_a((Entity)player, 0.0f, 0.0f);
                    this.func_70642_aH();
                }
                this.func_70893_e(true);
                this.func_70099_a(new ItemStack(TFCItems.wool, 1), 0.0f);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_70694_bm().func_77972_a(1, (EntityLivingBase)player);
                }
            }
        }
        if ((itemstack = player.field_71071_by.func_70448_g()) != null && this.isBreedingItemTFC(itemstack) && this.checkFamiliarity(IAnimal.InteractionEnum.BREED, player) && this.func_70874_b() == 0 && !super.func_70880_s() && (this.familiarizedToday || !this.canFamiliarize())) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ((ItemFoodTFC)itemstack.func_77973_b()).onConsumedByEntity(player.func_70694_bm(), this.field_70170_p, (EntityLivingBase)this));
            }
            this.hunger += 24000;
            this.func_146082_f(player);
            return true;
        }
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemCustomNameTag && itemstack.func_77942_o() && itemstack.field_77990_d.func_74764_b("ItemName")) {
            if (this.trySetName(itemstack.field_77990_d.func_74779_i("ItemName"), player)) {
                --itemstack.field_77994_a;
            }
            return true;
        }
        return super.func_70085_c(player);
    }

    @Override
    public boolean isAdult() {
        return this.getBirthDay() + this.getNumberOfDaysToAdult() <= TFC_Time.getTotalDays();
    }

    public boolean func_70877_b(ItemStack par1ItemStack) {
        return false;
    }

    public boolean isBreedingItemTFC(ItemStack item) {
        return !this.pregnant && this.isFood(item);
    }

    public boolean func_70631_g_() {
        return !this.isAdult();
    }

    @Override
    public boolean isFood(ItemStack item) {
        return item != null && (item.func_77973_b() == TFCItems.wheatGrain || item.func_77973_b() == TFCItems.oatGrain || item.func_77973_b() == TFCItems.riceGrain || item.func_77973_b() == TFCItems.barleyGrain || item.func_77973_b() == TFCItems.ryeGrain || item.func_77973_b() == TFCItems.maizeEar);
    }

    @Override
    public boolean isPregnant() {
        return this.pregnant;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return !this.func_70892_o() && this.isAdult() && this.shearer != null && this.checkFamiliarity(IAnimal.InteractionEnum.SHEAR, this.shearer);
    }

    @Override
    public void mate(IAnimal otherAnimal) {
        if (this.getGender() == IAnimal.GenderEnum.MALE) {
            otherAnimal.mate(this);
            return;
        }
        this.timeOfConception = TFC_Time.getTotalTicks();
        this.pregnant = true;
        this.func_70875_t();
        otherAnimal.setInLove(false);
        this.mateAggroMod = otherAnimal.getAggressionMod();
        this.mateObedMod = otherAnimal.getObedienceMod();
        this.mateSizeMod = otherAnimal.getSizeMod();
        this.mateStrengthMod = otherAnimal.getStrengthMod();
        this.mateColor = ((EntitySheepTFC)otherAnimal).func_70896_n();
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        }
        if (this.hunger > 168000) {
            this.hunger = 168000;
        }
        if (this.hunger > 0) {
            --this.hunger;
        }
        if (super.func_70880_s()) {
            super.func_70875_t();
            this.setInLove(true);
        }
        this.handleFamiliarityUpdate();
        this.syncData();
        if (this.isAdult()) {
            this.func_70873_a(0);
        } else {
            this.func_70873_a(-1);
        }
        if (!this.field_70170_p.field_72995_K && this.isPregnant() && TFC_Time.getTotalTicks() >= this.timeOfConception + (long)this.pregnancyRequiredTime) {
            int i = this.field_70146_Z.nextInt(3) + 1;
            for (int x = 0; x < i; ++x) {
                EntitySheepTFC baby = (EntitySheepTFC)this.createChildTFC((EntityAgeable)this);
                baby.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
                baby.field_70759_as = baby.field_70177_z;
                baby.field_70761_aq = baby.field_70177_z;
                this.field_70170_p.func_72838_d((Entity)baby);
                baby.setAge(TFC_Time.getTotalDays());
            }
            this.pregnant = false;
        }
        TFC_Core.preventEntityDataUpdate = true;
        super.func_70636_d();
        TFC_Core.preventEntityDataUpdate = false;
        if (this.hunger > 144000 && this.field_70146_Z.nextInt(100) == 0 && this.func_110143_aJ() < TFC_Core.getEntityMaxHealth((EntityLivingBase)this) && !this.field_70128_L) {
            this.func_70691_i(1.0f);
        } else if (this.hunger < 144000 && super.func_70880_s()) {
            this.setInLove(false);
        }
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        this.func_70893_e(true);
        ret.add(new ItemStack(TFCItems.wool, 2));
        if (!this.familiarizedToday && this.familiarity <= 35) {
            this.familiarizedToday = true;
            this.func_70642_aH();
        }
        this.field_70170_p.func_72956_a((Entity)this, "mob.sheep.shear", 1.0f, 1.0f);
        return ret;
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.animalID = nbt.func_74763_f("Animal ID");
        this.sex = nbt.func_74762_e("Sex");
        this.sizeMod = nbt.func_74760_g("Size Modifier");
        this.strengthMod = nbt.func_74760_g("Strength Modifier");
        this.aggressionMod = nbt.func_74760_g("Aggression Modifier");
        this.obedienceMod = nbt.func_74760_g("Obedience Modifier");
        this.familiarity = nbt.func_74762_e("Familiarity");
        this.lastFamiliarityUpdate = nbt.func_74763_f("lastFamUpdate");
        this.familiarizedToday = nbt.func_74767_n("Familiarized Today");
        this.hunger = nbt.func_74762_e("Hunger");
        this.pregnant = nbt.func_74767_n("Pregnant");
        this.mateSizeMod = nbt.func_74760_g("MateSize");
        this.mateStrengthMod = nbt.func_74760_g("MateStrength");
        this.mateAggroMod = nbt.func_74760_g("MateAggro");
        this.mateObedMod = nbt.func_74760_g("MateObed");
        this.mateColor = nbt.func_74762_e("MateColor");
        this.timeOfConception = nbt.func_74763_f("ConceptionTime");
        this.field_70180_af.func_75692_b(15, (Object)nbt.func_74762_e("Age"));
        this.setAge(nbt.func_74762_e("Age"));
    }

    @Override
    public void setAge(int par1) {
        this.field_70180_af.func_75692_b(15, (Object)par1);
    }

    @Override
    public void setAggressionMod(float aggressionMod) {
        this.aggressionMod = aggressionMod;
    }

    public void setAnimalID(long animalID) {
        this.animalID = animalID;
    }

    @Override
    public void setAttackedVec(Vec3 attackedVec) {
    }

    @Override
    public void setBirthDay(int day) {
        this.field_70180_af.func_75692_b(15, (Object)day);
    }

    @Override
    public void setFamiliarity(int familiarity) {
        this.familiarity = familiarity;
    }

    public void setFamiliarizedToday(boolean familiarizedToday) {
        this.familiarizedToday = familiarizedToday;
    }

    @Override
    public void setFearSource(Entity fearSource) {
    }

    public void func_70873_a(int par1) {
        if (!TFC_Core.preventEntityDataUpdate) {
            this.field_70180_af.func_75692_b(12, (Object)par1);
        }
    }

    @Override
    public void setHunger(int h) {
        this.hunger = h;
    }

    @Override
    public void setInLove(boolean b) {
        this.inLove = b;
    }

    public void setLastFamiliarityUpdate(long lastFamiliarityUpdate) {
        this.lastFamiliarityUpdate = lastFamiliarityUpdate;
    }

    @Override
    public void setObedienceMod(float obedienceMod) {
        this.obedienceMod = obedienceMod;
    }

    public void setPregnancyRequiredTime(int pregnancyRequiredTime) {
        this.pregnancyRequiredTime = pregnancyRequiredTime;
    }

    public void setPregnant(boolean pregnant) {
        this.pregnant = pregnant;
    }

    public void setSex(int sex) {
        this.sex = sex;
    }

    public void setShearer(EntityPlayer shearer) {
        this.shearer = shearer;
    }

    public void setSheepTimer(int sheepTimer) {
        this.sheepTimer = sheepTimer;
    }

    @Override
    public void setSizeMod(float sizeMod) {
        this.sizeMod = sizeMod;
    }

    @Override
    public void setStrengthMod(float strengthMod) {
        this.strengthMod = strengthMod;
    }

    public void setTimeOfConception(long timeOfConception) {
        this.timeOfConception = timeOfConception;
    }

    public void syncData() {
        if (this.field_70180_af != null) {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_75692_b(13, (Object)this.sex);
                byte[] values = new byte[]{TFC_Core.getByteFromSmallFloat(this.sizeMod), TFC_Core.getByteFromSmallFloat(this.strengthMod), TFC_Core.getByteFromSmallFloat(this.aggressionMod), TFC_Core.getByteFromSmallFloat(this.obedienceMod), (byte)this.familiarity, (byte)(this.familiarizedToday ? 1 : 0), (byte)(this.pregnant ? 1 : 0), 0};
                ByteBuffer buf = ByteBuffer.wrap(values);
                this.field_70180_af.func_75692_b(22, (Object)buf.getInt());
                this.field_70180_af.func_75692_b(23, (Object)buf.getInt());
                this.field_70180_af.func_75692_b(24, (Object)String.valueOf(this.timeOfConception));
            } else {
                this.sex = this.field_70180_af.func_75679_c(13);
                ByteBuffer buf = ByteBuffer.allocate(8);
                buf.putInt(this.field_70180_af.func_75679_c(22));
                buf.putInt(this.field_70180_af.func_75679_c(23));
                byte[] values = buf.array();
                this.sizeMod = TFC_Core.getSmallFloatFromByte(values[0]);
                this.strengthMod = TFC_Core.getSmallFloatFromByte(values[1]);
                this.aggressionMod = TFC_Core.getSmallFloatFromByte(values[2]);
                this.obedienceMod = TFC_Core.getSmallFloatFromByte(values[3]);
                this.familiarity = values[4];
                this.familiarizedToday = values[5] == 1;
                this.pregnant = values[6] == 1;
                try {
                    this.timeOfConception = Long.parseLong(this.field_70180_af.func_75681_e(24));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean trySetName(String name, EntityPlayer player) {
        if (this.checkFamiliarity(IAnimal.InteractionEnum.NAME, player)) {
            this.func_94058_c(name);
            return true;
        }
        this.func_85030_a(this.func_70621_aR(), 6.0f, this.field_70146_Z.nextFloat() / 2.0f + (this.func_70631_g_() ? 1.25f : 0.75f));
        return false;
    }

    protected void func_70619_bc() {
        this.sheepTimer = this.aiEatGrass.getEatGrassTick();
        super.func_70619_bc();
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("Sex", this.sex);
        nbt.func_74772_a("Animal ID", this.animalID);
        nbt.func_74776_a("Size Modifier", this.sizeMod);
        nbt.func_74768_a("Familiarity", this.familiarity);
        nbt.func_74772_a("lastFamUpdate", this.lastFamiliarityUpdate);
        nbt.func_74757_a("Familiarized Today", this.familiarizedToday);
        nbt.func_74776_a("Strength Modifier", this.strengthMod);
        nbt.func_74776_a("Aggression Modifier", this.aggressionMod);
        nbt.func_74776_a("Obedience Modifier", this.obedienceMod);
        nbt.func_74768_a("Hunger", this.hunger);
        nbt.func_74757_a("Pregnant", this.pregnant);
        nbt.func_74776_a("MateSize", this.mateSizeMod);
        nbt.func_74776_a("MateStrength", this.mateStrengthMod);
        nbt.func_74776_a("MateAggro", this.mateAggroMod);
        nbt.func_74776_a("MateObed", this.mateObedMod);
        nbt.func_74768_a("MateColor", this.mateColor);
        nbt.func_74772_a("ConceptionTime", this.timeOfConception);
        nbt.func_74768_a("Age", this.getBirthDay());
    }
}

