/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.Food;

import com.bioxx.tfc.Core.Player.FoodStatsTFC;
import com.bioxx.tfc.Core.Player.SkillStats;
import com.bioxx.tfc.Core.TFCTabs;
import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.Core.TFC_Time;
import com.bioxx.tfc.Items.ItemTerra;
import com.bioxx.tfc.Render.Item.FoodItemRenderer;
import com.bioxx.tfc.TerraFirmaCraft;
import com.bioxx.tfc.api.Entities.IAnimal;
import com.bioxx.tfc.api.Enums.EnumFoodGroup;
import com.bioxx.tfc.api.Enums.EnumSize;
import com.bioxx.tfc.api.Enums.EnumWeight;
import com.bioxx.tfc.api.Food;
import com.bioxx.tfc.api.FoodRegistry;
import com.bioxx.tfc.api.Interfaces.ICookableFood;
import com.bioxx.tfc.api.Interfaces.IFood;
import com.bioxx.tfc.api.Interfaces.IMergeableFood;
import com.bioxx.tfc.api.Interfaces.ISize;
import com.bioxx.tfc.api.TFCItems;
import com.bioxx.tfc.api.TFCOptions;
import com.bioxx.tfc.api.TFC_ItemHeat;
import com.bioxx.tfc.api.Util.Helper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

public class ItemFoodTFC
extends ItemTerra
implements ISize,
ICookableFood,
IMergeableFood {
    private EnumFoodGroup foodgroup;
    public int foodID;
    public float decayRate = 1.0f;
    public boolean edible = true;
    public boolean canBeUsedRaw = true;
    protected int tasteSweet;
    protected int tasteSour;
    protected int tasteSalty;
    protected int tasteBitter;
    protected int tasteUmami;
    protected boolean canBeSmoked;
    protected float smokeAbsorb;
    public IIcon cookedIcon;
    protected boolean hasCookedIcon;

    public ItemFoodTFC(EnumFoodGroup fg, int sw, int so, int sa, int bi, int um) {
        this.func_77637_a(TFCTabs.TFC_FOODS);
        this.setFolder("food/");
        this.foodgroup = fg;
        TFCItems.foodList.add(this);
        this.func_77656_e(100);
        this.field_77787_bX = false;
        this.smokeAbsorb = 0.5f;
        this.tasteSweet = sw;
        this.tasteSour = so;
        this.tasteSalty = sa;
        this.tasteBitter = bi;
        this.tasteUmami = um;
        this.foodID = FoodRegistry.getInstance().registerFood(fg, this);
    }

    public ItemFoodTFC(EnumFoodGroup fg, int sw, int so, int sa, int bi, int um, boolean edible) {
        this(fg, sw, so, sa, bi, um);
        this.edible = edible;
    }

    public ItemFoodTFC(EnumFoodGroup fg, int sw, int so, int sa, int bi, int um, boolean edible, boolean usable) {
        this(fg, sw, so, sa, bi, um, edible);
        this.canBeUsedRaw = usable;
    }

    public ItemFoodTFC setDecayRate(float f) {
        this.decayRate = f;
        return this;
    }

    public ItemFoodTFC setCanSmoke() {
        this.canBeSmoked = true;
        return this;
    }

    public ItemFoodTFC setHasCookedIcon() {
        this.hasCookedIcon = true;
        return this;
    }

    @Override
    public void func_94581_a(IIconRegister registerer) {
        super.func_94581_a(registerer);
        if (this.hasCookedIcon) {
            String name = this.func_77658_a();
            this.cookedIcon = registerer.func_94245_a("terrafirmacraft:" + this.textureFolder + name.replace("item.", "") + " Cooked");
        }
        MinecraftForgeClient.registerItemRenderer((Item)this, (IItemRenderer)new FoodItemRenderer());
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        if (Food.isCooked(stack) && this.cookedIcon != null) {
            return this.cookedIcon;
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 1;
    }

    @Override
    public float getDecayRate(ItemStack is) {
        float mult = 1.0f;
        if (Food.isCooked(is)) {
            mult *= 0.75f;
            if (Food.isPickled(is) || Food.isSalted(is)) {
                mult *= 0.75f;
            }
            if (Food.isSmoked(is)) {
                mult *= 1.0f - 0.25f * this.getSmokeAbsorbMultiplier();
            }
        } else {
            if (Food.isPickled(is) || Food.isSalted(is)) {
                mult *= 0.5f;
            }
            if (Food.isSmoked(is)) {
                mult *= 1.0f - 0.25f * this.getSmokeAbsorbMultiplier();
            }
            if (Food.isDried(is)) {
                mult *= 0.25f;
            }
        }
        return this.decayRate * TFC_Time.getYearRatio(96.0f) * mult;
    }

    @Override
    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        list.add(ItemFoodTFC.createTag(new ItemStack((Item)this, 1), 160.0f));
    }

    public String func_77653_i(ItemStack is) {
        StringBuilder name = new StringBuilder();
        if (is.func_77942_o()) {
            if (Food.isPickled(is)) {
                name.append(TFC_Core.translate("word.pickled")).append(' ');
            } else if (Food.isBrined(is) && !Food.isDried(is)) {
                name.append(TFC_Core.translate("word.brined")).append(' ');
            }
            if (Food.isSalted(is)) {
                name.append(TFC_Core.translate("word.salted")).append(' ');
            }
            if (Food.isCooked(is)) {
                name.append(TFC_Core.translate("word.cooked")).append(' ');
            } else if (Food.isSmoked(is)) {
                name.append(TFC_Core.translate("word.smoked")).append(' ');
            }
            if (Food.isDried(is) && !Food.isCooked(is)) {
                name.append(TFC_Core.translate("word.dried")).append(' ');
            }
            if (Food.isInfused(is)) {
                name.append(TFC_Core.translate(Food.getInfusion(is) + ".name")).append(' ');
            }
        }
        return name.append(TFC_Core.translate(this.func_77667_c(is) + ".name")).append(this.getCookedLevelString(is)).toString();
    }

    protected String getCookedLevelString(ItemStack is) {
        String s = "";
        if (Food.isCooked(is)) {
            s = s + " (";
            int cookedLevel = ((int)Food.getCooked(is) - 600) / 120;
            switch (cookedLevel) {
                case 0: {
                    s = s + TFC_Core.translate("food.cooked.0");
                    break;
                }
                case 1: {
                    s = s + TFC_Core.translate("food.cooked.1");
                    break;
                }
                case 2: {
                    s = s + TFC_Core.translate("food.cooked.2");
                    break;
                }
                case 3: {
                    s = s + TFC_Core.translate("food.cooked.3");
                    break;
                }
                default: {
                    s = s + TFC_Core.translate("food.cooked.4");
                }
            }
            s = s + ")";
        }
        return s;
    }

    public static void addFoodHeatInformation(ItemStack is, List<String> arraylist) {
        float meltTemp;
        if (TFC_ItemHeat.hasTemp(is) && (meltTemp = TFC_ItemHeat.isCookable(is)) != -1.0f) {
            arraylist.add(TFC_ItemHeat.getHeatColorFood(TFC_ItemHeat.getTemp(is), meltTemp));
        }
    }

    @Override
    public void func_77624_a(ItemStack is, EntityPlayer player, List arraylist, boolean flag) {
        ItemTerra.addSizeInformation(is, arraylist);
        arraylist.add(ItemFoodTFC.getFoodGroupName(this.getFoodGroup()));
        if (is.func_77942_o()) {
            ItemFoodTFC.addFoodHeatInformation(is, arraylist);
            this.addFoodInformation(is, player, arraylist);
        } else {
            arraylist.add(TFC_Core.translate("gui.badnbt"));
            TerraFirmaCraft.LOG.error(TFC_Core.translate("error.error") + " " + is.func_77977_a() + " " + TFC_Core.translate("error.NBT") + " " + TFC_Core.translate("error.Contact"));
        }
    }

    public void addFoodInformation(ItemStack is, EntityPlayer player, List<String> arraylist) {
        float decay;
        float ounces = Helper.roundNumber(Food.getWeight(is), 100.0f);
        if (ounces > 0.0f && ounces <= 160.0f) {
            arraylist.add(TFC_Core.translate("gui.food.amount") + " " + ounces + " oz / " + 160.0f + " oz");
        }
        if ((decay = Food.getDecay(is)) > 0.0f) {
            arraylist.add(EnumChatFormatting.DARK_GRAY + TFC_Core.translate("gui.food.decay") + " " + Helper.roundNumber(decay / ounces * 100.0f, 10.0f) + "%");
        }
        if (TFCOptions.enableDebugMode) {
            arraylist.add(EnumChatFormatting.DARK_GRAY + TFC_Core.translate("gui.food.decay") + ": " + decay);
            arraylist.add(EnumChatFormatting.DARK_GRAY + "Decay Rate: " + Helper.roundNumber(this.getDecayRate(is), 100.0f));
        }
        if (TFC_Core.showCtrlInformation()) {
            ItemFoodTFC.addTasteInformation(is, player, arraylist);
        } else {
            arraylist.add(TFC_Core.translate("gui.showtaste"));
        }
    }

    public static void addTasteInformation(ItemStack is, EntityPlayer player, List<String> arraylist) {
        IFood food = (IFood)is.func_77973_b();
        int sweet = food.getTasteSweet(is);
        int sour = food.getTasteSour(is);
        int salty = food.getTasteSalty(is);
        int bitter = food.getTasteBitter(is);
        int savory = food.getTasteSavory(is);
        SkillStats.SkillRank rank = TFC_Core.getSkillStats(player).getSkillRank("skill.cooking");
        if (Food.hasMealSkill(is)) {
            rank = SkillStats.SkillRank.values()[Food.getMealSkill(is)];
        }
        int[] prefs = TFC_Core.getPlayerFoodStats(player).getPrefTaste();
        String sSweet = EnumChatFormatting.DARK_GRAY + TFC_Core.translate("gui.taste.sweet") + ": " + EnumChatFormatting.WHITE;
        String sSour = EnumChatFormatting.DARK_GRAY + TFC_Core.translate("gui.taste.sour") + ": " + EnumChatFormatting.WHITE;
        String sSalty = EnumChatFormatting.DARK_GRAY + TFC_Core.translate("gui.taste.salty") + ": " + EnumChatFormatting.WHITE;
        String sBitter = EnumChatFormatting.DARK_GRAY + TFC_Core.translate("gui.taste.bitter") + ": " + EnumChatFormatting.WHITE;
        String sSavory = EnumChatFormatting.DARK_GRAY + TFC_Core.translate("gui.taste.savory") + ": " + EnumChatFormatting.WHITE;
        if (rank == SkillStats.SkillRank.Novice) {
            sSweet = sSweet + (sweet > prefs[0] ? TFC_Core.translate("gui.taste.novice.sweet1") : TFC_Core.translate("gui.taste.novice.sweet0"));
            sSour = sSour + (sour > prefs[1] ? TFC_Core.translate("gui.taste.novice.sour1") : TFC_Core.translate("gui.taste.novice.sour0"));
            sSalty = sSalty + (salty > prefs[2] ? TFC_Core.translate("gui.taste.novice.salty1") : TFC_Core.translate("gui.taste.novice.salty0"));
            sBitter = sBitter + (bitter > prefs[3] ? TFC_Core.translate("gui.taste.novice.bitter1") : TFC_Core.translate("gui.taste.novice.bitter0"));
            sSavory = sSavory + (savory > prefs[4] ? TFC_Core.translate("gui.taste.novice.savory1") : TFC_Core.translate("gui.taste.novice.savory0"));
        } else if (rank == SkillStats.SkillRank.Adept) {
            sSweet = sSweet + ItemFoodTFC.createBasicString(sweet, prefs[0], "sweet");
            sSour = sSour + ItemFoodTFC.createBasicString(sour, prefs[1], "sour");
            sSalty = sSalty + ItemFoodTFC.createBasicString(salty, prefs[2], "salty");
            sBitter = sBitter + ItemFoodTFC.createBasicString(bitter, prefs[3], "bitter");
            sSavory = sSavory + ItemFoodTFC.createBasicString(savory, prefs[4], "savory");
        } else if (rank == SkillStats.SkillRank.Expert) {
            sSweet = sSweet + ItemFoodTFC.createExpertString(sweet, prefs[0], "sweet");
            sSour = sSour + ItemFoodTFC.createExpertString(sour, prefs[1], "sour");
            sSalty = sSalty + ItemFoodTFC.createExpertString(salty, prefs[2], "salty");
            sBitter = sBitter + ItemFoodTFC.createExpertString(bitter, prefs[3], "bitter");
            sSavory = sSavory + ItemFoodTFC.createExpertString(savory, prefs[4], "savory");
        } else if (rank == SkillStats.SkillRank.Master) {
            sSweet = sSweet + ItemFoodTFC.createBasicString(sweet, prefs[0], "sweet") + " (" + (sweet - prefs[0]) + ")";
            sSour = sSour + ItemFoodTFC.createBasicString(sour, prefs[1], "sour") + " (" + (sour - prefs[1]) + ")";
            sSalty = sSalty + ItemFoodTFC.createBasicString(salty, prefs[2], "salty") + " (" + (salty - prefs[2]) + ")";
            sBitter = sBitter + ItemFoodTFC.createBasicString(bitter, prefs[3], "bitter") + " (" + (bitter - prefs[3]) + ")";
            sSavory = sSavory + ItemFoodTFC.createBasicString(savory, prefs[4], "savory") + " (" + (savory - prefs[4]) + ")";
        }
        arraylist.add(sSweet);
        arraylist.add(sSour);
        arraylist.add(sSalty);
        arraylist.add(sBitter);
        arraylist.add(sSavory);
    }

    private static String createExpertString(int val, int pref, String name) {
        int abs = Math.abs(val - pref);
        String out = ItemFoodTFC.createBasicString(val, pref, name);
        if (abs <= 5) {
            out = out + " (+-5)";
        } else if (abs <= 10) {
            out = out + " (+-10)";
        } else if (abs <= 15) {
            out = out + " (+-15)";
        } else if (abs <= 20) {
            out = out + " (+-20)";
        }
        return out;
    }

    private static String createBasicString(int val, int pref, String name) {
        int dif = val - pref;
        if (dif >= -5 && dif <= 5) {
            return TFC_Core.translate("gui.taste.4") + " " + TFC_Core.translate("gui.taste." + name);
        }
        if (dif >= -10 && dif < -5) {
            return TFC_Core.translate("gui.taste.3") + " " + TFC_Core.translate("gui.taste." + name);
        }
        if (dif >= -15 && dif < -10) {
            return TFC_Core.translate("gui.taste.2") + " " + TFC_Core.translate("gui.taste." + name);
        }
        if (dif >= -20 && dif < -15) {
            return TFC_Core.translate("gui.taste.1") + " " + TFC_Core.translate("gui.taste." + name);
        }
        if (dif < -20) {
            return TFC_Core.translate("gui.taste.0") + " " + TFC_Core.translate("gui.taste." + name);
        }
        if (dif > 5 && dif <= 10) {
            return TFC_Core.translate("gui.taste.5") + " " + TFC_Core.translate("gui.taste." + name);
        }
        if (dif > 10 && dif <= 15) {
            return TFC_Core.translate("gui.taste.6") + " " + TFC_Core.translate("gui.taste." + name);
        }
        if (dif > 15 && dif <= 20) {
            return TFC_Core.translate("gui.taste.7") + " " + TFC_Core.translate("gui.taste." + name);
        }
        if (dif > 20) {
            return TFC_Core.translate("gui.taste.8") + " " + TFC_Core.translate("gui.taste." + name);
        }
        return "";
    }

    public static String getFoodGroupName(EnumFoodGroup fg) {
        if (fg == EnumFoodGroup.Dairy) {
            return EnumChatFormatting.WHITE + TFC_Core.translate("gui.food.dairy");
        }
        if (fg == EnumFoodGroup.Fruit) {
            return EnumChatFormatting.DARK_PURPLE + TFC_Core.translate("gui.food.fruit");
        }
        if (fg == EnumFoodGroup.Vegetable) {
            return EnumChatFormatting.DARK_GREEN + TFC_Core.translate("gui.food.vegetable");
        }
        if (fg == EnumFoodGroup.Protein) {
            return EnumChatFormatting.DARK_RED + TFC_Core.translate("gui.food.protein");
        }
        if (fg == EnumFoodGroup.Grain) {
            return EnumChatFormatting.YELLOW + TFC_Core.translate("gui.food.grain");
        }
        return "N/A";
    }

    public static String getFoodGroupColor(EnumFoodGroup fg) {
        if (fg == EnumFoodGroup.Dairy) {
            return EnumChatFormatting.WHITE.toString();
        }
        if (fg == EnumFoodGroup.Fruit) {
            return EnumChatFormatting.DARK_PURPLE.toString();
        }
        if (fg == EnumFoodGroup.Vegetable) {
            return EnumChatFormatting.DARK_GREEN.toString();
        }
        if (fg == EnumFoodGroup.Protein) {
            return EnumChatFormatting.DARK_RED.toString();
        }
        if (fg == EnumFoodGroup.Grain) {
            return EnumChatFormatting.YELLOW.toString();
        }
        return "N/A";
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer player) {
        FoodStatsTFC foodstats = TFC_Core.getPlayerFoodStats(player);
        if (foodstats.needFood() && this.isEdible(is)) {
            player.func_71008_a(is, 32);
        }
        return is;
    }

    public ItemStack func_77654_b(ItemStack is, World world, EntityPlayer player) {
        FoodStatsTFC foodstats = TFC_Core.getPlayerFoodStats(player);
        if (!world.field_72995_K && this.isEdible(is)) {
            if (is.func_77942_o()) {
                float decay;
                float weight = Food.getWeight(is);
                float eatAmount = Math.min(weight - (decay = Math.max(Food.getDecay(is), 0.0f)), 5.0f);
                float stomachDiff = foodstats.stomachLevel + eatAmount - foodstats.getMaxStomach(foodstats.player);
                if (stomachDiff > 0.0f) {
                    eatAmount -= stomachDiff;
                }
                float tasteFactor = foodstats.getTasteFactor(is);
                foodstats.addNutrition(((IFood)is.func_77973_b()).getFoodGroup(), eatAmount * tasteFactor);
                foodstats.stomachLevel += eatAmount * tasteFactor;
                if (FoodStatsTFC.reduceFood(is, eatAmount)) {
                    is.field_77994_a = 0;
                }
            } else {
                foodstats.addNutrition(((IFood)is.func_77973_b()).getFoodGroup(), 1.0f);
                String error = TFC_Core.translate("error.error") + " " + is.func_77977_a() + " " + TFC_Core.translate("error.NBT") + " " + TFC_Core.translate("error.Contact");
                TerraFirmaCraft.LOG.error(error);
                TFC_Core.sendInfoMessage(player, (IChatComponent)new ChatComponentText(error));
            }
        }
        world.func_72956_a((Entity)player, "random.burp", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        TFC_Core.setPlayerFoodStats(player, foodstats);
        return is;
    }

    public ItemStack onConsumedByEntity(ItemStack is, World world, EntityLivingBase entity) {
        if (entity instanceof IAnimal) {
            float decay;
            float weight;
            float eatAmount;
            if (!world.field_72995_K && FoodStatsTFC.reduceFood(is, eatAmount = Math.min((weight = Food.getWeight(is)) - (decay = Math.max(Food.getDecay(is), 0.0f)), 5.0f))) {
                is.field_77994_a = 0;
            }
            world.func_72956_a((Entity)entity, "random.burp", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        return is;
    }

    public boolean isHot(ItemStack is) {
        return (double)TFC_ItemHeat.getTemp(is) > (double)TFC_ItemHeat.isCookable(is) * 0.8;
    }

    public static ItemStack createTag(ItemStack is) {
        return ItemFoodTFC.createTag(is, 999.0f);
    }

    public static ItemStack createTag(ItemStack is, float weight) {
        if (!is.func_77942_o()) {
            is.func_77982_d(new NBTTagCompound());
        }
        Food.setWeight(is, weight);
        Food.setDecay(is, -24.0f);
        Food.setDecayTimer(is, (int)TFC_Time.getTotalHours() + 1);
        return is;
    }

    public static ItemStack createTag(ItemStack is, float weight, float decay) {
        is = ItemFoodTFC.createTag(is, weight);
        Food.setDecay(is, decay);
        return is;
    }

    public int func_77626_a(ItemStack is) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack is) {
        return EnumAction.eat;
    }

    public int getDisplayDamage(ItemStack is) {
        float weight;
        float decay = Food.getDecay(is);
        int percent = (int)(decay / (weight = Food.getWeight(is)) * 100.0f);
        percent = percent > 0 ? (percent < 100 ? percent : 100) : 0;
        return percent;
    }

    public boolean isDamaged(ItemStack is) {
        return false;
    }

    public int getMaxDamage(ItemStack is) {
        return 100;
    }

    @Override
    public EnumSize getSize(ItemStack is) {
        float weight = Food.getWeight(is);
        if (weight <= 20.0f) {
            return EnumSize.TINY;
        }
        if (weight <= 40.0f) {
            return EnumSize.VERYSMALL;
        }
        if (weight <= 80.0f) {
            return EnumSize.SMALL;
        }
        return EnumSize.MEDIUM;
    }

    @Override
    public EnumWeight getWeight(ItemStack is) {
        float weight = Food.getWeight(is);
        if (weight < 80.0f) {
            return EnumWeight.LIGHT;
        }
        if (weight < 160.0f) {
            return EnumWeight.MEDIUM;
        }
        return EnumWeight.HEAVY;
    }

    @Override
    public boolean canStack() {
        return false;
    }

    @Override
    public EnumFoodGroup getFoodGroup() {
        return this.foodgroup;
    }

    @Override
    public int getFoodID() {
        return this.foodID;
    }

    @Override
    public ItemStack onDecayed(ItemStack is, World world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean isEdible(ItemStack is) {
        return this.edible || Food.isCooked(is);
    }

    @Override
    public boolean isUsable(ItemStack is) {
        return this.canBeUsedRaw || Food.isCooked(is);
    }

    @Override
    public int getTasteSweet(ItemStack is) {
        int base = this.tasteSweet;
        if (is != null) {
            if (is.func_77978_p().func_74764_b("tasteSweet")) {
                base = is.func_77978_p().func_74762_e("tasteSweet");
            }
            base += Food.getCookedProfile(is)[0];
            base = (int)((float)base + (float)Food.getFuelProfile(is)[0] * this.getSmokeAbsorbMultiplier());
        }
        return Math.max(base + Food.getSweetMod(is), 0);
    }

    @Override
    public int getTasteSour(ItemStack is) {
        int base = this.tasteSour;
        if (is != null) {
            if (is.func_77978_p().func_74764_b("tasteSour")) {
                base = is.func_77978_p().func_74762_e("tasteSour");
            }
            base += Food.getCookedProfile(is)[1];
            base = (int)((float)base + (float)Food.getFuelProfile(is)[1] * this.getSmokeAbsorbMultiplier());
        }
        if (Food.isBrined(is)) {
            base += 5;
        }
        if (Food.isPickled(is)) {
            base += 30;
        }
        return Math.max(base + Food.getSourMod(is), 0);
    }

    @Override
    public int getTasteSalty(ItemStack is) {
        int base = this.tasteSalty;
        if (is != null) {
            if (is.func_77978_p().func_74764_b("tasteSalty")) {
                base = is.func_77978_p().func_74762_e("tasteSalty");
            }
            base += Food.getCookedProfile(is)[2];
            base = (int)((float)base + (float)Food.getFuelProfile(is)[2] * this.getSmokeAbsorbMultiplier());
        }
        if (Food.isSalted(is)) {
            base += 40;
        }
        if (Food.isBrined(is)) {
            base += 10;
        }
        return Math.max(base + Food.getSaltyMod(is), 0);
    }

    @Override
    public int getTasteBitter(ItemStack is) {
        int base = this.tasteBitter;
        if (is != null) {
            if (is.func_77978_p().func_74764_b("tasteBitter")) {
                base = is.func_77978_p().func_74762_e("tasteBitter");
            }
            base += Food.getCookedProfile(is)[3];
            base = (int)((float)base + (float)Food.getFuelProfile(is)[3] * this.getSmokeAbsorbMultiplier());
        }
        return Math.max(base + Food.getBitterMod(is), 0);
    }

    @Override
    public int getTasteSavory(ItemStack is) {
        int base = this.tasteUmami;
        if (is != null) {
            if (is.func_77978_p().func_74764_b("tasteUmami")) {
                base = is.func_77978_p().func_74762_e("tasteUmami");
            }
            base += Food.getCookedProfile(is)[4];
            base = (int)((float)base + (float)Food.getFuelProfile(is)[4] * this.getSmokeAbsorbMultiplier());
        }
        return Math.max(base + Food.getSavoryMod(is), 0);
    }

    @Override
    public float getFoodMaxWeight(ItemStack is) {
        return 160.0f;
    }

    @Override
    public boolean renderDecay() {
        return true;
    }

    @Override
    public boolean renderWeight() {
        return true;
    }

    @Override
    public boolean canSmoke() {
        return this.canBeSmoked;
    }

    @Override
    public float getSmokeAbsorbMultiplier() {
        return this.smokeAbsorb;
    }

    public ItemFoodTFC setSmokeAbsorbMultiplier(float s) {
        this.smokeAbsorb = s;
        return this;
    }
}

