/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.GUI;

import com.bioxx.tfc.Containers.ContainerLargeVessel;
import com.bioxx.tfc.Core.Player.PlayerInventory;
import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.Core.TFC_Textures;
import com.bioxx.tfc.Core.TFC_Time;
import com.bioxx.tfc.GUI.GuiContainerTFC;
import com.bioxx.tfc.TileEntities.TEVessel;
import com.bioxx.tfc.api.Crafting.BarrelBriningRecipe;
import com.bioxx.tfc.api.Crafting.BarrelManager;
import com.bioxx.tfc.api.Crafting.BarrelPreservativeRecipe;
import com.bioxx.tfc.api.Enums.EnumFoodGroup;
import com.bioxx.tfc.api.Food;
import com.bioxx.tfc.api.Interfaces.IFood;
import com.bioxx.tfc.api.TFCFluids;
import com.bioxx.tfc.api.TFCItems;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiLargeVessel
extends GuiContainerTFC {
    public static final ResourceLocation TEXTURE = new ResourceLocation("terrafirmacraft", "textures/gui/gui_largevessel.png");
    private TEVessel vesselTE;
    private EntityPlayer player;
    private int guiTab;

    public GuiLargeVessel(InventoryPlayer inventoryplayer, TEVessel te, World world, int x, int y, int z, int tab) {
        super(new ContainerLargeVessel(inventoryplayer, te, world, x, y, z, tab), 176, 85);
        this.vesselTE = te;
        this.player = inventoryplayer.field_70458_d;
        this.field_147003_i = (this.field_146294_l - 208) / 2;
        this.field_147009_r = (this.field_146295_m - 198) / 2;
        this.guiTab = tab;
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.vesselTE.getInvCount() > 0) {
            if (this.guiTab == 0) {
                ((GuiButton)this.field_146292_n.get((int)4)).field_146125_m = false;
            } else if (this.guiTab == 1) {
                ((GuiButton)this.field_146292_n.get((int)1)).field_146125_m = false;
            }
        } else if (this.guiTab == 0) {
            ((GuiButton)this.field_146292_n.get((int)4)).field_146125_m = true;
        } else if (this.guiTab == 1) {
            ((GuiButton)this.field_146292_n.get((int)1)).field_146125_m = true;
        }
        if (this.vesselTE.getFluidLevel() > 0) {
            if (this.guiTab == 0) {
                ((GuiButton)this.field_146292_n.get((int)3)).field_146125_m = false;
            } else if (this.guiTab == 1) {
                ((GuiButton)this.field_146292_n.get((int)0)).field_146125_m = false;
            }
        } else if (this.guiTab == 0) {
            ((GuiButton)this.field_146292_n.get((int)3)).field_146125_m = true;
        } else if (this.guiTab == 1) {
            ((GuiButton)this.field_146292_n.get((int)0)).field_146125_m = true;
        }
        if (this.vesselTE.getSealed() && this.guiTab == 0) {
            ((GuiButton)this.field_146292_n.get((int)0)).field_146126_j = TFC_Core.translate("gui.Barrel.Unseal");
            ((GuiButton)this.field_146292_n.get((int)1)).field_146124_l = false;
            ((GuiButton)this.field_146292_n.get((int)2)).field_146124_l = false;
        } else if (!this.vesselTE.getSealed() && this.guiTab == 0) {
            ((GuiButton)this.field_146292_n.get((int)0)).field_146126_j = TFC_Core.translate("gui.Barrel.Seal");
            ((GuiButton)this.field_146292_n.get((int)1)).field_146124_l = true;
            ((GuiButton)this.field_146292_n.get((int)2)).field_146124_l = true;
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.createButtons();
    }

    public void createButtons() {
        this.field_146292_n.clear();
        if (this.guiTab == 0) {
            if (!this.vesselTE.getSealed()) {
                this.field_146292_n.add(new GuiButton(0, this.field_147003_i + 38, this.field_147009_r + 50, 50, 20, TFC_Core.translate("gui.Barrel.Seal")));
            } else {
                this.field_146292_n.add(new GuiButton(0, this.field_147003_i + 38, this.field_147009_r + 50, 50, 20, TFC_Core.translate("gui.Barrel.Unseal")));
            }
            this.field_146292_n.add(new GuiButton(1, this.field_147003_i + 88, this.field_147009_r + 50, 50, 20, TFC_Core.translate("gui.Barrel.Empty")));
            if (this.vesselTE.mode == 0) {
                this.field_146292_n.add(new GuiBarrelTabButton(2, this.field_147003_i + 39, this.field_147009_r + 29, 16, 16, this, TFC_Core.translate("gui.Barrel.ToggleOn"), 0, 204, 16, 16));
            } else if (this.vesselTE.mode == 1) {
                this.field_146292_n.add(new GuiBarrelTabButton(2, this.field_147003_i + 39, this.field_147009_r + 29, 16, 16, this, TFC_Core.translate("gui.Barrel.ToggleOff"), 0, 188, 16, 16));
            }
            this.field_146292_n.add(new GuiBarrelTabButton(3, this.field_147003_i + 36, this.field_147009_r - 12, 31, 15, this, TFC_Textures.guiSolidStorage, TFC_Core.translate("gui.Barrel.Solid")));
            this.field_146292_n.add(new GuiBarrelTabButton(4, this.field_147003_i + 5, this.field_147009_r - 12, 31, 15, this, TFC_Textures.guiLiquidStorage, TFC_Core.translate("gui.Barrel.Liquid")));
        } else if (this.guiTab == 1) {
            this.field_146292_n.add(new GuiBarrelTabButton(0, this.field_147003_i + 36, this.field_147009_r - 12, 31, 15, this, TFC_Textures.guiSolidStorage, TFC_Core.translate("gui.Barrel.Solid")));
            this.field_146292_n.add(new GuiBarrelTabButton(1, this.field_147003_i + 5, this.field_147009_r - 12, 31, 15, this, TFC_Textures.guiLiquidStorage, TFC_Core.translate("gui.Barrel.Liquid")));
            if (!this.vesselTE.getSealed()) {
                this.field_146292_n.add(new GuiButton(2, this.field_147003_i + 6, this.field_147009_r + 33, 44, 20, TFC_Core.translate("gui.Barrel.Seal")));
            } else {
                this.field_146292_n.add(new GuiButton(2, this.field_147003_i + 6, this.field_147009_r + 33, 44, 20, TFC_Core.translate("gui.Barrel.Unseal")));
            }
        }
    }

    @Override
    public void drawTooltip(int mx, int my, String text) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(text);
        this.drawHoveringText(list, mx, my + 15, this.field_146289_q);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (this.guiTab == 0) {
            if (guibutton.field_146127_k == 0) {
                if (!this.vesselTE.getSealed()) {
                    this.vesselTE.actionSeal(0, this.player);
                } else {
                    this.vesselTE.actionUnSeal(0, this.player);
                }
            } else if (guibutton.field_146127_k == 1) {
                this.vesselTE.actionEmpty();
            } else if (guibutton.field_146127_k == 2) {
                this.vesselTE.actionMode();
                this.createButtons();
            } else if (guibutton.field_146127_k == 3 && this.vesselTE.getFluidLevel() == 0 && this.vesselTE.getInvCount() == 0) {
                this.vesselTE.actionSwitchTab(1, this.player);
            }
        } else if (this.guiTab == 1) {
            if (guibutton.field_146127_k == 1 && this.vesselTE.getInvCount() == 0) {
                this.vesselTE.actionSwitchTab(0, this.player);
            } else if (guibutton.field_146127_k == 2) {
                if (!this.vesselTE.getSealed()) {
                    this.vesselTE.actionSeal(1, this.player);
                } else {
                    this.vesselTE.actionUnSeal(1, this.player);
                }
                this.createButtons();
            }
        }
    }

    @Override
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        TFC_Core.bindTexture(TEXTURE);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        int w = (this.field_146294_l - this.field_146999_f) / 2;
        int h = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.guiTab == 0) {
            this.func_73729_b(w, h, 0, 0, this.field_146999_f, this.getShiftedYSize());
            int scale = 0;
            if (this.vesselTE != null && this.vesselTE.fluid != null) {
                scale = this.vesselTE.getLiquidScaled(50);
                IIcon liquidIcon = this.vesselTE.fluid.getFluid().getIcon(this.vesselTE.fluid);
                TFC_Core.bindTexture(TextureMap.field_110575_b);
                int color = this.vesselTE.fluid.getFluid().getColor(this.vesselTE.fluid);
                GL11.glColor4ub((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)), (byte)-86);
                int div = (int)Math.floor(scale / 8);
                int rem = scale - div * 8;
                this.func_94065_a(w + 12, h + 65 - scale, liquidIcon, 8, div > 0 ? 8 : rem);
                for (int c = 0; div > 0 && c < div; ++c) {
                    this.func_94065_a(w + 12, h + 65 - (8 + c * 8), liquidIcon, 8, 8);
                }
                GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            }
            ItemStack inStack = this.vesselTE.func_70301_a(0);
            if (this.vesselTE.getFluidStack() != null) {
                this.func_73732_a(this.field_146289_q, this.vesselTE.fluid.getFluid().getLocalizedName(this.vesselTE.getFluidStack()), this.field_147003_i + 88, this.field_147009_r + 7, 0x555555);
            }
            if (this.vesselTE.sealtime != 0) {
                this.func_73732_a(this.field_146289_q, TFC_Time.getDateStringFromHours(this.vesselTE.sealtime), this.field_147003_i + 88, this.field_147009_r + 17, 0x555555);
            }
            if (this.vesselTE.recipe != null) {
                if (!(this.vesselTE.recipe instanceof BarrelBriningRecipe)) {
                    this.func_73732_a(this.field_146289_q, TFC_Core.translate("gui.Output") + ": " + this.vesselTE.recipe.getRecipeName(), this.field_147003_i + 88, this.field_147009_r + 72, 0x555555);
                } else if (this.vesselTE.getSealed() && this.vesselTE.getFluidStack() != null && this.vesselTE.getFluidStack().getFluid() == TFCFluids.BRINE && inStack != null && inStack.func_77973_b() instanceof IFood && (((IFood)inStack.func_77973_b()).getFoodGroup() == EnumFoodGroup.Fruit || ((IFood)inStack.func_77973_b()).getFoodGroup() == EnumFoodGroup.Vegetable || ((IFood)inStack.func_77973_b()).getFoodGroup() == EnumFoodGroup.Protein || (IFood)inStack.func_77973_b() == TFCItems.cheese) && !Food.isBrined(inStack)) {
                    this.func_73732_a(this.field_146289_q, TFC_Core.translate("gui.barrel.brining"), this.field_147003_i + 88, this.field_147009_r + 72, 0x555555);
                }
            } else if (this.vesselTE.recipe == null && this.vesselTE.getSealed() && this.vesselTE.getFluidStack() != null && inStack != null && inStack.func_77973_b() instanceof IFood && this.vesselTE.getFluidStack().getFluid() == TFCFluids.VINEGAR && !Food.isPickled(inStack) && Food.getWeight(inStack) / (float)this.vesselTE.getFluidStack().amount <= 160.0f / (float)this.vesselTE.getMaxLiquid()) {
                if ((((IFood)inStack.func_77973_b()).getFoodGroup() == EnumFoodGroup.Fruit || ((IFood)inStack.func_77973_b()).getFoodGroup() == EnumFoodGroup.Vegetable || ((IFood)inStack.func_77973_b()).getFoodGroup() == EnumFoodGroup.Protein || (IFood)inStack.func_77973_b() == TFCItems.cheese) && Food.isBrined(inStack)) {
                    this.func_73732_a(this.field_146289_q, TFC_Core.translate("gui.barrel.pickling"), this.field_147003_i + 88, this.field_147009_r + 72, 0x555555);
                }
            } else {
                BarrelPreservativeRecipe preservative = BarrelManager.getInstance().findMatchingPreservativeRepice(this.vesselTE, inStack, this.vesselTE.getFluidStack(), this.vesselTE.getSealed());
                if (preservative != null) {
                    this.func_73732_a(this.field_146289_q, TFC_Core.translate(preservative.getPreservingString()), this.field_147003_i + 88, this.field_147009_r + 72, 0x555555);
                }
            }
        } else if (this.guiTab == 1) {
            this.func_73729_b(w, h, 0, 86, this.field_146999_f, this.getShiftedYSize());
        }
        PlayerInventory.drawInventory(this, this.field_146294_l, this.field_146295_m, this.getShiftedYSize());
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        if (this.guiTab == 0 && this.mouseInRegion(12, 15, 9, 50, mouseX, mouseY)) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.vesselTE.getFluidLevel() + "mB");
            this.drawHoveringText(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r + 8, this.field_146289_q);
        }
    }

    public void func_73732_a(FontRenderer fontrenderer, String s, int i, int j, int k) {
        fontrenderer.func_78276_b(s, i - fontrenderer.func_78256_a(s) / 2, j, k);
    }

    @Override
    public void func_73863_a(int x, int y, float par3) {
        super.func_73863_a(x, y, par3);
        if (this.vesselTE.getSealed()) {
            GL11.glPushMatrix();
            if (this.guiTab == 0) {
                Slot inputSlot = this.field_147002_h.func_75139_a(0);
                this.drawSlotOverlay(inputSlot);
            } else if (this.guiTab == 1) {
                for (int i = 0; i < this.vesselTE.storage.length; ++i) {
                    Slot slot = this.field_147002_h.func_75139_a(i);
                    this.drawSlotOverlay(slot);
                }
            }
            GL11.glPopMatrix();
        }
    }

    private void drawSlotOverlay(Slot slot) {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        int xPos = slot.field_75223_e + this.field_147003_i - 1;
        int yPos = slot.field_75221_f + this.field_147009_r - 1;
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        this.func_73733_a(xPos, yPos, xPos + 18, yPos + 18, 0x75FFFFFF, 0x75FFFFFF);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    public class GuiBarrelTabButton
    extends GuiButton {
        private GuiLargeVessel screen;
        private IIcon buttonicon;
        private int xPos;
        private int yPos;
        private int xSize;
        private int ySize;

        public GuiBarrelTabButton(int index, int xPos, int yPos, int width, int height, GuiLargeVessel gui, IIcon icon, String s) {
            super(index, xPos, yPos, width, height, s);
            this.yPos = 172;
            this.xSize = 31;
            this.ySize = 15;
            this.screen = gui;
            this.buttonicon = icon;
        }

        public GuiBarrelTabButton(int index, int xPos, int yPos, int width, int height, GuiLargeVessel gui, String s, int xp, int yp, int xs, int ys) {
            super(index, xPos, yPos, width, height, s);
            this.yPos = 172;
            this.xSize = 31;
            this.ySize = 15;
            this.screen = gui;
            this.xPos = xp;
            this.yPos = yp;
            this.xSize = xs;
            this.ySize = ys;
        }

        public void func_146112_a(Minecraft mc, int x, int y) {
            if (this.field_146125_m) {
                TFC_Core.bindTexture(TEXTURE);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_73735_i = 301.0f;
                this.func_73729_b(this.field_146128_h, this.field_146129_i, this.xPos, this.yPos, this.xSize, this.ySize);
                this.field_146123_n = x >= this.field_146128_h && y >= this.field_146129_i && x < this.field_146128_h + this.field_146120_f && y < this.field_146129_i + this.field_146121_g;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                TFC_Core.bindTexture(TextureMap.field_110575_b);
                if (this.buttonicon != null) {
                    this.func_94065_a(this.field_146128_h + 12, this.field_146129_i + 4, this.buttonicon, 8, 8);
                }
                this.field_73735_i = 0.0f;
                this.func_146119_b(mc, x, y);
                if (this.field_146123_n) {
                    this.screen.drawTooltip(x, y, this.field_146126_j);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
        }
    }

    public class GuiButtonMode
    extends GuiButton {
        public GuiButtonMode(int par1, int par2, int par3, String par4Str) {
            super(par1, par2, par3, 200, 20, par4Str);
        }

        public GuiButtonMode(int par1, int par2, int par3, int par4, int par5, String par6Str) {
            super(par1, par2, par3, par4, par5, par6Str);
        }

        public void func_146112_a(Minecraft par1Minecraft, int xPos, int yPos) {
            if (this.field_146125_m) {
                FontRenderer fontrenderer = par1Minecraft.field_71466_p;
                par1Minecraft.func_110434_K().func_110577_a(field_146122_a);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = xPos >= this.field_146128_h && yPos >= this.field_146129_i && xPos < this.field_146128_h + this.field_146120_f && yPos < this.field_146129_i + this.field_146121_g;
                int k = this.func_146114_a(this.field_146123_n);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 46 + k * 20, this.field_146120_f / 2, this.field_146121_g);
                this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i, 200 - this.field_146120_f / 2, 46 + k * 20, this.field_146120_f / 2, this.field_146121_g);
                this.func_146119_b(par1Minecraft, xPos, yPos);
                int l = 0xE0E0E0;
                if (!this.field_146124_l) {
                    l = -6250336;
                } else if (this.field_146123_n) {
                    l = 0xFFFFA0;
                }
                this.func_73732_a(fontrenderer, ((GuiLargeVessel)GuiLargeVessel.this).vesselTE.mode == 0 ? TFC_Core.translate("gui.Barrel.ToggleOn") : TFC_Core.translate("gui.Barrel.ToggleOff"), this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, l);
            }
        }
    }
}

