/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.Handlers.Client;

import com.bioxx.tfc.Core.TFC_Climate;
import com.bioxx.tfc.Core.WeatherManager;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import org.lwjgl.opengl.GL11;

public class FogHandler {
    private double lerpTime = 14.0;
    private double lerpTimer;
    private boolean rainLast;
    private boolean snowLast;
    private boolean shouldLerp;
    private float fogEnd;
    private float fogStart;
    private float fogDensity = 0.1f;
    private float fogEndBegin;
    private float fogStartBegin;
    private float fogDensityBegin = 0.1f;
    private float fogEndFinish;
    private float fogStartFinish;
    private float fogDensityFinish = 0.1f;
    private float localWorldFog;
    private float snowStrength;
    private int renderRange = 17;

    @SubscribeEvent
    public void renderFogHandler(EntityViewRenderEvent.RenderFogEvent event) {
        if (event.fogMode >= 0) {
            if (this.renderRange != Minecraft.func_71410_x().field_71474_y.field_151451_c || this.fogEnd < 16.0f) {
                this.renderRange = Minecraft.func_71410_x().field_71474_y.field_151451_c;
                this.fogStart = event.farPlaneDistance * 0.75f;
                this.fogEnd = event.farPlaneDistance;
            }
            if (this.shouldLerp) {
                this.lerpTimer += event.renderPartialTicks;
                if (this.lerpTimer >= this.lerpTime) {
                    this.shouldLerp = false;
                }
                this.fogStart = this.lerp(this.fogStartBegin, this.fogStartFinish, this.lerpTime, this.lerpTimer);
                this.fogEnd = this.lerp(this.fogEndBegin, this.fogEndFinish, this.lerpTime, this.lerpTimer);
                this.fogDensity = this.lerp(this.fogDensityBegin, this.fogDensityFinish, this.lerpTime, this.lerpTimer);
            }
            this.calcFog(event);
            if ((int)event.entity.field_70163_u > 128) {
                GL11.glFogf((int)2914, (float)Math.min(this.fogDensity, 0.3f));
                GL11.glFogf((int)2915, (float)Math.max(this.fogStart, 8.0f));
                GL11.glFogf((int)2916, (float)Math.max(this.fogEnd, 16.0f));
            }
        }
    }

    private void calcFog(EntityViewRenderEvent.RenderFogEvent event) {
        if (this.renderRange < 6) {
            return;
        }
        boolean raining = event.entity.field_70170_p.func_72896_J();
        float temp = TFC_Climate.getHeightAdjustedTemp(event.entity.field_70170_p, (int)event.entity.field_70165_t, (int)event.entity.field_70163_u, (int)event.entity.field_70161_v);
        float localFog = WeatherManager.getInstance().getLocalFog(event.entity.field_70170_p, (int)event.entity.field_70165_t, (int)event.entity.field_70163_u, (int)event.entity.field_70161_v);
        if (localFog != this.localWorldFog) {
            localFog = WeatherManager.getInstance().getLocalFog(event.entity.field_70170_p, (int)event.entity.field_70165_t, (int)event.entity.field_70163_u, (int)event.entity.field_70161_v);
        }
        if (raining && temp > 0.0f) {
            if (!this.rainLast || this.snowLast) {
                this.startLerp(600.0);
                this.rainLast = true;
                this.snowLast = false;
                this.fogStartFinish = event.farPlaneDistance * 0.5f;
                this.fogEndFinish = event.farPlaneDistance * 0.75f;
                this.fogDensityFinish = 0.2f;
            }
        } else if (raining && temp <= 0.0f) {
            if (!this.snowLast) {
                this.startLerp(600.0);
                this.rainLast = true;
                this.snowLast = true;
                this.snowStrength = WeatherManager.getInstance().getSnowStrength();
                this.fogStartFinish = event.farPlaneDistance * 0.1f;
                this.fogEndFinish = event.farPlaneDistance * (0.2f + 0.1f * this.snowStrength);
                this.fogDensityFinish = 0.3f;
            } else if (this.snowLast && WeatherManager.getInstance().getSnowStrength() != this.snowStrength) {
                this.startLerp(300.0);
                this.snowStrength = WeatherManager.getInstance().getSnowStrength();
                this.fogStartFinish = event.farPlaneDistance * 0.1f;
                this.fogEndFinish = event.farPlaneDistance * (0.2f + 0.1f * this.snowStrength);
                this.fogDensityFinish = 0.3f;
            }
        } else if (localFog > 0.0f && localFog != this.localWorldFog) {
            this.startLerp(600.0);
            this.localWorldFog = localFog;
            this.fogStartFinish = event.farPlaneDistance * 0.1f;
            this.fogEndFinish = event.farPlaneDistance * (0.6f - 0.3f * localFog);
            this.fogDensityFinish = 0.2f - 0.08f * localFog;
        } else if (!raining) {
            if (this.rainLast || this.localWorldFog != 0.0f && localFog == 0.0f) {
                this.startLerp(600.0);
                this.localWorldFog = 0.0f;
                this.rainLast = false;
                this.snowLast = false;
                this.fogStartFinish = event.farPlaneDistance * 0.75f;
                this.fogEndFinish = event.farPlaneDistance;
                this.fogDensityFinish = 0.1f;
            } else if (!this.shouldLerp && this.localWorldFog == 0.0f) {
                this.fogStart = event.farPlaneDistance * 0.75f;
                this.fogEnd = event.farPlaneDistance;
                this.fogDensity = 0.1f;
            }
        }
    }

    public float lerp(float start, float target, double duration, double timeSinceStart) {
        float value = start;
        if (timeSinceStart > 0.0 && timeSinceStart < duration) {
            float range = target - start;
            float percent = (float)(timeSinceStart / duration);
            value = start + range * percent;
        } else if (timeSinceStart >= duration) {
            value = target;
        }
        return value;
    }

    private void startLerp(double ticks) {
        if (!this.shouldLerp) {
            this.shouldLerp = true;
            this.lerpTimer = 0.0;
            this.lerpTime = ticks;
            this.fogStartBegin = this.fogStart;
            this.fogEndBegin = this.fogEnd;
            this.fogDensityBegin = this.fogDensity;
        }
    }
}

