/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.Handlers;

import com.bioxx.tfc.Core.Player.FoodStatsTFC;
import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.Entities.EntityJavelin;
import com.bioxx.tfc.Items.ItemTFCArmor;
import com.bioxx.tfc.api.Enums.EnumDamageType;
import com.bioxx.tfc.api.Events.EntityArmorCalcEvent;
import com.bioxx.tfc.api.Interfaces.ICausesDamage;
import com.bioxx.tfc.api.Interfaces.IInnateArmor;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;

public class EntityDamageHandler {
    @SubscribeEvent
    public void onEntityHurt(LivingHurtEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity instanceof EntityPlayer) {
            float curMaxHealth = (float)((EntityPlayer)entity).func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
            float newMaxHealth = FoodStatsTFC.getMaxHealth((EntityPlayer)entity);
            float h = ((EntityPlayer)entity).func_110143_aJ();
            if (newMaxHealth != curMaxHealth) {
                ((EntityPlayer)entity).func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)newMaxHealth);
            }
            if (newMaxHealth < h) {
                ((EntityPlayer)entity).func_70606_j(newMaxHealth);
            }
        }
        if (event.source == DamageSource.field_76370_b) {
            event.ammount = 50.0f;
        } else if (event.source == DamageSource.field_76379_h) {
            float healthMod = TFC_Core.getEntityMaxHealth(entity) / 1000.0f;
            event.ammount *= 80.0f * healthMod;
        } else if (event.source == DamageSource.field_76369_e) {
            event.ammount = 50.0f;
        } else if (event.source == DamageSource.field_76371_c) {
            event.ammount = 100.0f;
        } else if (event.source == DamageSource.field_76368_d) {
            event.ammount = 100.0f;
        } else if (event.source == DamageSource.field_82729_p) {
            event.ammount = 100.0f;
        } else if (event.source.func_94541_c()) {
            event.ammount *= 30.0f;
        } else if (event.source == DamageSource.field_76376_m && entity.func_110143_aJ() > 25.0f) {
            event.ammount = 25.0f;
        } else if ("player".equals(event.source.field_76373_n) || "mob".equals(event.source.field_76373_n) || "arrow".equals(event.source.field_76373_n)) {
            Entity e;
            event.ammount = this.applyArmorCalculations(entity, event.source, event.ammount);
            if ("arrow".equals(event.source.field_76373_n) && (e = ((EntityDamageSourceIndirect)event.source).func_76364_f()) instanceof EntityJavelin) {
                ((EntityJavelin)e).setDamageTaken((short)(((EntityJavelin)e).damageTaken + 10));
                if (((EntityJavelin)e).damageTaken >= ((EntityJavelin)e).pickupItem.func_77612_l()) {
                    e.func_70106_y();
                }
            }
        }
    }

    protected int applyArmorCalculations(EntityLivingBase entity, DamageSource source, float originalDamage) {
        ItemStack[] armor = entity.func_70035_c();
        int pierceRating = 0;
        int slashRating = 0;
        int crushRating = 0;
        EntityArmorCalcEvent eventPre = new EntityArmorCalcEvent(entity, originalDamage, EntityArmorCalcEvent.EventType.PRE);
        MinecraftForge.EVENT_BUS.post((Event)eventPre);
        float damage = eventPre.incomingDamage;
        if (!source.func_76363_c() && armor != null) {
            float slashMult;
            float pierceMult;
            int location = this.getRandomSlot(entity.func_70681_au());
            if (armor[location] != null && armor[location].func_77973_b() instanceof ItemTFCArmor) {
                pierceRating = ((ItemTFCArmor)armor[location].func_77973_b()).armorTypeTFC.getPiercingAR();
                slashRating = ((ItemTFCArmor)armor[location].func_77973_b()).armorTypeTFC.getSlashingAR();
                crushRating = ((ItemTFCArmor)armor[location].func_77973_b()).armorTypeTFC.getCrushingAR();
                if (entity instanceof IInnateArmor) {
                    pierceRating += ((IInnateArmor)entity).getPierceArmor();
                    slashRating += ((IInnateArmor)entity).getSlashArmor();
                    crushRating += ((IInnateArmor)entity).getCrushArmor();
                }
                pierceMult = this.getDamageReduction(pierceRating);
                slashMult = this.getDamageReduction(slashRating);
                float crushMult = this.getDamageReduction(crushRating);
                damage = this.processDamageSource(source, damage, pierceMult, slashMult, crushMult);
                armor[location].func_77972_a((int)this.processArmorDamage(armor[location], damage), entity);
            } else if (armor[location] == null || armor[location] != null && !(armor[location].func_77973_b() instanceof ItemTFCArmor)) {
                if (entity instanceof IInnateArmor) {
                    pierceRating += ((IInnateArmor)entity).getPierceArmor();
                    slashRating += ((IInnateArmor)entity).getSlashArmor();
                    crushRating += ((IInnateArmor)entity).getCrushArmor();
                }
                pierceMult = this.getDamageReduction(pierceRating);
                slashMult = this.getDamageReduction(slashRating);
                float crushMult = this.getDamageReduction(crushRating);
                damage = this.processDamageSource(source, damage, pierceMult, slashMult, crushMult);
                if (location == 3) {
                    damage *= 1.75f;
                } else if (location == 0) {
                    entity.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 100, 1));
                }
            }
            EntityArmorCalcEvent eventPost = new EntityArmorCalcEvent(entity, damage, EntityArmorCalcEvent.EventType.POST);
            MinecraftForge.EVENT_BUS.post((Event)eventPost);
            float hasHealth = entity.func_110143_aJ();
            entity.func_70606_j(entity.func_110143_aJ() - eventPost.incomingDamage);
            entity.func_110142_aN().func_94547_a(source, hasHealth, eventPost.incomingDamage);
        }
        return 0;
    }

    private float processDamageSource(DamageSource source, float damage, float pierceMult, float slashMult, float crushMult) {
        EnumDamageType damageType = this.getDamageType(source);
        if (damageType == EnumDamageType.PIERCING) {
            damage *= pierceMult;
        } else if (damageType == EnumDamageType.SLASHING) {
            damage *= slashMult;
        } else if (damageType == EnumDamageType.CRUSHING) {
            damage *= crushMult;
        } else if (damageType == EnumDamageType.GENERIC) {
            damage = (float)((double)damage * ((double)((crushMult + slashMult + pierceMult) / 3.0f) - 0.25));
        }
        return Math.max(0.0f, damage);
    }

    private EnumDamageType getDamageType(DamageSource source) {
        EntityLiving el;
        EntityPlayer player;
        if (source.func_76364_f() instanceof EntityPlayer && (player = (EntityPlayer)source.func_76364_f()).func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ICausesDamage) {
            return ((ICausesDamage)player.func_71045_bC().func_77973_b()).getDamageType();
        }
        if (source.func_76364_f() instanceof EntityLiving && (el = (EntityLiving)source.func_76364_f()).func_70694_bm() != null && el.func_70694_bm().func_77973_b() instanceof ICausesDamage) {
            return ((ICausesDamage)el.func_70694_bm().func_77973_b()).getDamageType();
        }
        if (source.func_76364_f() instanceof ICausesDamage) {
            return ((ICausesDamage)source.func_76364_f()).getDamageType();
        }
        return EnumDamageType.GENERIC;
    }

    private int getRandomSlot(Random rand) {
        int chance = rand.nextInt(100);
        if (chance < 10) {
            return 3;
        }
        if (chance < 20) {
            return 0;
        }
        if (chance < 80) {
            return 2;
        }
        return 1;
    }

    private float processArmorDamage(ItemStack armor, float baseDamage) {
        NBTTagCompound nbt;
        if (armor.func_77942_o() && (nbt = armor.func_77978_p()).func_74764_b("armorReductionBuff")) {
            float reductBuff = (float)nbt.func_74771_c("armorReductionBuff") / 100.0f;
            return baseDamage - baseDamage * reductBuff;
        }
        return baseDamage;
    }

    protected float getDamageReduction(int armorRating) {
        if (armorRating == -1000) {
            armorRating = -999;
        }
        return 1000.0f / (1000.0f + (float)armorRating);
    }

    @SubscribeEvent
    public void onAttackEntity(AttackEntityEvent event) {
        if (event.entityLiving.field_70170_p.field_72995_K) {
            return;
        }
        EntityLivingBase attacker = event.entityLiving;
        EntityPlayer player = event.entityPlayer;
        Entity target = event.target;
        ItemStack stack = attacker.func_71124_b(0);
        if (stack != null && stack.func_77973_b().onLeftClickEntity(stack, player, target)) {
            return;
        }
        if (target.func_70075_an() && !target.func_85031_j(target)) {
            float damageAmount = 10.0f;
            if (stack != null && (damageAmount = (float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()) == 1.0f) {
                damageAmount = 10.0f;
            }
            if (player.func_70644_a(Potion.field_76420_g)) {
                damageAmount += (float)(3 << player.func_70660_b(Potion.field_76420_g).func_76458_c());
            }
            if (player.func_70644_a(Potion.field_76437_t)) {
                damageAmount -= (float)(2 << player.func_70660_b(Potion.field_76437_t).func_76458_c());
            }
            int knockback = 0;
            float enchantmentDamage = 0.0f;
            if (target instanceof EntityLiving) {
                enchantmentDamage = EnchantmentHelper.func_77512_a((EntityLivingBase)player, (EntityLivingBase)((EntityLiving)target));
                knockback += EnchantmentHelper.func_77507_b((EntityLivingBase)player, (EntityLivingBase)((EntityLiving)target));
            }
            if (player.func_70051_ag()) {
                ++knockback;
            }
            if (damageAmount > 0.0f || enchantmentDamage > 0.0f) {
                IEntityMultiPart ientitymultipart;
                boolean entityAttacked;
                boolean criticalHit;
                boolean bl = criticalHit = player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(Potion.field_76440_q) && player.field_70154_o == null && target instanceof EntityLiving;
                if (criticalHit && damageAmount > 0.0f) {
                    damageAmount += (float)event.entity.field_70170_p.field_73012_v.nextInt((int)(damageAmount / 2.0f + 2.0f));
                }
                damageAmount += enchantmentDamage;
                boolean onFire = false;
                int fireAspect = EnchantmentHelper.func_90036_a((EntityLivingBase)player);
                if (target instanceof EntityLiving && fireAspect > 0 && !target.func_70027_ad()) {
                    onFire = true;
                    target.func_70015_d(1);
                }
                if (entityAttacked = target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), damageAmount)) {
                    if (knockback > 0) {
                        target.func_70024_g((double)(-MathHelper.func_76126_a((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f));
                        player.field_70159_w *= 0.6;
                        player.field_70179_y *= 0.6;
                        player.func_70031_b(false);
                    }
                    if (criticalHit) {
                        player.func_71009_b(target);
                    }
                    if (enchantmentDamage > 0.0f) {
                        player.func_71047_c(target);
                    }
                    if (damageAmount >= 18.0f) {
                        player.func_71029_a((StatBase)AchievementList.field_75999_E);
                    }
                    player.func_130011_c(target);
                    if (target instanceof EntityLiving) {
                        target.func_70097_a(DamageSource.func_92087_a((Entity)attacker), damageAmount);
                    }
                }
                ItemStack itemstack = player.func_71045_bC();
                Entity object = target;
                if (target instanceof EntityDragonPart && (ientitymultipart = ((EntityDragonPart)target).field_70259_a) instanceof EntityLiving) {
                    object = ientitymultipart;
                }
                if (itemstack != null && object instanceof EntityLiving) {
                    itemstack.func_77961_a((EntityLivingBase)((EntityLiving)object), player);
                    if (itemstack.field_77994_a <= 0) {
                        player.func_71028_bD();
                    }
                }
                if (target instanceof EntityLivingBase) {
                    player.func_71064_a(StatList.field_75951_w, Math.round(damageAmount * 10.0f));
                    if (fireAspect > 0 && entityAttacked) {
                        target.func_70015_d(fireAspect * 4);
                    } else if (onFire) {
                        target.func_70066_B();
                    }
                }
                player.func_71020_j(0.3f);
            }
        }
        event.setCanceled(true);
    }
}

