/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.Handlers;

import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.Food.ItemFoodTFC;
import com.bioxx.tfc.Items.Tools.ItemKnife;
import com.bioxx.tfc.api.Events.ItemCookEvent;
import com.bioxx.tfc.api.Food;
import com.bioxx.tfc.api.Interfaces.IFood;
import com.bioxx.tfc.api.TFCItems;
import com.bioxx.tfc.api.Util.Helper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class FoodCraftingHandler {
    public static boolean preCrafted;

    @SubscribeEvent
    public void onFoodCook(ItemCookEvent event) {
    }

    @SubscribeEvent
    public void onFoodCrafting(PlayerEvent.ItemCraftedEvent e) {
        if (preCrafted) {
            preCrafted = false;
            return;
        }
        ItemStack craftResult = e.crafting;
        IInventory craftingInv = e.craftMatrix;
        if (craftingInv != null) {
            if (FoodCraftingHandler.refiningGrain(craftResult, craftingInv)) {
                List knives = OreDictionary.getOres((String)"itemKnife", (boolean)false);
                FoodCraftingHandler.handleItem(e.player, craftingInv, knives);
                for (int i = 0; i < craftingInv.func_70302_i_(); ++i) {
                    ItemStack inputStack = craftingInv.func_70301_a(i);
                    if (inputStack == null || !(inputStack.func_77973_b() instanceof IFood)) continue;
                    float foodWeight = Food.getWeight(inputStack);
                    int strawCount = 0;
                    int j = 0;
                    while ((float)j < foodWeight) {
                        ++strawCount;
                        j += 4;
                    }
                    TFC_Core.giveItemToPlayer(new ItemStack(TFCItems.straw, strawCount), e.player);
                }
            } else if (FoodCraftingHandler.makingDough(craftResult, craftingInv)) {
                for (int i = 0; i < craftingInv.func_70302_i_(); ++i) {
                    ItemStack inputStack = craftingInv.func_70301_a(i);
                    if (inputStack == null || !(inputStack.func_77973_b() instanceof IFood)) continue;
                    float grainWeight = Food.getWeight(inputStack);
                    float grainDecay = Food.getDecay(inputStack);
                    if (grainDecay >= 0.0f) {
                        grainWeight -= grainDecay;
                    }
                    grainWeight -= Math.min(grainWeight, 80.0f);
                    inputStack = ItemFoodTFC.createTag(inputStack, grainWeight, 0.0f);
                    if (!(grainWeight > 0.0f)) continue;
                    ++inputStack.field_77994_a;
                    if (inputStack.field_77994_a <= 2) continue;
                    inputStack.field_77994_a = 2;
                }
            } else if (craftResult.func_77942_o() && craftResult.func_77978_p().func_74764_b("foodWeight")) {
                craftResult = FoodCraftingHandler.processFoodInput(e.player, craftResult, craftingInv);
            }
        }
    }

    private static ItemStack processFoodInput(EntityPlayer player, ItemStack craftResult, IInventory craftingInv) {
        block20: {
            int i;
            int foodSlot;
            float finalDecay;
            float finalWeight;
            block21: {
                finalWeight = 0.0f;
                finalDecay = 0.0f;
                int[] fuelTasteProfile = new int[]{0, 0, 0, 0, 0};
                int[] cookedTasteProfile = new int[]{0, 0, 0, 0, 0};
                float cookedTime = 0.0f;
                int foodCount = 0;
                int itemCount = 0;
                foodSlot = 0;
                for (i = 0; i < craftingInv.func_70302_i_(); ++i) {
                    float inputWeight;
                    ItemStack is = craftingInv.func_70301_a(i);
                    if (is == null) continue;
                    ++itemCount;
                    if (!(is.func_77973_b() instanceof ItemFoodTFC) || !is.func_77942_o() || !is.func_77978_p().func_74764_b("foodWeight")) continue;
                    foodSlot = i;
                    if (foodCount == 0) {
                        fuelTasteProfile = Food.getFuelProfile(is);
                        cookedTasteProfile = Food.getCookedProfile(is);
                        cookedTime = Food.getCooked(is);
                    }
                    float oldInputWeight = inputWeight = Food.getWeight(is);
                    float inputDecayPercent = Food.getDecay(is) / oldInputWeight;
                    float inputDecay = Food.getDecay(is);
                    float weightChange = 0.0f;
                    if (finalWeight < 160.0f && Food.isSameSmoked(cookedTasteProfile, Food.getCookedProfile(is)) && Food.isSameSmoked(fuelTasteProfile, Food.getFuelProfile(is)) && ((int)Food.getCooked(is) - 600) / 120 == ((int)cookedTime - 600) / 120) {
                        weightChange = Math.min(160.0f - finalWeight, inputWeight);
                        inputWeight -= weightChange;
                        finalWeight += weightChange;
                    }
                    if (inputWeight != oldInputWeight) {
                        if (inputWeight == 0.0f) {
                            if (finalDecay < 0.0f) {
                                if (inputDecay > finalDecay) {
                                    finalDecay = inputDecay;
                                }
                            } else {
                                finalDecay += inputDecay;
                            }
                        } else {
                            float decayChange = weightChange * inputDecayPercent;
                            inputDecay -= decayChange;
                            if (finalDecay < 0.0f) {
                                if (decayChange > finalDecay) {
                                    finalDecay = decayChange;
                                }
                            } else {
                                finalDecay += decayChange;
                            }
                        }
                        ++foodCount;
                    }
                    if (!(inputWeight > 0.0f)) continue;
                    Food.setWeight(is, inputWeight);
                    Food.setDecay(is, inputDecay);
                    ++is.field_77994_a;
                    if (is.field_77994_a <= 2) continue;
                    is.field_77994_a = 2;
                }
                if (craftResult.field_77994_a == 0) {
                    craftResult.field_77994_a = 1;
                }
                if (itemCount != true) break block21;
                if (!(finalDecay > 0.0f)) break block20;
                for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack stack = player.field_71071_by.func_70301_a(i);
                    if (stack == null || !(stack.func_77973_b() instanceof ItemKnife)) continue;
                    stack.func_77972_a(1, (EntityLivingBase)player);
                    if (stack.func_77960_j() >= stack.func_77958_k()) {
                        player.field_71071_by.func_70299_a(i, null);
                    }
                    break block20;
                }
                break block20;
            }
            for (i = 0; i < craftingInv.func_70302_i_(); ++i) {
                ItemStack itemstack = craftingInv.func_70301_a(i);
                if (itemstack == null) continue;
                boolean fullInv = FoodCraftingHandler.isInvFull(player);
                if (itemstack.func_77973_b() instanceof ItemKnife && fullInv && !preCrafted) {
                    ++itemstack.field_77994_a;
                    if (itemstack.field_77994_a > 2) {
                        itemstack.field_77994_a = 2;
                    }
                }
                if (!(itemstack.func_77973_b() instanceof ItemKnife) || fullInv && preCrafted) continue;
                if (finalDecay > 0.0f) {
                    FoodCraftingHandler.damageItem(player, craftingInv, i, itemstack.func_77973_b());
                    continue;
                }
                if (!(finalDecay <= 0.0f)) continue;
                if (finalWeight / 2.0f < 1.0f) {
                    ++itemstack.field_77994_a;
                    if (itemstack.field_77994_a <= 2) continue;
                    itemstack.field_77994_a = 2;
                    continue;
                }
                FoodCraftingHandler.damageItem(player, craftingInv, i, itemstack.func_77973_b());
                Food.setWeight(craftingInv.func_70301_a(foodSlot), Helper.roundNumber(finalWeight / 2.0f, 100.0f));
                ++craftingInv.func_70301_a((int)foodSlot).field_77994_a;
                if (craftingInv.func_70301_a((int)foodSlot).field_77994_a <= 2) continue;
                craftingInv.func_70301_a((int)foodSlot).field_77994_a = 2;
            }
        }
        return craftResult;
    }

    public static void updateOutput(EntityPlayer player, ItemStack craftResult, IInventory craftingInv) {
        int i;
        float finalWeight = 0.0f;
        float finalDecay = 0.0f;
        int sweetMod = -1;
        int sourMod = -1;
        int saltyMod = -1;
        int bitterMod = -1;
        int umamiMod = -1;
        int[] fuelTasteProfile = new int[]{0, 0, 0, 0, 0};
        int[] cookedTasteProfile = new int[]{0, 0, 0, 0, 0};
        float cookedTime = 0.0f;
        String infusion = null;
        boolean salted = true;
        boolean pickled = true;
        boolean brined = true;
        boolean dried = true;
        short driedAmt = 0;
        int foodCount = 0;
        int itemCount = 0;
        for (i = 0; i < craftingInv.func_70302_i_(); ++i) {
            float inputWeight;
            if (craftingInv.func_70301_a(i) == null) continue;
            ++itemCount;
            ItemStack is = craftingInv.func_70301_a(i);
            if (!(is.func_77973_b() instanceof ItemFoodTFC) || !is.func_77942_o() || !is.func_77978_p().func_74764_b("foodWeight")) continue;
            if (foodCount == 0) {
                fuelTasteProfile = Food.getFuelProfile(is);
                cookedTasteProfile = Food.getCookedProfile(is);
                cookedTime = Food.getCooked(is);
                infusion = Food.getInfusion(is);
                driedAmt = Food.getDried(is);
            }
            if (sweetMod == -1) {
                sweetMod = Food.getSweetMod(is);
            } else if (sweetMod != Food.getSweetMod(is)) {
                sweetMod = 0;
            }
            if (sourMod == -1) {
                sourMod = Food.getSourMod(is);
            } else if (sourMod != Food.getSourMod(is)) {
                sourMod = 0;
            }
            if (saltyMod == -1) {
                saltyMod = Food.getSaltyMod(is);
            } else if (saltyMod != Food.getSaltyMod(is)) {
                saltyMod = 0;
            }
            if (bitterMod == -1) {
                bitterMod = Food.getBitterMod(is);
            } else if (bitterMod != Food.getBitterMod(is)) {
                bitterMod = 0;
            }
            if (umamiMod == -1) {
                umamiMod = Food.getSavoryMod(is);
            } else if (umamiMod != Food.getSavoryMod(is)) {
                umamiMod = 0;
            }
            float oldInputWeight = inputWeight = Food.getWeight(is);
            float inputDecayPercent = Food.getDecay(is) / oldInputWeight;
            float inputDecay = Food.getDecay(is);
            float weightChange = 0.0f;
            salted = salted && Food.isSalted(is);
            pickled = pickled && Food.isPickled(is);
            brined = brined && Food.isBrined(is);
            boolean bl = dried = dried && Food.isDried(is);
            if (finalWeight < 160.0f && Food.isSameSmoked(cookedTasteProfile, Food.getCookedProfile(is)) && Food.isSameSmoked(fuelTasteProfile, Food.getFuelProfile(is)) && ((int)Food.getCooked(is) - 600) / 120 == ((int)cookedTime - 600) / 120) {
                weightChange = Math.min(160.0f - finalWeight, inputWeight);
                inputWeight -= weightChange;
                finalWeight += weightChange;
            }
            if (inputWeight == oldInputWeight) continue;
            if (inputWeight == 0.0f) {
                if (finalDecay < 0.0f) {
                    if (inputDecay > finalDecay) {
                        finalDecay = inputDecay;
                    }
                } else {
                    finalDecay += inputDecay;
                }
            } else {
                float decayChange = weightChange * inputDecayPercent;
                inputDecay -= decayChange;
                if (finalDecay < 0.0f) {
                    if (decayChange > finalDecay) {
                        finalDecay = decayChange;
                    }
                } else {
                    finalDecay += decayChange;
                }
            }
            ++foodCount;
        }
        if (itemCount == 1) {
            if (finalDecay > 0.0f) {
                for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    if (player.field_71071_by.func_70301_a(i) == null || !(player.field_71071_by.func_70301_a(i).func_77973_b() instanceof ItemKnife)) continue;
                    finalWeight -= finalDecay;
                    finalDecay = 0.0f;
                    break;
                }
            }
        } else {
            for (i = 0; i < craftingInv.func_70302_i_(); ++i) {
                float doughWeight;
                ItemStack inputStack = craftingInv.func_70301_a(i);
                if (inputStack == null) continue;
                if (inputStack.func_77973_b() == TFCItems.powder && inputStack.func_77960_j() == 9) {
                    salted = true;
                    continue;
                }
                if (inputStack.func_77973_b() instanceof ItemKnife) {
                    if (finalDecay > 0.0f) {
                        finalWeight -= finalDecay;
                        finalDecay = 0.0f;
                        continue;
                    }
                    if (!(finalDecay <= 0.0f) || FoodCraftingHandler.refiningGrain(craftResult, craftingInv) || !(finalWeight / 2.0f >= 1.0f)) continue;
                    finalWeight /= 2.0f;
                    continue;
                }
                if (!FoodCraftingHandler.makingDough(craftResult, craftingInv) || !(inputStack.func_77973_b() instanceof IFood)) continue;
                float grainWeight = Food.getWeight(inputStack);
                float grainDecay = Food.getDecay(inputStack);
                if (grainDecay >= 0.0f) {
                    grainWeight -= grainDecay;
                }
                finalWeight = doughWeight = Math.min(grainWeight, 80.0f) * 2.0f;
                finalDecay = 0.0f;
            }
        }
        craftResult = ItemFoodTFC.createTag(craftResult, Helper.roundNumber(finalWeight, 100.0f), Helper.roundNumber(finalDecay, 100.0f));
        if (sweetMod != 0) {
            Food.setSweetMod(craftResult, sweetMod);
        }
        if (sourMod != 0) {
            Food.setSourMod(craftResult, sourMod);
        }
        if (saltyMod != 0) {
            Food.setSaltyMod(craftResult, saltyMod);
        }
        if (bitterMod != 0) {
            Food.setBitterMod(craftResult, bitterMod);
        }
        if (umamiMod != 0) {
            Food.setSavoryMod(craftResult, umamiMod);
        }
        if (cookedTime > 0.0f) {
            Food.setCooked(craftResult, cookedTime);
        }
        for (int fuelTaste : fuelTasteProfile) {
            if (fuelTaste <= 0) continue;
            Food.setFuelProfile(craftResult, fuelTasteProfile);
            break;
        }
        for (int cookedTaste : cookedTasteProfile) {
            if (cookedTaste <= 0) continue;
            Food.setCookedProfile(craftResult, cookedTasteProfile);
            break;
        }
        if (salted) {
            Food.setSalted(craftResult, salted);
        }
        if (pickled) {
            Food.setPickled(craftResult, pickled);
        }
        if (brined) {
            Food.setBrined(craftResult, brined);
        }
        if (dried) {
            Food.setDried(craftResult, 4);
        } else if (driedAmt > 0) {
            Food.setDried(craftResult, driedAmt);
        }
        if (infusion != null) {
            Food.setInfusion(craftResult, infusion);
        }
        if (craftResult.field_77994_a == 0) {
            craftResult.field_77994_a = 1;
        }
    }

    public static boolean refiningGrain(ItemStack craftResult, IInventory iinventory) {
        return craftResult.func_77973_b() == TFCItems.wheatGrain && FoodCraftingHandler.gridHasItem(iinventory, TFCItems.wheatWhole) || craftResult.func_77973_b() == TFCItems.ryeGrain && FoodCraftingHandler.gridHasItem(iinventory, TFCItems.ryeWhole) || craftResult.func_77973_b() == TFCItems.oatGrain && FoodCraftingHandler.gridHasItem(iinventory, TFCItems.oatWhole) || craftResult.func_77973_b() == TFCItems.barleyGrain && FoodCraftingHandler.gridHasItem(iinventory, TFCItems.barleyWhole) || craftResult.func_77973_b() == TFCItems.riceGrain && FoodCraftingHandler.gridHasItem(iinventory, TFCItems.riceWhole);
    }

    public static boolean makingDough(ItemStack craftResult, IInventory iinventory) {
        return !(craftResult.func_77973_b() != TFCItems.wheatDough && craftResult.func_77973_b() != TFCItems.ryeDough && craftResult.func_77973_b() != TFCItems.oatDough && craftResult.func_77973_b() != TFCItems.barleyDough && craftResult.func_77973_b() != TFCItems.cornmealDough && craftResult.func_77973_b() != TFCItems.riceDough || !FoodCraftingHandler.gridHasItem(iinventory, TFCItems.woodenBucketWater) && !FoodCraftingHandler.gridHasItem(iinventory, TFCItems.redSteelBucketWater));
    }

    public static boolean isInvFull(EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            if (player.field_71071_by.field_70462_a[i] != null) continue;
            return false;
        }
        return true;
    }

    public static void preCraft(EntityPlayer player, ItemStack craftResult, IInventory craftingInv) {
        preCrafted = true;
        if (FoodCraftingHandler.refiningGrain(craftResult, craftingInv)) {
            List knives = OreDictionary.getOres((String)"itemKnife", (boolean)false);
            FoodCraftingHandler.handleItem(player, craftingInv, knives);
            for (int i = 0; i < craftingInv.func_70302_i_(); ++i) {
                ItemStack inputStack = craftingInv.func_70301_a(i);
                if (inputStack == null || !(inputStack.func_77973_b() instanceof IFood)) continue;
                float foodWeight = Food.getWeight(inputStack);
                int strawCount = 0;
                int j = 0;
                while ((float)j < foodWeight) {
                    ++strawCount;
                    j += 4;
                }
                TFC_Core.giveItemToPlayer(new ItemStack(TFCItems.straw, strawCount), player);
            }
        } else if (FoodCraftingHandler.makingDough(craftResult, craftingInv)) {
            for (int i = 0; i < craftingInv.func_70302_i_(); ++i) {
                ItemStack inputStack = craftingInv.func_70301_a(i);
                if (inputStack == null || !(inputStack.func_77973_b() instanceof IFood)) continue;
                float grainWeight = Food.getWeight(inputStack);
                float grainDecay = Food.getDecay(inputStack);
                if (grainDecay >= 0.0f) {
                    grainWeight -= grainDecay;
                }
                float doughWeight = Math.min(grainWeight, 80.0f);
                inputStack = ItemFoodTFC.createTag(inputStack, Helper.roundNumber(grainWeight -= doughWeight, 100.0f), 0.0f);
                if (!(grainWeight > 0.0f)) continue;
                ++inputStack.field_77994_a;
            }
        } else if (craftResult.func_77942_o() && craftResult.func_77978_p().func_74764_b("foodWeight")) {
            craftResult = FoodCraftingHandler.processFoodInput(player, craftResult, craftingInv);
        }
    }

    public static boolean gridHasItem(IInventory iinventory, Item id) {
        for (int i = 0; i < iinventory.func_70302_i_(); ++i) {
            if (iinventory.func_70301_a(i) == null || iinventory.func_70301_a(i).func_77973_b() != id) continue;
            return true;
        }
        return false;
    }

    public static void handleItem(EntityPlayer entityplayer, IInventory iinventory, Item[] items) {
        for (int i = 0; i < iinventory.func_70302_i_(); ++i) {
            if (iinventory.func_70301_a(i) == null) continue;
            for (int j = 0; j < items.length; ++j) {
                FoodCraftingHandler.damageItem(entityplayer, iinventory, i, items[j]);
            }
        }
    }

    public static void handleItem(EntityPlayer entityplayer, IInventory iinventory, List<ItemStack> items) {
        for (int i = 0; i < iinventory.func_70302_i_(); ++i) {
            if (iinventory.func_70301_a(i) == null) continue;
            for (ItemStack is : items) {
                FoodCraftingHandler.damageItem(entityplayer, iinventory, i, is.func_77973_b());
            }
        }
    }

    public static void damageItem(EntityPlayer entityplayer, IInventory iinventory, int i, Item item) {
        int index;
        ItemStack is;
        if (iinventory.func_70301_a(i).func_77973_b() == item && (is = iinventory.func_70301_a(index = i).func_77946_l()) != null) {
            is.func_77972_a(1, (EntityLivingBase)entityplayer);
            if (is.func_77960_j() != 0 || entityplayer.field_71075_bZ.field_75098_d) {
                iinventory.func_70299_a(index, is);
                ++iinventory.func_70301_a((int)index).field_77994_a;
                if (iinventory.func_70301_a((int)index).field_77994_a > 2) {
                    iinventory.func_70301_a((int)index).field_77994_a = 2;
                }
            }
        }
    }
}

