/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.Handlers.Network;

import com.bioxx.tfc.Core.Config.SyncingOption;
import com.bioxx.tfc.Core.Config.TFC_ConfigFiles;
import com.bioxx.tfc.Handlers.Network.AbstractPacket;
import com.bioxx.tfc.TerraFirmaCraft;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;

public class ConfigSyncPacket
extends AbstractPacket {
    private Map<String, Boolean> map;

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(TFC_ConfigFiles.SYNCING_OPTION_MAP.size());
        for (SyncingOption option : TFC_ConfigFiles.SYNCING_OPTION_MAP.values()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)option.name);
            buffer.writeBoolean(option.inConfig());
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        int size = buffer.readInt();
        this.map = new HashMap<String, Boolean>(size);
        for (int i = 0; i < size; ++i) {
            this.map.put(ByteBufUtils.readUTF8String((ByteBuf)buffer), buffer.readBoolean());
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        if (this.map == null) {
            throw new IllegalStateException("Packet was not decoded");
        }
        TerraFirmaCraft.LOG.info("Applying server TFCCrafting settings");
        try {
            for (Map.Entry<String, Boolean> entry : this.map.entrySet()) {
                TFC_ConfigFiles.SYNCING_OPTION_MAP.get(entry.getKey()).apply(entry.getValue());
            }
        }
        catch (IllegalAccessException e) {
            TerraFirmaCraft.LOG.fatal("Error loading TFCCrafting settings from server!", (Throwable)e);
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

