/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.Handlers.Network;

import com.bioxx.tfc.Core.Player.FoodStatsTFC;
import com.bioxx.tfc.Core.Player.PlayerInventory;
import com.bioxx.tfc.Core.Player.SkillStats;
import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.Handlers.Network.AbstractPacket;
import com.bioxx.tfc.TerraFirmaCraft;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class PlayerUpdatePacket
extends AbstractPacket {
    private byte flag;
    private float stomachLevel;
    private float waterLevel;
    private long soberTime;
    private float nutrFruit;
    private float nutrVeg;
    private float nutrGrain;
    private float nutrProtein;
    private float nutrDairy;
    private SkillStats playerSkills;
    private String skillName;
    private int skillLevel;
    private boolean craftingTable;
    private Map<String, Integer> skillMap = new HashMap<String, Integer>();

    public PlayerUpdatePacket() {
    }

    public PlayerUpdatePacket(EntityPlayer p, int f) {
        this.flag = (byte)f;
        if (this.flag == 0) {
            FoodStatsTFC fs = TFC_Core.getPlayerFoodStats(p);
            this.stomachLevel = fs.stomachLevel;
            this.waterLevel = fs.waterLevel;
            this.soberTime = fs.soberTime;
            this.nutrFruit = fs.nutrFruit;
            this.nutrVeg = fs.nutrVeg;
            this.nutrGrain = fs.nutrGrain;
            this.nutrProtein = fs.nutrProtein;
            this.nutrDairy = fs.nutrDairy;
        } else if (this.flag == 2) {
            this.craftingTable = p.getEntityData().func_74767_n("craftingTable");
        } else if (this.flag == 3) {
            this.playerSkills = TFC_Core.getSkillStats(p);
        }
    }

    public PlayerUpdatePacket(int f, String name, int lvl) {
        this.flag = (byte)f;
        if (this.flag == 1) {
            this.skillName = name;
            this.skillLevel = lvl;
        }
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeByte((int)this.flag);
        if (this.flag == 0) {
            buffer.writeFloat(this.stomachLevel);
            buffer.writeFloat(this.waterLevel);
            buffer.writeLong(this.soberTime);
            buffer.writeFloat(this.nutrFruit);
            buffer.writeFloat(this.nutrVeg);
            buffer.writeFloat(this.nutrGrain);
            buffer.writeFloat(this.nutrProtein);
            buffer.writeFloat(this.nutrDairy);
        } else if (this.flag == 1) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.skillName);
            buffer.writeInt(this.skillLevel);
        } else if (this.flag == 2) {
            buffer.writeBoolean(this.craftingTable);
        } else if (this.flag == 3) {
            this.playerSkills.toOutBuffer(buffer);
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.flag = buffer.readByte();
        if (this.flag == 0) {
            this.stomachLevel = buffer.readFloat();
            this.waterLevel = buffer.readFloat();
            this.soberTime = buffer.readLong();
            this.nutrFruit = buffer.readFloat();
            this.nutrVeg = buffer.readFloat();
            this.nutrGrain = buffer.readFloat();
            this.nutrProtein = buffer.readFloat();
            this.nutrDairy = buffer.readFloat();
        } else if (this.flag == 1) {
            this.skillName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
            this.skillLevel = buffer.readInt();
        } else if (this.flag == 2) {
            this.craftingTable = buffer.readBoolean();
        } else if (this.flag == 3) {
            this.skillMap.clear();
            int size = buffer.readInt();
            for (int l = 0; l < size; ++l) {
                String name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
                int lvl = buffer.readInt();
                this.skillMap.put(name, lvl);
            }
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        if (this.flag == 0) {
            FoodStatsTFC fs = TFC_Core.getPlayerFoodStats(player);
            fs.stomachLevel = this.stomachLevel;
            fs.waterLevel = this.waterLevel;
            fs.soberTime = this.soberTime;
            fs.nutrFruit = this.nutrFruit;
            fs.nutrVeg = this.nutrVeg;
            fs.nutrGrain = this.nutrGrain;
            fs.nutrProtein = this.nutrProtein;
            fs.nutrDairy = this.nutrDairy;
            TFC_Core.setPlayerFoodStats(player, fs);
        } else if (this.flag == 1) {
            this.playerSkills = TFC_Core.getSkillStats(player);
            this.playerSkills.setSkillSave(this.skillName, this.skillLevel);
        } else if (this.flag == 2) {
            if (this.craftingTable && !player.getEntityData().func_74764_b("craftingTable")) {
                player.getEntityData().func_74757_a("craftingTable", this.craftingTable);
                PlayerInventory.upgradePlayerCrafting(player);
            }
        } else if (this.flag == 3) {
            this.playerSkills = TFC_Core.getSkillStats(player);
            for (String skill : this.skillMap.keySet()) {
                this.playerSkills.setSkillSave(skill, this.skillMap.get(skill));
            }
            this.skillMap.clear();
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        if (this.flag == 4) {
            PlayerUpdatePacket pkt = new PlayerUpdatePacket(player, 3);
            TerraFirmaCraft.PACKET_PIPELINE.sendTo(pkt, (EntityPlayerMP)player);
        }
    }
}

