/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.Items.ItemBlocks;

import com.bioxx.tfc.Core.Metal.Alloy;
import com.bioxx.tfc.Core.Metal.AlloyManager;
import com.bioxx.tfc.Core.Metal.AlloyMetal;
import com.bioxx.tfc.Core.Metal.MetalPair;
import com.bioxx.tfc.Core.Metal.MetalRegistry;
import com.bioxx.tfc.Items.ItemBlocks.ItemTerraBlock;
import com.bioxx.tfc.Items.ItemTerra;
import com.bioxx.tfc.api.Constant.Global;
import com.bioxx.tfc.api.Enums.EnumSize;
import com.bioxx.tfc.api.Enums.EnumWeight;
import com.bioxx.tfc.api.Interfaces.ISize;
import com.bioxx.tfc.api.Metal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;

public class ItemCrucible
extends ItemTerraBlock
implements ISize {
    public Map<String, MetalPair> metals = new HashMap<String, MetalPair>();
    private Alloy currentAlloy;

    public ItemCrucible(Block par1) {
        super(par1);
    }

    @Override
    public void func_77624_a(ItemStack is, EntityPlayer player, List arraylist, boolean flag) {
        ItemTerra.addSizeInformation(is, arraylist);
        this.readFromItemNBT(is.func_77978_p(), arraylist);
    }

    public void readFromItemNBT(NBTTagCompound nbt, List<String> arraylist) {
        this.currentAlloy = null;
        this.metals = new HashMap<String, MetalPair>();
        if (nbt != null && nbt.func_74764_b("Metals")) {
            NBTTagList nbttaglist = nbt.func_150295_c("Metals", 9);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                int id = nbttagcompound1.func_74762_e("ID");
                float amount = nbttagcompound1.func_74760_g("AmountF");
                Metal m = MetalRegistry.instance.getMetalFromItem(Item.func_150899_d((int)id));
                this.addMetal(m, amount);
            }
        }
        if (this.currentAlloy != null) {
            for (int c = 0; c < this.currentAlloy.alloyIngred.size(); ++c) {
                double m = this.currentAlloy.alloyIngred.get((int)c).metal;
                m = (double)Math.round(m * 100.0) / 100.0;
                if (this.currentAlloy.alloyIngred.get((int)c).metalType == null) continue;
                arraylist.add(EnumChatFormatting.DARK_GRAY + this.currentAlloy.alloyIngred.get((int)c).metalType.name + " " + EnumChatFormatting.DARK_GREEN + m + "%");
            }
        }
    }

    public boolean addMetal(Metal m, float amt) {
        if (this.getTotalMetal() + amt <= 3000.0f && !"Unknown".equals(m.name)) {
            if (this.metals.containsKey(m.name)) {
                this.metals.get((Object)m.name).amount += amt;
            } else {
                this.metals.put(m.name, new MetalPair(m, amt));
            }
            this.updateCurrentAlloy();
            return true;
        }
        return false;
    }

    public float getTotalMetal() {
        Iterator<MetalPair> iter = this.metals.values().iterator();
        float totalAmount = 0.0f;
        while (iter.hasNext()) {
            MetalPair m = iter.next();
            if (m == null) continue;
            totalAmount += m.amount;
        }
        return totalAmount;
    }

    private void updateCurrentAlloy() {
        ArrayList<AlloyMetal> a = new ArrayList<AlloyMetal>();
        Iterator<MetalPair> iter = this.metals.values().iterator();
        float totalAmount = this.getTotalMetal();
        for (MetalPair m : this.metals.values()) {
            if (m == null) continue;
            a.add(new AlloyMetal(m.type, m.amount / totalAmount * 100.0f));
        }
        Metal match = AlloyManager.INSTANCE.matchesAlloy(a, Alloy.EnumTier.TierV);
        if (match != null) {
            this.currentAlloy = new Alloy(match, totalAmount);
            this.currentAlloy.alloyIngred = a;
        } else {
            this.currentAlloy = new Alloy(Global.UNKNOWN, totalAmount);
            this.currentAlloy.alloyIngred = a;
        }
    }

    @Override
    public EnumSize getSize(ItemStack is) {
        return EnumSize.HUGE;
    }

    @Override
    public boolean canStack() {
        return false;
    }

    @Override
    public EnumWeight getWeight(ItemStack is) {
        return EnumWeight.HEAVY;
    }
}

