/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.Items.Tools;

import com.bioxx.tfc.Blocks.Terrain.BlockOre;
import com.bioxx.tfc.Core.Player.SkillStats;
import com.bioxx.tfc.Core.TFCTabs;
import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.Core.TFC_Textures;
import com.bioxx.tfc.Items.ItemTerra;
import com.bioxx.tfc.Items.Tools.ItemTerraTool;
import com.bioxx.tfc.TileEntities.TEOre;
import com.bioxx.tfc.WorldGen.Generators.OreSpawnData;
import com.bioxx.tfc.WorldGen.Generators.WorldGenOre;
import com.bioxx.tfc.api.Constant.Global;
import com.bioxx.tfc.api.Crafting.AnvilManager;
import com.bioxx.tfc.api.Enums.EnumItemReach;
import com.bioxx.tfc.api.Enums.EnumSize;
import com.bioxx.tfc.api.Enums.EnumWeight;
import com.bioxx.tfc.api.TFCBlocks;
import com.bioxx.tfc.api.TFCItems;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class ItemProPick
extends ItemTerra {
    private Map<String, ProspectResult> results = new HashMap<String, ProspectResult>();
    private Random random;

    public ItemProPick() {
        this.field_77777_bU = 1;
        this.func_77637_a(TFCTabs.TFC_TOOLS);
        this.setWeight(EnumWeight.LIGHT);
        this.setSize(EnumSize.SMALL);
    }

    @Override
    public void func_94581_a(IIconRegister registerer) {
        this.field_77791_bV = registerer.func_94245_a("terrafirmacraft:tools/" + this.func_77658_a().replace("item.", ""));
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (pass == 1 && nbt != null && nbt.func_74764_b("broken")) {
            return TFC_Textures.brokenItem;
        }
        return this.func_77618_c(stack.func_77960_j(), pass);
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block block = world.func_147439_a(x, y, z);
        if (!world.field_72995_K) {
            if (block == TFCBlocks.toolRack) {
                return true;
            }
            int meta = world.func_72805_g(x, y, z);
            SkillStats.SkillRank rank = TFC_Core.getSkillStats(player).getSkillRank("skill.prospecting");
            if ((block == TFCBlocks.ore || block == TFCBlocks.ore2 || block == TFCBlocks.ore3) && world.func_147438_o(x, y, z) instanceof TEOre) {
                TEOre te = (TEOre)world.func_147438_o(x, y, z);
                if (block == TFCBlocks.ore && rank == SkillStats.SkillRank.Master) {
                    meta = ((BlockOre)block).getOreGrade(te, meta);
                }
                if (block == TFCBlocks.ore2) {
                    meta += Global.ORE_METAL.length;
                }
                if (block == TFCBlocks.ore3) {
                    meta = meta + Global.ORE_METAL.length + Global.ORE_MINERAL.length;
                }
                this.tellResult(player, new ItemStack(TFCItems.oreChunk, 1, meta));
                return true;
            }
            if (!TFC_Core.isGround(block)) {
                for (OreSpawnData osd : WorldGenOre.oreList.values()) {
                    if (osd == null || block != osd.block) continue;
                    this.tellResult(player, new ItemStack(block));
                    return true;
                }
            }
            this.random = new Random(x * z + y);
            int chance = 60 + (rank.ordinal() + 1) * 10;
            this.results.clear();
            if (this.random.nextInt(100) >= chance && rank != SkillStats.SkillRank.Master) {
                this.tellNothingFound(player);
                return true;
            }
            this.results.clear();
            for (int i = -12; i < 12; ++i) {
                for (int j = -12; j < 12; ++j) {
                    for (int k = -12; k < 12; ++k) {
                        int blockX = x + i;
                        int blockY = y + j;
                        int blockZ = z + k;
                        block = world.func_147439_a(blockX, blockY, blockZ);
                        meta = world.func_72805_g(blockX, blockY, blockZ);
                        ItemStack ore = null;
                        if (block == TFCBlocks.ore && world.func_147438_o(blockX, blockY, blockZ) instanceof TEOre) {
                            TEOre te = (TEOre)world.func_147438_o(blockX, blockY, blockZ);
                            ore = rank == SkillStats.SkillRank.Master ? new ItemStack(TFCItems.oreChunk, 1, ((BlockOre)block).getOreGrade(te, meta)) : new ItemStack(TFCItems.oreChunk, 1, meta);
                        } else if (block == TFCBlocks.ore2) {
                            ore = new ItemStack(TFCItems.oreChunk, 1, meta + Global.ORE_METAL.length);
                        } else if (block == TFCBlocks.ore3) {
                            ore = new ItemStack(TFCItems.oreChunk, 1, meta + Global.ORE_METAL.length + Global.ORE_MINERAL.length);
                        } else {
                            if (TFC_Core.isGround(block)) continue;
                            for (OreSpawnData osd : WorldGenOre.oreList.values()) {
                                if (osd == null || block != osd.block) continue;
                                ore = new ItemStack(block);
                                break;
                            }
                        }
                        if (ore == null) continue;
                        String oreName = ore.func_82833_r();
                        if (this.results.containsKey(oreName)) {
                            ++this.results.get((Object)oreName).count;
                        } else {
                            this.results.put(oreName, new ProspectResult(ore, 1));
                        }
                        ore = null;
                        oreName = null;
                    }
                }
            }
            if (this.results.isEmpty()) {
                this.tellNothingFound(player);
            } else {
                this.tellResult(player);
            }
            this.results.clear();
            this.random = null;
            itemStack.func_77972_a(1, (EntityLivingBase)player);
            if (itemStack.func_77960_j() >= itemStack.func_77958_k()) {
                player.func_71028_bD();
            }
        }
        return true;
    }

    private void tellNothingFound(EntityPlayer player) {
        TFC_Core.sendInfoMessage(player, (IChatComponent)new ChatComponentTranslation("gui.ProPick.FoundNothing", new Object[0]));
    }

    private void tellResult(EntityPlayer player, ItemStack ore) {
        String oreName = ore.func_77977_a() + ".name";
        TFC_Core.sendInfoMessage(player, new ChatComponentTranslation("gui.ProPick.Found", new Object[0]).func_150258_a(" ").func_150257_a((IChatComponent)new ChatComponentTranslation(oreName, new Object[0])));
    }

    private void tellResult(EntityPlayer player) {
        TFC_Core.getSkillStats(player).increaseSkill("skill.prospecting", 1);
        int index = this.random.nextInt(this.results.size());
        ProspectResult result = this.results.values().toArray(new ProspectResult[0])[index];
        String oreName = result.itemStack.func_77977_a() + ".name";
        String quantityMsg = result.count < 10 ? "gui.ProPick.FoundTraces" : (result.count < 20 ? "gui.ProPick.FoundSmall" : (result.count < 40 ? "gui.ProPick.FoundMedium" : (result.count < 80 ? "gui.ProPick.FoundLarge" : "gui.ProPick.FoundVeryLarge")));
        TFC_Core.sendInfoMessage(player, new ChatComponentTranslation(quantityMsg, new Object[0]).func_150258_a(" ").func_150257_a((IChatComponent)new ChatComponentTranslation(oreName, new Object[0])));
        oreName = null;
        result = null;
    }

    @Override
    public boolean canStack() {
        return false;
    }

    @Override
    public EnumItemReach getReach(ItemStack is) {
        return EnumItemReach.SHORT;
    }

    public int getMaxDamage(ItemStack stack) {
        return (int)((float)this.func_77612_l() + (float)this.func_77612_l() * AnvilManager.getDurabilityBuff(stack));
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        float digSpeed = super.getDigSpeed(stack, block, meta);
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta)) {
            return digSpeed + digSpeed * AnvilManager.getDurabilityBuff(stack);
        }
        return digSpeed;
    }

    @Override
    public void func_77624_a(ItemStack is, EntityPlayer player, List arraylist, boolean flag) {
        ItemTerra.addSizeInformation(is, arraylist);
        ItemTerraTool.addSmithingBonusInformation(is, arraylist);
    }

    private class ProspectResult {
        public ItemStack itemStack;
        public int count;

        public ProspectResult(ItemStack itemStack, int count) {
            this.itemStack = itemStack;
            this.count = count;
        }
    }
}

