/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.TileEntities;

import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.Core.TFC_Time;
import com.bioxx.tfc.Food.ItemFoodTFC;
import com.bioxx.tfc.Items.Tools.ItemCustomBucketMilk;
import com.bioxx.tfc.TerraFirmaCraft;
import com.bioxx.tfc.TileEntities.NetworkTileEntity;
import com.bioxx.tfc.api.Crafting.BarrelAlcoholRecipe;
import com.bioxx.tfc.api.Crafting.BarrelBriningRecipe;
import com.bioxx.tfc.api.Crafting.BarrelLiquidToLiquidRecipe;
import com.bioxx.tfc.api.Crafting.BarrelManager;
import com.bioxx.tfc.api.Crafting.BarrelMultiItemRecipe;
import com.bioxx.tfc.api.Crafting.BarrelPreservativeRecipe;
import com.bioxx.tfc.api.Crafting.BarrelRecipe;
import com.bioxx.tfc.api.Crafting.BarrelVinegarRecipe;
import com.bioxx.tfc.api.Enums.EnumFoodGroup;
import com.bioxx.tfc.api.Food;
import com.bioxx.tfc.api.Interfaces.IFood;
import com.bioxx.tfc.api.TFCBlocks;
import com.bioxx.tfc.api.TFCFluids;
import com.bioxx.tfc.api.TFCItems;
import com.bioxx.tfc.api.TFC_ItemHeat;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import java.util.Stack;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class TEBarrel
extends NetworkTileEntity
implements IInventory {
    public FluidStack fluid;
    public byte rotation;
    public int barrelType;
    public int mode;
    public ItemStack[] storage = new ItemStack[12];
    private boolean sealed;
    public int sealtime;
    public int unsealtime;
    private int processTimer;
    public static final int MODE_IN = 0;
    public static final int MODE_OUT = 1;
    public static final int INPUT_SLOT = 0;
    public BarrelRecipe recipe;
    public boolean shouldDropItem = true;

    public boolean getSealed() {
        return this.sealed;
    }

    public int getTechLevel() {
        return 1;
    }

    public void clearInventory() {
        this.storage = new ItemStack[12];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public void setSealed() {
        this.sealed = true;
    }

    public void setUnsealed(String reason) {
        if ("killing fuse".equals(reason)) {
            this.sealed = false;
        }
    }

    public void func_70305_f() {
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.storage[i] != null) {
            if (this.storage[i].field_77994_a <= j) {
                ItemStack is = this.storage[i];
                this.storage[i] = null;
                return is;
            }
            ItemStack isSplit = this.storage[i].func_77979_a(j);
            if (this.storage[i].field_77994_a == 0) {
                this.storage[i] = null;
            }
            return isSplit;
        }
        return null;
    }

    public void ejectContents() {
        float f3 = 0.05f;
        Random rand = new Random();
        float f = rand.nextFloat() * 0.3f + 0.1f;
        float f1 = rand.nextFloat() * 2.0f + 0.4f;
        float f2 = rand.nextFloat() * 0.3f + 0.1f;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.storage[i] == null) continue;
            EntityItem entityitem = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + f), (double)((float)this.field_145848_d + f1), (double)((float)this.field_145849_e + f2), this.storage[i]);
            entityitem.field_70159_w = (float)rand.nextGaussian() * f3;
            entityitem.field_70181_x = (float)rand.nextGaussian() * f3 + 0.2f;
            entityitem.field_70179_y = (float)rand.nextGaussian() * f3;
            this.field_145850_b.func_72838_d((Entity)entityitem);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public String func_145825_b() {
        return "Barrel";
    }

    public int func_70302_i_() {
        return 12;
    }

    public ItemStack func_70301_a(int i) {
        return this.storage[i];
    }

    public ItemStack func_70304_b(int i) {
        return this.storage[i];
    }

    public int getInvCount() {
        int count = 0;
        for (ItemStack is : this.storage) {
            if (is == null) continue;
            ++count;
        }
        if (this.storage[0] != null && count == 1) {
            return 0;
        }
        return count;
    }

    public int getGunPowderCount() {
        int count = 0;
        for (ItemStack is : this.storage) {
            if (is == null || is.func_77973_b() != Items.field_151016_H) continue;
            count += is.field_77994_a;
        }
        return count;
    }

    public boolean canAcceptLiquids() {
        return this.getInvCount() == 0;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70299_a(int i, ItemStack is) {
        if (!ItemStack.func_77989_b((ItemStack)this.storage[i], (ItemStack)is)) {
            this.storage[i] = is;
            if (i == 0) {
                this.processItems();
                if (!this.getSealed()) {
                    this.unsealtime = (int)TFC_Time.getTotalHours();
                }
            }
        }
    }

    public int getFluidLevel() {
        if (this.fluid != null) {
            return this.fluid.amount;
        }
        return 0;
    }

    public ItemStack getInputStack() {
        return this.storage[0];
    }

    public FluidStack getFluidStack() {
        return this.fluid;
    }

    public int getMaxLiquid() {
        return 10000;
    }

    public boolean addLiquid(FluidStack inFS) {
        if (inFS != null) {
            if (inFS.getFluid() != null && inFS.getFluid().getTemperature(inFS) > 385) {
                return false;
            }
            if (this.fluid == null) {
                this.fluid = inFS.copy();
                if (this.fluid.amount > this.getMaxLiquid()) {
                    this.fluid.amount = this.getMaxLiquid();
                    inFS.amount -= this.getMaxLiquid();
                } else {
                    inFS.amount = 0;
                }
            } else {
                if (this.fluid.amount == this.getMaxLiquid() || !this.fluid.isFluidEqual(inFS)) {
                    return false;
                }
                int a = this.fluid.amount + inFS.amount - this.getMaxLiquid();
                this.fluid.amount = Math.min(this.fluid.amount + inFS.amount, this.getMaxLiquid());
                inFS.amount = a > 0 ? a : 0;
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    public ItemStack addLiquid(ItemStack is) {
        FluidStack isfs;
        if (is == null || is.field_77994_a > 1) {
            return is;
        }
        if (FluidContainerRegistry.isFilledContainer((ItemStack)is)) {
            FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)is);
            if (this.addLiquid(fs)) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return FluidContainerRegistry.drainFluidContainer((ItemStack)is);
            }
        } else if (is.func_77973_b() instanceof IFluidContainerItem && (isfs = ((IFluidContainerItem)is.func_77973_b()).getFluid(is)) != null && this.addLiquid(isfs)) {
            ((IFluidContainerItem)is.func_77973_b()).drain(is, is.func_77958_k(), true);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return is;
    }

    public ItemStack removeLiquid(ItemStack is) {
        FluidStack isfs;
        if (is == null || is.field_77994_a > 1) {
            return is;
        }
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)is)) {
            ItemStack out = FluidContainerRegistry.fillFluidContainer((FluidStack)this.fluid, (ItemStack)is);
            if (out != null) {
                FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)out);
                this.fluid.amount -= fs.amount;
                is = null;
                if (this.fluid.amount == 0) {
                    this.fluid = null;
                }
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return out;
            }
        } else if (this.fluid != null && is.func_77973_b() instanceof IFluidContainerItem && ((isfs = ((IFluidContainerItem)is.func_77973_b()).getFluid(is)) == null || this.fluid.isFluidEqual(isfs))) {
            this.fluid.amount -= ((IFluidContainerItem)is.func_77973_b()).fill(is, this.fluid, true);
            if (this.fluid.amount == 0) {
                this.fluid = null;
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return is;
    }

    public void drainLiquid(int amount) {
        if (!this.getSealed() && this.getFluidStack() != null) {
            this.getFluidStack().amount -= amount;
            if (this.getFluidStack().amount <= 0) {
                this.actionEmpty();
            } else {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public int getLiquidScaled(int i) {
        if (this.fluid != null) {
            return this.fluid.amount * i / this.getMaxLiquid();
        }
        return 0;
    }

    public boolean actionSeal(int tab, EntityPlayer player) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("seal", true);
        nbt.func_74774_a("tab", (byte)tab);
        nbt.func_74778_a("player", player.func_70005_c_());
        this.broadcastPacketInRange(this.createDataPacket(nbt));
        this.sealed = true;
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    public boolean actionUnSeal(int tab, EntityPlayer player) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("seal", false);
        nbt.func_74774_a("tab", (byte)tab);
        nbt.func_74778_a("player", player.func_70005_c_());
        this.broadcastPacketInRange(this.createDataPacket(nbt));
        this.sealed = false;
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    public void actionEmpty() {
        this.fluid = null;
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("fluidID", (byte)-1);
        this.broadcastPacketInRange(this.createDataPacket(nbt));
    }

    public void actionMode() {
        this.mode = this.mode == 0 ? 1 : 0;
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("mode", (byte)this.mode);
        this.broadcastPacketInRange(this.createDataPacket(nbt));
    }

    public void actionSwitchTab(int tab, EntityPlayer player) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("tab", (byte)tab);
        nbt.func_74778_a("player", player.func_70005_c_());
        this.broadcastPacketInRange(this.createDataPacket(nbt));
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("Sealed", this.sealed);
        nbt.func_74768_a("SealTime", this.sealtime);
        nbt.func_74768_a("barrelType", this.barrelType);
        NBTTagCompound fluidNBT = new NBTTagCompound();
        if (this.fluid != null) {
            this.fluid.writeToNBT(fluidNBT);
        }
        nbt.func_74782_a("fluidNBT", (NBTBase)fluidNBT);
        nbt.func_74774_a("rotation", this.rotation);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.storage.length; ++i) {
            if (this.storage[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.storage[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("fluidNBT"));
        this.sealed = nbt.func_74767_n("Sealed");
        this.sealtime = nbt.func_74762_e("SealTime");
        this.barrelType = nbt.func_74762_e("barrelType");
        this.rotation = nbt.func_74771_c("rotation");
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.storage = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.storage.length) continue;
            this.storage[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    public void readFromItemNBT(NBTTagCompound nbt) {
        this.barrelType = nbt.func_74762_e("barrelType");
        this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("fluidNBT"));
        this.sealed = nbt.func_74767_n("Sealed");
        this.sealtime = nbt.func_74762_e("SealTime");
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = nbttaglist.func_150305_b(i);
            byte byte0 = nbt1.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.storage.length) continue;
            this.func_70299_a(byte0, ItemStack.func_77949_a((NBTTagCompound)nbt1));
        }
    }

    public void updateGui() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void handleInitPacket(NBTTagCompound nbt) {
        this.rotation = nbt.func_74771_c("rotation");
        this.sealed = nbt.func_74767_n("sealed");
        this.sealtime = nbt.func_74762_e("SealTime");
        this.barrelType = nbt.func_74762_e("barrelType");
        if (nbt.func_74762_e("fluid") != -1) {
            if (this.fluid != null) {
                this.fluid.amount = nbt.func_74762_e("fluidAmount");
            } else {
                this.fluid = new FluidStack(nbt.func_74762_e("fluid"), nbt.func_74762_e("fluidAmount"));
            }
        } else {
            this.fluid = null;
        }
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void createInitNBT(NBTTagCompound nbt) {
        nbt.func_74774_a("rotation", this.rotation);
        nbt.func_74757_a("sealed", this.sealed);
        nbt.func_74768_a("SealTime", this.sealtime);
        nbt.func_74768_a("fluid", this.fluid != null ? this.fluid.getFluidID() : -1);
        nbt.func_74768_a("fluidAmount", this.fluid != null ? this.fluid.amount : 0);
        nbt.func_74768_a("barrelType", this.barrelType);
    }

    @Override
    public void handleDataPacket(NBTTagCompound nbt) {
        if (nbt.func_74764_b("fluidID")) {
            if (nbt.func_74771_c("fluidID") == -1) {
                this.fluid = null;
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (!this.field_145850_b.field_72995_K) {
            if (nbt.func_74764_b("mode")) {
                this.mode = nbt.func_74771_c("mode");
            } else if (nbt.func_74764_b("seal")) {
                this.sealed = nbt.func_74767_n("seal");
                if (!this.sealed) {
                    this.unsealtime = (int)TFC_Time.getTotalHours();
                    this.sealtime = 0;
                } else {
                    this.sealtime = (int)TFC_Time.getTotalHours();
                    this.unsealtime = 0;
                }
                NBTTagCompound timeTag = new NBTTagCompound();
                timeTag.func_74768_a("SealTime", this.sealtime);
                this.broadcastPacketInRange(this.createDataPacket(timeTag));
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (nbt.func_74764_b("tab")) {
                byte tab = nbt.func_74771_c("tab");
                this.switchTab(this.field_145850_b.func_72924_a(nbt.func_74779_i("player")), tab);
            }
        } else if (nbt.func_74764_b("SealTime")) {
            this.sealtime = nbt.func_74762_e("SealTime");
        }
    }

    protected void switchTab(EntityPlayer player, int tab) {
        if (player != null) {
            if (tab == 0) {
                player.openGui((Object)TerraFirmaCraft.instance, 35, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            } else if (tab == 1) {
                player.openGui((Object)TerraFirmaCraft.instance, 36, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int count;
            ItemStack itemstack = this.storage[0];
            BarrelPreservativeRecipe preservative = BarrelManager.getInstance().findMatchingPreservativeRepice(this, itemstack, this.fluid, this.sealed);
            if (itemstack != null && this.fluid != null && this.fluid.getFluid() == TFCFluids.FRESHWATER && TFC_ItemHeat.hasTemp(itemstack)) {
                float temp = TFC_ItemHeat.getTemp(itemstack);
                if (this.fluid.amount >= 1 && temp > 1.0f) {
                    --this.fluid.amount;
                    TFC_ItemHeat.setTemp(itemstack, temp -= 50.0f);
                    TFC_ItemHeat.handleItemHeat(itemstack);
                }
            }
            if (this.fluid != null && itemstack != null && itemstack.func_77973_b() instanceof IFood) {
                float w = Food.getWeight(itemstack);
                if (this.fluid.getFluid() == TFCFluids.VINEGAR && Food.isBrined(itemstack) && !Food.isPickled(itemstack) && w / (float)this.fluid.amount <= 160.0f / (float)this.getMaxLiquid() && this.getSealed() && this.sealtime != 0 && TFC_Time.getTotalHours() - (long)this.sealtime >= 4L) {
                    this.fluid.amount = (int)((float)this.fluid.amount - 1.0f * w);
                    Food.setPickled(itemstack, true);
                }
            }
            if (preservative == null) {
                TFC_Core.handleItemTicking(this, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            } else {
                float env = preservative.getEnvironmentalDecayFactor();
                float base = preservative.getBaseDecayModifier();
                if (Float.isNaN(env) || (double)env < 0.0) {
                    TFC_Core.handleItemTicking(this, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                } else if (Float.isNaN(base) || (double)base < 0.0) {
                    TFC_Core.handleItemTicking(this, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, env);
                } else {
                    TFC_Core.handleItemTicking(this, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, env, base);
                }
            }
            if (!this.getSealed() && TFC_Core.isExposedToRain(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e) && ((count = this.getInvCount()) == 0 || count == 1 && this.getInputStack() != null)) {
                if (this.fluid == null) {
                    this.fluid = new FluidStack(TFCFluids.FRESHWATER, 1);
                } else if (this.fluid != null && this.fluid.getFluid() == TFCFluids.FRESHWATER) {
                    this.fluid.amount = Math.min(this.fluid.amount + 1, this.getMaxLiquid());
                }
            }
            ++this.processTimer;
            if (this.processTimer > 100) {
                this.processItems();
                this.processTimer = 0;
            }
            if (this.getFluidLevel() > 0 && this.getInputStack() != null) {
                count = 1;
                while (this.getInputStack().field_77994_a > this.getInputStack().func_77976_d()) {
                    ItemStack is = this.getInputStack().func_77979_a(this.getInputStack().func_77976_d());
                    if (count < this.storage.length && this.func_70301_a(count) == null) {
                        this.func_70299_a(count, is);
                    } else {
                        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, is));
                    }
                    ++count;
                }
            } else if (this.getFluidLevel() > 0 && this.getInputStack() == null && this.getInvCount() > 0) {
                for (int i = 0; i < this.storage.length; ++i) {
                    if (this.storage[i] == null) continue;
                    this.storage[0] = this.storage[i].func_77946_l();
                    this.storage[i] = null;
                    break;
                }
            }
            if (this.fluid != null && this.fluid.amount == 0) {
                this.fluid = null;
            }
            if (this.mode == 0) {
                ItemStack container = this.getInputStack();
                FluidStack inLiquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)container);
                if (container != null && container.func_77973_b() instanceof IFluidContainerItem) {
                    FluidStack isfs = ((IFluidContainerItem)container.func_77973_b()).getFluid(container);
                    if (isfs != null && this.addLiquid(isfs)) {
                        ((IFluidContainerItem)container.func_77973_b()).drain(container, ((IFluidContainerItem)container.func_77973_b()).getCapacity(container), true);
                    }
                } else if (inLiquid != null && container != null && container.field_77994_a == 1 && this.addLiquid(inLiquid)) {
                    this.func_70299_a(0, FluidContainerRegistry.drainFluidContainer((ItemStack)container));
                }
            } else if (this.mode == 1) {
                ItemStack container = this.getInputStack();
                if (container != null && this.fluid != null && container.func_77973_b() instanceof IFluidContainerItem) {
                    FluidStack isfs = ((IFluidContainerItem)container.func_77973_b()).getFluid(container);
                    if (isfs == null || this.fluid.isFluidEqual(isfs)) {
                        this.fluid.amount -= ((IFluidContainerItem)container.func_77973_b()).fill(container, this.fluid, true);
                        if (this.fluid.amount == 0) {
                            this.fluid = null;
                        }
                    }
                } else if (FluidContainerRegistry.isEmptyContainer((ItemStack)container)) {
                    ItemStack fullContainer = this.removeLiquid(this.getInputStack());
                    if (fullContainer.func_77973_b() == TFCItems.woodenBucketMilk) {
                        ItemCustomBucketMilk.createTag(fullContainer, 20.0f);
                    }
                    this.func_70299_a(0, fullContainer);
                }
            }
        }
    }

    public void processItems() {
        if (this.getInvCount() == 0) {
            boolean isCheese = this.handleCheese();
            if (this.getFluidStack() != null && !isCheese) {
                this.recipe = BarrelManager.getInstance().findMatchingRecipe(this.getInputStack(), this.getFluidStack(), this.sealed, this.getTechLevel());
                if (this.recipe != null && !this.field_145850_b.field_72995_K) {
                    Stack<ItemStack> resultStacks;
                    FluidStack origFS;
                    int time = 0;
                    if (this.sealtime > 0) {
                        time = (int)TFC_Time.getTotalHours() - this.sealtime;
                    } else if (this.unsealtime > 0) {
                        time = (int)TFC_Time.getTotalHours() - this.unsealtime;
                    }
                    if (this.recipe.isSealedRecipe() && time < this.recipe.sealTime) {
                        return;
                    }
                    ItemStack origIS = this.getInputStack() != null ? this.getInputStack().func_77946_l() : null;
                    FluidStack fluidStack = origFS = this.getFluidStack() != null ? this.getFluidStack().copy() : null;
                    if (this.fluid.isFluidEqual(this.recipe.getResultFluid(origIS, origFS, time)) && this.recipe.removesLiquid) {
                        this.fluid.amount = this.fluid.getFluid() == TFCFluids.BRINE && origIS != null && origIS.func_77973_b() instanceof IFood ? (int)((float)this.fluid.amount - (float)this.recipe.getResultFluid((ItemStack)origIS, (FluidStack)origFS, (int)time).amount * Food.getWeight(origIS)) : (this.fluid.amount -= this.recipe.getResultFluid((ItemStack)origIS, (FluidStack)origFS, (int)time).amount);
                    } else {
                        this.fluid = this.recipe.getResultFluid(origIS, origFS, time).copy();
                        if (this.fluid != null && !(this.recipe instanceof BarrelLiquidToLiquidRecipe) && origFS != null) {
                            this.fluid.amount = origFS.amount;
                        }
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    if (origFS != null && origFS.getFluid() != TFCFluids.MILKCURDLED && this.fluid.getFluid() == TFCFluids.MILKCURDLED) {
                        this.sealtime = (int)TFC_Time.getTotalHours();
                    }
                    if (!(resultStacks = this.recipe.getResult(origIS, origFS, time)).isEmpty()) {
                        ItemStack result = resultStacks.pop();
                        if (this.fluid != null && this.fluid.getFluid() == TFCFluids.BRINE) {
                            if (result == null && origIS != null) {
                                result = origIS.func_77946_l();
                            }
                            if (result != null && result.func_77973_b() instanceof IFood && (result.func_77973_b() == TFCItems.cheese || ((IFood)result.func_77973_b()).getFoodGroup() != EnumFoodGroup.Grain) && !Food.isBrined(result)) {
                                Food.setBrined(result, true);
                            }
                        }
                        this.storage[0] = result;
                        for (int i = 1; i < this.storage.length; ++i) {
                            if (this.storage[i] != null || resultStacks.isEmpty()) continue;
                            this.func_70299_a(i, resultStacks.pop());
                        }
                        while (!resultStacks.isEmpty()) {
                            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, resultStacks.pop()));
                        }
                        this.func_70299_a(0, result);
                    }
                }
            } else if (this.getFluidStack() == null && !isCheese) {
                this.recipe = null;
            }
        }
    }

    private boolean handleCheese() {
        ItemStack inIS = this.getInputStack();
        if (this.getSealed() && this.fluid != null && this.fluid.getFluid() == TFCFluids.MILKCURDLED && (inIS == null || inIS.func_77973_b() instanceof IFood && ((IFood)inIS.func_77973_b()).getFoodGroup() != EnumFoodGroup.Dairy && ((IFood)inIS.func_77973_b()).isEdible(inIS) && Food.getWeight(inIS) <= 20.0f)) {
            this.recipe = new BarrelRecipe(null, new FluidStack(TFCFluids.MILKCURDLED, 10000), ItemFoodTFC.createTag(new ItemStack(TFCItems.cheese, 1), 160.0f), null).setMinTechLevel(0);
            if (!this.field_145850_b.field_72995_K) {
                int time = 0;
                if (this.sealtime > 0) {
                    time = (int)TFC_Time.getTotalHours() - this.sealtime;
                } else if (this.unsealtime > 0) {
                    time = (int)TFC_Time.getTotalHours() - this.unsealtime;
                }
                if (time < this.recipe.sealTime) {
                    return true;
                }
                float w = (float)this.fluid.amount / 62.5f;
                ItemStack is = ItemFoodTFC.createTag(new ItemStack(TFCItems.cheese), w);
                if (inIS != null && inIS.func_77973_b() instanceof IFood) {
                    int[] profile = Food.getFoodTasteProfile(inIS);
                    float ratio = Math.min((Food.getWeight(this.getInputStack()) - Food.getDecay(inIS)) / 20.0f, 1.0f);
                    Food.setSweetMod(is, (int)Math.floor((float)profile[0] * ratio));
                    Food.setSourMod(is, (int)Math.floor((float)profile[1] * ratio));
                    Food.setSaltyMod(is, (int)Math.floor((float)profile[2] * ratio));
                    Food.setBitterMod(is, (int)Math.floor((float)profile[3] * ratio));
                    Food.setSavoryMod(is, (int)Math.floor((float)profile[4] * ratio));
                    Food.setInfusion(is, inIS.func_77973_b().func_77658_a());
                    this.storage[0] = null;
                }
                this.actionEmpty();
                this.func_70299_a(0, is);
            }
            return true;
        }
        return false;
    }

    public static ItemStack createFullBarrel(FluidStack f, ItemStack is) {
        if (!is.func_77942_o()) {
            is.func_77982_d(new NBTTagCompound());
        }
        is.func_77978_p().func_74757_a("Sealed", true);
        NBTTagCompound fluidNBT = new NBTTagCompound();
        if (f != null) {
            f.writeToNBT(fluidNBT);
        }
        is.func_77978_p().func_74782_a("fluidNBT", (NBTBase)fluidNBT);
        return is;
    }

    public static void registerRecipes() {
        BarrelManager.getInstance().addRecipe(new BarrelAlcoholRecipe(ItemFoodTFC.createTag(new ItemStack(TFCItems.potato), 160.0f), new FluidStack(TFCFluids.FRESHWATER, 10000), null, new FluidStack(TFCFluids.VODKA, 10000)));
        BarrelManager.getInstance().addRecipe(new BarrelAlcoholRecipe(ItemFoodTFC.createTag(new ItemStack(TFCItems.redApple), 160.0f), new FluidStack(TFCFluids.FRESHWATER, 10000), null, new FluidStack(TFCFluids.CIDER, 10000)));
        BarrelManager.getInstance().addRecipe(new BarrelAlcoholRecipe(ItemFoodTFC.createTag(new ItemStack(TFCItems.greenApple), 160.0f), new FluidStack(TFCFluids.FRESHWATER, 10000), null, new FluidStack(TFCFluids.CIDER, 10000)));
        BarrelManager.getInstance().addRecipe(new BarrelAlcoholRecipe(ItemFoodTFC.createTag(new ItemStack(TFCItems.wheatGround), 160.0f), new FluidStack(TFCFluids.FRESHWATER, 10000), null, new FluidStack(TFCFluids.WHISKEY, 10000)));
        BarrelManager.getInstance().addRecipe(new BarrelAlcoholRecipe(ItemFoodTFC.createTag(new ItemStack(TFCItems.ryeGround), 160.0f), new FluidStack(TFCFluids.FRESHWATER, 10000), null, new FluidStack(TFCFluids.RYEWHISKEY, 10000)));
        BarrelManager.getInstance().addRecipe(new BarrelAlcoholRecipe(ItemFoodTFC.createTag(new ItemStack(TFCItems.barleyGround), 160.0f), new FluidStack(TFCFluids.FRESHWATER, 10000), null, new FluidStack(TFCFluids.BEER, 10000)));
        BarrelManager.getInstance().addRecipe(new BarrelAlcoholRecipe(ItemFoodTFC.createTag(new ItemStack(TFCItems.riceGround), 160.0f), new FluidStack(TFCFluids.FRESHWATER, 10000), null, new FluidStack(TFCFluids.SAKE, 10000)));
        BarrelManager.getInstance().addRecipe(new BarrelAlcoholRecipe(ItemFoodTFC.createTag(new ItemStack(TFCItems.sugar), 160.0f), new FluidStack(TFCFluids.FRESHWATER, 10000), null, new FluidStack(TFCFluids.RUM, 10000)));
        BarrelManager.getInstance().addRecipe(new BarrelAlcoholRecipe(ItemFoodTFC.createTag(new ItemStack(TFCItems.cornmealGround), 160.0f), new FluidStack(TFCFluids.FRESHWATER, 10000), null, new FluidStack(TFCFluids.CORNWHISKEY, 10000)));
        BarrelManager.getInstance().addRecipe(new BarrelRecipe(null, new FluidStack(TFCFluids.MILKVINEGAR, 10000), null, new FluidStack(TFCFluids.MILKCURDLED, 10000)).setMinTechLevel(0).setRemovesLiquid(false));
        BarrelManager.getInstance().addRecipe(new BarrelRecipe(new ItemStack(TFCItems.logs, 1, 0), new FluidStack(TFCFluids.FRESHWATER, 1000), null, new FluidStack(TFCFluids.TANNIN, 1000)).setMinTechLevel(0));
        BarrelManager.getInstance().addRecipe(new BarrelRecipe(new ItemStack(TFCItems.logs, 1, 2), new FluidStack(TFCFluids.FRESHWATER, 1000), null, new FluidStack(TFCFluids.TANNIN, 1000)).setMinTechLevel(0));
        BarrelManager.getInstance().addRecipe(new BarrelRecipe(new ItemStack(TFCItems.logs, 1, 3), new FluidStack(TFCFluids.FRESHWATER, 1000), null, new FluidStack(TFCFluids.TANNIN, 1000)).setMinTechLevel(0));
        BarrelManager.getInstance().addRecipe(new BarrelRecipe(new ItemStack(TFCItems.logs, 1, 4), new FluidStack(TFCFluids.FRESHWATER, 1000), null, new FluidStack(TFCFluids.TANNIN, 1000)).setMinTechLevel(0));
        BarrelManager.getInstance().addRecipe(new BarrelRecipe(new ItemStack(TFCItems.logs, 1, 5), new FluidStack(TFCFluids.FRESHWATER, 1000), null, new FluidStack(TFCFluids.TANNIN, 1000)).setMinTechLevel(0));
        BarrelManager.getInstance().addRecipe(new BarrelRecipe(new ItemStack(TFCItems.logs, 1, 6), new FluidStack(TFCFluids.FRESHWATER, 1000), null, new FluidStack(TFCFluids.TANNIN, 1000)).setMinTechLevel(0));
        BarrelManager.getInstance().addRecipe(new BarrelRecipe(new ItemStack(TFCItems.logs, 1, 9), new FluidStack(TFCFluids.FRESHWATER, 1000), null, new FluidStack(TFCFluids.TANNIN, 1000)).setMinTechLevel(0));
        BarrelManager.getInstance().addRecipe(new BarrelRecipe(new ItemStack(TFCItems.powder, 1, 0), new FluidStack(TFCFluids.FRESHWATER, 500), null, new FluidStack(TFCFluids.LIMEWATER, 500), 0).setMinTechLevel(0).setSealedRecipe(false).setRemovesLiquid(false).setAllowAnyStack(false));
        BarrelManager.getInstance().addRecipe(new BarrelMultiItemRecipe(new ItemStack(TFCItems.scrapedHide, 1, 0), new FluidStack(TFCFluids.FRESHWATER, 300), new ItemStack(TFCItems.prepHide, 1, 0), new FluidStack(TFCFluids.FRESHWATER, 300)).setMinTechLevel(0));
        BarrelManager.getInstance().addRecipe(new BarrelMultiItemRecipe(new ItemStack(TFCItems.scrapedHide, 1, 1), new FluidStack(TFCFluids.FRESHWATER, 400), new ItemStack(TFCItems.prepHide, 1, 1), new FluidStack(TFCFluids.FRESHWATER, 400)).setMinTechLevel(0));
        BarrelManager.getInstance().addRecipe(new BarrelMultiItemRecipe(new ItemStack(TFCItems.scrapedHide, 1, 2), new FluidStack(TFCFluids.FRESHWATER, 500), new ItemStack(TFCItems.prepHide, 1, 2), new FluidStack(TFCFluids.FRESHWATER, 500)).setMinTechLevel(0));
        BarrelManager.getInstance().addRecipe(new BarrelMultiItemRecipe(new ItemStack(TFCItems.hide, 1, 0), new FluidStack(TFCFluids.LIMEWATER, 300), new ItemStack(TFCItems.soakedHide, 1, 0), new FluidStack(TFCFluids.LIMEWATER, 300)).setMinTechLevel(0));
        BarrelManager.getInstance().addRecipe(new BarrelMultiItemRecipe(new ItemStack(TFCItems.hide, 1, 1), new FluidStack(TFCFluids.LIMEWATER, 400), new ItemStack(TFCItems.soakedHide, 1, 1), new FluidStack(TFCFluids.LIMEWATER, 400)).setMinTechLevel(0));
        BarrelManager.getInstance().addRecipe(new BarrelMultiItemRecipe(new ItemStack(TFCItems.hide, 1, 2), new FluidStack(TFCFluids.LIMEWATER, 500), new ItemStack(TFCItems.soakedHide, 1, 2), new FluidStack(TFCFluids.LIMEWATER, 500)).setMinTechLevel(0));
        BarrelManager.getInstance().addRecipe(new BarrelMultiItemRecipe(new ItemStack(TFCItems.prepHide, 1, 0), new FluidStack(TFCFluids.TANNIN, 300), new ItemStack(TFCItems.leather, 1), new FluidStack(TFCFluids.TANNIN, 300)).setKeepStackSize(false).setMinTechLevel(0));
        BarrelManager.getInstance().addRecipe(new BarrelMultiItemRecipe(new ItemStack(TFCItems.prepHide, 1, 1), new FluidStack(TFCFluids.TANNIN, 400), new ItemStack(TFCItems.leather, 2), new FluidStack(TFCFluids.TANNIN, 400)).setKeepStackSize(false).setMinTechLevel(0));
        BarrelManager.getInstance().addRecipe(new BarrelMultiItemRecipe(new ItemStack(TFCItems.prepHide, 1, 2), new FluidStack(TFCFluids.TANNIN, 500), new ItemStack(TFCItems.leather, 3), new FluidStack(TFCFluids.TANNIN, 500)).setKeepStackSize(false).setMinTechLevel(0));
        BarrelManager.getInstance().addRecipe(new BarrelRecipe(new ItemStack(TFCBlocks.sand, 1, Short.MAX_VALUE), new FluidStack(TFCFluids.LIMEWATER, 100), new ItemStack(TFCItems.mortar, 16), new FluidStack(TFCFluids.LIMEWATER, 100)).setMinTechLevel(0));
        BarrelManager.getInstance().addRecipe(new BarrelRecipe(new ItemStack(TFCBlocks.sand2, 1, Short.MAX_VALUE), new FluidStack(TFCFluids.LIMEWATER, 100), new ItemStack(TFCItems.mortar, 16), new FluidStack(TFCFluids.LIMEWATER, 100)).setMinTechLevel(0));
        BarrelManager.getInstance().addRecipe(new BarrelVinegarRecipe(new FluidStack(TFCFluids.VODKA, 100), new FluidStack(TFCFluids.VINEGAR, 100)));
        BarrelManager.getInstance().addRecipe(new BarrelVinegarRecipe(new FluidStack(TFCFluids.CIDER, 100), new FluidStack(TFCFluids.VINEGAR, 100)));
        BarrelManager.getInstance().addRecipe(new BarrelVinegarRecipe(new FluidStack(TFCFluids.WHISKEY, 100), new FluidStack(TFCFluids.VINEGAR, 100)));
        BarrelManager.getInstance().addRecipe(new BarrelVinegarRecipe(new FluidStack(TFCFluids.RYEWHISKEY, 100), new FluidStack(TFCFluids.VINEGAR, 100)));
        BarrelManager.getInstance().addRecipe(new BarrelVinegarRecipe(new FluidStack(TFCFluids.BEER, 100), new FluidStack(TFCFluids.VINEGAR, 100)));
        BarrelManager.getInstance().addRecipe(new BarrelVinegarRecipe(new FluidStack(TFCFluids.SAKE, 100), new FluidStack(TFCFluids.VINEGAR, 100)));
        BarrelManager.getInstance().addRecipe(new BarrelVinegarRecipe(new FluidStack(TFCFluids.RUM, 100), new FluidStack(TFCFluids.VINEGAR, 100)));
        BarrelManager.getInstance().addRecipe(new BarrelVinegarRecipe(new FluidStack(TFCFluids.CORNWHISKEY, 100), new FluidStack(TFCFluids.VINEGAR, 100)));
        BarrelManager.getInstance().addRecipe(new BarrelLiquidToLiquidRecipe(new FluidStack(TFCFluids.SALTWATER, 9000), new FluidStack(TFCFluids.VINEGAR, 1000), new FluidStack(TFCFluids.BRINE, 10000)).setSealedRecipe(false).setMinTechLevel(0).setRemovesLiquid(false));
        BarrelManager.getInstance().addRecipe(new BarrelBriningRecipe(new FluidStack(TFCFluids.BRINE, 60), new FluidStack(TFCFluids.BRINE, 60)).setMinTechLevel(0));
        BarrelManager.getInstance().addRecipe(new BarrelMultiItemRecipe(ItemFoodTFC.createTag(new ItemStack(TFCItems.sugarcane), 1.0f), new FluidStack(TFCFluids.FRESHWATER, 60), ItemFoodTFC.createTag(new ItemStack(TFCItems.sugar), 0.1f), new FluidStack(TFCFluids.FRESHWATER, 60)).setMinTechLevel(0));
        BarrelManager.getInstance().addRecipe(new BarrelMultiItemRecipe(new ItemStack(TFCItems.jute, 1, 0), new FluidStack(TFCFluids.FRESHWATER, 200), new ItemStack(TFCItems.juteFiber, 1, 0), new FluidStack(TFCFluids.FRESHWATER, 200)).setMinTechLevel(0));
        BarrelManager.getInstance().addRecipe(new BarrelLiquidToLiquidRecipe(new FluidStack(TFCFluids.MILK, 9000), new FluidStack(TFCFluids.VINEGAR, 1000), new FluidStack(TFCFluids.MILKVINEGAR, 10000)).setSealedRecipe(false).setMinTechLevel(0).setRemovesLiquid(false));
        BarrelManager.getInstance().addRecipe(new BarrelLiquidToLiquidRecipe(new FluidStack(TFCFluids.MILKVINEGAR, 9000), new FluidStack(TFCFluids.MILK, 1000), new FluidStack(TFCFluids.MILKVINEGAR, 10000)).setSealedRecipe(false).setMinTechLevel(0).setRemovesLiquid(false));
        BarrelPreservativeRecipe picklePreservative = new BarrelPreservativeRecipe(new FluidStack(TFCFluids.VINEGAR, 31), "gui.barrel.preserving").setAllowGrains(false).setRequiresPickled(true).setEnvironmentalDecayFactor(0.25f).setBaseDecayModifier(0.1f).setRequiresSealed(true);
        BarrelPreservativeRecipe brineInBrinePreservative = new BarrelPreservativeRecipe(new FluidStack(TFCFluids.BRINE, 62), "gui.barrel.preserving").setAllowGrains(false).setRequiresBrined(true).setEnvironmentalDecayFactor(0.75f).setRequiresSealed(true);
        BarrelPreservativeRecipe brineInVinegarPreservative = new BarrelPreservativeRecipe(new FluidStack(TFCFluids.VINEGAR, 62), "gui.barrel.preserving").setAllowGrains(false).setRequiresBrined(true).setEnvironmentalDecayFactor(0.75f).setRequiresSealed(true);
        BarrelManager.getInstance().addPreservative(picklePreservative);
        BarrelManager.getInstance().addPreservative(brineInBrinePreservative);
        BarrelManager.getInstance().addPreservative(brineInVinegarPreservative);
    }
}

