/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.TileEntities;

import com.bioxx.tfc.Blocks.BlockFarmland;
import com.bioxx.tfc.Core.TFC_Achievements;
import com.bioxx.tfc.Core.TFC_Climate;
import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.Core.TFC_Time;
import com.bioxx.tfc.Food.CropIndex;
import com.bioxx.tfc.Food.CropManager;
import com.bioxx.tfc.TileEntities.NetworkTileEntity;
import com.bioxx.tfc.TileEntities.TEFarmland;
import com.bioxx.tfc.TileEntities.TEWorldItem;
import com.bioxx.tfc.api.TFCBlocks;
import com.bioxx.tfc.api.TFCOptions;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class TECrop
extends NetworkTileEntity {
    public float growth = 0.1f;
    public int cropId;
    private long growthTimer;
    private long plantedTime = TFC_Time.getTotalTicks();
    private byte sunLevel = 1;
    public int tendingLevel;
    private int killLevel;

    public TECrop() {
        this.growthTimer = TFC_Time.getTotalTicks();
    }

    public void func_145845_h() {
        Random r = new Random();
        if (!this.field_145850_b.field_72995_K) {
            float timeMultiplier = 360.0f / (float)TFC_Time.daysInYear;
            CropIndex crop = CropManager.getInstance().getCropFromId(this.cropId);
            long time = TFC_Time.getTotalTicks();
            if (crop != null && this.growthTimer < time && this.sunLevel > 0) {
                int baseKillChance;
                this.sunLevel = (byte)(this.sunLevel - 1);
                if (crop.needsSunlight && TECrop.hasSunlight(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                    this.sunLevel = (byte)(this.sunLevel + 1);
                    if (this.sunLevel > 30) {
                        this.sunLevel = (byte)30;
                    }
                }
                TEFarmland tef = null;
                TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
                if (te instanceof TEFarmland) {
                    tef = (TEFarmland)te;
                }
                float ambientTemp = TFC_Climate.getHeightAdjustedTempSpecificDay(this.field_145850_b, TFC_Time.getDayOfYearFromTick(this.growthTimer), this.field_145851_c, this.field_145848_d, this.field_145849_e);
                float tempAdded = 0.0f;
                boolean isDormant = false;
                if (!crop.dormantInFrost && ambientTemp < crop.minGrowthTemp) {
                    tempAdded = -0.03f * (crop.minGrowthTemp - ambientTemp);
                } else if (crop.dormantInFrost && ambientTemp < crop.minGrowthTemp) {
                    if (this.growth > 1.0f) {
                        tempAdded = -0.03f * (crop.minGrowthTemp - ambientTemp);
                    }
                    isDormant = true;
                } else if (ambientTemp < 28.0f) {
                    tempAdded = ambientTemp * 3.5E-4f;
                } else if (ambientTemp < 37.0f) {
                    tempAdded = (28.0f - (ambientTemp - 28.0f)) * 3.0E-4f;
                }
                if (!crop.dormantInFrost && ambientTemp < crop.minAliveTemp) {
                    baseKillChance = 6;
                    if (this.field_145850_b.field_73012_v.nextInt(baseKillChance - this.killLevel) == 0) {
                        this.killCrop(crop);
                    } else if (this.killLevel < baseKillChance - 1) {
                        ++this.killLevel;
                    }
                } else if (crop.dormantInFrost && ambientTemp < crop.minAliveTemp) {
                    if (this.growth > 1.0f) {
                        baseKillChance = 6;
                        if (this.field_145850_b.field_73012_v.nextInt(baseKillChance - this.killLevel) == 0) {
                            this.killCrop(crop);
                        } else if (this.killLevel < baseKillChance - 1) {
                            ++this.killLevel;
                        }
                    }
                } else {
                    this.killLevel = 0;
                }
                int nutriType = crop.cycleType;
                int nutri = tef != null ? tef.nutrients[nutriType] : 18000;
                int fert = tef != null ? tef.nutrients[3] : 0;
                int soilMax = tef != null ? tef.getSoilMax() : 18000;
                float waterBoost = BlockFarmland.isFreshWaterNearby(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) ? 0.1f : 0.0f;
                nutri = Math.min(nutri + fert, (int)((float)soilMax * 1.25f));
                float nutriMult = 0.2f + (float)nutri / (float)soilMax * 0.5f + waterBoost;
                if (tef != null && !isDormant) {
                    if (tef.nutrients[nutriType] > 0) {
                        tef.drainNutrients(nutriType, crop.nutrientUsageMult);
                    }
                    if (tef.nutrients[3] > 0) {
                        tef.drainNutrients(3, crop.nutrientUsageMult);
                    }
                }
                float growthRate = Math.max(0.0f, ((float)crop.numGrowthStages / ((float)crop.growthTime * TFC_Time.timeRatio96) + tempAdded) * nutriMult * timeMultiplier * TFCOptions.cropGrowthMultiplier);
                if (tef != null && tef.isInfested) {
                    growthRate /= 2.0f;
                }
                int oldGrowth = (int)Math.floor(this.growth);
                if (!isDormant) {
                    this.growth += growthRate;
                }
                if (oldGrowth < (int)Math.floor(this.growth)) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                if ((TFCOptions.enableCropsDie || !TFC_Core.isFarmland(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e))) && crop.maxLifespan == -1 && this.growth > (float)crop.numGrowthStages + (float)crop.numGrowthStages / 2.0f || this.growth < 0.0f) {
                    this.killCrop(crop);
                }
                this.growthTimer += (long)(r.nextInt(2) + 23) * 1000L;
            } else if (crop != null && crop.needsSunlight && this.sunLevel <= 0) {
                this.killCrop(crop);
            }
            if (TFC_Core.isExposedToRain(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e) && TFC_Climate.getHeightAdjustedTemp(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e) < 0.0f && (crop != null && !crop.dormantInFrost || this.growth > 1.0f)) {
                this.killCrop(crop);
            }
        }
    }

    public static boolean hasSunlight(World world, int x, int y, int z) {
        Chunk chunk = world.func_72938_d(x, z);
        int skylight = chunk.func_76614_a(EnumSkyBlock.Sky, x & 0xF, y, z & 0xF);
        boolean sky = world.func_72937_j(x, y + 1, z);
        return sky || skylight > 13;
    }

    public float getEstimatedGrowth(CropIndex crop) {
        return (float)crop.numGrowthStages / (float)(this.growthTimer - this.plantedTime / 24000L) * 1.5f;
    }

    public void onHarvest(World world, EntityPlayer player, boolean isBreaking) {
        if (!world.field_72995_K) {
            CropIndex crop = CropManager.getInstance().getCropFromId(this.cropId);
            if (crop != null && this.growth >= (float)(crop.numGrowthStages - 1)) {
                int skill;
                ItemStack is1 = crop.getOutput1(this);
                ItemStack is2 = crop.getOutput2(this);
                ItemStack seedStack = crop.getSeed();
                if (is1 != null) {
                    world.func_72838_d((Entity)new EntityItem(world, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, is1));
                }
                if (is2 != null) {
                    world.func_72838_d((Entity)new EntityItem(world, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, is2));
                }
                seedStack.field_77994_a = 1 + (world.field_73012_v.nextInt(1 + (skill = 20 - (int)(20.0f * TFC_Core.getSkillStats(player).getSkillMultiplier("skill.agriculture")))) == 0 ? 1 : 0);
                if (isBreaking) {
                    world.func_72838_d((Entity)new EntityItem(world, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, seedStack));
                }
                TFC_Core.getSkillStats(player).increaseSkill("skill.agriculture", 1);
                if (TFC_Core.isSoil(world.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e))) {
                    player.func_71064_a((StatBase)TFC_Achievements.achWildVegetable, 1);
                }
            } else if (crop != null) {
                ItemStack is = crop.getSeed();
                is.field_77994_a = 1;
                world.func_72838_d((Entity)new EntityItem(world, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, is));
            }
        }
    }

    public void killCrop(CropIndex crop) {
        ItemStack is = crop.getSeed();
        is.field_77994_a = 1;
        if (TFC_Core.isFarmland(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) && TFCOptions.enableSeedDrops) {
            if (this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, TFCBlocks.worldItem)) {
                TEWorldItem te = (TEWorldItem)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                te.storage[0] = is;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        } else {
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.growth = nbt.func_74760_g("growth");
        this.cropId = nbt.func_74762_e("cropId");
        this.growthTimer = nbt.func_74763_f("growthTimer");
        this.plantedTime = nbt.func_74763_f("plantedTime");
        this.killLevel = nbt.func_74762_e("killLevel");
        this.sunLevel = nbt.func_74771_c("sunLevel");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74776_a("growth", this.growth);
        nbt.func_74768_a("cropId", this.cropId);
        nbt.func_74772_a("growthTimer", this.growthTimer);
        nbt.func_74772_a("plantedTime", this.plantedTime);
        nbt.func_74768_a("killLevel", this.killLevel);
        nbt.func_74774_a("sunLevel", this.sunLevel);
    }

    @Override
    public void handleInitPacket(NBTTagCompound nbt) {
        this.growth = nbt.func_74760_g("growth");
        this.cropId = nbt.func_74762_e("cropId");
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void handleDataPacket(NBTTagCompound nbt) {
        this.growth = nbt.func_74760_g("growth");
        this.cropId = nbt.func_74762_e("cropId");
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void createDataNBT(NBTTagCompound nbt) {
        nbt.func_74776_a("growth", this.growth);
        nbt.func_74768_a("cropId", this.cropId);
    }

    @Override
    public void createInitNBT(NBTTagCompound nbt) {
        nbt.func_74776_a("growth", this.growth);
        nbt.func_74768_a("cropId", this.cropId);
    }
}

