/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.TileEntities;

import com.bioxx.tfc.Blocks.Devices.BlockChestTFC;
import com.bioxx.tfc.Blocks.Terrain.BlockCobble;
import com.bioxx.tfc.Blocks.Terrain.BlockDirt;
import com.bioxx.tfc.Blocks.Terrain.BlockGravel;
import com.bioxx.tfc.Blocks.Terrain.BlockSand;
import com.bioxx.tfc.Blocks.Terrain.BlockSmooth;
import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.TileEntities.NetworkTileEntity;
import com.bioxx.tfc.TileEntities.TEBarrel;
import com.bioxx.tfc.TileEntities.TEChest;
import com.bioxx.tfc.api.Food;
import com.bioxx.tfc.api.TFCFluids;
import com.bioxx.tfc.api.TFCItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class TEHopper
extends NetworkTileEntity
implements IHopper {
    private ItemStack[] storage = new ItemStack[5];
    private String customName;
    private int cooldown = -1;
    public int pressCooldown;
    public ItemStack pressBlock;

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.storage = new ItemStack[this.func_70302_i_()];
        if (nbt.func_150297_b("CustomName", 8)) {
            this.customName = nbt.func_74779_i("CustomName");
        }
        this.cooldown = nbt.func_74762_e("TransferCooldown");
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.storage.length) continue;
            this.storage[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.pressCooldown = nbt.func_74762_e("pressCooldown");
        this.pressBlock = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("pressBlock"));
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.storage.length; ++i) {
            if (this.storage[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.storage[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
        nbt.func_74768_a("TransferCooldown", this.cooldown);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.customName);
        }
        nbt.func_74768_a("pressCooldown", this.pressCooldown);
        if (this.pressBlock != null) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            this.pressBlock.func_77955_b(nbttagcompound1);
            nbt.func_74782_a("pressBlock", (NBTBase)nbttagcompound1);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1));
    }

    public int func_70302_i_() {
        return this.storage.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.storage[i];
    }

    public ItemStack func_70298_a(int i, int amount) {
        if (this.storage[i] != null) {
            if (this.storage[i].field_77994_a <= amount) {
                ItemStack itemstack = this.storage[i];
                this.storage[i] = null;
                return itemstack;
            }
            ItemStack itemstack = this.storage[i].func_77979_a(amount);
            if (this.storage[i].field_77994_a == 0) {
                this.storage[i] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.storage[i] != null) {
            ItemStack itemstack = this.storage[i];
            this.storage[i] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack is) {
        this.storage[i] = is;
        if (is != null && is.field_77994_a > this.func_70297_j_()) {
            is.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.hopper";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String s) {
        this.customName = s;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer p) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : p.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack is) {
        return true;
    }

    public void func_145845_h() {
        block12: {
            Block blockAbove;
            block14: {
                block13: {
                    block11: {
                        if (!this.field_145850_b.field_72995_K) break block11;
                        if (this.pressCooldown > 0) {
                            --this.pressCooldown;
                        } else {
                            this.pressBlock = null;
                        }
                        break block12;
                    }
                    if (this.field_145850_b == null || this.field_145850_b.field_72995_K) break block12;
                    --this.cooldown;
                    TFC_Core.handleItemTicking((IInventory)this, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    if (this.pressCooldown <= 0) break block13;
                    --this.pressCooldown;
                    if (this.pressCooldown % 20 != 0) break block14;
                    this.press();
                    break block14;
                }
                if (this.pressCooldown == 0 && this.pressBlock != null) {
                    for (int i = 0; i < this.storage.length; ++i) {
                        if (this.storage[i] != null && (!ItemStack.func_77989_b((ItemStack)this.storage[i], (ItemStack)this.pressBlock) || this.storage[i].field_77994_a >= this.storage[i].func_77976_d())) continue;
                        if (this.storage[i] == null) {
                            this.storage[i] = this.pressBlock;
                        } else {
                            ++this.storage[i].field_77994_a;
                        }
                        this.pressBlock = null;
                        break;
                    }
                }
            }
            if (!this.isCoolingDown()) {
                this.setCooldown(0);
            }
            if ((blockAbove = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) != null && this.hasPressableItem() > 0) {
                if (!(this.pressBlock == null || blockAbove instanceof BlockCobble || blockAbove instanceof BlockGravel || blockAbove instanceof BlockSand || blockAbove instanceof BlockDirt)) {
                    TFC_Core.setBlockToAirWithDrops(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                } else if (blockAbove instanceof BlockSmooth) {
                    this.pressBlock = new ItemStack(blockAbove, 1, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e));
                    this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                    this.sendPressPacket();
                    this.beginPressing();
                }
            }
        }
    }

    private void press() {
        ItemStack item;
        TEBarrel barrel = null;
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) instanceof TEBarrel) {
            barrel = (TEBarrel)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        }
        if ((item = this.getPressableItem()) != null) {
            if (item.field_77994_a > 0) {
                Food.setWeight(item, Food.getWeight(item) - 0.64f);
            }
            if (barrel != null && barrel.canAcceptLiquids() && !barrel.getSealed()) {
                barrel.addLiquid(new FluidStack(TFCFluids.OLIVEOIL, 1));
            }
        }
    }

    private void beginPressing() {
        int pressWeight = this.hasPressableItem();
        if (pressWeight > 0) {
            this.pressCooldown = (int)((float)this.pressCooldown + (float)pressWeight / 0.64f * 20.0f);
            this.sendCooldownPacket();
        }
    }

    public int hasPressableItem() {
        int amount = 0;
        for (int i = 0; i < this.storage.length; ++i) {
            if (this.storage[i] == null || this.storage[i].func_77973_b() != TFCItems.olive) continue;
            amount = (int)((double)amount + Math.floor(Food.getWeight(this.storage[i])));
        }
        return amount;
    }

    public ItemStack getPressableItem() {
        for (int i = 0; i < this.storage.length; ++i) {
            if (this.storage[i] == null || this.storage[i].func_77973_b() != TFCItems.olive) continue;
            return this.storage[i];
        }
        return null;
    }

    public void setCooldown(int time) {
        this.cooldown = time;
    }

    public boolean isCoolingDown() {
        return this.cooldown > 0;
    }

    public static IInventory getInputInventory(IHopper hopper) {
        return TEHopper.searchForOutputInventory(hopper.func_145831_w(), hopper.func_96107_aA(), hopper.func_96109_aB() + 1.0, hopper.func_96108_aC());
    }

    public static EntityItem searchForLooseInput(World world, double x, double y, double z) {
        List list = world.func_82733_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1.0), (double)(y + 1.0), (double)(z + 1.0)), IEntitySelector.field_94557_a);
        return !list.isEmpty() ? (EntityItem)list.get(0) : null;
    }

    public static IInventory searchForOutputInventory(World world, double x, double y, double z) {
        List list;
        Block block;
        int k;
        int j;
        IInventory iinventory = null;
        int i = MathHelper.func_76128_c((double)x);
        TileEntity tileentity = world.func_147438_o(i, j = MathHelper.func_76128_c((double)y), k = MathHelper.func_76128_c((double)z));
        if (tileentity instanceof IInventory && (iinventory = (IInventory)tileentity) instanceof TEChest && (block = world.func_147439_a(i, j, k)) instanceof BlockChestTFC) {
            iinventory = ((BlockChestTFC)block).getInventory(world, i, j, k);
        }
        if (iinventory == null && (list = world.func_94576_a((Entity)null, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1.0), (double)(y + 1.0), (double)(z + 1.0)), IEntitySelector.field_96566_b)) != null && !list.isEmpty()) {
            iinventory = (IInventory)list.get(world.field_73012_v.nextInt(list.size()));
        }
        return iinventory;
    }

    @Override
    public void handleInitPacket(NBTTagCompound nbt) {
        if (nbt.func_74764_b("pressBlock")) {
            this.pressBlock = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("pressBlock"));
        }
        this.pressCooldown = nbt.func_74762_e("pressCooldown");
    }

    @Override
    public void createInitNBT(NBTTagCompound nbt) {
        if (this.pressBlock != null) {
            NBTTagCompound pb = new NBTTagCompound();
            this.pressBlock.func_77955_b(pb);
            nbt.func_74782_a("pressBlock", (NBTBase)pb);
        }
        nbt.func_74768_a("pressCooldown", this.pressCooldown);
    }

    @Override
    public void handleDataPacket(NBTTagCompound nbt) {
        if (nbt.func_74764_b("pressBlock")) {
            this.pressBlock = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("pressBlock"));
        }
        if (nbt.func_74764_b("pressCooldown")) {
            this.pressCooldown = nbt.func_74762_e("pressCooldown");
        }
    }

    private void sendPressPacket() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.pressBlock != null) {
            NBTTagCompound pb = new NBTTagCompound();
            this.pressBlock.func_77955_b(pb);
            nbt.func_74782_a("pressBlock", (NBTBase)pb);
        }
        this.broadcastPacketInRange(this.createDataPacket(nbt));
    }

    private void sendCooldownPacket() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("pressCooldown", this.pressCooldown);
        this.broadcastPacketInRange(this.createDataPacket(nbt));
    }

    public double func_96107_aA() {
        return this.field_145851_c;
    }

    public double func_96109_aB() {
        return this.field_145848_d;
    }

    public double func_96108_aC() {
        return this.field_145849_e;
    }
}

