/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.TileEntities;

import com.bioxx.tfc.TileEntities.NetworkTileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class TEMetalSheet
extends NetworkTileEntity {
    public ItemStack sheetStack;
    private byte sides;
    public int metalID;

    public void clearSides() {
        this.sides = 0;
    }

    public boolean topExists() {
        return (this.sides & 1) > 0;
    }

    public boolean bottomExists() {
        return (this.sides & 2) > 0;
    }

    public boolean northExists() {
        return (this.sides & 4) > 0;
    }

    public boolean southExists() {
        return (this.sides & 8) > 0;
    }

    public boolean eastExists() {
        return (this.sides & 0x10) > 0;
    }

    public boolean westExists() {
        return (this.sides & 0x20) > 0;
    }

    public void toggleBySide(int side, boolean setOn) {
        switch (side) {
            case 0: {
                this.toggleBottom(setOn);
                break;
            }
            case 1: {
                this.toggleTop(setOn);
                break;
            }
            case 2: {
                this.toggleNorth(setOn);
                break;
            }
            case 3: {
                this.toggleSouth(setOn);
                break;
            }
            case 4: {
                this.toggleEast(setOn);
                break;
            }
            case 5: {
                this.toggleWest(setOn);
            }
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void toggleTop(boolean setOn) {
        this.sides = this.topExists() && !setOn ? (byte)(this.sides - 1) : (byte)(this.sides + 1);
    }

    public void toggleBottom(boolean setOn) {
        this.sides = this.bottomExists() && !setOn ? (byte)(this.sides - 2) : (byte)(this.sides + 2);
    }

    public void toggleNorth(boolean setOn) {
        this.sides = this.northExists() && !setOn ? (byte)(this.sides - 4) : (byte)(this.sides + 4);
    }

    public void toggleSouth(boolean setOn) {
        this.sides = this.southExists() && !setOn ? (byte)(this.sides - 8) : (byte)(this.sides + 8);
    }

    public void toggleEast(boolean setOn) {
        this.sides = this.eastExists() && !setOn ? (byte)(this.sides - 16) : (byte)(this.sides + 16);
    }

    public void toggleWest(boolean setOn) {
        this.sides = this.westExists() && !setOn ? (byte)(this.sides - 32) : (byte)(this.sides + 32);
    }

    public boolean isEmpty() {
        return !this.topExists() && !this.bottomExists() && !this.northExists() && !this.southExists() && !this.eastExists() && !this.westExists();
    }

    public boolean canUpdate() {
        return false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.sheetStack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("sheetType"));
        this.sides = nbt.func_74771_c("sides");
        this.metalID = nbt.func_74762_e("metalID");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74774_a("sides", this.sides);
        NBTTagCompound st = new NBTTagCompound();
        if (this.sheetStack != null) {
            this.sheetStack.func_77955_b(st);
        }
        nbt.func_74782_a("sheetType", (NBTBase)st);
        nbt.func_74768_a("metalID", this.metalID);
    }

    @Override
    public void handleInitPacket(NBTTagCompound nbt) {
        this.sides = nbt.func_74771_c("sides");
        this.metalID = nbt.func_74762_e("metalID");
    }

    @Override
    public void handleDataPacket(NBTTagCompound nbt) {
    }

    @Override
    public void createDataNBT(NBTTagCompound nbt) {
    }

    @Override
    public void createInitNBT(NBTTagCompound nbt) {
        nbt.func_74774_a("sides", this.sides);
        nbt.func_74768_a("metalID", this.metalID);
    }
}

