/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.WAILA;

import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.Core.TFC_Time;
import com.bioxx.tfc.Entities.Mobs.EntityCowTFC;
import com.bioxx.tfc.api.Entities.IAnimal;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class WMobs
implements IWailaEntityProvider {
    public Entity getWailaOverride(IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        String head = currenttip.get(0);
        if (entity instanceof IAnimal) {
            IAnimal animal = (IAnimal)entity;
            if (config.getConfig("tfc.baby") && !animal.isAdult()) {
                head = EnumChatFormatting.WHITE + TFC_Core.translate("gui.baby") + " " + head;
            }
            if (config.getConfig("tfc.gender")) {
                if (animal.getGender() == IAnimal.GenderEnum.MALE) {
                    head = head + " \u2642";
                } else if (animal.getGender() == IAnimal.GenderEnum.FEMALE) {
                    head = head + " \u2640";
                }
            }
        }
        currenttip.set(0, head);
        return currenttip;
    }

    public List<String> getWailaBody(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        IAnimal animal = (IAnimal)entity;
        NBTTagCompound nbt = accessor.getNBTData();
        int familiarity = nbt.func_74762_e("Familiarity");
        boolean familiarizedToday = animal.getFamiliarizedToday();
        boolean pregnant = animal.isPregnant();
        if (pregnant) {
            currenttip.add(TFC_Core.translate("entity.pregnant") + " : " + TFC_Time.getDateStringFromHours(animal.getDueDay() * 24));
        }
        if (config.getConfig("tfc.familiarToday") && animal.canFamiliarize()) {
            if (familiarizedToday) {
                currenttip.add(TFC_Core.translate("gui.familiarized") + EnumChatFormatting.GREEN.toString() + " \u2714");
            } else {
                currenttip.add(TFC_Core.translate("gui.familiarized") + EnumChatFormatting.RED.toString() + " \u2718");
            }
        }
        if (config.getConfig("tfc.familiarity")) {
            currenttip.add(TFC_Core.translate("gui.familiarity") + " : " + familiarity + "%");
        }
        if (animal instanceof EntityCowTFC && animal.getGender() == IAnimal.GenderEnum.FEMALE && animal.isAdult()) {
            EntityCowTFC cow = (EntityCowTFC)entity;
            if (cow.isMilkable()) {
                currenttip.add(TFC_Core.translate("fluid.milk") + EnumChatFormatting.GREEN.toString() + " \u2714");
            } else {
                currenttip.add(TFC_Core.translate("fluid.milk") + EnumChatFormatting.RED.toString() + " \u2718");
            }
        }
        return currenttip;
    }

    public List<String> getWailaTail(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, Entity ent, NBTTagCompound tag, World world) {
        return tag;
    }

    public static void callbackRegister(IWailaRegistrar reg) {
        reg.addConfig("TerraFirmaCraft", "tfc.baby");
        reg.addConfig("TerraFirmaCraft", "tfc.gender");
        reg.addConfig("TerraFirmaCraft", "tfc.familiarToday");
        reg.addConfig("TerraFirmaCraft", "tfc.familiarity", false);
        reg.registerHeadProvider((IWailaEntityProvider)new WMobs(), IAnimal.class);
        reg.registerBodyProvider((IWailaEntityProvider)new WMobs(), IAnimal.class);
    }
}

