/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.WorldGen.Data;

import com.bioxx.tfc.WorldGen.Data.DataCacheBlockTFC;
import com.bioxx.tfc.WorldGen.DataLayer;
import com.bioxx.tfc.WorldGen.GenLayers.GenLayerTFC;
import com.bioxx.tfc.WorldGen.WorldCacheManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.LongHashMap;

public class DataCache {
    private final WorldCacheManager chunkManager;
    private long lastCleanupTime;
    private LongHashMap cacheMap = new LongHashMap();
    private List<DataCacheBlockTFC> cache = new ArrayList<DataCacheBlockTFC>();
    private int index;

    public DataCache(WorldCacheManager worldLayerManager) {
        this.chunkManager = worldLayerManager;
    }

    public DataCache(WorldCacheManager par1, int ind) {
        this.chunkManager = par1;
        this.index = ind;
    }

    public DataCacheBlockTFC getDataCacheBlock(GenLayerTFC indexLayers, int x, int y) {
        long var3 = (long)(x >>= 4) & 0xFFFFFFFFL | ((long)(y >>= 4) & 0xFFFFFFFFL) << 32;
        DataCacheBlockTFC var5 = (DataCacheBlockTFC)this.cacheMap.func_76164_a(var3);
        if (var5 == null) {
            var5 = new DataCacheBlockTFC(this, indexLayers, x, y, this.index);
            this.cacheMap.func_76163_a(var3, (Object)var5);
            this.cache.add(var5);
        }
        var5.lastAccessTime = MinecraftServer.func_130071_aq();
        return var5;
    }

    public DataLayer getDataLayerAt(GenLayerTFC indexLayers, int par1, int par2) {
        return this.getDataCacheBlock(indexLayers, par1, par2).getDataLayerAt(par1, par2);
    }

    public void cleanupCache() {
        long var1 = MinecraftServer.func_130071_aq();
        long var3 = var1 - this.lastCleanupTime;
        if (var3 > 7500L || var3 < 0L) {
            this.lastCleanupTime = var1;
            for (int var5 = 0; var5 < this.cache.size(); ++var5) {
                long var7;
                DataCacheBlockTFC var6 = this.cache.get(var5);
                if (var6 == null || (var7 = var1 - var6.lastAccessTime) <= 30000L && var7 >= 0L) continue;
                this.cache.remove(var5--);
                long var9 = (long)var6.xPosition & 0xFFFFFFFFL | ((long)var6.zPosition & 0xFFFFFFFFL) << 32;
                this.cacheMap.func_76159_d(var9);
            }
        }
    }

    public DataLayer[] getCachedData(GenLayerTFC indexLayers, int par1, int par2) {
        return this.getDataCacheBlock((GenLayerTFC)indexLayers, (int)par1, (int)par2).data;
    }

    public static WorldCacheManager getChunkManager(DataCache cache) {
        return cache.chunkManager;
    }
}

