/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.WorldGen.GenLayers.DataLayers.EVT;

import com.bioxx.tfc.TerraFirmaCraft;
import com.bioxx.tfc.WorldGen.DataLayer;
import com.bioxx.tfc.WorldGen.GenLayers.DataLayers.EVT.GenLayerAddEVT;
import com.bioxx.tfc.WorldGen.GenLayers.DataLayers.EVT.GenLayerEVTInit;
import com.bioxx.tfc.WorldGen.GenLayers.DataLayers.EVT.GenLayerEVTMix;
import com.bioxx.tfc.WorldGen.GenLayers.GenLayerFuzzyZoomTFC;
import com.bioxx.tfc.WorldGen.GenLayers.GenLayerSmoothTFC;
import com.bioxx.tfc.WorldGen.GenLayers.GenLayerTFC;
import com.bioxx.tfc.WorldGen.GenLayers.GenLayerVoronoiZoomTFC;
import com.bioxx.tfc.WorldGen.GenLayers.GenLayerZoomTFC;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import net.minecraft.world.WorldType;

public abstract class GenEVTLayer
extends GenLayerTFC {
    public static final int LOW = DataLayer.EVT_0_25.layerID;
    public static final int HIGH = DataLayer.EVT_8.layerID;
    private static boolean shouldDraw;

    public static GenLayerTFC initialize(long seed, WorldType worldType) {
        GenLayerTFC continent = GenEVTLayer.genContinent(0L);
        GenEVTLayer.drawImage(512, continent, "EVT 0");
        continent = GenLayerZoomTFC.magnify(1000L, continent, 2);
        continent = new GenLayerSmoothTFC(1000L, continent);
        GenEVTLayer.drawImage(512, continent, "EVT 1");
        for (int zoomLevel = 0; zoomLevel < 4; ++zoomLevel) {
            if (zoomLevel == 0) {
                continent = new GenLayerEVTMix(1000 + zoomLevel, continent);
                GenEVTLayer.drawImage(512, continent, "EVT 2-" + zoomLevel + " Mix");
            }
            continent = new GenLayerZoomTFC(1000 + zoomLevel, continent);
            GenEVTLayer.drawImage(512, continent, "EVT 2-" + zoomLevel + " Smoothed");
        }
        GenLayerSmoothTFC finalCont = new GenLayerSmoothTFC(1000L, continent);
        GenLayerVoronoiZoomTFC voronoiZoom = new GenLayerVoronoiZoomTFC(10L, finalCont);
        GenEVTLayer.drawImage(512, voronoiZoom, "EVT 4 Voronoi EVT");
        voronoiZoom.func_75905_a(seed);
        return voronoiZoom;
    }

    public static GenLayerTFC genContinent(long seed) {
        GenLayerTFC continent = new GenLayerEVTInit(1L + seed);
        GenEVTLayer.drawImage(512, continent, "EVT Init 0");
        continent = new GenLayerAddEVT(1L, continent);
        GenEVTLayer.drawImage(512, continent, "EVT Init 0b Add EVT");
        continent = new GenLayerFuzzyZoomTFC(2000L, continent);
        GenEVTLayer.drawImage(512, continent, "EVT Init 1");
        continent = new GenLayerAddEVT(1L, continent);
        GenEVTLayer.drawImage(512, continent, "EVT Init 2 Add EVT");
        continent = new GenLayerZoomTFC(2001L, continent);
        GenEVTLayer.drawImage(512, continent, "EVT Init 3 Zoom");
        continent = new GenLayerAddEVT(2L, continent);
        GenEVTLayer.drawImage(512, continent, "EVT Init 4 Add EVT");
        continent = new GenLayerEVTMix(88L, continent);
        GenEVTLayer.drawImage(512, continent, "EVT Init 4b Mix");
        continent = new GenLayerZoomTFC(2002L, continent);
        GenEVTLayer.drawImage(512, continent, "EVT Init 5 Zoom");
        continent = new GenLayerAddEVT(3L, continent);
        GenEVTLayer.drawImage(512, continent, "EVT Init 6 Add EVT");
        continent = new GenLayerZoomTFC(2003L, continent);
        GenEVTLayer.drawImage(512, continent, "EVT Init 7 Zoom");
        continent = new GenLayerAddEVT(4L, continent);
        GenEVTLayer.drawImage(512, continent, "EVT Init 8 Add EVT");
        return continent;
    }

    public static void drawImage(int size, GenLayerTFC genlayer, String name) {
        if (!shouldDraw) {
            return;
        }
        try {
            File outFile = new File(name + ".bmp");
            if (outFile.exists()) {
                return;
            }
            int[] ints = genlayer.func_75904_a(0, 0, size, size);
            BufferedImage outBitmap = new BufferedImage(size, size, 1);
            Graphics2D graphics = (Graphics2D)outBitmap.getGraphics();
            graphics.clearRect(0, 0, size, size);
            TerraFirmaCraft.LOG.info("Starting " + name + ".bmp");
            for (int x = 0; x < size; ++x) {
                for (int z = 0; z < size; ++z) {
                    int value = ints[x * size + z];
                    if (value - 80 >= 0 && value - 80 <= 7) {
                        graphics.setColor(Color.getColor("", (value - 80) * 32 << 16));
                    } else {
                        graphics.setColor(Color.getColor("", 0xFFFFFF));
                    }
                    graphics.drawRect(x, z, 1, 1);
                }
            }
            TerraFirmaCraft.LOG.info("Finished " + name + ".bmp");
            ImageIO.write((RenderedImage)outBitmap, "BMP", outFile);
        }
        catch (Exception e) {
            TerraFirmaCraft.LOG.catching((Throwable)e);
        }
    }

    public GenEVTLayer(long par1) {
        super(par1);
    }
}

