/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.WorldGen.GenLayers.DataLayers.Stability;

import com.bioxx.tfc.TerraFirmaCraft;
import com.bioxx.tfc.WorldGen.DataLayer;
import com.bioxx.tfc.WorldGen.GenLayers.DataLayers.Stability.GenLayerStabilityInit;
import com.bioxx.tfc.WorldGen.GenLayers.GenLayerFuzzyZoomTFC;
import com.bioxx.tfc.WorldGen.GenLayers.GenLayerSmoothTFC;
import com.bioxx.tfc.WorldGen.GenLayers.GenLayerTFC;
import com.bioxx.tfc.WorldGen.GenLayers.GenLayerVoronoiZoomTFC;
import com.bioxx.tfc.WorldGen.GenLayers.GenLayerZoomTFC;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import net.minecraft.world.WorldType;

public abstract class GenStabilityLayer
extends GenLayerTFC {
    private static boolean shouldDraw;

    public static GenLayerTFC initialize(long par0, WorldType par2WorldType) {
        GenLayerTFC continent = GenStabilityLayer.genContinent(par0);
        GenStabilityLayer.drawImage(512, continent, "Stability 0");
        continent = GenLayerZoomTFC.magnify(1000L, continent, 2);
        continent = new GenLayerSmoothTFC(1000L, continent);
        GenStabilityLayer.drawImage(512, continent, "Stability 1");
        for (int zoomLevel = 0; zoomLevel < 4; ++zoomLevel) {
            continent = new GenLayerZoomTFC(1000 + zoomLevel, continent);
            GenStabilityLayer.drawImage(512, continent, "Stability 2-" + zoomLevel);
        }
        GenLayerSmoothTFC finalCont = new GenLayerSmoothTFC(1000L, continent);
        GenStabilityLayer.drawImage(512, finalCont, "Stability 3");
        GenLayerVoronoiZoomTFC voronoiZoom = new GenLayerVoronoiZoomTFC(10L, finalCont);
        voronoiZoom.func_75905_a(par0);
        return voronoiZoom;
    }

    public static GenLayerTFC genContinent(long seed) {
        GenLayerTFC continent = new GenLayerStabilityInit(1L + seed);
        continent = new GenLayerFuzzyZoomTFC(2000L, continent);
        continent = new GenLayerZoomTFC(2001L, continent);
        continent = new GenLayerZoomTFC(2002L, continent);
        continent = new GenLayerZoomTFC(2003L, continent);
        return continent;
    }

    public static void drawImage(int size, GenLayerTFC genlayer, String name) {
        if (!shouldDraw) {
            return;
        }
        try {
            File outFile = new File(name + ".bmp");
            if (outFile.exists()) {
                return;
            }
            int[] ints = genlayer.func_75904_a(0, 0, size, size);
            BufferedImage outBitmap = new BufferedImage(size, size, 1);
            Graphics2D graphics = (Graphics2D)outBitmap.getGraphics();
            graphics.clearRect(0, 0, size, size);
            TerraFirmaCraft.LOG.info(name + ".bmp");
            for (int x = 0; x < size; ++x) {
                for (int z = 0; z < size; ++z) {
                    int id = DataLayer.layers[ints[x * size + z]].data1;
                    graphics.setColor(Color.getColor("", (id * 255 << 16) + (id * 255 << 8) + id * 255));
                    graphics.drawRect(x, z, 1, 1);
                }
            }
            TerraFirmaCraft.LOG.info(name + ".bmp");
            ImageIO.write((RenderedImage)outBitmap, "BMP", outFile);
        }
        catch (Exception e) {
            TerraFirmaCraft.LOG.catching((Throwable)e);
        }
    }

    public GenStabilityLayer(long par1) {
        super(par1);
    }

    @Override
    public void func_75905_a(long par1) {
        this.field_75907_b = par1;
        if (this.field_75909_a != null) {
            this.field_75909_a.func_75905_a(par1);
        }
        this.field_75907_b *= this.field_75907_b * 6364136223846793005L + 1442695040888963407L;
        this.field_75907_b += this.field_75906_d;
        this.field_75907_b *= this.field_75907_b * 6364136223846793005L + 1442695040888963407L;
        this.field_75907_b += this.field_75906_d;
        this.field_75907_b *= this.field_75907_b * 6364136223846793005L + 1442695040888963407L;
        this.field_75907_b += this.field_75906_d;
    }

    @Override
    public void func_75903_a(long par1, long par3) {
        this.field_75908_c = this.field_75907_b;
        this.field_75908_c *= this.field_75908_c * 6364136223846793005L + 1442695040888963407L;
        this.field_75908_c += par1;
        this.field_75908_c *= this.field_75908_c * 6364136223846793005L + 1442695040888963407L;
        this.field_75908_c += par3;
        this.field_75908_c *= this.field_75908_c * 6364136223846793005L + 1442695040888963407L;
        this.field_75908_c += par1;
        this.field_75908_c *= this.field_75908_c * 6364136223846793005L + 1442695040888963407L;
        this.field_75908_c += par3;
    }

    @Override
    protected int func_75902_a(int par1) {
        int var2 = (int)((this.field_75908_c >> 24) % (long)par1);
        if (var2 < 0) {
            var2 += par1;
        }
        this.field_75908_c *= this.field_75908_c * 6364136223846793005L + 1442695040888963407L;
        this.field_75908_c += this.field_75907_b;
        return var2;
    }

    @Override
    public abstract int[] func_75904_a(int var1, int var2, int var3, int var4);
}

