/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.WorldGen.GenLayers;

import com.bioxx.tfc.TerraFirmaCraft;
import com.bioxx.tfc.WorldGen.GenLayers.Biome.GenLayerAddIslandTFC;
import com.bioxx.tfc.WorldGen.GenLayers.Biome.GenLayerBiomeEdge;
import com.bioxx.tfc.WorldGen.GenLayers.Biome.GenLayerBiomeTFC;
import com.bioxx.tfc.WorldGen.GenLayers.Biome.GenLayerDeepOcean;
import com.bioxx.tfc.WorldGen.GenLayers.Biome.GenLayerIslandTFC;
import com.bioxx.tfc.WorldGen.GenLayers.Biome.GenLayerLakes;
import com.bioxx.tfc.WorldGen.GenLayers.Biome.GenLayerShoreTFC;
import com.bioxx.tfc.WorldGen.GenLayers.GenLayerFuzzyZoomTFC;
import com.bioxx.tfc.WorldGen.GenLayers.GenLayerSmoothBiomeTFC;
import com.bioxx.tfc.WorldGen.GenLayers.GenLayerSmoothTFC;
import com.bioxx.tfc.WorldGen.GenLayers.GenLayerZoomTFC;
import com.bioxx.tfc.WorldGen.GenLayers.River.GenLayerRiverInitTFC;
import com.bioxx.tfc.WorldGen.GenLayers.River.GenLayerRiverMixTFC;
import com.bioxx.tfc.WorldGen.GenLayers.River.GenLayerRiverTFC;
import com.bioxx.tfc.WorldGen.TFCBiome;
import com.bioxx.tfc.WorldGen.TFCWorldType;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import net.minecraft.world.gen.layer.GenLayer;

public abstract class GenLayerTFC
extends GenLayer {
    protected long field_75907_b;
    protected GenLayerTFC field_75909_a;
    protected long field_75908_c;
    protected long field_75906_d;
    private static boolean shouldDraw;

    public static GenLayerTFC[] initialize(long par0, TFCWorldType par2) {
        GenLayerTFC continent = GenLayerTFC.genContinent(0L, false);
        continent = new GenLayerDeepOcean(4L, continent);
        GenLayerTFC.drawImage(512, continent, "8b Continents Done Deep Ocean");
        int var4 = 4;
        GenLayerTFC continentCopy2 = GenLayerZoomTFC.magnify(1000L, continent, 0);
        GenLayerTFC.drawImage(512, continentCopy2, "14 ContinentsZoom");
        GenLayerBiomeTFC var17 = new GenLayerBiomeTFC(200L, continentCopy2, par2);
        GenLayerTFC.drawImage(512, var17, "15 Biome");
        GenLayerLakes lakes = new GenLayerLakes(200L, var17);
        GenLayerTFC.drawImage(512, var17, "15b Lakes");
        continentCopy2 = GenLayerZoomTFC.magnify(1000L, lakes, 2);
        GenLayerTFC.drawImage(512, continentCopy2, "16 ZoomBiome");
        GenLayerTFC var18 = new GenLayerBiomeEdge(1000L, continentCopy2);
        GenLayerTFC.drawImage(512, var18, "17 BiomeEdge");
        for (int var7 = 0; var7 < var4; ++var7) {
            var18 = new GenLayerZoomTFC(1000 + var7, var18);
            GenLayerTFC.drawImage(512, var18, "18-" + var7 + " Zoom");
            if (var7 == 0) {
                var18 = new GenLayerAddIslandTFC(3L, var18);
            }
            if (var7 != 1) continue;
            var18 = new GenLayerShoreTFC(1000L, var18);
            GenLayerTFC.drawImage(512, var18, "18z Shore");
        }
        GenLayerTFC riverCont = GenLayerZoomTFC.magnify(1000L, continent, 2);
        GenLayerTFC.drawImage(512, riverCont, "9 ContinentsZoom");
        riverCont = new GenLayerRiverInitTFC(100L, riverCont);
        GenLayerTFC.drawImage(512, riverCont, "10 RiverInit");
        riverCont = GenLayerZoomTFC.magnify(1000L, riverCont, 6);
        GenLayerTFC.drawImage(512, riverCont, "11 RiverInitZoom");
        riverCont = new GenLayerRiverTFC(1L, riverCont);
        GenLayerTFC.drawImage(512, riverCont, "12 River");
        riverCont = new GenLayerSmoothTFC(1000L, riverCont);
        GenLayerTFC.drawImage(512, riverCont, "13 SmoothRiver");
        GenLayerSmoothBiomeTFC smoothContinent = new GenLayerSmoothBiomeTFC(1000L, var18);
        GenLayerTFC.drawImage(512, smoothContinent, "Biome 19");
        GenLayerRiverMixTFC riverMix = new GenLayerRiverMixTFC(100L, smoothContinent, riverCont);
        GenLayerTFC.drawImage(512, riverMix, "Biome 20");
        GenLayerTFC finalCont = GenLayerZoomTFC.magnify(1000L, riverMix, 2);
        GenLayerTFC.drawImage(512, finalCont, "Biome 20-zoom");
        finalCont = new GenLayerSmoothBiomeTFC(1001L, finalCont);
        GenLayerTFC.drawImage(512, finalCont, "Biome 21");
        riverMix.func_75905_a(par0);
        finalCont.func_75905_a(par0);
        return new GenLayerTFC[]{riverMix, finalCont};
    }

    public static GenLayerTFC genContinent(long seed, boolean oceanReduction) {
        GenLayerIslandTFC continentStart = new GenLayerIslandTFC(1L + seed);
        GenLayerTFC.drawImage(512, continentStart, "0 ContinentsStart");
        GenLayerFuzzyZoomTFC continentFuzzyZoom = new GenLayerFuzzyZoomTFC(2000L, continentStart);
        GenLayerTFC.drawImage(512, continentFuzzyZoom, "1 ContinentsFuzzyZoom");
        GenLayerAddIslandTFC var10 = new GenLayerAddIslandTFC(1L, continentFuzzyZoom);
        GenLayerTFC.drawImage(512, var10, "2 ContinentsAddIsland");
        GenLayerZoomTFC var11 = new GenLayerZoomTFC(2001L, var10);
        GenLayerTFC.drawImage(512, var11, "3 ContinentsAddIslandZoom");
        var10 = new GenLayerAddIslandTFC(2L, var11);
        GenLayerTFC.drawImage(512, var10, "4 ContinentsAddIsland2");
        var11 = new GenLayerZoomTFC(2002L, var10);
        GenLayerTFC.drawImage(512, var11, "5 ContinentsAddIslandZoom2");
        var10 = new GenLayerAddIslandTFC(3L, var11);
        GenLayerTFC.drawImage(512, var10, "6 ContinentsAddIsland3");
        var11 = new GenLayerZoomTFC(2003L, var10);
        GenLayerTFC.drawImage(512, var11, "7 ContinentsAddIslandZoom3");
        GenLayerAddIslandTFC continent = new GenLayerAddIslandTFC(4L, var11);
        GenLayerTFC.drawImage(512, continent, "8 ContinentsDone");
        return continent;
    }

    public static void drawImage(int size, GenLayerTFC genlayer, String name) {
        if (!shouldDraw) {
            return;
        }
        try {
            File outFile = new File(name + ".bmp");
            if (outFile.exists()) {
                return;
            }
            int[] ints = genlayer.func_75904_a(0, 0, size, size);
            BufferedImage outBitmap = new BufferedImage(size, size, 1);
            Graphics2D graphics = (Graphics2D)outBitmap.getGraphics();
            graphics.clearRect(0, 0, size, size);
            TerraFirmaCraft.LOG.info(name + ".bmp");
            for (int x = 0; x < size; ++x) {
                for (int z = 0; z < size; ++z) {
                    if (ints[x * size + z] == -1 || TFCBiome.getBiomeGenArray()[ints[x * size + z]] == null) continue;
                    graphics.setColor(Color.getColor("", TFCBiome.getBiome(ints[x * size + z]).getBiomeColor()));
                    graphics.drawRect(x, z, 1, 1);
                }
            }
            TerraFirmaCraft.LOG.info(name + ".bmp");
            ImageIO.write((RenderedImage)outBitmap, "BMP", outFile);
        }
        catch (Exception e) {
            TerraFirmaCraft.LOG.catching((Throwable)e);
        }
    }

    public GenLayerTFC(long par1) {
        super(par1);
        this.field_75906_d = par1;
        this.field_75906_d *= this.field_75906_d * 6364136223846793005L + 1442695040888963407L;
        this.field_75906_d += par1;
        this.field_75906_d *= this.field_75906_d * 6364136223846793005L + 1442695040888963407L;
        this.field_75906_d += par1;
        this.field_75906_d *= this.field_75906_d * 6364136223846793005L + 1442695040888963407L;
        this.field_75906_d += par1;
    }

    public void func_75905_a(long par1) {
        this.field_75907_b = par1;
        if (this.field_75909_a != null) {
            this.field_75909_a.func_75905_a(par1);
        }
        this.field_75907_b *= this.field_75907_b * 6364136223846793005L + 1442695040888963407L;
        this.field_75907_b += this.field_75906_d;
        this.field_75907_b *= this.field_75907_b * 6364136223846793005L + 1442695040888963407L;
        this.field_75907_b += this.field_75906_d;
        this.field_75907_b *= this.field_75907_b * 6364136223846793005L + 1442695040888963407L;
        this.field_75907_b += this.field_75906_d;
    }

    public void func_75903_a(long par1, long par3) {
        this.field_75908_c = this.field_75907_b;
        this.field_75908_c *= this.field_75908_c * 6364136223846793005L + 1442695040888963407L;
        this.field_75908_c += par1;
        this.field_75908_c *= this.field_75908_c * 6364136223846793005L + 1442695040888963407L;
        this.field_75908_c += par3;
        this.field_75908_c *= this.field_75908_c * 6364136223846793005L + 1442695040888963407L;
        this.field_75908_c += par1;
        this.field_75908_c *= this.field_75908_c * 6364136223846793005L + 1442695040888963407L;
        this.field_75908_c += par3;
    }

    protected int func_75902_a(int par1) {
        int var2 = (int)((this.field_75908_c >> 24) % (long)par1);
        if (var2 < 0) {
            var2 += par1;
        }
        this.field_75908_c *= this.field_75908_c * 6364136223846793005L + 1442695040888963407L;
        this.field_75908_c += this.field_75907_b;
        return var2;
    }

    public abstract int[] func_75904_a(int var1, int var2, int var3, int var4);

    public static int validateInt(int[] array, int index) {
        return array[index];
    }

    public static void validateIntArray(int[] array, int xSize, int zSize) {
        for (int z = 0; z < zSize; ++z) {
            for (int x = 0; x < xSize; ++x) {
                if (TFCBiome.biomeList[array[x + z * xSize]] != null) continue;
                TerraFirmaCraft.LOG.error("Error Array garbage data: " + array[x + z * xSize]);
                return;
            }
        }
    }
}

