/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.WorldGen.Generators;

import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.TerraFirmaCraft;
import com.bioxx.tfc.api.Constant.Global;
import com.bioxx.tfc.api.TFCBlocks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;

public class OreSpawnData {
    public int type;
    public int size;
    public int meta;
    public int rarity;
    public int min = 5;
    public int max = 128;
    public int vDensity;
    public int hDensity;
    public Block block;
    public Map<Block, List<Integer>> base;

    public OreSpawnData(String t, String s, String blockName, int m, int r, String[] baseRocks) {
        this.block = Block.func_149684_b((String)blockName);
        if (this.block == null) {
            TerraFirmaCraft.LOG.error(TFC_Core.translate("error.error") + " " + TFC_Core.translate("error.OreCFG") + " " + blockName);
            throw new NullPointerException(TFC_Core.translate("error.OreCFG") + " " + blockName);
        }
        this.meta = m;
        this.rarity = r;
        this.type = "default".equals(t) ? 0 : 1;
        this.size = "small".equals(s) ? 0 : ("medium".equals(s) ? 1 : 2);
        this.base = new HashMap<Block, List<Integer>>();
        for (String name : baseRocks) {
            this.getOre(name);
        }
    }

    public OreSpawnData(String t, String s, String blockName, int m, int r, String[] baseRocks, int minHeight, int maxHeight, int v, int h) {
        this(t, s, blockName, m, r, baseRocks);
        this.min = minHeight;
        this.max = maxHeight;
        this.vDensity = v;
        this.hDensity = h;
    }

    private void getOre(String name) {
        int i;
        for (i = 0; i < Global.STONE_IGIN.length; ++i) {
            if (!name.equalsIgnoreCase(Global.STONE_IGIN[i])) continue;
            ArrayList<Integer> metadata = this.base.containsKey(TFCBlocks.stoneIgIn) ? this.base.get(TFCBlocks.stoneIgIn) : new ArrayList<Integer>();
            metadata.add(i);
            this.base.put(TFCBlocks.stoneIgIn, metadata);
            return;
        }
        for (i = 0; i < Global.STONE_IGEX.length; ++i) {
            if (!name.equalsIgnoreCase(Global.STONE_IGEX[i])) continue;
            ArrayList<Integer> metadata = this.base.containsKey(TFCBlocks.stoneIgEx) ? this.base.get(TFCBlocks.stoneIgEx) : new ArrayList<Integer>();
            metadata.add(i);
            this.base.put(TFCBlocks.stoneIgEx, metadata);
            return;
        }
        for (i = 0; i < Global.STONE_SED.length; ++i) {
            if (!name.equalsIgnoreCase(Global.STONE_SED[i])) continue;
            ArrayList<Integer> metadata = this.base.containsKey(TFCBlocks.stoneSed) ? this.base.get(TFCBlocks.stoneSed) : new ArrayList<Integer>();
            metadata.add(i);
            this.base.put(TFCBlocks.stoneSed, metadata);
            return;
        }
        for (i = 0; i < Global.STONE_MM.length; ++i) {
            if (!name.equalsIgnoreCase(Global.STONE_MM[i])) continue;
            ArrayList<Integer> metadata = this.base.containsKey(TFCBlocks.stoneMM) ? this.base.get(TFCBlocks.stoneMM) : new ArrayList<Integer>();
            metadata.add(i);
            this.base.put(TFCBlocks.stoneMM, metadata);
            return;
        }
        if ("igneous intrusive".equalsIgnoreCase(name)) {
            ArrayList<Integer> metadata = this.base.containsKey(TFCBlocks.stoneIgIn) ? this.base.get(TFCBlocks.stoneIgIn) : new ArrayList<Integer>();
            metadata.add(-1);
            this.base.put(TFCBlocks.stoneIgIn, metadata);
            return;
        }
        if ("igneous extrusive".equalsIgnoreCase(name)) {
            ArrayList<Integer> metadata = this.base.containsKey(TFCBlocks.stoneIgEx) ? this.base.get(TFCBlocks.stoneIgEx) : new ArrayList<Integer>();
            metadata.add(-1);
            this.base.put(TFCBlocks.stoneIgEx, metadata);
            return;
        }
        if ("sedimentary".equalsIgnoreCase(name)) {
            ArrayList<Integer> metadata = this.base.containsKey(TFCBlocks.stoneSed) ? this.base.get(TFCBlocks.stoneSed) : new ArrayList<Integer>();
            metadata.add(-1);
            this.base.put(TFCBlocks.stoneSed, metadata);
            return;
        }
        if ("metamorphic".equalsIgnoreCase(name)) {
            ArrayList<Integer> metadata = this.base.containsKey(TFCBlocks.stoneMM) ? this.base.get(TFCBlocks.stoneMM) : new ArrayList<Integer>();
            metadata.add(-1);
            this.base.put(TFCBlocks.stoneMM, metadata);
            return;
        }
    }
}

