/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.WorldGen.Generators.Trees;

import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.api.TFCBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenCustomBigTree
extends WorldGenerator {
    private static final byte[] OTHER_COORD_PAIRS = new byte[]{2, 0, 0, 1, 2, 1};
    private final Random rand = new Random();
    private World worldObj;
    private int[] basePos = new int[]{0, 0, 0};
    private int heightLimit;
    private int height;
    private static final double HEIGHT_ATTENUATION = 0.618;
    private static final double BRANCH_SLOPE = 0.381;
    private double scaleWidth = 1.0;
    private double leafDensity = 1.0;
    private int heightLimitLimit = 12;
    private int leafDistanceLimit = 4;
    private int[][] leafNodes;
    private final int treeId;

    public WorldGenCustomBigTree(boolean par1, int id) {
        super(par1);
        this.treeId = id;
    }

    private int checkBlockLine(int[] startCoords, int[] endCoords) {
        int result;
        int[] distance = new int[]{0, 0, 0};
        int newAxis = 0;
        for (int axis = 0; axis < 3; axis = (int)((byte)(axis + 1))) {
            distance[axis] = endCoords[axis] - startCoords[axis];
            if (Math.abs(distance[axis]) <= Math.abs(distance[newAxis])) continue;
            newAxis = axis;
        }
        if (distance[newAxis] == 0) {
            return -1;
        }
        byte newAxisInverse = OTHER_COORD_PAIRS[newAxis];
        byte newAxisInversePerp = OTHER_COORD_PAIRS[newAxis + 3];
        int direction = distance[newAxis] > 0 ? 1 : -1;
        double var9 = (double)distance[newAxisInverse] / (double)distance[newAxis];
        double var11 = (double)distance[newAxisInversePerp] / (double)distance[newAxis];
        int[] coords = new int[]{0, 0, 0};
        int endPoint = distance[newAxis] + direction;
        for (result = 0; result != endPoint; result += direction) {
            coords[newAxis] = startCoords[newAxis] + result;
            coords[newAxisInverse] = MathHelper.func_76128_c((double)((double)startCoords[newAxisInverse] + (double)result * var9));
            coords[newAxisInversePerp] = MathHelper.func_76128_c((double)((double)startCoords[newAxisInversePerp] + (double)result * var11));
            Block block = this.worldObj.func_147439_a(coords[0], coords[1], coords[2]);
            if (!block.isAir((IBlockAccess)this.worldObj, coords[0], coords[1], coords[2]) && block != TFCBlocks.leaves && block != TFCBlocks.leaves2) break;
        }
        return result == endPoint ? -1 : Math.abs(result);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        this.worldObj = world;
        long seed = rand.nextLong();
        this.rand.setSeed(seed);
        this.basePos[0] = x;
        this.basePos[1] = y;
        this.basePos[2] = z;
        if (this.heightLimit == 0) {
            this.heightLimit = 5 + this.rand.nextInt(this.heightLimitLimit);
        }
        if (!this.validTreeLocation()) {
            return false;
        }
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateTrunk();
        this.generateLeafNodeBases();
        return true;
    }

    private void generateLeafNode(int x, int y, int z) {
        int range = y + this.leafDistanceLimit;
        for (int yCoord = y; yCoord < range; ++yCoord) {
            float leafSizeAtHeight = this.leafSize(yCoord - y);
            this.genTreeLayer(x, yCoord, z, leafSizeAtHeight, (byte)1, TFCBlocks.leaves);
        }
    }

    private void generateLeafNodeBases() {
        int[] location = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        for (int i = 0; i < this.leafNodes.length; ++i) {
            int[] leafPoints = this.leafNodes[i];
            int[] newLocation = new int[]{leafPoints[0], leafPoints[1], leafPoints[2]};
            location[1] = leafPoints[3];
            int baseHeight = location[1] - this.basePos[1];
            if (!this.leafNodeNeedsBase(baseHeight)) continue;
            this.placeBlockLine(location, newLocation, TFCBlocks.logNatural);
        }
    }

    private void generateLeafNodeList() {
        int var1;
        this.height = (int)((double)this.heightLimit * 0.618);
        if (this.height >= this.heightLimit) {
            this.height = this.heightLimit - 1;
        }
        if ((var1 = (int)(1.382 + Math.pow(this.leafDensity * (double)this.heightLimit / 13.0, 2.0))) < 1) {
            var1 = 1;
        }
        int[][] var2 = new int[var1 * this.heightLimit][4];
        int trunkTop = this.basePos[1] + this.heightLimit - this.leafDistanceLimit;
        int var4 = 1;
        int treeTop = this.basePos[1] + this.height;
        int height = trunkTop - this.basePos[1];
        var2[0][0] = this.basePos[0];
        var2[0][1] = trunkTop--;
        var2[0][2] = this.basePos[2];
        var2[0][3] = treeTop;
        while (height >= 0) {
            float var8 = this.layerSize(height);
            if (var8 < 0.0f) {
                --trunkTop;
                --height;
                continue;
            }
            double var9 = 0.5;
            for (int var7 = 0; var7 < var1; ++var7) {
                int[] var18;
                int var16;
                double var13;
                double var11 = this.scaleWidth * (double)var8 * ((double)this.rand.nextFloat() + 0.328);
                int var15 = MathHelper.func_76128_c((double)(var11 * Math.sin(var13 = (double)this.rand.nextFloat() * 2.0 * Math.PI) + (double)this.basePos[0] + var9));
                int[] var17 = new int[]{var15, trunkTop, var16 = MathHelper.func_76128_c((double)(var11 * Math.cos(var13) + (double)this.basePos[2] + var9))};
                if (this.checkBlockLine(var17, var18 = new int[]{var15, trunkTop + this.leafDistanceLimit, var16}) != -1) continue;
                int[] var19 = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
                double var20 = Math.sqrt(Math.pow(Math.abs(this.basePos[0] - var17[0]), 2.0) + Math.pow(Math.abs(this.basePos[2] - var17[2]), 2.0));
                double var22 = var20 * 0.381;
                var19[1] = (double)var17[1] - var22 > (double)treeTop ? treeTop : (int)((double)var17[1] - var22);
                if (this.checkBlockLine(var19, var17) != -1) continue;
                var2[var4][0] = var15;
                var2[var4][1] = trunkTop;
                var2[var4][2] = var16;
                var2[var4][3] = var19[1];
                ++var4;
            }
            --trunkTop;
            --height;
        }
        this.leafNodes = new int[var4][4];
        System.arraycopy(var2, 0, this.leafNodes, 0, var4);
    }

    private void generateLeaves() {
        for (int i = 0; i < this.leafNodes.length; ++i) {
            int x = this.leafNodes[i][0];
            int y = this.leafNodes[i][1];
            int z = this.leafNodes[i][2];
            this.generateLeafNode(x, y, z);
        }
    }

    private void generateTrunk() {
        int x = this.basePos[0];
        int y = this.basePos[1];
        int maxY = this.basePos[1] + this.height;
        int z = this.basePos[2];
        int[] bottom = new int[]{x, y, z};
        int[] top = new int[]{x, maxY, z};
        this.placeBlockLine(bottom, top, TFCBlocks.logNatural);
    }

    private void genTreeLayer(int x, int y, int z, float leafSizeAtHeight, byte axis, Block b) {
        int range = (int)((double)leafSizeAtHeight + 0.618);
        byte axisInverse = OTHER_COORD_PAIRS[axis];
        byte axisInversePerp = OTHER_COORD_PAIRS[axis + 3];
        int[] startCoords = new int[]{x, y, z};
        int[] coords = new int[]{0, 0, 0};
        int width2 = -range;
        coords[axis] = startCoords[axis];
        for (int width1 = -range; width1 <= range; ++width1) {
            coords[axisInverse] = startCoords[axisInverse] + width1;
            width2 = -range;
            while (width2 <= range) {
                double distance = Math.sqrt(Math.pow((double)Math.abs(width1) + 0.5, 2.0) + Math.pow((double)Math.abs(width2) + 0.5, 2.0));
                if (distance > (double)leafSizeAtHeight) {
                    ++width2;
                    continue;
                }
                coords[axisInversePerp] = startCoords[axisInversePerp] + width2;
                Block block = this.worldObj.func_147439_a(coords[0], coords[1], coords[2]);
                if (this.worldObj.func_147437_c(coords[0], coords[1], coords[2]) || block == TFCBlocks.leaves || block == TFCBlocks.leaves2) {
                    this.func_150516_a(this.worldObj, coords[0], coords[1], coords[2], b, this.treeId);
                }
                ++width2;
            }
        }
    }

    private float layerSize(int height) {
        if ((double)height < (double)this.heightLimit * 0.3) {
            return -1.618f;
        }
        float halfLimit = (float)this.heightLimit / 2.0f;
        float leafBase = (float)this.heightLimit / 2.0f - (float)height;
        float size = leafBase == 0.0f ? halfLimit : (Math.abs(leafBase) >= halfLimit ? 0.0f : (float)Math.sqrt(Math.pow(Math.abs(halfLimit), 2.0) - Math.pow(Math.abs(leafBase), 2.0)));
        return size *= 0.5f;
    }

    private boolean leafNodeNeedsBase(int par1) {
        return (double)par1 >= (double)this.heightLimit * 0.2;
    }

    private float leafSize(int height) {
        return height >= 0 && height < this.leafDistanceLimit ? (height != 0 && height != this.leafDistanceLimit - 1 ? 3.0f : 2.0f) : -1.0f;
    }

    private void placeBlockLine(int[] bottom, int[] top, Block b) {
        int[] location = new int[]{0, 0, 0};
        int newAxis = 0;
        for (int axis = 0; axis < 3; axis = (int)((byte)(axis + 1))) {
            location[axis] = top[axis] - bottom[axis];
            if (Math.abs(location[axis]) <= Math.abs(location[newAxis])) continue;
            newAxis = axis;
        }
        if (location[newAxis] != 0) {
            byte newAxisInverse = OTHER_COORD_PAIRS[newAxis];
            byte newAxisInversePerp = OTHER_COORD_PAIRS[newAxis + 3];
            int direction = location[newAxis] > 0 ? 1 : -1;
            double var10 = (double)location[newAxisInverse] / (double)location[newAxis];
            double var12 = (double)location[newAxisInversePerp] / (double)location[newAxis];
            int[] coords = new int[]{0, 0, 0};
            for (int loc = 0; loc != location[newAxis] + direction; loc += direction) {
                coords[newAxis] = MathHelper.func_76128_c((double)((double)(bottom[newAxis] + loc) + 0.5));
                coords[newAxisInverse] = MathHelper.func_76128_c((double)((double)bottom[newAxisInverse] + (double)loc * var10 + 0.5));
                coords[newAxisInversePerp] = MathHelper.func_76128_c((double)((double)bottom[newAxisInversePerp] + (double)loc * var12 + 0.5));
                Block block = this.worldObj.func_147439_a(coords[0], coords[1], coords[2]);
                if (!this.worldObj.func_147437_c(coords[0], coords[1], coords[2]) && block != TFCBlocks.leaves && block != TFCBlocks.leaves2) continue;
                this.func_150516_a(this.worldObj, coords[0], coords[1], coords[2], b, this.treeId);
            }
        }
    }

    public void func_76487_a(double heightScale, double widthScale, double densityScale) {
        this.heightLimitLimit = (int)(heightScale * 12.0);
        if (heightScale > 0.5) {
            this.leafDistanceLimit = 5;
        }
        this.scaleWidth = widthScale;
        this.leafDensity = densityScale;
    }

    private boolean validTreeLocation() {
        int[] coords = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        int[] topCoords = new int[]{this.basePos[0], this.basePos[1] + this.heightLimit - 1, this.basePos[2]};
        Block block = this.worldObj.func_147439_a(this.basePos[0], this.basePos[1] - 1, this.basePos[2]);
        if (!TFC_Core.isSoil(block)) {
            return false;
        }
        int distance = this.checkBlockLine(coords, topCoords);
        if (distance == -1) {
            return true;
        }
        if (distance < 6) {
            return false;
        }
        this.heightLimit = distance;
        return true;
    }
}

