/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.WorldGen.Generators;

import com.bioxx.tfc.Core.TFC_Climate;
import com.bioxx.tfc.Core.TFC_Time;
import com.bioxx.tfc.Food.CropIndex;
import com.bioxx.tfc.Food.CropManager;
import com.bioxx.tfc.TileEntities.TECrop;
import com.bioxx.tfc.api.TFCBlocks;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldGenGrowCrops
implements IWorldGenerator {
    private final int cropBlockId;

    public WorldGenGrowCrops(int par1) {
        this.cropBlockId = par1;
    }

    public void generate(World world, Random rand, int x, int z, int numToGen) {
        int i = x;
        int j = 150;
        int k = z;
        for (int c = 0; c < numToGen; ++c) {
            float growth;
            TECrop te;
            i = x - 8 + rand.nextInt(16);
            k = z - 8 + rand.nextInt(16);
            j = world.func_72825_h(i, k);
            CropIndex crop = CropManager.getInstance().getCropFromId(this.cropBlockId);
            if (crop == null) continue;
            float temp = TFC_Climate.getHeightAdjustedTempSpecificDay(world, TFC_Time.getTotalDays(), i, j, k);
            int month = TFC_Time.getSeasonAdjustedMonth(k);
            if (!(temp > crop.minAliveTemp) || month <= 0 || month > 6) continue;
            Block b = world.func_147439_a(i, j, k);
            if (!TFCBlocks.crops.func_149718_j(world, i, j, k) || !b.isAir((IBlockAccess)world, i, j, k) && b != TFCBlocks.tallGrass || !world.func_147465_d(i, j, k, TFCBlocks.crops, 0, 2) || (te = (TECrop)world.func_147438_o(i, j, k)) == null) continue;
            te.cropId = this.cropBlockId;
            float gt = Math.max((float)(crop.growthTime / TFC_Time.daysInMonth), 0.01f);
            float mg = Math.min((float)month / gt, 1.0f) * (0.75f + rand.nextFloat() * 0.25f);
            te.growth = growth = Math.min((float)crop.numGrowthStages * mg, (float)crop.numGrowthStages);
        }
    }

    public void generate(Random par2Random, int x, int z, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
    }
}

