/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.WorldGen.Generators;

import com.bioxx.tfc.Blocks.Terrain.BlockOre;
import com.bioxx.tfc.Core.TFC_Climate;
import com.bioxx.tfc.TileEntities.TEWorldItem;
import com.bioxx.tfc.WorldGen.DataLayer;
import com.bioxx.tfc.WorldGen.TFCBiome;
import com.bioxx.tfc.api.TFCBlocks;
import com.bioxx.tfc.api.TFCItems;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldGenLooseRocks
implements IWorldGenerator {
    private boolean generateRocks(World world, Random random, int i, int j, int k) {
        if ((world.func_147437_c(i, j + 1, k) || world.func_147439_a(i, j + 1, k) == Blocks.field_150433_aE || world.func_147439_a(i, j + 1, k) == TFCBlocks.tallGrass) && (world.func_147439_a(i, j, k).func_149688_o() == Material.field_151577_b || world.func_147439_a(i, j, k).func_149688_o() == Material.field_151576_e) && world.func_147439_a(i, j, k).func_149662_c() && world.func_147465_d(i, j + 1, k, TFCBlocks.worldItem, 0, 2)) {
            TEWorldItem te = (TEWorldItem)world.func_147438_o(i, j + 1, k);
            ItemStack sample = this.getCoreSample(world, i, j, k);
            if (world.field_73012_v.nextInt(3) == 0 && sample != null) {
                te.storage[0] = sample;
            } else {
                DataLayer dl = TFC_Climate.getRockLayer(world, i, j, k, 0);
                te.storage[0] = new ItemStack(TFCItems.looseRock, 1, dl.data1);
            }
        }
        return true;
    }

    private ItemStack getCoreSample(World world, int xCoord, int yCoord, int zCoord) {
        ArrayList<Item> coreSample = new ArrayList<Item>();
        ArrayList<ItemStack> coreSampleStacks = new ArrayList<ItemStack>();
        for (int x = -15; x < 16; ++x) {
            for (int z = -15; z < 16; ++z) {
                for (int y = yCoord; y > yCoord - 35; --y) {
                    int m;
                    if (!world.func_72899_e(xCoord + x, y, zCoord + z) || world.func_147439_a(xCoord + x, y, zCoord + z) != TFCBlocks.ore || coreSample.contains(BlockOre.getDroppedItem(m = world.func_72805_g(xCoord + x, y, zCoord + z))) || m == 14 || m == 15) continue;
                    coreSample.add(BlockOre.getDroppedItem(m));
                    coreSampleStacks.add(new ItemStack(BlockOre.getDroppedItem(m), 1, m));
                }
            }
        }
        if (!coreSampleStacks.isEmpty()) {
            return (ItemStack)coreSampleStacks.get(world.field_73012_v.nextInt(coreSampleStacks.size()));
        }
        return null;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int zCoord;
        int xCoord;
        TFCBiome biome;
        if (world.func_72807_a(chunkX *= 16, chunkZ *= 16) instanceof TFCBiome && ((biome = (TFCBiome)world.func_72807_a(chunkX, chunkZ)) == TFCBiome.OCEAN || biome == TFCBiome.DEEP_OCEAN)) {
            return;
        }
        for (int itemCount = 0; itemCount < 8; ++itemCount) {
            xCoord = chunkX + random.nextInt(16) + 8;
            zCoord = chunkZ + random.nextInt(16) + 8;
            this.generateRocks(world, random, xCoord, world.func_72825_h(xCoord, zCoord) - 1, zCoord);
        }
        for (int stickCount = 0; stickCount < 5; ++stickCount) {
            xCoord = chunkX + random.nextInt(16) + 8;
            zCoord = chunkZ + random.nextInt(16) + 8;
            this.generateSticks(world, random, xCoord, world.func_72825_h(xCoord, zCoord) - 1, zCoord);
        }
    }

    private boolean generateSticks(World world, Random random, int i, int j, int k) {
        TFCBiome biome;
        if ((world.func_147437_c(i, j + 1, k) || world.func_147439_a(i, j + 1, k) == Blocks.field_150433_aE || world.func_147439_a(i, j + 1, k) == TFCBlocks.tallGrass) && (world.func_147439_a(i, j, k).func_149688_o() == Material.field_151577_b || world.func_147439_a(i, j, k).func_149688_o() == Material.field_151576_e || world.func_147439_a(i, j, k).func_149688_o() == Material.field_151595_p || world.func_147439_a(i, j, k).func_149688_o() == Material.field_151578_c) && world.func_147439_a(i, j, k).func_149662_c() && world.func_72807_a(i, k) instanceof TFCBiome && ((biome = (TFCBiome)world.func_72807_a(i, k)) == TFCBiome.DEEP_OCEAN || biome == TFCBiome.BEACH || biome == TFCBiome.GRAVEL_BEACH || biome == TFCBiome.OCEAN || biome == TFCBiome.RIVER || this.isNearTree(world, i, j, k)) && world.func_147465_d(i, j + 1, k, TFCBlocks.worldItem, 0, 2)) {
            TEWorldItem te = (TEWorldItem)world.func_147438_o(i, j + 1, k);
            te.storage[0] = new ItemStack(TFCItems.stick, 1);
        }
        return true;
    }

    private boolean isNearTree(World world, int i, int j, int k) {
        if (world.func_147439_a(i, j + 3, k).func_149688_o() == Material.field_151584_j || world.func_147439_a(i + 5, j + 3, k).func_149688_o() == Material.field_151584_j || world.func_147439_a(i - 5, j + 3, k).func_149688_o() == Material.field_151584_j || world.func_147439_a(i, j + 3, k + 5).func_149688_o() == Material.field_151584_j || world.func_147439_a(i, j + 3, k - 5).func_149688_o() == Material.field_151584_j) {
            return true;
        }
        return world.func_147439_a(i, j + 6, k).func_149688_o() == Material.field_151584_j || world.func_147439_a(i + 5, j + 6, k).func_149688_o() == Material.field_151584_j || world.func_147439_a(i - 5, j + 6, k).func_149688_o() == Material.field_151584_j || world.func_147439_a(i, j + 6, k + 5).func_149688_o() == Material.field_151584_j || world.func_147439_a(i, j + 6, k - 5).func_149688_o() == Material.field_151584_j;
    }
}

