/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.WorldGen.Generators;

import com.bioxx.tfc.Chunkdata.ChunkData;
import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.TileEntities.TEOre;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenMinable
extends WorldGenerator {
    private static List oreList = new ArrayList();
    public static int mPChunkX;
    public static int mPChunkZ;
    private int xChunk;
    private int zChunk;
    public Block mPBlock;
    private final int minableBlockMeta;
    public static int mPPrevX;
    public static int mPPrevZ;
    public static Block mPPrevBlock;
    public static int mPPrevMeta;
    private static boolean genBeforeCheck;
    public static int mineCount;
    public static int mineCountM;
    private static Random rand;
    private static World worldObj;
    private final int rarity;
    private final int veinSi;
    private final int veinAm;
    private final int height;
    private int mineHeight = 2;
    private final int diameter;
    private final int vDens;
    private final int hDens;
    private final Block genInBlock;
    private final int genInBlockMeta;
    private final boolean useMarcoVeins;
    private final int grade;
    private final Block minableBlock;
    private int numberOfBlocks;

    public WorldGenMinable(Block block, int j, Block layerBlock, int layerMeta, int rarity, int veinSize, int veinAmount, int height, int diameter, int vDensity, int hDensity, boolean vein, int oreGrade) {
        this.minableBlock = block;
        this.minableBlockMeta = j;
        this.genInBlock = layerBlock;
        this.genInBlockMeta = layerMeta;
        this.rarity = rarity;
        this.veinSi = veinSize;
        this.veinAm = veinAmount;
        this.height = height;
        this.diameter = diameter;
        this.vDens = vDensity;
        this.hDens = hDensity;
        this.useMarcoVeins = vein;
        this.grade = oreGrade;
    }

    public boolean generateBeforeCheck() {
        genBeforeCheck = false;
        genBeforeCheck = oreList.contains(Arrays.asList(this.mPBlock, this.minableBlockMeta));
        if (!genBeforeCheck) {
            oreList.add(Arrays.asList(this.mPBlock, this.minableBlockMeta));
        }
        return genBeforeCheck;
    }

    private void createMine(World worldObj, Random rand, int x, int z) {
        for (int loopCount = 0; loopCount < this.veinAm; ++loopCount) {
            int temp1 = this.mPCalculateDensity(this.diameter, this.hDens);
            int temp2 = this.mineHeight + this.mPCalculateDensity(this.height, this.vDens);
            int temp3 = this.mPCalculateDensity(this.diameter, this.hDens);
            int posX = x + temp1;
            int posY = temp2;
            int posZ = z + temp3;
            if (!this.useMarcoVeins) {
                this.bODgenerate(worldObj, rand, posX, posY, posZ, this.veinSi);
                continue;
            }
            this.bODgenerateVein(worldObj, rand, posX, posY, posZ, this.veinSi);
        }
    }

    public boolean generate(World world, Random random, int x, int z, int min, int max) {
        mPChunkX = x;
        mPChunkZ = z;
        rand = random;
        worldObj = world;
        mineCount = 0;
        oreList.clear();
        this.mPBlock = this.minableBlock;
        if (!(mPChunkX == mPPrevX && mPChunkZ == mPPrevZ && mPPrevBlock == this.mPBlock && this.minableBlockMeta == mPPrevMeta || this.generateBeforeCheck())) {
            mPPrevX = mPChunkX;
            mPPrevZ = mPChunkZ;
            this.xChunk = mPChunkX;
            this.zChunk = mPChunkZ;
            mPPrevBlock = this.mPBlock;
            mPPrevMeta = this.minableBlockMeta;
            this.mineHeight = min + rand.nextInt(max - min);
            if (this.rarity == 1 || this.rarity > 0 && rand.nextInt(this.rarity) == 0) {
                this.createMine(worldObj, rand, this.xChunk, this.zChunk);
            }
        }
        return true;
    }

    public int mPCalculateDensity(int oreDistance, float oreDensity) {
        int loopCount = 0;
        int densityValuePassInner = 0;
        int densityValuePass = 0;
        oreDensity *= 0.01f;
        oreDensity = oreDensity * (float)(oreDistance >> 1) + 1.0f;
        densityValuePassInner = oreDistance / loopCount;
        densityValuePassInner += (oreDistance - densityValuePassInner * loopCount) / loopCount;
        densityValuePass = 0;
        for (loopCount = (int)oreDensity; loopCount > 0; --loopCount) {
            densityValuePass += rand.nextInt(densityValuePassInner);
        }
        return densityValuePass;
    }

    public boolean bODgenerateVein(World world, Random rand, int parX, int parY, int parZ, int xyz) {
        int posX = parX;
        int posY = parY;
        int posZ = parZ;
        int posX2 = 0;
        int posY2 = 0;
        int posZ2 = 0;
        int directionX = 0;
        int directionY = 0;
        int directionZ = 0;
        int directionX2 = 0;
        int directionY2 = 0;
        int directionZ2 = 0;
        int directionChange = 0;
        int directionChange2 = 0;
        int blocksToUse = xyz;
        int blocksToUse2 = 0;
        int blocksMade = 0;
        while (blocksMade <= blocksToUse) {
            blocksToUse2 = 1 + blocksToUse / 30;
            directionChange = rand.nextInt(6);
            directionX = rand.nextInt(2);
            directionY = rand.nextInt(2);
            directionZ = rand.nextInt(2);
            for (int blocksMade1 = 0; blocksMade1 <= blocksToUse2; ++blocksMade1) {
                TEOre te;
                boolean isCorrectMeta;
                if (directionX == 0 && directionChange != 1) {
                    posX += rand.nextInt(2);
                }
                if (directionX == 1 && directionChange != 1) {
                    posX -= rand.nextInt(2);
                }
                if (directionY == 0 && directionChange != 2) {
                    posY += rand.nextInt(2);
                }
                if (directionY == 1 && directionChange != 2) {
                    posY -= rand.nextInt(2);
                }
                if (directionZ == 0 && directionChange != 3) {
                    posZ += rand.nextInt(2);
                }
                if (directionZ == 1 && directionChange != 3) {
                    posZ -= rand.nextInt(2);
                }
                if (rand.nextInt(4) == 0) {
                    posX2 += rand.nextInt(2);
                    posY2 += rand.nextInt(2);
                    posZ2 += rand.nextInt(2);
                    posX2 -= rand.nextInt(2);
                    posY2 -= rand.nextInt(2);
                    posZ2 -= rand.nextInt(2);
                }
                if (rand.nextInt(3) == 0) {
                    posX2 = posX;
                    posY2 = posY;
                    posZ2 = posZ;
                    directionX2 = rand.nextInt(2);
                    directionY2 = rand.nextInt(2);
                    directionZ2 = rand.nextInt(2);
                    directionChange2 = rand.nextInt(6);
                    if (directionX2 == 0 && directionChange2 != 0) {
                        posX2 += rand.nextInt(2);
                    }
                    if (directionY2 == 0 && directionChange2 != 1) {
                        posY2 += rand.nextInt(2);
                    }
                    if (directionZ2 == 0 && directionChange2 != 2) {
                        posZ2 += rand.nextInt(2);
                    }
                    if (directionX2 == 1 && directionChange2 != 0) {
                        posX2 -= rand.nextInt(2);
                    }
                    if (directionY2 == 1 && directionChange2 != 1) {
                        posY2 -= rand.nextInt(2);
                    }
                    if (directionZ2 == 1 && directionChange2 != 2) {
                        posZ2 -= rand.nextInt(2);
                    }
                    for (int blocksMade2 = 0; blocksMade2 <= 1 + blocksToUse2 / 5; ++blocksMade2) {
                        TEOre te2;
                        if (directionX2 == 0 && directionChange2 != 0) {
                            posX2 += rand.nextInt(2);
                        }
                        if (directionY2 == 0 && directionChange2 != 1) {
                            posY2 += rand.nextInt(2);
                        }
                        if (directionZ2 == 0 && directionChange2 != 2) {
                            posZ2 += rand.nextInt(2);
                        }
                        if (directionX2 == 1 && directionChange2 != 0) {
                            posX2 -= rand.nextInt(2);
                        }
                        if (directionY2 == 1 && directionChange2 != 1) {
                            posY2 -= rand.nextInt(2);
                        }
                        if (directionZ2 == 1 && directionChange2 != 2) {
                            posZ2 -= rand.nextInt(2);
                        }
                        boolean isCorrectRockType = false;
                        boolean isCorrectMeta2 = false;
                        int localX = posX & 0xF;
                        int localZ = posZ & 0xF;
                        ChunkData data = TFC_Core.getCDM(world).getData(posX >> 4, posZ >> 4);
                        int hm = data != null ? data.heightmap[localX + localZ * 16] : 0;
                        posY = Math.min(255, posY + hm);
                        int m = world.func_72805_g(posX, posY, posZ);
                        Block b = world.func_147439_a(posX, posY, posZ);
                        isCorrectRockType = b == this.genInBlock;
                        boolean bl = isCorrectMeta2 = m == this.genInBlockMeta || this.genInBlockMeta == -1;
                        if (isCorrectRockType && isCorrectMeta2 && this.mPBlock != null && world.func_147465_d(posX, posY, posZ, this.mPBlock, this.minableBlockMeta, 2) && (te2 = (TEOre)world.func_147438_o(posX, posY, posZ)) != null) {
                            te2.baseBlockID = Block.func_149682_b((Block)b);
                            te2.baseBlockMeta = m;
                            te2.extraData = (byte)(this.grade + 8);
                        }
                        ++blocksMade;
                        ++blocksMade1;
                    }
                }
                int localX = posX & 0xF;
                int localZ = posZ & 0xF;
                ChunkData data = TFC_Core.getCDM(world).getData(posX >> 4, posZ >> 4);
                int hm = data != null ? data.heightmap[localX + localZ * 16] : 0;
                posY = Math.min(255, posY + hm);
                int m = world.func_72805_g(posX, posY, posZ);
                Block b = world.func_147439_a(posX, posY, posZ);
                boolean isCorrectRockType = b == this.genInBlock;
                boolean bl = isCorrectMeta = m == this.genInBlockMeta || this.genInBlockMeta == -1;
                if (isCorrectRockType && isCorrectMeta && this.mPBlock != null && world.func_147465_d(posX, posY, posZ, this.mPBlock, this.minableBlockMeta, 2) && (te = (TEOre)world.func_147438_o(posX, posY, posZ)) != null) {
                    te.baseBlockID = Block.func_149682_b((Block)b);
                    te.baseBlockMeta = m;
                    te.extraData = (byte)this.grade;
                }
                ++blocksMade;
            }
            posX = parX += rand.nextInt(3) - 1;
            posY = parY += rand.nextInt(3) - 1;
            posZ = parZ += rand.nextInt(3) - 1;
        }
        return true;
    }

    public boolean bODgenerate(World world, Random rand, int par3, int par4, int par5, int xyz) {
        this.numberOfBlocks = xyz;
        float var6 = rand.nextFloat() * (float)Math.PI;
        double var7 = (float)(par3 + 8) + MathHelper.func_76126_a((float)var6) * (float)this.numberOfBlocks / 8.0f;
        double var9 = (float)(par3 + 8) - MathHelper.func_76126_a((float)var6) * (float)this.numberOfBlocks / 8.0f;
        double var11 = (float)(par5 + 8) + MathHelper.func_76134_b((float)var6) * (float)this.numberOfBlocks / 8.0f;
        double var13 = (float)(par5 + 8) - MathHelper.func_76134_b((float)var6) * (float)this.numberOfBlocks / 8.0f;
        double var15 = par4 + rand.nextInt(3) - 2;
        double var17 = par4 + rand.nextInt(3) - 2;
        for (int var19 = 0; var19 <= this.numberOfBlocks; ++var19) {
            double var20 = var7 + (var9 - var7) * (double)var19 / (double)this.numberOfBlocks;
            double var22 = var15 + (var17 - var15) * (double)var19 / (double)this.numberOfBlocks;
            double var24 = var11 + (var13 - var11) * (double)var19 / (double)this.numberOfBlocks;
            double var26 = rand.nextDouble() * (double)this.numberOfBlocks / 16.0;
            double var28 = (double)(MathHelper.func_76126_a((float)((float)var19 * (float)Math.PI / (float)this.numberOfBlocks)) + 1.0f) * var26 + 1.0;
            double var30 = (double)(MathHelper.func_76126_a((float)((float)var19 * (float)Math.PI / (float)this.numberOfBlocks)) + 1.0f) * var26 + 1.0;
            int var32 = MathHelper.func_76128_c((double)(var20 - var28 / 2.0));
            int var33 = MathHelper.func_76128_c((double)(var22 - var30 / 2.0));
            int var34 = MathHelper.func_76128_c((double)(var24 - var28 / 2.0));
            int var35 = MathHelper.func_76128_c((double)(var20 + var28 / 2.0));
            int var36 = MathHelper.func_76128_c((double)(var22 + var30 / 2.0));
            int var37 = MathHelper.func_76128_c((double)(var24 + var28 / 2.0));
            for (int posX = var32; posX <= var35; ++posX) {
                double var39 = ((double)posX + 0.5 - var20) / (var28 / 2.0);
                if (!(var39 * var39 < 1.0)) continue;
                for (int posY = var33; posY <= var36; ++posY) {
                    double var42 = ((double)posY + 0.5 - var22) / (var30 / 2.0);
                    if (!(var39 * var39 + var42 * var42 < 1.0)) continue;
                    for (int posZ = var34; posZ <= var37; ++posZ) {
                        TEOre te;
                        boolean isCorrectMeta;
                        double var45 = ((double)posZ + 0.5 - var24) / (var28 / 2.0);
                        int localX = posX & 0xF;
                        int localZ = posZ & 0xF;
                        ChunkData data = TFC_Core.getCDM(world).getData(posX >> 4, posZ >> 4);
                        int hm = data != null ? data.heightmap[localX + localZ * 16] : 0;
                        posY = Math.min(255, posY + hm);
                        int m = world.func_72805_g(posX, posY, posZ);
                        Block b = world.func_147439_a(posX, posY, posZ);
                        boolean isCorrectRockType = b == this.genInBlock;
                        boolean bl = isCorrectMeta = m == this.genInBlockMeta || this.genInBlockMeta == -1;
                        if (!isCorrectRockType || !isCorrectMeta || !(var39 * var39 + var42 * var42 + var45 * var45 < 1.0) || this.mPBlock == null || !world.func_147465_d(posX, posY, posZ, this.mPBlock, this.minableBlockMeta, 2) || (te = (TEOre)world.func_147438_o(posX, posY, posZ)) == null) continue;
                        te.baseBlockID = Block.func_149682_b((Block)b);
                        te.baseBlockMeta = m;
                        te.extraData = (byte)this.grade;
                    }
                }
            }
        }
        return true;
    }

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        return false;
    }
}

