/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.WorldGen.Generators;

import com.bioxx.tfc.Core.TFC_Climate;
import com.bioxx.tfc.Core.Util.CaseInsensitiveHashMap;
import com.bioxx.tfc.WorldGen.DataLayer;
import com.bioxx.tfc.WorldGen.Generators.OreSpawnData;
import com.bioxx.tfc.WorldGen.Generators.WorldGenMinable;
import com.bioxx.tfc.WorldGen.TFCWorldChunkManager;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldGenOre
implements IWorldGenerator {
    private int chunkX;
    private int chunkZ;
    private World worldObj;
    private Random random;
    public static Map<String, OreSpawnData> oreList = new CaseInsensitiveHashMap<OreSpawnData>();

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        this.chunkX = chunkX *= 16;
        this.chunkZ = chunkZ *= 16;
        this.worldObj = world;
        this.random = rand;
        for (OreSpawnData osd : oreList.values()) {
            if (osd.type == 0) {
                if (osd.size == 0) {
                    this.oreSmall(osd.block, osd.meta, osd.base, osd.rarity, osd.min, osd.max, osd.vDensity, osd.hDensity);
                    continue;
                }
                if (osd.size == 1) {
                    this.oreMedium(osd.block, osd.meta, osd.base, osd.rarity, osd.min, osd.max, osd.vDensity, osd.hDensity);
                    continue;
                }
                if (osd.size != 2) continue;
                this.oreLarge(osd.block, osd.meta, osd.base, osd.rarity, osd.min, osd.max, osd.vDensity, osd.hDensity);
                continue;
            }
            if (osd.type != 1) continue;
            if (osd.size == 0) {
                this.oreSmallVein(osd.block, osd.meta, osd.base, osd.rarity, osd.min, osd.max, osd.vDensity, osd.hDensity);
                continue;
            }
            if (osd.size == 1) {
                this.oreMediumVein(osd.block, osd.meta, osd.base, osd.rarity, osd.min, osd.max, osd.vDensity, osd.hDensity);
                continue;
            }
            if (osd.size != 2) continue;
            this.oreLargeVein(osd.block, osd.meta, osd.base, osd.rarity, osd.min, osd.max, osd.vDensity, osd.hDensity);
        }
    }

    private void oreSmallVein(Block block, int meta, Map<Block, List<Integer>> baseRocks, int rarity, int min, int max, int vDensity, int hDensity) {
        WorldGenOre.createOreVein(block, meta, baseRocks, rarity, 20, 30, 5, 40, vDensity, hDensity, this.worldObj, this.random, this.chunkX, this.chunkZ, min, max);
    }

    private void oreMediumVein(Block block, int meta, Map<Block, List<Integer>> baseRocks, int rarity, int min, int max, int vDensity, int hDensity) {
        WorldGenOre.createOreVein(block, meta, baseRocks, rarity, 30, 40, 10, 60, vDensity, hDensity, this.worldObj, this.random, this.chunkX, this.chunkZ, min, max);
    }

    private void oreLargeVein(Block block, int meta, Map<Block, List<Integer>> baseRocks, int rarity, int min, int max, int vDensity, int hDensity) {
        WorldGenOre.createOreVein(block, meta, baseRocks, rarity, 60, 45, 20, 80, vDensity, hDensity, this.worldObj, this.random, this.chunkX, this.chunkZ, min, max);
    }

    private void oreSmall(Block block, int meta, Map<Block, List<Integer>> baseRocks, int rarity, int min, int max, int vDensity, int hDensity) {
        WorldGenOre.createOre(block, meta, baseRocks, rarity, 20, 30, 5, 80, vDensity, hDensity, this.worldObj, this.random, this.chunkX, this.chunkZ, min, max);
    }

    private void oreMedium(Block block, int meta, Map<Block, List<Integer>> baseRocks, int rarity, int min, int max, int vDensity, int hDensity) {
        WorldGenOre.createOre(block, meta, baseRocks, rarity, 30, 40, 10, 120, vDensity, hDensity, this.worldObj, this.random, this.chunkX, this.chunkZ, min, max);
    }

    private void oreLarge(Block block, int meta, Map<Block, List<Integer>> baseRocks, int rarity, int min, int max, int vDensity, int hDensity) {
        WorldGenOre.createOre(block, meta, baseRocks, rarity, 60, 40, 5, 120, vDensity, hDensity, this.worldObj, this.random, this.chunkX, this.chunkZ, min, max);
    }

    private static void createOre(Block block, int j, Map<Block, List<Integer>> layers, int rarity, int veinSize, int veinAmount, int height, int diameter, int vDensity, int hDensity, World world, Random rand, int chunkX, int chunkZ, int min, int max) {
        if (world.func_72959_q() instanceof TFCWorldChunkManager) {
            for (Block b : layers.keySet()) {
                for (int metadata : layers.get(b)) {
                    DataLayer rockLayer1 = TFC_Climate.getCacheManager(world).getRockLayerAt(chunkX, chunkZ, 0);
                    DataLayer rockLayer2 = TFC_Climate.getCacheManager(world).getRockLayerAt(chunkX, chunkZ, 1);
                    DataLayer rockLayer3 = TFC_Climate.getCacheManager(world).getRockLayerAt(chunkX, chunkZ, 2);
                    if ((rockLayer1.block != b || rockLayer1.data2 != metadata && metadata != -1) && (rockLayer2.block != b || rockLayer2.data2 != metadata && metadata != -1) && (rockLayer3.block != b || rockLayer3.data2 != metadata && metadata != -1)) continue;
                    int grade = rand.nextInt(100);
                    grade = grade < 20 ? 1 : (grade < 50 ? 2 : 0);
                    new WorldGenMinable(block, j, b, metadata, rarity, veinSize, veinAmount, height, diameter, vDensity, hDensity, false, grade).generate(world, rand, chunkX, chunkZ, min, max);
                }
            }
        }
    }

    private static void createOreVein(Block block, int j, Map<Block, List<Integer>> layers, int rarity, int veinSize, int veinAmount, int height, int diameter, int vDensity, int hDensity, World world, Random rand, int chunkX, int chunkZ, int min, int max) {
        if (world.func_72959_q() instanceof TFCWorldChunkManager) {
            for (Block b : layers.keySet()) {
                for (int metadata : layers.get(b)) {
                    DataLayer rockLayer1 = TFC_Climate.getCacheManager(world).getRockLayerAt(chunkX, chunkZ, 0);
                    DataLayer rockLayer2 = TFC_Climate.getCacheManager(world).getRockLayerAt(chunkX, chunkZ, 1);
                    DataLayer rockLayer3 = TFC_Climate.getCacheManager(world).getRockLayerAt(chunkX, chunkZ, 2);
                    if ((rockLayer1.block != b || rockLayer1.data2 != metadata && metadata != -1) && (rockLayer2.block != b || rockLayer2.data2 != metadata && metadata != -1) && (rockLayer3.block != b || rockLayer3.data2 != metadata && metadata != -1)) continue;
                    int grade = rand.nextInt(100);
                    grade = grade < 20 ? 1 : (grade < 50 ? 2 : 0);
                    new WorldGenMinable(block, j, b, metadata, rarity, veinSize, veinAmount, height, diameter, vDensity, hDensity, true, grade).generate(world, rand, chunkX, chunkZ, min, max);
                }
            }
        }
    }
}

