/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.WorldGen.MapGen;

import com.bioxx.tfc.Core.TFC_Climate;
import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.WorldGen.DataLayer;
import com.bioxx.tfc.WorldGen.MapGen.MapGenBaseTFC;
import com.bioxx.tfc.api.TFCBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class MapGenCavesTFC
extends MapGenBaseTFC {
    public void generate(IChunkProvider par1IChunkProvider, World par2World, int par3, int par4, Block[] idsBig, byte[] metaBig) {
        super.generate(par1IChunkProvider, par2World, par3, par4, idsBig);
    }

    protected void generateLargeCaveNode(long par1, int par3, int par4, Block[] par5, double par6, double par8, double par10) {
        this.generateCaveNode(par1, par3, par4, par5, par6, par8, par10, 1.0f + this.rand.nextFloat() * 6.0f, 0.0f, 0.0f, -1, -1, 0.5, 2.5);
    }

    protected void generateCaveNode(long seed, int chunkX, int chunkZ, Block[] idArray, double i, double j, double k, float par12, float par13, float par14, int par15, int par16, double par17, double width) {
        boolean var28;
        double worldX = chunkX * 16 + 8;
        double worldZ = chunkZ * 16 + 8;
        float var23 = 0.0f;
        float var24 = 0.0f;
        Random var25 = new Random(seed);
        if (par16 <= 0) {
            int var26 = this.range * 16 - 16;
            par16 = var26 - var25.nextInt(var26 / 4);
        }
        boolean var54 = false;
        if (par15 == -1) {
            par15 = par16 / 2;
            var54 = true;
        }
        int var27 = var25.nextInt(par16 / 2) + par16 / 4;
        boolean bl = var28 = var25.nextInt(6) == 0;
        while (par15 < par16) {
            float var33 = MathHelper.func_76134_b((float)par14);
            float var34 = MathHelper.func_76126_a((float)par14);
            i += (double)(MathHelper.func_76134_b((float)par13) * var33);
            j += (double)var34;
            k += (double)(MathHelper.func_76126_a((float)par13) * var33);
            par14 = var28 ? (par14 *= 0.92f) : (par14 *= 0.7f);
            par14 += var24 * 0.1f;
            par13 += var23 * 0.1f;
            var24 *= 0.9f;
            var23 *= 0.75f;
            var24 += (var25.nextFloat() - var25.nextFloat()) * var25.nextFloat() * 2.0f;
            var23 += (var25.nextFloat() - var25.nextFloat()) * var25.nextFloat() * 4.0f;
            if (!var54 && par15 == var27 && par12 > 1.0f && par16 > 0) {
                this.generateCaveNode(var25.nextLong(), chunkX, chunkZ, idArray, i, j, k, var25.nextFloat() * 0.5f + 0.5f, par13 - 1.5707964f, par14 / 3.0f, par15, par16, 1.0, width);
                this.generateCaveNode(var25.nextLong(), chunkX, chunkZ, idArray, i, j, k, var25.nextFloat() * 0.5f + 0.5f, par13 + 1.5707964f, par14 / 3.0f, par15, par16, 1.0, width);
                return;
            }
            double var29 = width + (double)(MathHelper.func_76126_a((float)((float)par15 * (float)Math.PI / (float)par16)) * par12 * 1.0f);
            double var31 = var29 * par17;
            if (var54 || var25.nextInt(4) != 0) {
                double var35 = i - worldX;
                double var37 = k - worldZ;
                double var39 = par16 - par15;
                double var41 = par12 + 2.0f + 16.0f;
                if (var35 * var35 + var37 * var37 - var39 * var39 > var41 * var41) {
                    return;
                }
                if (i >= worldX - 16.0 - var29 * 2.0 && k >= worldZ - 16.0 - var29 * 2.0 && i <= worldX + 16.0 + var29 * 2.0 && k <= worldZ + 16.0 + var29 * 2.0) {
                    int zCoord;
                    int xCoord;
                    int var55 = MathHelper.func_76128_c((double)(i - var29)) - chunkX * 16 - 1;
                    int var36 = MathHelper.func_76128_c((double)(i + var29)) - chunkX * 16 + 1;
                    int var57 = MathHelper.func_76128_c((double)(j - var31)) - 1;
                    int yCoord = MathHelper.func_76128_c((double)(j + var31)) + 1;
                    int var56 = MathHelper.func_76128_c((double)(k - var29)) - chunkZ * 16 - 1;
                    int var40 = MathHelper.func_76128_c((double)(k + var29)) - chunkZ * 16 + 1;
                    if (var55 < 0) {
                        var55 = 0;
                    }
                    if (var36 > 16) {
                        var36 = 16;
                    }
                    if (var57 < 1) {
                        var57 = 1;
                    }
                    if (yCoord > 250) {
                        yCoord = 250;
                    }
                    if (var56 < 0) {
                        var56 = 0;
                    }
                    if (var40 > 16) {
                        var40 = 16;
                    }
                    boolean var58 = false;
                    for (xCoord = var55; !var58 && xCoord < var36; ++xCoord) {
                        for (zCoord = var56; !var58 && zCoord < var40; ++zCoord) {
                            for (int y = yCoord + 1; !var58 && y >= var57 - 1; --y) {
                                int index = (xCoord * 16 + zCoord) * 256 + y;
                                if (y < 0 || y >= 256) continue;
                                if (idArray[index] == TFCBlocks.saltWaterStationary || idArray[index] == TFCBlocks.freshWaterStationary) {
                                    var58 = true;
                                }
                                if (y == var57 - 1 || xCoord == var55 || xCoord == var36 - 1 || zCoord == var56 || zCoord == var40 - 1) continue;
                                y = var57;
                            }
                        }
                    }
                    if (!var58) {
                        for (xCoord = var55; xCoord < var36; ++xCoord) {
                            double var59 = ((double)(xCoord + chunkX * 16) + 0.5 - i) / var29;
                            for (zCoord = var56; zCoord < var40; ++zCoord) {
                                double var46 = ((double)(zCoord + chunkZ * 16) + 0.5 - k) / var29;
                                int index = (xCoord * 16 + zCoord) * 256 + yCoord;
                                boolean isGrass = false;
                                Block grassBlock = Blocks.field_150350_a;
                                if (!(var59 * var59 + var46 * var46 < 1.0)) continue;
                                for (int var50 = yCoord - 1; var50 >= var57; --var50) {
                                    double var51 = ((double)var50 + 0.5 - j) / var31;
                                    if (var51 > -0.7 && var59 * var59 + var51 * var51 + var46 * var46 < 1.0) {
                                        if (TFC_Core.isGrass(idArray[index])) {
                                            grassBlock = idArray[index];
                                            isGrass = true;
                                        }
                                        if (TFC_Core.isSoil(idArray[index]) || TFC_Core.isRawStone(idArray[index])) {
                                            if (TFC_Core.isSoilOrGravel(idArray[index + 1])) {
                                                int upCount = 1;
                                                while (TFC_Core.isSoilOrGravel(idArray[index + upCount])) {
                                                    idArray[index + upCount] = Blocks.field_150350_a;
                                                    ++upCount;
                                                }
                                            }
                                            if (var50 < 10 && TFC_Climate.getStability(this.worldObj, (int)worldX, (int)worldZ) == 1) {
                                                idArray[index] = TFCBlocks.lava;
                                            } else {
                                                idArray[index] = Blocks.field_150350_a;
                                                if (isGrass && TFC_Core.isDirt(idArray[index - 1])) {
                                                    idArray[index - 1] = grassBlock;
                                                }
                                            }
                                        }
                                    }
                                    --index;
                                }
                            }
                        }
                        if (var54) break;
                    }
                }
            }
            ++par15;
        }
    }

    @Override
    protected void recursiveGenerate(World world, int par2, int par3, int par4, int par5, Block[] ids) {
        int var7 = this.rand.nextInt(this.rand.nextInt(this.rand.nextInt(40) + 1) + 1);
        double xCoord = par2 * 16 + this.rand.nextInt(16);
        double yCoord = this.rand.nextInt(1 + this.rand.nextInt(140)) + 60;
        double zCoord = par3 * 16 + this.rand.nextInt(16);
        float rain = TFC_Climate.getRainfall(world, (int)xCoord, 144, (int)zCoord);
        double width = 2.0;
        int caveChance = 35;
        if (rain > 1000.0f) {
            width += 0.5;
            caveChance -= 5;
        } else if (rain > 2000.0f) {
            width += 1.0;
            caveChance -= 10;
        } else if (rain < 1000.0f) {
            width -= 0.5;
            caveChance += 5;
        } else if (rain < 500.0f) {
            width -= 1.0;
            caveChance += 10;
        } else if (rain < 250.0f) {
            width -= 1.25;
            caveChance += 15;
        }
        if (TFC_Climate.getCacheManager(world) != null) {
            DataLayer rockLayer1 = TFC_Climate.getCacheManager(world).getRockLayerAt((int)xCoord, (int)zCoord, 0);
            Block layerID = rockLayer1.block;
            if (layerID == TFCBlocks.stoneIgEx) {
                width -= 0.4;
            } else if (layerID == TFCBlocks.stoneIgIn) {
                width -= 0.5;
            } else if (layerID == TFCBlocks.stoneSed) {
                width += 0.2;
                var7 += 5;
            } else if (layerID == TFCBlocks.stoneMM) {
                width += 0.3;
            }
        }
        width = yCoord < 32.0 ? (width *= 0.5) : (yCoord < 64.0 ? (width *= 0.65) : (yCoord < 96.0 ? (width *= 0.8) : (yCoord < 120.0 ? (width *= 0.9) : (width *= 0.5))));
        if (this.rand.nextInt(8) == 0) {
            width += 1.0;
        }
        if (this.rand.nextInt(caveChance) != 0) {
            var7 = 0;
        }
        for (int var8 = 0; var8 < var7; ++var8) {
            int var15 = 1;
            if (this.rand.nextInt(4) == 0) {
                this.generateLargeCaveNode(this.rand.nextLong(), par4, par5, ids, xCoord, yCoord, zCoord);
                var15 += this.rand.nextInt(4);
            }
            for (int var16 = 0; var16 < var15; ++var16) {
                float var17 = this.rand.nextFloat() * (float)Math.PI * 2.0f;
                float var18 = (this.rand.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float var19 = this.rand.nextFloat() * 2.0f + this.rand.nextFloat();
                if (this.rand.nextInt(10) == 0) {
                    var19 *= this.rand.nextFloat() * this.rand.nextFloat() * 3.0f + 1.0f;
                }
                this.generateCaveNode(this.rand.nextLong(), par4, par5, ids, xCoord, yCoord, zCoord, var19, var17, var18, 0, 0, 1.0, width);
            }
        }
    }
}

