/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.WorldGen;

import com.bioxx.tfc.Entities.Mobs.EntityCreeperTFC;
import com.bioxx.tfc.Entities.Mobs.EntityDeer;
import com.bioxx.tfc.Entities.Mobs.EntityEndermanTFC;
import com.bioxx.tfc.Entities.Mobs.EntityFishTFC;
import com.bioxx.tfc.Entities.Mobs.EntityPheasantTFC;
import com.bioxx.tfc.Entities.Mobs.EntitySkeletonTFC;
import com.bioxx.tfc.Entities.Mobs.EntitySlimeTFC;
import com.bioxx.tfc.Entities.Mobs.EntitySpiderTFC;
import com.bioxx.tfc.Entities.Mobs.EntitySquidTFC;
import com.bioxx.tfc.Entities.Mobs.EntityZombieTFC;
import com.bioxx.tfc.TerraFirmaCraft;
import com.bioxx.tfc.WorldGen.BiomeDecoratorTFC;
import com.bioxx.tfc.WorldGen.Generators.Trees.WorldGenAcaciaKoaTrees;
import com.bioxx.tfc.WorldGen.Generators.Trees.WorldGenCustomBigTree;
import com.bioxx.tfc.WorldGen.Generators.Trees.WorldGenCustomCedarTrees;
import com.bioxx.tfc.WorldGen.Generators.Trees.WorldGenCustomMapleShortTrees;
import com.bioxx.tfc.WorldGen.Generators.Trees.WorldGenCustomMapleTallTrees;
import com.bioxx.tfc.WorldGen.Generators.Trees.WorldGenCustomShortTrees;
import com.bioxx.tfc.WorldGen.Generators.Trees.WorldGenCustomTallTrees;
import com.bioxx.tfc.WorldGen.Generators.Trees.WorldGenCustomWillowTrees;
import com.bioxx.tfc.WorldGen.Generators.Trees.WorldGenDouglasFir;
import com.bioxx.tfc.WorldGen.Generators.Trees.WorldGenPineShort;
import com.bioxx.tfc.WorldGen.Generators.Trees.WorldGenPineTall;
import com.bioxx.tfc.WorldGen.Generators.Trees.WorldGenRedwoodXL;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;

public class TFCBiome
extends BiomeGenBase {
    public static float riverDepthMin = -0.5f;
    public static float riverDepthMax = -0.3f;
    public float temperatureTFC;
    public BiomeDecoratorTFC field_76760_I;
    public static TFCBiome[] biomeList = new TFCBiome[256];
    public static final TFCBiome OCEAN = new TFCBiome(0).setBiomeName("Ocean").setMinMaxHeight(-0.9f, 1.0E-5f).setBiomeColor(255);
    public static final TFCBiome RIVER = new TFCBiome(7).setBiomeName("River").setMinMaxHeight(riverDepthMin, riverDepthMax).setBiomeColor(0xFFFFFF);
    public static final TFCBiome HELL = new TFCBiome(8).setColor(0xFF0000).setBiomeName("Hell").setDisableRain().setTemperatureRainfall(2.0f, 0.0f);
    public static final TFCBiome BEACH = new TFCBiome(16).setColor(16440917).setBiomeName("Beach").setMinMaxHeight(0.01f, 0.02f).setBiomeColor(16758899);
    public static final TFCBiome GRAVEL_BEACH = new TFCBiome(17).setColor(16440917).setBiomeName("Gravel Beach").setMinMaxHeight(0.01f, 0.02f).setBiomeColor(9402723);
    public static final TFCBiome HIGH_HILLS = new TFCBiome(3).setBiomeName("High Hills").setMinMaxHeight(0.8f, 1.6f).setBiomeColor(282407);
    public static final TFCBiome PLAINS = new TFCBiome(1).setBiomeName("Plains").setMinMaxHeight(0.1f, 0.16f).setBiomeColor(6938528);
    public static final TFCBiome SWAMPLAND = new TFCBiome(6).setBiomeName("Swamp").setMinMaxHeight(-0.1f, 0.1f).setBiomeColor(2046251).setLilyPads(8).setWaterPlants(45);
    public static final TFCBiome HIGH_HILLS_EDGE = new TFCBiome(20).setBiomeName("High Hills Edge").setMinMaxHeight(0.2f, 0.4f).setBiomeColor(3188583);
    public static final TFCBiome ROLLING_HILLS = new TFCBiome(30).setBiomeName("Rolling Hills").setMinMaxHeight(0.1f, 0.4f).setBiomeColor(8893492);
    public static final TFCBiome MOUNTAINS = new TFCBiome(31).setBiomeName("Mountains").setMinMaxHeight(0.8f, 1.6f).setBiomeColor(7371104);
    public static final TFCBiome MOUNTAINS_EDGE = new TFCBiome(32).setBiomeName("Mountains Edge").setMinMaxHeight(0.4f, 0.8f).setBiomeColor(11713695);
    public static final TFCBiome HIGH_PLAINS = new TFCBiome(35).setBiomeName("High Plains").setMinMaxHeight(0.4f, 0.43f).setBiomeColor(10920988);
    public static final TFCBiome DEEP_OCEAN = new TFCBiome(36).setBiomeName("Deep Ocean").setMinMaxHeight(-1.5f, 1.0E-5f).setBiomeColor(918874);
    public static final TFCBiome LAKE = new TFCBiome(2).setBiomeName("Lake").setMinMaxHeight(-0.5f, 0.001f).setBiomeColor(4886174).setLilyPads(2);
    protected static WorldGenAcaciaKoaTrees worldGenAcaciaKoaTrees;
    protected static WorldGenCustomTallTrees worldGenAshTallTrees;
    protected static WorldGenCustomTallTrees worldGenAspenTallTrees;
    protected static WorldGenCustomTallTrees worldGenBirchTallTrees;
    protected static WorldGenCustomTallTrees worldGenChestnutTallTrees;
    protected static WorldGenDouglasFir worldGenDouglasFirTallTrees;
    protected static WorldGenCustomTallTrees worldGenHickoryTallTrees;
    protected static WorldGenCustomMapleTallTrees worldGenMapleTallTrees;
    protected static WorldGenCustomTallTrees worldGenOakTallTrees;
    protected static WorldGenPineTall worldGenPineTallTrees;
    protected static WorldGenRedwoodXL worldGenRedwoodTallTrees;
    protected static WorldGenCustomTallTrees worldGenSpruceTallTrees;
    protected static WorldGenCustomTallTrees worldGenSycamoreTallTrees;
    protected static WorldGenCustomCedarTrees worldGenWhiteCedarTallTrees;
    protected static WorldGenCustomTallTrees worldGenWhiteElmTallTrees;
    protected static WorldGenCustomShortTrees worldGenAshShortTrees;
    protected static WorldGenCustomShortTrees worldGenAspenShortTrees;
    protected static WorldGenCustomShortTrees worldGenBirchShortTrees;
    protected static WorldGenCustomShortTrees worldGenChestnutShortTrees;
    protected static WorldGenDouglasFir worldGenDouglasFirShortTrees;
    protected static WorldGenCustomShortTrees worldGenHickoryShortTrees;
    protected static WorldGenCustomMapleShortTrees worldGenMapleShortTrees;
    protected static WorldGenCustomShortTrees worldGenOakShortTrees;
    protected static WorldGenPineShort worldGenPineShortTrees;
    protected static WorldGenRedwoodXL worldGenRedwoodShortTrees;
    protected static WorldGenCustomShortTrees worldGenSpruceShortTrees;
    protected static WorldGenCustomShortTrees worldGenSycamoreShortTrees;
    protected static WorldGenCustomShortTrees worldGenWhiteElmShortTrees;
    protected static WorldGenCustomWillowTrees worldGenWillowShortTrees;
    protected int biomeColor;

    public TFCBiome(int par1) {
        super(par1);
        this.field_76752_A = Blocks.field_150349_c;
        this.field_76753_B = Blocks.field_150346_d;
        this.field_76748_D = 0.1f;
        this.field_76749_E = 0.3f;
        this.temperatureTFC = 0.5f;
        this.field_76751_G = 0.5f;
        this.field_76761_J = new ArrayList();
        this.field_76762_K = new ArrayList();
        this.field_76755_L = new ArrayList();
        worldGenAcaciaKoaTrees = new WorldGenAcaciaKoaTrees(false, 0);
        worldGenAshTallTrees = new WorldGenCustomTallTrees(false, 7);
        worldGenAspenTallTrees = new WorldGenCustomTallTrees(false, 1);
        worldGenBirchTallTrees = new WorldGenCustomTallTrees(false, 2);
        worldGenChestnutTallTrees = new WorldGenCustomTallTrees(false, 3);
        worldGenDouglasFirTallTrees = new WorldGenDouglasFir(false, 4, true);
        worldGenHickoryTallTrees = new WorldGenCustomTallTrees(false, 5);
        worldGenMapleTallTrees = new WorldGenCustomMapleTallTrees(false, 6);
        worldGenOakTallTrees = new WorldGenCustomTallTrees(false, 0);
        worldGenPineTallTrees = new WorldGenPineTall(8);
        worldGenRedwoodTallTrees = new WorldGenRedwoodXL(false);
        worldGenSpruceTallTrees = new WorldGenCustomTallTrees(false, 10);
        worldGenSycamoreTallTrees = new WorldGenCustomTallTrees(false, 11);
        worldGenWhiteCedarTallTrees = new WorldGenCustomCedarTrees(false, 12);
        worldGenWhiteElmTallTrees = new WorldGenCustomTallTrees(false, 13);
        worldGenAshShortTrees = new WorldGenCustomShortTrees(false, 7);
        worldGenAspenShortTrees = new WorldGenCustomShortTrees(false, 1);
        worldGenBirchShortTrees = new WorldGenCustomShortTrees(false, 2);
        worldGenChestnutShortTrees = new WorldGenCustomShortTrees(false, 3);
        worldGenDouglasFirShortTrees = new WorldGenDouglasFir(false, 4, false);
        worldGenHickoryShortTrees = new WorldGenCustomShortTrees(false, 5);
        worldGenMapleShortTrees = new WorldGenCustomMapleShortTrees(false, 6);
        worldGenOakShortTrees = new WorldGenCustomShortTrees(false, 0);
        worldGenPineShortTrees = new WorldGenPineShort(false, 8);
        worldGenRedwoodShortTrees = new WorldGenRedwoodXL(false);
        worldGenSpruceShortTrees = new WorldGenCustomShortTrees(false, 10);
        worldGenSycamoreShortTrees = new WorldGenCustomShortTrees(false, 11);
        worldGenWhiteElmShortTrees = new WorldGenCustomShortTrees(false, 13);
        worldGenWillowShortTrees = new WorldGenCustomWillowTrees(false, 14);
        this.field_76762_K.clear();
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityPheasantTFC.class, 16, 0, 0));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityPheasantTFC.class, 2, 1, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityDeer.class, 1, 1, 4));
        this.field_76755_L.clear();
        switch (par1) {
            case 0: {
                this.field_76755_L.add(new BiomeGenBase.SpawnListEntry(EntitySquidTFC.class, 8, 1, 1));
                break;
            }
            case 2: {
                this.field_76755_L.add(new BiomeGenBase.SpawnListEntry(EntityFishTFC.class, 7, 1, 2));
                this.field_76755_L.add(new BiomeGenBase.SpawnListEntry(EntityFishTFC.class, 12, 0, 0));
                break;
            }
        }
        this.field_76761_J.clear();
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntitySpiderTFC.class, 5, 1, 1));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityZombieTFC.class, 10, 2, 4));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntitySkeletonTFC.class, 8, 1, 1));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityCreeperTFC.class, 3, 1, 2));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntitySlimeTFC.class, 8, 1, 2));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityEndermanTFC.class, 1, 1, 2));
        TFCBiome.biomeList[par1] = this;
        this.field_76760_I = this.createBiomeDecorator();
    }

    public int getBiomeColor() {
        return this.biomeColor;
    }

    public TFCBiome setBiomeColor(int c) {
        this.biomeColor = c;
        return this;
    }

    public BiomeDecoratorTFC createBiomeDecorator() {
        return new BiomeDecoratorTFC(this);
    }

    public void func_76728_a(World par1World, Random par2Random, int par3, int par4) {
        this.field_76760_I.func_150512_a(par1World, par2Random, this, par3, par4);
    }

    public TFCBiome setMinMaxHeight(float par1, float par2) {
        this.field_76748_D = par1 - 2.7f;
        this.field_76749_E = par2 - 2.7f;
        return this;
    }

    public TFCBiome setTemperatureRainfall(float par1, float par2) {
        this.temperatureTFC = par1;
        this.field_76751_G = par2;
        return this;
    }

    public TFCBiome setBiomeName(String par1Str) {
        this.field_76791_y = par1Str;
        return this;
    }

    public TFCBiome setWaterMult(int par1) {
        this.field_76759_H = par1;
        return this;
    }

    public TFCBiome setColor(int par1) {
        this.field_76790_z = par1;
        return this;
    }

    public TFCBiome setDisableRain() {
        this.field_76765_S = false;
        return this;
    }

    public static WorldGenerator getTreeGen(int i, Boolean j) {
        Random r = new Random();
        switch (i) {
            case 7: {
                if (j.booleanValue()) {
                    return r.nextInt(20) == 0 ? new WorldGenCustomBigTree(false, 7) : worldGenAshTallTrees;
                }
                return worldGenAshShortTrees;
            }
            case 1: {
                if (j.booleanValue()) {
                    return r.nextInt(20) == 0 ? new WorldGenCustomBigTree(false, 1) : worldGenAspenTallTrees;
                }
                return worldGenAspenShortTrees;
            }
            case 2: {
                if (j.booleanValue()) {
                    return r.nextInt(20) == 0 ? new WorldGenCustomBigTree(false, 2) : worldGenBirchTallTrees;
                }
                return worldGenBirchShortTrees;
            }
            case 3: {
                if (j.booleanValue()) {
                    return r.nextInt(20) == 0 ? new WorldGenCustomBigTree(false, 3) : worldGenChestnutTallTrees;
                }
                return worldGenChestnutShortTrees;
            }
            case 4: {
                if (j.booleanValue()) {
                    return worldGenDouglasFirTallTrees;
                }
                return worldGenDouglasFirShortTrees;
            }
            case 5: {
                if (j.booleanValue()) {
                    return r.nextInt(20) == 0 ? new WorldGenCustomBigTree(false, 5) : worldGenHickoryTallTrees;
                }
                return worldGenHickoryShortTrees;
            }
            case 6: {
                if (j.booleanValue()) {
                    return r.nextInt(20) == 0 ? new WorldGenCustomBigTree(false, 6) : worldGenMapleTallTrees;
                }
                return worldGenMapleShortTrees;
            }
            case 0: {
                if (j.booleanValue()) {
                    return r.nextInt(20) == 0 ? new WorldGenCustomBigTree(false, 0) : worldGenOakTallTrees;
                }
                return worldGenOakShortTrees;
            }
            case 8: {
                if (j.booleanValue()) {
                    return worldGenPineTallTrees;
                }
                return worldGenPineShortTrees;
            }
            case 9: {
                if (j.booleanValue()) {
                    return worldGenRedwoodTallTrees;
                }
                return worldGenRedwoodShortTrees;
            }
            case 10: {
                if (j.booleanValue()) {
                    return r.nextInt(20) == 0 ? new WorldGenCustomBigTree(false, 10) : worldGenSpruceTallTrees;
                }
                return worldGenSpruceShortTrees;
            }
            case 11: {
                if (j.booleanValue()) {
                    return r.nextInt(20) == 0 ? new WorldGenCustomBigTree(false, 11) : worldGenSycamoreTallTrees;
                }
                return worldGenSycamoreShortTrees;
            }
            case 12: {
                return worldGenWhiteCedarTallTrees;
            }
            case 13: {
                if (j.booleanValue()) {
                    return r.nextInt(20) == 0 ? new WorldGenCustomBigTree(false, 13) : worldGenWhiteElmTallTrees;
                }
                return worldGenWhiteElmShortTrees;
            }
            case 14: {
                return worldGenWillowShortTrees;
            }
            case 15: {
                return new WorldGenCustomShortTrees(false, 15);
            }
            case 16: {
                return worldGenAcaciaKoaTrees;
            }
        }
        return null;
    }

    public static TFCBiome getBiome(int id) {
        if (biomeList[id] == null) {
            TerraFirmaCraft.LOG.warn("Biome ID is null: " + id);
        }
        if (id >= 0 && id <= biomeList.length && biomeList[id] != null) {
            return biomeList[id];
        }
        TerraFirmaCraft.LOG.warn("Biome ID is out of bounds: " + id + ", defaulting to 0 (Ocean)");
        return OCEAN;
    }

    public static TFCBiome getBiomeByName(String name) {
        for (int i = 0; i < TFCBiome.getBiomeGenArray().length; ++i) {
            String n;
            if (TFCBiome.getBiomeGenArray()[i] == null || !(n = TFCBiome.getBiomeGenArray()[i].field_76791_y.toLowerCase()).equalsIgnoreCase(name)) continue;
            return TFCBiome.getBiomeGenArray()[i];
        }
        return null;
    }

    public static TFCBiome[] getBiomeGenArray() {
        return (TFCBiome[])biomeList.clone();
    }

    public TFCBiome setLilyPads(int i) {
        this.field_76760_I.lilyPadPerChunk = i;
        return this;
    }

    public TFCBiome setWaterPlants(int i) {
        this.field_76760_I.waterPlantsPerChunk = i;
        return this;
    }
}

