/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.api.Crafting;

import com.bioxx.tfc.Food.ItemFoodTFC;
import com.bioxx.tfc.api.Crafting.BarrelRecipe;
import com.bioxx.tfc.api.Food;
import java.util.Stack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class BarrelAlcoholRecipe
extends BarrelRecipe {
    public BarrelAlcoholRecipe(ItemStack inputItem, FluidStack inputFluid, ItemStack outIS, FluidStack outputFluid) {
        super(inputItem, inputFluid, outIS, outputFluid);
        this.sealTime = 72;
    }

    @Override
    public Stack<ItemStack> getResult(ItemStack inIS, FluidStack inFS, int sealedTime) {
        Stack<ItemStack> result = new Stack<ItemStack>();
        result.push(this.recipeOutIS);
        return result;
    }

    @Override
    public FluidStack getResultFluid(ItemStack inIS, FluidStack inFS, int sealedTime) {
        float amt = (float)inFS.amount / 10000.0f;
        FluidStack out = this.recipeOutFluid.copy();
        if (out.tag == null) {
            out.tag = new NBTTagCompound();
        }
        float weight = Food.getWeight(inIS);
        out.tag.func_74776_a("potency", weight / Food.getWeight(this.recipeIS) / amt);
        return this.recipeOutFluid;
    }

    @Override
    public Boolean matches(ItemStack itemstack, FluidStack inFluid) {
        if (this.recipeIS.func_77942_o()) {
            if (itemstack == null || !itemstack.func_77942_o()) {
                return false;
            }
            if (this.recipeIS.func_77973_b() instanceof ItemFoodTFC) {
                if (!(itemstack.func_77973_b() instanceof ItemFoodTFC)) {
                    return false;
                }
                float recipeWeight = Food.getWeight(this.recipeIS);
                float itemstackWeight = Food.getWeight(itemstack);
                float percent = itemstackWeight / (recipeWeight * ((float)inFluid.amount / (float)this.recipeFluid.amount));
                if (percent < 0.25f || percent > 0.75f) {
                    return false;
                }
            }
        }
        return OreDictionary.itemMatches((ItemStack)this.recipeIS, (ItemStack)itemstack, (boolean)false) && inFluid.isFluidEqual(this.recipeFluid);
    }
}

