/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.api.Crafting;

import com.bioxx.tfc.api.Crafting.BarrelRecipe;
import java.util.Stack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BarrelLiquidToLiquidRecipe
extends BarrelRecipe {
    public FluidStack inputfluid;

    public BarrelLiquidToLiquidRecipe(FluidStack fluidInBarrel, FluidStack inputfluid, FluidStack outputFluid) {
        super(null, fluidInBarrel, null, outputFluid);
        this.inputfluid = inputfluid;
    }

    @Override
    public Boolean matches(ItemStack item, FluidStack fluid) {
        FluidStack itemLiquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)item);
        if (this.recipeFluid != null && this.recipeFluid.isFluidEqual(fluid) && itemLiquid != null && itemLiquid.isFluidEqual(this.inputfluid)) {
            if (10000 - fluid.amount < itemLiquid.amount) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Stack<ItemStack> getResult(ItemStack inIS, FluidStack inFS, int sealedTime) {
        Stack<ItemStack> result = new Stack<ItemStack>();
        if (inIS != null) {
            result.push(inIS.func_77973_b().getContainerItem(inIS));
        } else {
            result.push(null);
        }
        return result;
    }

    @Override
    public FluidStack getResultFluid(ItemStack inIS, FluidStack inFS, int sealedTime) {
        if (this.recipeOutFluid != null) {
            FluidStack fs = this.recipeOutFluid.copy();
            FluidStack itemLiquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)inIS);
            fs.amount = !this.removesLiquid ? inFS.amount + itemLiquid.amount : fs.amount * inFS.amount / this.recipeFluid.amount;
            return fs;
        }
        return null;
    }

    public FluidStack getInputfluid() {
        return this.inputfluid;
    }
}

