/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.api.Crafting;

import com.bioxx.tfc.TileEntities.TEBarrel;
import com.bioxx.tfc.api.Crafting.BarrelPreservativeRecipe;
import com.bioxx.tfc.api.Crafting.BarrelRecipe;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class BarrelManager {
    private static final BarrelManager INSTANCE = new BarrelManager();
    private List<BarrelRecipe> recipes = new ArrayList<BarrelRecipe>();
    private List<BarrelPreservativeRecipe> preservativeRecipes = new ArrayList<BarrelPreservativeRecipe>();

    public static final BarrelManager getInstance() {
        return INSTANCE;
    }

    private BarrelManager() {
    }

    public void addRecipe(BarrelRecipe recipe) {
        this.recipes.add(recipe);
    }

    public void addPreservative(BarrelPreservativeRecipe recipe) {
        this.preservativeRecipes.add(recipe);
    }

    public BarrelRecipe findMatchingRecipe(ItemStack item, FluidStack fluid, boolean sealed, int techLevel) {
        Iterator<BarrelRecipe> iterator = this.recipes.iterator();
        while (iterator.hasNext()) {
            BarrelRecipe recipe;
            BarrelRecipe br = recipe = iterator.next();
            if (fluid == null || !br.matches(item, fluid).booleanValue() || br.sealedRecipe != sealed || br.minTechLevel > techLevel) continue;
            return br;
        }
        return null;
    }

    public BarrelPreservativeRecipe findMatchingPreservativeRepice(TEBarrel barrel, ItemStack item, FluidStack fluid, boolean sealed) {
        for (BarrelPreservativeRecipe recipe : this.preservativeRecipes) {
            if (!recipe.checkForPreservation(barrel, fluid, item, sealed)) continue;
            return recipe;
        }
        return null;
    }

    public List<BarrelRecipe> getRecipes() {
        return this.recipes;
    }

    public List<BarrelPreservativeRecipe> getPreservatives() {
        return this.preservativeRecipes;
    }
}

