/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.api.Crafting;

import com.bioxx.tfc.api.Crafting.LoomRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class LoomManager {
    private static final LoomManager INSTANCE = new LoomManager();
    private List<LoomRecipe> recipes = new ArrayList<LoomRecipe>();
    private Map<LoomRecipe, ResourceLocation> textures = new HashMap<LoomRecipe, ResourceLocation>();

    public static final LoomManager getInstance() {
        return INSTANCE;
    }

    private LoomManager() {
    }

    public void addRecipe(LoomRecipe recipe, ResourceLocation rl) {
        this.recipes.add(recipe);
        if (recipe != null) {
            this.textures.remove(recipe);
            this.textures.put(recipe, rl);
        }
    }

    public LoomRecipe findMatchingRecipe(ItemStack item) {
        Iterator<LoomRecipe> iterator = this.recipes.iterator();
        while (iterator.hasNext()) {
            LoomRecipe recipe;
            LoomRecipe lr = recipe = iterator.next();
            if (item == null || !lr.matches(item).booleanValue()) continue;
            return lr;
        }
        return null;
    }

    public LoomRecipe findMatchingResult(ItemStack item) {
        Iterator<LoomRecipe> iterator = this.recipes.iterator();
        while (iterator.hasNext()) {
            LoomRecipe recipe;
            LoomRecipe lr = recipe = iterator.next();
            if (item == null || !lr.resultMatches(item).booleanValue()) continue;
            return lr;
        }
        return null;
    }

    public boolean hasPotentialRecipes(ItemStack item) {
        Iterator<LoomRecipe> iterator = this.recipes.iterator();
        while (iterator.hasNext()) {
            LoomRecipe recipe;
            LoomRecipe lr = recipe = iterator.next();
            if (item == null || !lr.partiallyMatches(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public LoomRecipe findPotentialRecipes(ItemStack item) {
        Iterator<LoomRecipe> iterator = this.recipes.iterator();
        while (iterator.hasNext()) {
            LoomRecipe recipe;
            LoomRecipe lr = recipe = iterator.next();
            if (item == null || !lr.partiallyMatches(item).booleanValue()) continue;
            return lr;
        }
        return null;
    }

    public ResourceLocation findMatchingTexture(LoomRecipe recipe) {
        ResourceLocation rl = null;
        if (recipe != null && (rl = this.textures.remove(recipe)) != null) {
            this.textures.put(recipe, rl);
            return rl;
        }
        return null;
    }

    public List<LoomRecipe> getRecipes() {
        return this.recipes;
    }
}

