/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.api;

import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.Core.TFC_Time;
import com.bioxx.tfc.TerraFirmaCraft;
import com.bioxx.tfc.api.Interfaces.IFood;
import com.bioxx.tfc.api.Util.Helper;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class Food {
    public static final String DECAY_TAG = "foodDecay";
    public static final String DECAY_TIMER_TAG = "decayTimer";
    public static final String DECAY_RATE_TAG = "decayRate";
    public static final String WEIGHT_TAG = "foodWeight";
    public static final String PROCESSING_TAG = "Processing Tag";
    public static final String BRINED_TAG = "Brined";
    public static final String PICKLED_TAG = "Pickled";
    public static final String SALTED_TAG = "Salted";
    public static final String COOKED_TAG = "Cooked";
    public static final String COOKED_PROFILE_TAG = "CookedProfile";
    public static final String FUEL_PROFILE_TAG = "FuelProfile";
    public static final String DRIED_TAG = "Dried";
    public static final String SMOKE_COUNTER_TAG = "SmokeCounter";
    public static final String SWEET_MOD_TAG = "tasteSweetMod";
    public static final String SOUR_MOD_TAG = "tasteSourMod";
    public static final String SALTY_MOD_TAG = "tasteSaltyMod";
    public static final String BITTER_MOD_TAG = "tasteBitterMod";
    public static final String UMAMI_MOD_TAG = "tasteUmamiMod";
    public static final String MEAL_SKILL_TAG = "mealSkill";
    public static final String INFUSION_TAG = "Infusion";
    public static final String FOOD_GROUP_TAG = "FG";
    public static final int DRYHOURS = 4;
    public static final int SMOKEHOURS = 12;

    private static NBTTagCompound getProcTag(ItemStack is) {
        if (is.func_77942_o() && is.func_77978_p().func_74764_b(PROCESSING_TAG)) {
            return (NBTTagCompound)is.func_77978_p().func_74781_a(PROCESSING_TAG);
        }
        return new NBTTagCompound();
    }

    private static void setProcTag(ItemStack is, NBTTagCompound nbt) {
        if (!is.func_77942_o()) {
            is.func_77982_d(new NBTTagCompound());
        }
        is.func_77978_p().func_74782_a(PROCESSING_TAG, (NBTBase)nbt);
    }

    private static NBTTagCompound getNBT(ItemStack is) {
        if (is.func_77942_o()) {
            return is.func_77978_p();
        }
        TerraFirmaCraft.LOG.error(TFC_Core.translate("error.error") + " " + is.func_77977_a() + " " + TFC_Core.translate("error.NBT") + " " + TFC_Core.translate("error.Contact"));
        return new NBTTagCompound();
    }

    public static boolean areEqual(ItemStack is1, ItemStack is2) {
        return Food.isBrined(is1) == Food.isBrined(is2) && Food.isPickled(is1) == Food.isPickled(is2) && Food.isCooked(is1) == Food.isCooked(is2) && Food.isDried(is1) == Food.isDried(is2) && Food.isSalted(is1) == Food.isSalted(is2) && (Food.isInfused(is1) && Food.isInfused(is2) && Food.getInfusion(is1).equals(Food.getInfusion(is2)) || !Food.isInfused(is1) && !Food.isInfused(is2)) && (Food.isSmoked(is1) && Food.isSmoked(is2) && Food.isSameSmoked(is1, is2) || !Food.isSmoked(is1) && !Food.isSmoked(is2));
    }

    public static boolean isBrined(ItemStack is) {
        NBTTagCompound nbt = Food.getProcTag(is);
        return nbt.func_74764_b(BRINED_TAG) && nbt.func_74767_n(BRINED_TAG);
    }

    public static void setBrined(ItemStack is, boolean value) {
        NBTTagCompound nbt = Food.getProcTag(is);
        nbt.func_74757_a(BRINED_TAG, value);
        Food.setProcTag(is, nbt);
    }

    public static boolean isPickled(ItemStack is) {
        NBTTagCompound nbt = Food.getProcTag(is);
        return nbt.func_74764_b(PICKLED_TAG) && nbt.func_74767_n(PICKLED_TAG);
    }

    public static void setPickled(ItemStack is, boolean value) {
        NBTTagCompound nbt = Food.getProcTag(is);
        nbt.func_74757_a(PICKLED_TAG, value);
        Food.setProcTag(is, nbt);
    }

    public static boolean isSalted(ItemStack is) {
        NBTTagCompound nbt = Food.getProcTag(is);
        return nbt.func_74764_b(SALTED_TAG) && nbt.func_74767_n(SALTED_TAG);
    }

    public static void setSalted(ItemStack is, boolean value) {
        NBTTagCompound nbt = Food.getProcTag(is);
        nbt.func_74757_a(SALTED_TAG, value);
        Food.setProcTag(is, nbt);
    }

    public static boolean isCooked(ItemStack is) {
        NBTTagCompound nbt = Food.getProcTag(is);
        return nbt.func_74764_b(COOKED_TAG) && nbt.func_74760_g(COOKED_TAG) > 600.0f;
    }

    public static float getCooked(ItemStack is) {
        NBTTagCompound nbt = Food.getProcTag(is);
        if (nbt.func_74764_b(COOKED_TAG)) {
            return nbt.func_74760_g(COOKED_TAG);
        }
        return 0.0f;
    }

    public static void setCooked(ItemStack is, float value) {
        NBTTagCompound nbt = Food.getProcTag(is);
        nbt.func_74776_a(COOKED_TAG, value);
        Food.setProcTag(is, nbt);
    }

    public static int[] getCookedProfile(ItemStack is) {
        NBTTagCompound nbt = Food.getProcTag(is);
        if (nbt.func_74764_b(COOKED_PROFILE_TAG)) {
            return nbt.func_74759_k(COOKED_PROFILE_TAG);
        }
        return new int[]{0, 0, 0, 0, 0};
    }

    public static void setCookedProfile(ItemStack is, int[] value) {
        NBTTagCompound nbt = Food.getProcTag(is);
        nbt.func_74783_a(COOKED_PROFILE_TAG, value);
        Food.setProcTag(is, nbt);
    }

    public static int[] getFuelProfile(ItemStack is) {
        NBTTagCompound nbt = Food.getProcTag(is);
        if (nbt.func_74764_b(FUEL_PROFILE_TAG)) {
            return nbt.func_74759_k(FUEL_PROFILE_TAG);
        }
        return new int[]{0, 0, 0, 0, 0};
    }

    public static void setFuelProfile(ItemStack is, int[] value) {
        NBTTagCompound nbt = Food.getProcTag(is);
        nbt.func_74783_a(FUEL_PROFILE_TAG, value);
        Food.setProcTag(is, nbt);
    }

    public static boolean isSmoked(ItemStack is) {
        NBTTagCompound nbt = Food.getProcTag(is);
        return nbt.func_74764_b(FUEL_PROFILE_TAG) && !Food.isSameSmoked(Food.getFuelProfile(is), new int[]{0, 0, 0, 0, 0});
    }

    public static boolean isSameSmoked(ItemStack is1, ItemStack is2) {
        int[] f2;
        int[] f1 = Food.getFuelProfile(is1);
        return f1[0] == (f2 = Food.getFuelProfile(is2))[0] && f1[1] == f2[1] && f1[2] == f2[2] && f1[3] == f2[3] && f1[4] == f2[4];
    }

    public static boolean isSameSmoked(int[] f1, int[] f2) {
        return f1[0] == f2[0] && f1[1] == f2[1] && f1[2] == f2[2] && f1[3] == f2[3] && f1[4] == f2[4];
    }

    public static void setDecay(ItemStack is, float value) {
        NBTTagCompound nbt = Food.getNBT(is);
        nbt.func_74776_a(DECAY_TAG, Helper.roundNumber(value, 10000.0f));
        if (value > Food.getWeight(is)) {
            is.field_77994_a = 0;
        }
    }

    public static float getDecay(ItemStack is) {
        NBTTagCompound nbt = Food.getNBT(is);
        if (nbt.func_74764_b(DECAY_TAG)) {
            return nbt.func_74760_g(DECAY_TAG);
        }
        return 0.0f;
    }

    public static void setDecayTimer(ItemStack is, int value) {
        NBTTagCompound nbt = Food.getNBT(is);
        nbt.func_74768_a(DECAY_TIMER_TAG, value);
    }

    public static int getDecayTimer(ItemStack is) {
        NBTTagCompound nbt = Food.getNBT(is);
        if (nbt.func_74764_b(DECAY_TIMER_TAG)) {
            return nbt.func_74762_e(DECAY_TIMER_TAG);
        }
        return (int)TFC_Time.getTotalHours();
    }

    public static void setWeight(ItemStack is, float value) {
        NBTTagCompound nbt = Food.getNBT(is);
        nbt.func_74776_a(WEIGHT_TAG, Helper.roundNumber(value, 100.0f));
        if (Food.getDecay(is) > value || value <= 0.0f) {
            is.field_77994_a = 0;
        }
    }

    public static float getWeight(ItemStack is) {
        NBTTagCompound nbt = Food.getNBT(is);
        if (nbt.func_74764_b(WEIGHT_TAG)) {
            return nbt.func_74760_g(WEIGHT_TAG);
        }
        return 0.0f;
    }

    public static boolean isDried(ItemStack is) {
        NBTTagCompound nbt = Food.getProcTag(is);
        return nbt.func_74764_b(DRIED_TAG) && nbt.func_74765_d(DRIED_TAG) >= 4;
    }

    public static short getDried(ItemStack is) {
        NBTTagCompound nbt = Food.getProcTag(is);
        if (nbt.func_74764_b(DRIED_TAG)) {
            return nbt.func_74765_d(DRIED_TAG);
        }
        return 0;
    }

    public static void setDried(ItemStack is, int value) {
        NBTTagCompound nbt = Food.getProcTag(is);
        nbt.func_74777_a(DRIED_TAG, (short)value);
        Food.setProcTag(is, nbt);
    }

    public static short getSmokeCounter(ItemStack is) {
        NBTTagCompound nbt = Food.getProcTag(is);
        if (nbt.func_74764_b(SMOKE_COUNTER_TAG)) {
            return nbt.func_74765_d(SMOKE_COUNTER_TAG);
        }
        return 0;
    }

    public static void setSmokeCounter(ItemStack is, int value) {
        NBTTagCompound nbt = Food.getProcTag(is);
        nbt.func_74777_a(SMOKE_COUNTER_TAG, (short)value);
        Food.setProcTag(is, nbt);
    }

    public static int getCookedColorMultiplier(ItemStack is) {
        float cookedLevel = Food.getCooked(is);
        int r = 255 - (int)(160.0f * (Math.max(cookedLevel - 600.0f, 0.0f) / 600.0f));
        int b = 255 - (int)(160.0f * (Math.max(cookedLevel - 600.0f, 0.0f) / 600.0f));
        int g = 255 - (int)(160.0f * (Math.max(cookedLevel - 600.0f, 0.0f) / 600.0f));
        return (r << 16) + (b << 8) + g;
    }

    public static void setSweetMod(ItemStack is, int val) {
        NBTTagCompound nbt = Food.getNBT(is);
        nbt.func_74768_a(SWEET_MOD_TAG, val);
    }

    public static int getSweetMod(ItemStack is) {
        NBTTagCompound nbt = Food.getNBT(is);
        if (nbt.func_74764_b(SWEET_MOD_TAG)) {
            return nbt.func_74762_e(SWEET_MOD_TAG);
        }
        return 0;
    }

    public static void setSourMod(ItemStack is, int val) {
        NBTTagCompound nbt = Food.getNBT(is);
        nbt.func_74768_a(SOUR_MOD_TAG, val);
    }

    public static int getSourMod(ItemStack is) {
        NBTTagCompound nbt = Food.getNBT(is);
        if (nbt.func_74764_b(SOUR_MOD_TAG)) {
            return nbt.func_74762_e(SOUR_MOD_TAG);
        }
        return 0;
    }

    public static void setSaltyMod(ItemStack is, int val) {
        NBTTagCompound nbt = Food.getNBT(is);
        nbt.func_74768_a(SALTY_MOD_TAG, val);
    }

    public static int getSaltyMod(ItemStack is) {
        NBTTagCompound nbt = Food.getNBT(is);
        if (nbt.func_74764_b(SALTY_MOD_TAG)) {
            return nbt.func_74762_e(SALTY_MOD_TAG);
        }
        return 0;
    }

    public static void setBitterMod(ItemStack is, int val) {
        NBTTagCompound nbt = Food.getNBT(is);
        nbt.func_74768_a(BITTER_MOD_TAG, val);
    }

    public static int getBitterMod(ItemStack is) {
        NBTTagCompound nbt = Food.getNBT(is);
        if (nbt.func_74764_b(BITTER_MOD_TAG)) {
            return nbt.func_74762_e(BITTER_MOD_TAG);
        }
        return 0;
    }

    public static void setSavoryMod(ItemStack is, int val) {
        NBTTagCompound nbt = Food.getNBT(is);
        nbt.func_74768_a(UMAMI_MOD_TAG, val);
    }

    public static int getSavoryMod(ItemStack is) {
        NBTTagCompound nbt = Food.getNBT(is);
        if (nbt.func_74764_b(UMAMI_MOD_TAG)) {
            return nbt.func_74762_e(UMAMI_MOD_TAG);
        }
        return 0;
    }

    public static void adjustFlavor(ItemStack is, Random r) {
        Food.setSweetMod(is, r.nextInt(17) - 8);
        Food.setSourMod(is, r.nextInt(17) - 8);
        Food.setSaltyMod(is, r.nextInt(17) - 8);
        Food.setBitterMod(is, r.nextInt(17) - 8);
        Food.setSavoryMod(is, r.nextInt(17) - 8);
    }

    public static void setMealSkill(ItemStack is, int val) {
        NBTTagCompound nbt = Food.getNBT(is);
        nbt.func_74768_a(MEAL_SKILL_TAG, val);
    }

    public static int getMealSkill(ItemStack is) {
        NBTTagCompound nbt = Food.getNBT(is);
        if (nbt.func_74764_b(MEAL_SKILL_TAG)) {
            return nbt.func_74762_e(MEAL_SKILL_TAG);
        }
        return 0;
    }

    public static boolean hasMealSkill(ItemStack is) {
        NBTTagCompound nbt = Food.getNBT(is);
        return nbt.func_74764_b(MEAL_SKILL_TAG);
    }

    public static int[] getFoodTasteProfile(ItemStack is) {
        int[] profile = new int[5];
        if (is != null && is.func_77973_b() instanceof IFood) {
            profile[0] = ((IFood)is.func_77973_b()).getTasteSweet(is);
            profile[1] = ((IFood)is.func_77973_b()).getTasteSour(is);
            profile[2] = ((IFood)is.func_77973_b()).getTasteSalty(is);
            profile[3] = ((IFood)is.func_77973_b()).getTasteBitter(is);
            profile[4] = ((IFood)is.func_77973_b()).getTasteSavory(is);
        }
        return profile;
    }

    public static boolean isInfused(ItemStack is) {
        NBTTagCompound nbt = Food.getNBT(is);
        return nbt.func_74764_b(INFUSION_TAG);
    }

    public static String getInfusion(ItemStack is) {
        NBTTagCompound nbt = Food.getNBT(is);
        if (nbt.func_74764_b(INFUSION_TAG)) {
            return nbt.func_74779_i(INFUSION_TAG);
        }
        return null;
    }

    public static void setInfusion(ItemStack is, String val) {
        NBTTagCompound nbt = Food.getNBT(is);
        nbt.func_74778_a(INFUSION_TAG, val);
    }

    public static void setFoodGroups(ItemStack is, int[] val) {
        NBTTagCompound nbt = Food.getNBT(is);
        nbt.func_74783_a(FOOD_GROUP_TAG, val);
    }

    public static int[] getFoodGroups(ItemStack is) {
        NBTTagCompound nbt = Food.getNBT(is);
        if (nbt.func_74764_b(FOOD_GROUP_TAG)) {
            return nbt.func_74759_k(FOOD_GROUP_TAG);
        }
        return new int[]{-1, -1, -1, -1};
    }

    public static void setDecayRate(ItemStack is, float val) {
        NBTTagCompound nbt = Food.getNBT(is);
        nbt.func_74776_a(DECAY_RATE_TAG, val);
    }

    public static float getDecayRate(ItemStack is) {
        NBTTagCompound nbt = Food.getNBT(is);
        if (nbt.func_74764_b(DECAY_RATE_TAG)) {
            return nbt.func_74760_g(DECAY_RATE_TAG);
        }
        return 1.0f;
    }
}

