/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.api;

import com.bioxx.tfc.api.Enums.EnumFoodGroup;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;

public class FoodRegistry {
    private static final FoodRegistry INSTANCE = new FoodRegistry();
    private int proteinCount;
    private Map<Integer, Item> proteinMap = new HashMap<Integer, Item>();
    private int vegetableCount = 10000;
    private Map<Integer, Item> vegetableMap = new HashMap<Integer, Item>();
    private int fruitCount = 20000;
    private Map<Integer, Item> fruitMap = new HashMap<Integer, Item>();
    private int grainCount = 30000;
    private Map<Integer, Item> grainMap = new HashMap<Integer, Item>();
    private int dairyCount = 40000;
    private Map<Integer, Item> dairyMap = new HashMap<Integer, Item>();

    public static final FoodRegistry getInstance() {
        return INSTANCE;
    }

    private FoodRegistry() {
    }

    public int registerFood(EnumFoodGroup efg, Item i) {
        switch (efg) {
            case Protein: {
                this.proteinMap.put(this.proteinCount, i);
                return this.proteinCount++;
            }
            case Vegetable: {
                this.vegetableMap.put(this.vegetableCount, i);
                return this.vegetableCount++;
            }
            case Fruit: {
                this.fruitMap.put(this.fruitCount, i);
                return this.fruitCount++;
            }
            case Grain: {
                this.grainMap.put(this.grainCount, i);
                return this.grainCount++;
            }
            case Dairy: {
                this.dairyMap.put(this.dairyCount, i);
                return this.dairyCount++;
            }
        }
        return -1;
    }

    public Item getFood(int id) {
        if (this.proteinMap.containsKey(id)) {
            return this.proteinMap.get(id);
        }
        if (this.vegetableMap.containsKey(id)) {
            return this.vegetableMap.get(id);
        }
        if (this.fruitMap.containsKey(id)) {
            return this.fruitMap.get(id);
        }
        if (this.grainMap.containsKey(id)) {
            return this.grainMap.get(id);
        }
        if (this.dairyMap.containsKey(id)) {
            return this.dairyMap.get(id);
        }
        return null;
    }

    public EnumFoodGroup getFoodGroup(int id) {
        if (this.proteinMap.containsKey(id)) {
            return EnumFoodGroup.Protein;
        }
        if (this.vegetableMap.containsKey(id)) {
            return EnumFoodGroup.Vegetable;
        }
        if (this.fruitMap.containsKey(id)) {
            return EnumFoodGroup.Fruit;
        }
        if (this.grainMap.containsKey(id)) {
            return EnumFoodGroup.Grain;
        }
        if (this.dairyMap.containsKey(id)) {
            return EnumFoodGroup.Dairy;
        }
        return EnumFoodGroup.None;
    }
}

