/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.api;

import com.bioxx.tfc.api.HeatIndex;
import com.bioxx.tfc.api.TFC_ItemHeat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class HeatRegistry {
    private static final HeatRegistry INSTANCE = new HeatRegistry();
    private List<HeatIndex> heatList = new ArrayList<HeatIndex>();

    public static final HeatRegistry getInstance() {
        return INSTANCE;
    }

    private HeatRegistry() {
    }

    public void addIndex(HeatIndex index) {
        this.heatList.add(index);
    }

    public List<HeatIndex> getHeatList() {
        return this.heatList;
    }

    public HeatIndex findMatchingIndex(ItemStack input) {
        for (int k = 0; k < this.heatList.size(); ++k) {
            HeatIndex tempIndex = this.heatList.get(k);
            if (!tempIndex.matches(input)) continue;
            return tempIndex;
        }
        return null;
    }

    public Boolean getIsLiquid(ItemStack is) {
        HeatIndex hi = INSTANCE.findMatchingIndex(is);
        if (hi != null && is.func_77942_o()) {
            float temp = 0.0f;
            if (is.func_77978_p().func_74764_b("temperature")) {
                temp = is.func_77978_p().func_74760_g("temperature");
            }
            return temp >= hi.meltTemp;
        }
        return false;
    }

    public float getMeltingPoint(ItemStack is) {
        HeatIndex hi = this.findMatchingIndex(is);
        if (hi != null) {
            return hi.meltTemp;
        }
        return -1.0f;
    }

    public Boolean isTemperatureWeldable(ItemStack is) {
        HeatIndex index;
        if (TFC_ItemHeat.hasTemp(is) && (index = INSTANCE.findMatchingIndex(is)) != null) {
            float temp = TFC_ItemHeat.getTemp(is);
            return temp < index.meltTemp && (double)temp > (double)index.meltTemp * 0.8;
        }
        return false;
    }

    public Boolean isTemperatureWorkable(ItemStack is) {
        HeatIndex index;
        if (TFC_ItemHeat.hasTemp(is) && (index = INSTANCE.findMatchingIndex(is)) != null) {
            float temp = TFC_ItemHeat.getTemp(is);
            return temp < index.meltTemp && (double)temp > (double)index.meltTemp * 0.6;
        }
        return false;
    }

    public Boolean isTemperatureDanger(ItemStack is) {
        HeatIndex index;
        if (TFC_ItemHeat.hasTemp(is) && (index = INSTANCE.findMatchingIndex(is)) != null) {
            float temp = TFC_ItemHeat.getTemp(is);
            return temp < index.meltTemp && (double)temp > (double)index.meltTemp * 0.9;
        }
        return false;
    }
}

