/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.api;

import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.api.HeatIndex;
import com.bioxx.tfc.api.HeatRegistry;
import com.bioxx.tfc.api.Metal;
import com.bioxx.tfc.api.TFCOptions;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TFC_ItemHeat {
    public static String getHeatColor(float temp, float meltTemp) {
        String phrase = "";
        if (temp < 80.0f) {
            phrase = TFC_Core.translate("gui.ItemHeat.Warming");
            if ((double)temp > 16.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 32.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 48.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 64.0) {
                phrase = phrase + "\u2605";
            }
        } else if (temp >= 80.0f && temp < 210.0f) {
            phrase = TFC_Core.translate("gui.ItemHeat.Hot");
            if ((double)temp > 106.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 132.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 158.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 184.0) {
                phrase = phrase + "\u2605";
            }
        } else if (temp >= 210.0f && temp < 480.0f) {
            phrase = TFC_Core.translate("gui.ItemHeat.VeryHot");
            if ((double)temp > 264.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 318.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 372.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 426.0) {
                phrase = phrase + "\u2605";
            }
        } else if (temp >= 480.0f && temp < 580.0f) {
            phrase = "\u00a74" + TFC_Core.translate("gui.ItemHeat.FaintRed");
            if ((double)temp > 500.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 520.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 540.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 560.0) {
                phrase = phrase + "\u2605";
            }
        } else if (temp >= 580.0f && temp < 730.0f) {
            phrase = "\u00a74" + TFC_Core.translate("gui.ItemHeat.DarkRed");
            if ((double)temp > 610.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 640.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 670.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 700.0) {
                phrase = phrase + "\u2605";
            }
        } else if (temp >= 730.0f && temp < 930.0f) {
            phrase = "\u00a7c" + TFC_Core.translate("gui.ItemHeat.BrightRed");
            if ((double)temp > 770.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 810.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 850.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 890.0) {
                phrase = phrase + "\u2605";
            }
        } else if (temp >= 930.0f && temp < 1100.0f) {
            phrase = "\u00a76" + TFC_Core.translate("gui.ItemHeat.Orange");
            if ((double)temp > 964.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 998.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 1032.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 1066.0) {
                phrase = phrase + "\u2605";
            }
        } else if (temp >= 1100.0f && temp < 1300.0f) {
            phrase = "\u00a7e" + TFC_Core.translate("gui.ItemHeat.Yellow");
            if ((double)temp > 1140.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 1180.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 1220.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 1260.0) {
                phrase = phrase + "\u2605";
            }
        } else if (temp >= 1300.0f && temp < 1400.0f) {
            phrase = "\u00a7e" + TFC_Core.translate("gui.ItemHeat.YellowWhite");
            if ((double)temp > 1320.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 1340.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 1360.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 1380.0) {
                phrase = phrase + "\u2605";
            }
        } else if (temp >= 1400.0f && temp < 1500.0f) {
            phrase = "\u00a7f" + TFC_Core.translate("gui.ItemHeat.White");
            if ((double)temp > 1420.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 1440.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 1460.0) {
                phrase = phrase + "\u2605";
            }
            if ((double)temp > 1480.0) {
                phrase = phrase + "\u2605";
            }
        } else if (temp >= 1500.0f) {
            phrase = "\u00a7f" + TFC_Core.translate("gui.ItemHeat.BrilliantWhite");
        }
        if (temp > meltTemp) {
            phrase = phrase + "\u00a7f - " + TFC_Core.translate("gui.ItemHeat.Liquid");
        }
        return phrase;
    }

    public static String getHeatColorFood(float temp, float meltTemp) {
        if (temp < meltTemp) {
            if (temp < meltTemp * 0.1f) {
                return TFC_Core.translate("gui.FoodHeat.Cold");
            }
            if (temp >= meltTemp * 0.1f && temp < meltTemp * 0.4f) {
                return "\u00a74" + TFC_Core.translate("gui.FoodHeat.Warm");
            }
            if (temp >= meltTemp * 0.4f && temp < meltTemp * 0.8f) {
                return "\u00a74" + TFC_Core.translate("gui.ItemHeat.Hot");
            }
            return "\u00a74" + TFC_Core.translate("gui.ItemHeat.VeryHot");
        }
        return TFC_Core.translate("gui.ClearSlot");
    }

    public static String getHeatColorTorch(float temp, float meltTemp) {
        if (temp < meltTemp) {
            if (temp > 0.0f && temp < meltTemp * 0.8f) {
                return TFC_Core.translate("gui.Torch.CatchingFire");
            }
            if (temp >= meltTemp * 0.8f) {
                return "\u00a74" + TFC_Core.translate("gui.Torch.Lit");
            }
        }
        return TFC_Core.translate("gui.ClearSlot");
    }

    public static Boolean getIsLiquid(ItemStack is) {
        return TFC_ItemHeat.getTemp(is) >= TFC_ItemHeat.isCookable(is);
    }

    public static float isCookable(ItemStack is) {
        HeatRegistry manager = HeatRegistry.getInstance();
        if (is != null && manager != null) {
            HeatIndex hi = manager.findMatchingIndex(is);
            if (hi != null) {
                return hi.meltTemp;
            }
            return -1.0f;
        }
        return -1.0f;
    }

    public static float getSpecificHeat(ItemStack is) {
        HeatRegistry manager = HeatRegistry.getInstance();
        if (is != null && manager != null) {
            HeatIndex hi = manager.findMatchingIndex(is);
            if (hi != null) {
                return hi.specificHeat;
            }
            return 1.0f;
        }
        return 1.0f;
    }

    public static float isCookable(Metal m) {
        HeatRegistry manager = HeatRegistry.getInstance();
        if (manager != null) {
            HeatIndex hi = manager.findMatchingIndex(new ItemStack(m.meltedItem));
            if (hi != null) {
                return hi.meltTemp;
            }
            return -1.0f;
        }
        return -1.0f;
    }

    public static float getTemp(ItemStack is) {
        if (TFC_ItemHeat.hasTemp(is)) {
            return is.func_77978_p().func_74760_g("temperature");
        }
        return 0.0f;
    }

    public static boolean hasTemp(ItemStack is) {
        return is != null && is.func_77942_o() && is.func_77978_p().func_74764_b("temperature");
    }

    public static float getTempIncrease(ItemStack is) {
        int debugBump = 0;
        if (TFCOptions.enableDebugMode) {
            debugBump = 2;
        }
        return TFCOptions.tempIncreaseMultiplier * TFC_ItemHeat.getSpecificHeat(is) + (float)debugBump;
    }

    public static float getTempDecrease(ItemStack is) {
        if (TFCOptions.enableDebugMode) {
            return 0.0f;
        }
        return TFCOptions.tempDecreaseMultiplier * TFC_ItemHeat.getSpecificHeat(is);
    }

    public static void handleItemHeat(ItemStack is) {
        if (is != null && is.func_77942_o()) {
            NBTTagCompound comp = is.func_77978_p();
            if (TFC_ItemHeat.hasTemp(is)) {
                float temp = TFC_ItemHeat.getTemp(is);
                if (temp > 0.0f) {
                    comp.func_74776_a("temperature", temp -= TFC_ItemHeat.getTempDecrease(is));
                }
                if (temp <= 0.0f) {
                    comp.func_82580_o("temperature");
                }
                if (comp.func_82582_d()) {
                    is.field_77990_d = null;
                }
            }
        }
    }

    public static Boolean setTemp(ItemStack is, float temp) {
        if (is != null) {
            if (is.func_77942_o()) {
                is.func_77978_p().func_74776_a("temperature", temp);
            } else if (TFC_ItemHeat.isCookable(is) != -1.0f) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74776_a("temperature", temp);
                is.func_77982_d(nbt);
            }
        } else {
            return false;
        }
        if (temp <= 0.0f) {
            TFC_ItemHeat.removeTempTag(is);
        }
        return true;
    }

    public static void removeTempTag(ItemStack is) {
        if (is.func_77942_o() && is.func_77978_p().func_74764_b("temperature")) {
            is.func_77978_p().func_82580_o("temperature");
        }
        if (is.func_77942_o() && is.func_77978_p().func_82582_d()) {
            is.field_77990_d = null;
        }
    }
}

