/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.api.TileEntities;

import com.bioxx.tfc.TileEntities.NetworkTileEntity;
import com.bioxx.tfc.api.HeatIndex;
import com.bioxx.tfc.api.HeatRegistry;
import com.bioxx.tfc.api.TFC_ItemHeat;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TEFireEntity
extends NetworkTileEntity {
    public int airFromBellows;
    public float fireTemp;
    public int maxFireTempScale = 2000;
    public int fuelTimeLeft;
    public int fuelBurnTemp;
    public int fuelTasteProfile;
    public static final int AIRTOADD = 200;

    public void careForInventorySlot(ItemStack is) {
        HeatRegistry manager;
        HeatIndex index;
        if (is != null && (index = (manager = HeatRegistry.getInstance()).findMatchingIndex(is)) != null && index.hasOutput()) {
            float temp = TFC_ItemHeat.getTemp(is);
            temp = this.fireTemp > temp ? (temp += TFC_ItemHeat.getTempIncrease(is)) : (temp -= TFC_ItemHeat.getTempDecrease(is));
            TFC_ItemHeat.setTemp(is, temp);
        }
    }

    public void receiveAirFromBellows() {
        if (this.airFromBellows < 600) {
            this.airFromBellows += 200;
        }
        if (this.airFromBellows > 600) {
            this.airFromBellows = 600;
        }
    }

    public void keepTempToRange() {
        if (this.fireTemp > (float)this.getMaxTemp()) {
            this.fireTemp = this.getMaxTemp();
        } else if (this.fireTemp < 0.0f) {
            this.fireTemp = 0.0f;
        }
    }

    public int getMaxTemp() {
        return this.fuelBurnTemp + this.airFromBellows;
    }

    public int getTemperatureScaled(int s) {
        return (int)(this.fireTemp * (float)s / (float)this.maxFireTempScale);
    }

    protected float handleTemp() {
        if (this.fuelTimeLeft > 0) {
            --this.fuelTimeLeft;
            if (this.airFromBellows > 0) {
                --this.fuelTimeLeft;
            }
        } else if (this.fuelTimeLeft < 0) {
            this.fuelTimeLeft = 0;
        }
        if (this.fuelTimeLeft > 0) {
            return this.fuelBurnTemp + this.airFromBellows;
        }
        return 0.0f;
    }

    public void handleAirReduction() {
        if (this.airFromBellows > 0) {
            --this.airFromBellows;
        }
    }

    public void handleTempFlux(float desiredTemp) {
        if (this.fireTemp < desiredTemp) {
            this.fireTemp = this.airFromBellows == 0 ? (this.fireTemp += 1.0f) : (this.fireTemp += 2.0f);
        } else if (this.fireTemp > desiredTemp && desiredTemp == 0.0f) {
            this.fireTemp = this.airFromBellows == 0 ? (this.fireTemp -= 1.0f) : (float)((double)this.fireTemp - 0.5);
        }
        this.keepTempToRange();
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74776_a("temperature", this.fireTemp);
        nbt.func_74768_a("fuelTime", this.fuelTimeLeft);
        nbt.func_74768_a("fuelTemp", this.fuelBurnTemp);
        nbt.func_74768_a("bellowsAir", this.airFromBellows);
        nbt.func_74768_a("fuelTasteProfile", this.fuelTasteProfile);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.fireTemp = nbt.func_74760_g("temperature");
        this.fuelTimeLeft = nbt.func_74762_e("fuelTime");
        this.fuelBurnTemp = nbt.func_74762_e("fuelTemp");
        this.airFromBellows = nbt.func_74762_e("airBellows");
        this.fuelTasteProfile = nbt.func_74762_e("fuelTasteProfile");
    }

    @Override
    public void handleInitPacket(NBTTagCompound nbt) {
    }

    @Override
    public void handleDataPacket(NBTTagCompound nbt) {
    }

    @Override
    public void createDataNBT(NBTTagCompound nbt) {
    }

    @Override
    public void createInitNBT(NBTTagCompound nbt) {
    }
}

