/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.lib.gui.override;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuiChatRPGHud
extends GuiNewChat {
    protected static final Splitter NEWLINE_SPLITTER = Splitter.on((char)'\n');
    protected static final Joiner NEWLINE_STRING_JOINER = Joiner.on((String)"\\n");
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final Minecraft field_146247_f;
    protected final List<String> field_146248_g = Lists.newArrayList();
    protected final List<ChatLine> field_146252_h = Lists.newArrayList();
    private final List<ChatLine> drawnChatLines = Lists.newArrayList();
    protected int field_146250_j;
    protected boolean field_146251_k;
    protected int xOffset = 0;
    protected int yOffset = 0;

    public GuiChatRPGHud(Minecraft mc) {
        super(mc);
        this.field_146247_f = mc;
    }

    public void clearChatMessages(boolean p_146231_1_) {
        this.getDrawnChatLines().clear();
        this.field_146252_h.clear();
        if (p_146231_1_) {
            this.field_146248_g.clear();
        }
    }

    public void func_146227_a(IChatComponent chatComponent) {
        this.func_146234_a(chatComponent, 0);
    }

    public void func_146234_a(IChatComponent chatComponent, int chatLineId) {
        this.setChatLine(chatComponent, chatLineId, this.field_146247_f.field_71456_v.func_73834_c(), false);
        LOGGER.info("[CHAT] {}", new Object[]{NEWLINE_STRING_JOINER.join(NEWLINE_SPLITTER.split((CharSequence)chatComponent.func_150260_c()))});
    }

    private void setChatLine(IChatComponent chatComponent, int chatLineId, int updateCounter, boolean displayOnly) {
        if (chatLineId != 0) {
            this.func_146242_c(chatLineId);
        }
        int i = MathHelper.func_76141_d((float)((float)this.func_146228_f() / this.func_146244_h()));
        List list = GuiUtilRenderComponents.func_178908_a((IChatComponent)chatComponent, (int)i, (FontRenderer)this.field_146247_f.field_71466_p, (boolean)false, (boolean)false);
        boolean flag = this.func_146241_e();
        for (IChatComponent itextcomponent : list) {
            if (flag && this.field_146250_j > 0) {
                this.field_146251_k = true;
                this.func_146229_b(1);
            }
            this.getDrawnChatLines().add(0, new ChatLine(updateCounter, itextcomponent, chatLineId));
        }
        while (this.getDrawnChatLines().size() > 100) {
            this.getDrawnChatLines().remove(this.getDrawnChatLines().size() - 1);
        }
        if (!displayOnly) {
            this.field_146252_h.add(0, new ChatLine(updateCounter, chatComponent, chatLineId));
            while (this.field_146252_h.size() > 100) {
                this.field_146252_h.remove(this.field_146252_h.size() - 1);
            }
        }
    }

    public void func_146245_b() {
        this.getDrawnChatLines().clear();
        this.func_146240_d();
        for (int i = this.field_146252_h.size() - 1; i >= 0; --i) {
            ChatLine chatline = this.field_146252_h.get(i);
            this.setChatLine(chatline.func_151461_a(), chatline.func_74539_c(), chatline.func_74540_b(), true);
        }
    }

    public List<String> func_146238_c() {
        return this.field_146248_g;
    }

    public void func_146239_a(String message) {
        if (this.field_146248_g.isEmpty() || !this.field_146248_g.get(this.field_146248_g.size() - 1).equals(message)) {
            this.field_146248_g.add(message);
        }
    }

    public void func_146240_d() {
        this.field_146250_j = 0;
        this.field_146251_k = false;
    }

    public void func_146229_b(int amount) {
        this.field_146250_j += amount;
        int i = this.getDrawnChatLines().size();
        if (this.field_146250_j > i - this.func_146232_i()) {
            this.field_146250_j = i - this.func_146232_i();
        }
        if (this.field_146250_j <= 0) {
            this.field_146250_j = 0;
            this.field_146251_k = false;
        }
    }

    @Nullable
    public IChatComponent func_146236_a(int mouseX, int mouseY) {
        if (!this.func_146241_e()) {
            return null;
        }
        ScaledResolution scaledresolution = new ScaledResolution(this.field_146247_f);
        int i = scaledresolution.func_78325_e();
        float f = this.func_146244_h();
        int j = mouseX / i - 2;
        int k = mouseY / i - 40;
        j = MathHelper.func_76141_d((float)((float)j / f));
        k = MathHelper.func_76141_d((float)((float)k / f));
        if (j >= 0 && k >= 0) {
            int l = Math.min(this.func_146232_i(), this.getDrawnChatLines().size());
            if (j <= MathHelper.func_76141_d((float)((float)this.func_146228_f() / this.func_146244_h())) && k < this.field_146247_f.field_71466_p.field_78288_b * l + l) {
                int i1 = k / this.field_146247_f.field_71466_p.field_78288_b + this.field_146250_j;
                if (i1 >= 0 && i1 < this.getDrawnChatLines().size()) {
                    ChatLine chatline = this.getDrawnChatLines().get(i1);
                    int j1 = 0;
                    for (IChatComponent itextcomponent : chatline.func_151461_a()) {
                        if (!(itextcomponent instanceof ChatComponentText) || (j1 += this.field_146247_f.field_71466_p.func_78256_a(GuiUtilRenderComponents.func_178909_a((String)((ChatComponentText)itextcomponent).func_150265_g(), (boolean)false))) <= j) continue;
                        return itextcomponent;
                    }
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public boolean func_146241_e() {
        return this.field_146247_f.field_71462_r instanceof GuiChat;
    }

    public void func_146242_c(int id) {
        Iterator<ChatLine> iterator = this.getDrawnChatLines().iterator();
        while (iterator.hasNext()) {
            ChatLine chatline = iterator.next();
            if (chatline.func_74539_c() != id) continue;
            iterator.remove();
        }
        iterator = this.field_146252_h.iterator();
        while (iterator.hasNext()) {
            ChatLine chatline1 = iterator.next();
            if (chatline1.func_74539_c() != id) continue;
            iterator.remove();
            break;
        }
    }

    public int func_146228_f() {
        return GuiChatRPGHud.calculateChatboxWidth(this.field_146247_f.field_71474_y.field_96692_F);
    }

    public int func_146246_g() {
        return GuiChatRPGHud.calculateChatboxHeight(this.func_146241_e() ? this.field_146247_f.field_71474_y.field_96694_H : this.field_146247_f.field_71474_y.field_96693_G);
    }

    public float func_146244_h() {
        return this.field_146247_f.field_71474_y.field_96691_E;
    }

    public static int calculateChatboxWidth(float scale) {
        return MathHelper.func_76141_d((float)(scale * 280.0f + 40.0f));
    }

    public static int calculateChatboxHeight(float scale) {
        return MathHelper.func_76141_d((float)(scale * 160.0f + 20.0f));
    }

    public int func_146232_i() {
        return this.func_146246_g() / 9;
    }

    public List<ChatLine> getDrawnChatLines() {
        return this.drawnChatLines;
    }

    public List<ChatLine> getChatLines() {
        return this.field_146252_h;
    }

    public int getScrollPos() {
        return this.field_146250_j;
    }

    public boolean isScrolled() {
        return this.field_146251_k;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(int xOffset) {
        this.xOffset = xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(int yOffset) {
        this.yOffset = yOffset;
    }
}

