/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui.hud.element.hotbar;

import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.EntityLivingBase;
import net.spellcraftgaming.lib.GameData;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElement;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;

public class HudElementHealthMountHotbar
extends HudElement {
    public HudElementHealthMountHotbar() {
        super(HudElementType.HEALTH_MOUNT, 0, 0, 0, 0, false);
        this.parent = HudElementType.WIDGET;
    }

    @Override
    public boolean checkConditions() {
        return GameData.isRidingLivingMount() && GameData.shouldDrawHUD();
    }

    @Override
    public void drawElement(Gui gui, float zLevel, float partialTicks) {
        ScaledResolution res = new ScaledResolution(this.mc);
        int height = res.func_78328_b() + this.settings.getPositionValue("mount_health_position")[1];
        EntityLivingBase mount = (EntityLivingBase)GameData.getMount();
        int health = (int)Math.ceil(mount.func_110143_aJ());
        int healthMax = (int)mount.func_110138_aP();
        int posX = (this.settings.getBoolValue("render_player_face") != false ? 49 : 25) + this.settings.getPositionValue("mount_health_position")[0];
        int offset = GameData.getHotbarWidgetWidthOffset();
        HudElementHealthMountHotbar.drawCustomBar(posX, height - 56, 200 + offset, 10, (double)health / (double)healthMax * 100.0, -1, -1, this.settings.getIntValue("color_health"), HudElementHealthMountHotbar.offsetColorPercent(this.settings.getIntValue("color_health"), 25));
        String stringHealth = health + "/" + healthMax;
        if (this.settings.getBoolValue("show_numbers_health").booleanValue()) {
            gui.func_73732_a(GameData.getFontRenderer(), stringHealth, posX + 100 + offset, height - 55, -1);
        }
    }
}

