/*
 * Decompiled with CFR 0.152.
 */
package com.mgen256.al.blocks;

import com.mgen256.al.blocks.LampAndTorchBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ALLamp
extends LampAndTorchBase {
    static PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    private static AxisAlignedBB[] SHAPES = new AxisAlignedBB[]{new AxisAlignedBB(0.3125, 0.875, 0.3125, 0.6875, 1.0, 0.6875), new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.125, 0.6875), new AxisAlignedBB(0.375, 0.4375, 0.75, 0.625, 0.8125, 1.0), new AxisAlignedBB(0.375, 0.4375, 0.0, 0.625, 0.8125, 0.25), new AxisAlignedBB(0.75, 0.4375, 0.375, 1.0, 0.8125, 0.625), new AxisAlignedBB(0.0, 0.4375, 0.375, 0.25, 0.8125, 0.625)};

    public ALLamp(Block mainblock, String mainblockName) {
        super("al_lamp_", mainblock, mainblockName, mainblock.func_149688_o(null));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.field_149784_t = 15;
    }

    @Override
    protected PropertyDirection getFacing() {
        return FACING;
    }

    @Override
    protected AxisAlignedBB getShapes(IBlockState state) {
        return SHAPES[((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a()];
    }

    @Override
    public int getMaxMeta() {
        return SHAPES.length;
    }

    public IBlockState func_176203_a(int meta) {
        if (!(0 <= meta && meta < this.getMaxMeta())) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a((IProperty)this.getFacing(), (Comparable)EnumFacing.values()[meta]);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        for (EnumFacing enumfacing : EnumFacing.Plane.VERTICAL) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
        return this.func_176223_P();
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.onNeighborChangeInternal(worldIn, pos, state);
    }

    protected boolean onNeighborChangeInternal(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.checkForDrop(worldIn, pos, state)) {
            return true;
        }
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumFacing enumfacing1 = enumfacing.func_176734_d();
        BlockPos blockpos = pos.func_177972_a(enumfacing1);
        boolean flag = false;
        if (worldIn.func_180495_p(blockpos).func_193401_d((IBlockAccess)worldIn, blockpos, enumfacing) == BlockFaceShape.UNDEFINED) {
            flag = true;
        }
        if (flag) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            return true;
        }
        return false;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean canPlaceTopOrDown(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing facing) {
        BlockFaceShape shape = state.func_193401_d(world, pos, facing);
        return (shape == BlockFaceShape.SOLID || shape == BlockFaceShape.CENTER || shape == BlockFaceShape.CENTER_BIG) && !this.isExceptionBlockForAttaching2(this);
    }

    @Override
    protected boolean canPlaceAt(World worldIn, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        BlockFaceShape blockfaceshape = iblockstate.func_193401_d((IBlockAccess)worldIn, blockpos, facing);
        if ((facing.equals((Object)EnumFacing.UP) || facing.equals((Object)EnumFacing.DOWN)) && this.canPlaceTopOrDown(iblockstate, (IBlockAccess)worldIn, blockpos, facing)) {
            return true;
        }
        if (facing != EnumFacing.UP) {
            return !this.isExceptBlockForAttachWithPiston2(block) && blockfaceshape != BlockFaceShape.UNDEFINED;
        }
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : FACING.func_177700_c()) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isExceptionBlockForAttaching2(Block attachBlock) {
        return attachBlock instanceof BlockShulkerBox || attachBlock instanceof BlockTrapDoor || attachBlock == Blocks.field_150461_bJ || attachBlock == Blocks.field_150383_bp || attachBlock == Blocks.field_150426_aN || attachBlock == Blocks.field_150432_aD || attachBlock == Blocks.field_180398_cJ || attachBlock == Blocks.field_150399_cn;
    }
}

